// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fp

// expBySqrtExp is equivalent to z.Exp(x, 48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1c000020bd27400000000023)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expBySqrtExp(x Element) *Element {
	// addition chain:
	//
	//	_10       = 2*1
	//	_11       = 1 + _10
	//	_101      = _10 + _11
	//	_111      = _10 + _101
	//	_1001     = _10 + _111
	//	_1011     = _10 + _1001
	//	_1101     = _10 + _1011
	//	_1111     = _10 + _1101
	//	_10001    = _10 + _1111
	//	_10010    = 1 + _10001
	//	_10011    = 1 + _10010
	//	_10111    = _101 + _10010
	//	_11001    = _10 + _10111
	//	_11011    = _10 + _11001
	//	_11101    = _10 + _11011
	//	_11111    = _10 + _11101
	//	_100001   = _10 + _11111
	//	_100011   = _10 + _100001
	//	_100101   = _10 + _100011
	//	_100111   = _10 + _100101
	//	_101001   = _10 + _100111
	//	_101011   = _10 + _101001
	//	_101101   = _10 + _101011
	//	_101111   = _10 + _101101
	//	_110001   = _10 + _101111
	//	_110011   = _10 + _110001
	//	_110101   = _10 + _110011
	//	_110111   = _10 + _110101
	//	_111001   = _10 + _110111
	//	_111011   = _10 + _111001
	//	_111101   = _10 + _111011
	//	_1111010  = 2*_111101
	//	_1111111  = _101 + _1111010
	//	_11111110 = 2*_1111111
	//	_11111111 = 1 + _11111110
	//	i43       = ((_100001 + _11111111) << 3 + _10111) << 2 + 1
	//	i65       = ((i43 << 9 + _1001) << 7 + _11111) << 4
	//	i82       = ((_111 + i65) << 9 + _1111) << 5 + _111
	//	i111      = ((i82 << 11 + _101011) << 7 + _100011) << 9
	//	i139      = ((_11111 + i111) << 8 + _100101) << 17 + _100111
	//	i161      = ((i139 << 4 + _1101) << 9 + _11111111) << 7
	//	i176      = ((_11111 + i161) << 6 + _10111) << 6 + _1001
	//	i198      = ((i176 << 4 + _11) << 6 + _11) << 10
	//	i214      = ((_110101 + i198) << 2 + 1) << 11 + _11101
	//	i238      = ((i214 << 6 + _101) << 7 + _1101) << 9
	//	i259      = ((_100001 + i238) << 7 + _100101) << 11 + _100111
	//	i287      = ((i259 << 7 + _101111) << 6 + _11111) << 13
	//	i302      = ((_100001 + i287) << 6 + _111011) << 6 + _111001
	//	i329      = ((i302 << 10 + _10111) << 11 + _111101) << 4
	//	i346      = ((_1101 + i329) << 8 + _110001) << 6 + _110001
	//	i366      = ((i346 << 5 + _11001) << 3 + _11) << 10
	//	i382      = ((_100111 + i366) << 5 + _1001) << 8 + _11001
	//	i407      = ((i382 << 10 + _1111) << 7 + _11101) << 6
	//	i427      = ((_11101 + i407) << 9 + _11111111) << 8 + _100101
	//	i454      = ((i427 << 6 + _101101) << 10 + _100011) << 9
	//	i474      = ((_1001 + i454) << 8 + _1101) << 9 + _100111
	//	i499      = ((i474 << 8 + _100011) << 6 + _101101) << 9
	//	i515      = ((_100101 + i499) << 4 + _1111) << 9 + _1111111
	//	i540      = ((i515 << 6 + _11001) << 8 + _111) << 9
	//	i555      = ((_111011 + i540) << 5 + _10011) << 7 + _100111
	//	i577      = ((i555 << 5 + _10111) << 9 + _111001) << 6
	//	i591      = ((_111101 + i577) << 9 + _11111111) << 2 + _11
	//	i612      = ((i591 << 7 + _10111) << 6 + _10011) << 6
	//	i630      = ((_101 + i612) << 9 + _10001) << 6 + _11011
	//	i657      = ((i630 << 10 + _100101) << 7 + _110011) << 8
	//	i670      = ((_111101 + i657) << 7 + _100011) << 3 + _111
	//	i696      = ((i670 << 10 + _1011) << 11 + _110011) << 3
	//	i713      = ((_111 + i696) << 9 + _101011) << 5 + _10111
	//	i734      = ((i713 << 7 + _101011) << 2 + _11) << 10
	//	i753      = ((_101001 + i734) << 10 + _110111) << 6 + _111001
	//	i776      = ((i753 << 6 + _101001) << 9 + _100111) << 6
	//	i788      = ((_110011 + i776) << 7 + _100001) << 2 + _11
	//	i827      = ((i788 << 21 + 1) << 11 + _101111) << 5
	//	return      ((_1001 + i827) << 7 + _11101) << 46 + _100011
	//
	// Operations: 753 squares 130 multiplies

	// Allocate Temporaries.
	var (
		t0  = new(Element)
		t1  = new(Element)
		t2  = new(Element)
		t3  = new(Element)
		t4  = new(Element)
		t5  = new(Element)
		t6  = new(Element)
		t7  = new(Element)
		t8  = new(Element)
		t9  = new(Element)
		t10 = new(Element)
		t11 = new(Element)
		t12 = new(Element)
		t13 = new(Element)
		t14 = new(Element)
		t15 = new(Element)
		t16 = new(Element)
		t17 = new(Element)
		t18 = new(Element)
		t19 = new(Element)
		t20 = new(Element)
		t21 = new(Element)
		t22 = new(Element)
		t23 = new(Element)
		t24 = new(Element)
		t25 = new(Element)
		t26 = new(Element)
		t27 = new(Element)
		t28 = new(Element)
		t29 = new(Element)
		t30 = new(Element)
	)

	// var t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30 Element
	// Step 1: t14 = x^0x2
	t14.Square(&x)

	// Step 2: t3 = x^0x3
	t3.Mul(&x, t14)

	// Step 3: t18 = x^0x5
	t18.Mul(t14, t3)

	// Step 4: t12 = x^0x7
	t12.Mul(t14, t18)

	// Step 5: t1 = x^0x9
	t1.Mul(t14, t12)

	// Step 6: t13 = x^0xb
	t13.Mul(t14, t1)

	// Step 7: t26 = x^0xd
	t26.Mul(t14, t13)

	// Step 8: t24 = x^0xf
	t24.Mul(t14, t26)

	// Step 9: t17 = x^0x11
	t17.Mul(t14, t24)

	// Step 10: z = x^0x12
	z.Mul(&x, t17)

	// Step 11: t19 = x^0x13
	t19.Mul(&x, z)

	// Step 12: t11 = x^0x17
	t11.Mul(t18, z)

	// Step 13: t22 = x^0x19
	t22.Mul(t14, t11)

	// Step 14: t16 = x^0x1b
	t16.Mul(t14, t22)

	// Step 15: t0 = x^0x1d
	t0.Mul(t14, t16)

	// Step 16: t28 = x^0x1f
	t28.Mul(t14, t0)

	// Step 17: t4 = x^0x21
	t4.Mul(t14, t28)

	// Step 18: z = x^0x23
	z.Mul(t14, t4)

	// Step 19: t15 = x^0x25
	t15.Mul(t14, z)

	// Step 20: t6 = x^0x27
	t6.Mul(t14, t15)

	// Step 21: t7 = x^0x29
	t7.Mul(t14, t6)

	// Step 22: t10 = x^0x2b
	t10.Mul(t14, t7)

	// Step 23: t25 = x^0x2d
	t25.Mul(t14, t10)

	// Step 24: t2 = x^0x2f
	t2.Mul(t14, t25)

	// Step 25: t27 = x^0x31
	t27.Mul(t14, t2)

	// Step 26: t5 = x^0x33
	t5.Mul(t14, t27)

	// Step 27: t29 = x^0x35
	t29.Mul(t14, t5)

	// Step 28: t9 = x^0x37
	t9.Mul(t14, t29)

	// Step 29: t8 = x^0x39
	t8.Mul(t14, t9)

	// Step 30: t21 = x^0x3b
	t21.Mul(t14, t8)

	// Step 31: t14 = x^0x3d
	t14.Mul(t14, t21)

	// Step 32: t20 = x^0x7a
	t20.Square(t14)

	// Step 33: t23 = x^0x7f
	t23.Mul(t18, t20)

	// Step 34: t20 = x^0xfe
	t20.Square(t23)

	// Step 35: t20 = x^0xff
	t20.Mul(&x, t20)

	// Step 36: t30 = x^0x120
	t30.Mul(t4, t20)

	// Step 39: t30 = x^0x900
	for s := 0; s < 3; s++ {
		t30.Square(t30)
	}

	// Step 40: t30 = x^0x917
	t30.Mul(t11, t30)

	// Step 42: t30 = x^0x245c
	for s := 0; s < 2; s++ {
		t30.Square(t30)
	}

	// Step 43: t30 = x^0x245d
	t30.Mul(&x, t30)

	// Step 52: t30 = x^0x48ba00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 53: t30 = x^0x48ba09
	t30.Mul(t1, t30)

	// Step 60: t30 = x^0x245d0480
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 61: t30 = x^0x245d049f
	t30.Mul(t28, t30)

	// Step 65: t30 = x^0x245d049f0
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 66: t30 = x^0x245d049f7
	t30.Mul(t12, t30)

	// Step 75: t30 = x^0x48ba093ee00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 76: t30 = x^0x48ba093ee0f
	t30.Mul(t24, t30)

	// Step 81: t30 = x^0x9174127dc1e0
	for s := 0; s < 5; s++ {
		t30.Square(t30)
	}

	// Step 82: t30 = x^0x9174127dc1e7
	t30.Mul(t12, t30)

	// Step 93: t30 = x^0x48ba093ee0f3800
	for s := 0; s < 11; s++ {
		t30.Square(t30)
	}

	// Step 94: t30 = x^0x48ba093ee0f382b
	t30.Mul(t10, t30)

	// Step 101: t30 = x^0x245d049f7079c1580
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 102: t30 = x^0x245d049f7079c15a3
	t30.Mul(z, t30)

	// Step 111: t30 = x^0x48ba093ee0f382b4600
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 112: t30 = x^0x48ba093ee0f382b461f
	t30.Mul(t28, t30)

	// Step 120: t30 = x^0x48ba093ee0f382b461f00
	for s := 0; s < 8; s++ {
		t30.Square(t30)
	}

	// Step 121: t30 = x^0x48ba093ee0f382b461f25
	t30.Mul(t15, t30)

	// Step 138: t30 = x^0x9174127dc1e70568c3e4a0000
	for s := 0; s < 17; s++ {
		t30.Square(t30)
	}

	// Step 139: t30 = x^0x9174127dc1e70568c3e4a0027
	t30.Mul(t6, t30)

	// Step 143: t30 = x^0x9174127dc1e70568c3e4a00270
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 144: t30 = x^0x9174127dc1e70568c3e4a0027d
	t30.Mul(t26, t30)

	// Step 153: t30 = x^0x122e824fb83ce0ad187c94004fa00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 154: t30 = x^0x122e824fb83ce0ad187c94004faff
	t30.Mul(t20, t30)

	// Step 161: t30 = x^0x9174127dc1e70568c3e4a0027d7f80
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 162: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f
	t30.Mul(t28, t30)

	// Step 168: t30 = x^0x245d049f7079c15a30f928009f5fe7c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 169: t30 = x^0x245d049f7079c15a30f928009f5fe7d7
	t30.Mul(t11, t30)

	// Step 175: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 176: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c9
	t30.Mul(t1, t30)

	// Step 180: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c90
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 181: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c93
	t30.Mul(t3, t30)

	// Step 187: t30 = x^0x245d049f7079c15a30f928009f5fe7d724c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 188: t30 = x^0x245d049f7079c15a30f928009f5fe7d724c3
	t30.Mul(t3, t30)

	// Step 198: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c00
	for s := 0; s < 10; s++ {
		t30.Square(t30)
	}

	// Step 199: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c35
	t29.Mul(t29, t30)

	// Step 201: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d4
	for s := 0; s < 2; s++ {
		t29.Square(t29)
	}

	// Step 202: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d5
	t29.Mul(&x, t29)

	// Step 213: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a800
	for s := 0; s < 11; s++ {
		t29.Square(t29)
	}

	// Step 214: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d
	t29.Mul(t0, t29)

	// Step 220: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa0740
	for s := 0; s < 6; s++ {
		t29.Square(t29)
	}

	// Step 221: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa0745
	t29.Mul(t18, t29)

	// Step 228: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a280
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 229: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d
	t29.Mul(t26, t29)

	// Step 238: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a00
	for s := 0; s < 9; s++ {
		t29.Square(t29)
	}

	// Step 239: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a21
	t29.Mul(t4, t29)

	// Step 246: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d1080
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 247: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a5
	t29.Mul(t15, t29)

	// Step 258: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d1468852800
	for s := 0; s < 11; s++ {
		t29.Square(t29)
	}

	// Step 259: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d1468852827
	t29.Mul(t6, t29)

	// Step 266: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a3442941380
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 267: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af
	t29.Mul(t2, t29)

	// Step 273: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebc0
	for s := 0; s < 6; s++ {
		t29.Square(t29)
	}

	// Step 274: t28 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf
	t28.Mul(t28, t29)

	// Step 287: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be000
	for s := 0; s < 13; s++ {
		t28.Square(t28)
	}

	// Step 288: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021
	t28.Mul(t4, t28)

	// Step 294: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef80840
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 295: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087b
	t28.Mul(t21, t28)

	// Step 301: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ec0
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 302: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef9
	t28.Mul(t8, t28)

	// Step 312: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be400
	for s := 0; s < 10; s++ {
		t28.Square(t28)
	}

	// Step 313: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be417
	t28.Mul(t11, t28)

	// Step 324: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b800
	for s := 0; s < 11; s++ {
		t28.Square(t28)
	}

	// Step 325: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83d
	t28.Mul(t14, t28)

	// Step 329: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83d0
	for s := 0; s < 4; s++ {
		t28.Square(t28)
	}

	// Step 330: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd
	t28.Mul(t26, t28)

	// Step 338: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd00
	for s := 0; s < 8; s++ {
		t28.Square(t28)
	}

	// Step 339: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31
	t28.Mul(t27, t28)

	// Step 345: t28 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c40
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 346: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71
	t27.Mul(t27, t28)

	// Step 351: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e20
	for s := 0; s < 5; s++ {
		t27.Square(t27)
	}

	// Step 352: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39
	t27.Mul(t22, t27)

	// Step 355: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71c8
	for s := 0; s < 3; s++ {
		t27.Square(t27)
	}

	// Step 356: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb
	t27.Mul(t3, t27)

	// Step 366: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c00
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 367: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c27
	t27.Mul(t6, t27)

	// Step 372: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e0
	for s := 0; s < 5; s++ {
		t27.Square(t27)
	}

	// Step 373: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e9
	t27.Mul(t1, t27)

	// Step 381: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e900
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 382: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e919
	t27.Mul(t22, t27)

	// Step 392: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a46400
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 393: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f
	t27.Mul(t24, t27)

	// Step 400: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d2320780
	for s := 0; s < 7; s++ {
		t27.Square(t27)
	}

	// Step 401: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d
	t27.Mul(t0, t27)

	// Step 407: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e740
	for s := 0; s < 6; s++ {
		t27.Square(t27)
	}

	// Step 408: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d
	t27.Mul(t0, t27)

	// Step 417: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903ceba00
	for s := 0; s < 9; s++ {
		t27.Square(t27)
	}

	// Step 418: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff
	t27.Mul(t20, t27)

	// Step 426: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff00
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 427: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25
	t27.Mul(t15, t27)

	// Step 433: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc940
	for s := 0; s < 6; s++ {
		t27.Square(t27)
	}

	// Step 434: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d
	t27.Mul(t25, t27)

	// Step 444: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b400
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 445: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423
	t27.Mul(z, t27)

	// Step 454: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b684600
	for s := 0; s < 9; s++ {
		t27.Square(t27)
	}

	// Step 455: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b684609
	t27.Mul(t1, t27)

	// Step 463: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b68460900
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 464: t26 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d
	t26.Mul(t26, t27)

	// Step 473: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a00
	for s := 0; s < 9; s++ {
		t26.Square(t26)
	}

	// Step 474: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a27
	t26.Mul(t6, t26)

	// Step 482: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2700
	for s := 0; s < 8; s++ {
		t26.Square(t26)
	}

	// Step 483: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723
	t26.Mul(z, t26)

	// Step 489: t26 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8c0
	for s := 0; s < 6; s++ {
		t26.Square(t26)
	}

	// Step 490: t25 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed
	t25.Mul(t25, t26)

	// Step 499: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da00
	for s := 0; s < 9; s++ {
		t25.Square(t25)
	}

	// Step 500: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25
	t25.Mul(t15, t25)

	// Step 504: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da250
	for s := 0; s < 4; s++ {
		t25.Square(t25)
	}

	// Step 505: t24 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f
	t24.Mul(t24, t25)

	// Step 514: t24 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be00
	for s := 0; s < 9; s++ {
		t24.Square(t24)
	}

	// Step 515: t23 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f
	t23.Mul(t23, t24)

	// Step 521: t23 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fc0
	for s := 0; s < 6; s++ {
		t23.Square(t23)
	}

	// Step 522: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9
	t22.Mul(t22, t23)

	// Step 530: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd900
	for s := 0; s < 8; s++ {
		t22.Square(t22)
	}

	// Step 531: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd907
	t22.Mul(t12, t22)

	// Step 540: t22 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e00
	for s := 0; s < 9; s++ {
		t22.Square(t22)
	}

	// Step 541: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b
	t21.Mul(t21, t22)

	// Step 546: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c760
	for s := 0; s < 5; s++ {
		t21.Square(t21)
	}

	// Step 547: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c773
	t21.Mul(t19, t21)

	// Step 554: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b980
	for s := 0; s < 7; s++ {
		t21.Square(t21)
	}

	// Step 555: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7
	t21.Mul(t6, t21)

	// Step 560: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734e0
	for s := 0; s < 5; s++ {
		t21.Square(t21)
	}

	// Step 561: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f7
	t21.Mul(t11, t21)

	// Step 570: t21 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee00
	for s := 0; s < 9; s++ {
		t21.Square(t21)
	}

	// Step 571: t21 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39
	t21.Mul(t8, t21)

	// Step 577: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e40
	for s := 0; s < 6; s++ {
		t21.Square(t21)
	}

	// Step 578: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d
	t21.Mul(t14, t21)

	// Step 587: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfa00
	for s := 0; s < 9; s++ {
		t21.Square(t21)
	}

	// Step 588: t20 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaff
	t20.Mul(t20, t21)

	// Step 590: t20 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebfc
	for s := 0; s < 2; s++ {
		t20.Square(t20)
	}

	// Step 591: t20 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff
	t20.Mul(t3, t20)

	// Step 598: t20 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff80
	for s := 0; s < 7; s++ {
		t20.Square(t20)
	}

	// Step 599: t20 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff97
	t20.Mul(t11, t20)

	// Step 605: t20 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5c0
	for s := 0; s < 6; s++ {
		t20.Square(t20)
	}

	// Step 606: t19 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d3
	t19.Mul(t19, t20)

	// Step 612: t19 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c0
	for s := 0; s < 6; s++ {
		t19.Square(t19)
	}

	// Step 613: t18 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c5
	t18.Mul(t18, t19)

	// Step 622: t18 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a00
	for s := 0; s < 9; s++ {
		t18.Square(t18)
	}

	// Step 623: t17 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a11
	t17.Mul(t17, t18)

	// Step 629: t17 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba628440
	for s := 0; s < 6; s++ {
		t17.Square(t17)
	}

	// Step 630: t16 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b
	t16.Mul(t16, t17)

	// Step 640: t16 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c00
	for s := 0; s < 10; s++ {
		t16.Square(t16)
	}

	// Step 641: t15 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25
	t15.Mul(t15, t16)

	// Step 648: t15 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b61280
	for s := 0; s < 7; s++ {
		t15.Square(t15)
	}

	// Step 649: t15 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b3
	t15.Mul(t5, t15)

	// Step 657: t15 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b300
	for s := 0; s < 8; s++ {
		t15.Square(t15)
	}

	// Step 658: t14 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d
	t14.Mul(t14, t15)

	// Step 665: t14 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599e80
	for s := 0; s < 7; s++ {
		t14.Square(t14)
	}

	// Step 666: t14 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3
	t14.Mul(z, t14)

	// Step 669: t14 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf518
	for s := 0; s < 3; s++ {
		t14.Square(t14)
	}

	// Step 670: t14 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f
	t14.Mul(t12, t14)

	// Step 680: t14 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c00
	for s := 0; s < 10; s++ {
		t14.Square(t14)
	}

	// Step 681: t13 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b
	t13.Mul(t13, t14)

	// Step 692: t13 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05800
	for s := 0; s < 11; s++ {
		t13.Square(t13)
	}

	// Step 693: t13 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833
	t13.Mul(t5, t13)

	// Step 696: t13 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c198
	for s := 0; s < 3; s++ {
		t13.Square(t13)
	}

	// Step 697: t12 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f
	t12.Mul(t12, t13)

	// Step 706: t12 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e00
	for s := 0; s < 9; s++ {
		t12.Square(t12)
	}

	// Step 707: t12 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2b
	t12.Mul(t10, t12)

	// Step 712: t12 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c560
	for s := 0; s < 5; s++ {
		t12.Square(t12)
	}

	// Step 713: t11 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577
	t11.Mul(t11, t12)

	// Step 720: t11 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bb80
	for s := 0; s < 7; s++ {
		t11.Square(t11)
	}

	// Step 721: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbab
	t10.Mul(t10, t11)

	// Step 723: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeac
	for s := 0; s < 2; s++ {
		t10.Square(t10)
	}

	// Step 724: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf
	t10.Mul(t3, t10)

	// Step 734: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc00
	for s := 0; s < 10; s++ {
		t10.Square(t10)
	}

	// Step 735: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc29
	t10.Mul(t7, t10)

	// Step 745: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a400
	for s := 0; s < 10; s++ {
		t10.Square(t10)
	}

	// Step 746: t9 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437
	t9.Mul(t9, t10)

	// Step 752: t9 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290dc0
	for s := 0; s < 6; s++ {
		t9.Square(t9)
	}

	// Step 753: t8 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9
	t8.Mul(t8, t9)

	// Step 759: t8 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e40
	for s := 0; s < 6; s++ {
		t8.Square(t8)
	}

	// Step 760: t7 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e69
	t7.Mul(t7, t8)

	// Step 769: t7 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd200
	for s := 0; s < 9; s++ {
		t7.Square(t7)
	}

	// Step 770: t6 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227
	t6.Mul(t6, t7)

	// Step 776: t6 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489c0
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 777: t5 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f3
	t5.Mul(t5, t6)

	// Step 784: t5 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f980
	for s := 0; s < 7; s++ {
		t5.Square(t5)
	}

	// Step 785: t4 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1
	t4.Mul(t4, t5)

	// Step 787: t4 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e684
	for s := 0; s < 2; s++ {
		t4.Square(t4)
	}

	// Step 788: t3 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e687
	t3.Mul(t3, t4)

	// Step 809: t3 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e00000
	for s := 0; s < 21; s++ {
		t3.Square(t3)
	}

	// Step 810: t3 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e00001
	t3.Mul(&x, t3)

	// Step 821: t3 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e68700000800
	for s := 0; s < 11; s++ {
		t3.Square(t3)
	}

	// Step 822: t2 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f
	t2.Mul(t2, t3)

	// Step 827: t2 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e0
	for s := 0; s < 5; s++ {
		t2.Square(t2)
	}

	// Step 828: t1 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e9
	t1.Mul(t1, t2)

	// Step 835: t1 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f480
	for s := 0; s < 7; s++ {
		t1.Square(t1)
	}

	// Step 836: t0 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f49d
	t0.Mul(t0, t1)

	// Step 882: t0 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1c000020bd27400000000000
	for s := 0; s < 46; s++ {
		t0.Square(t0)
	}

	// Step 883: z = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1c000020bd27400000000023
	z.Mul(z, t0)

	return z
}

// expByLegendreExp is equivalent to z.Exp(x, 9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f34380000417a4e800000000045)
//
// uses github.com/mmcloughlin/addchain v0.4.0 to generate a shorter addition chain
func (z *Element) expByLegendreExp(x Element) *Element {
	// addition chain:
	//
	//	_10       = 2*1
	//	_11       = 1 + _10
	//	_101      = _10 + _11
	//	_111      = _10 + _101
	//	_1001     = _10 + _111
	//	_1011     = _10 + _1001
	//	_1101     = _10 + _1011
	//	_1111     = _10 + _1101
	//	_10001    = _10 + _1111
	//	_10010    = 1 + _10001
	//	_10011    = 1 + _10010
	//	_10111    = _101 + _10010
	//	_11001    = _10 + _10111
	//	_11011    = _10 + _11001
	//	_11101    = _10 + _11011
	//	_11111    = _10 + _11101
	//	_100001   = _10 + _11111
	//	_100011   = _10 + _100001
	//	_100101   = _10 + _100011
	//	_100111   = _10 + _100101
	//	_101001   = _10 + _100111
	//	_101011   = _10 + _101001
	//	_101101   = _10 + _101011
	//	_101111   = _10 + _101101
	//	_110001   = _10 + _101111
	//	_110011   = _10 + _110001
	//	_110101   = _10 + _110011
	//	_110111   = _10 + _110101
	//	_111001   = _10 + _110111
	//	_111011   = _10 + _111001
	//	_111101   = _10 + _111011
	//	_1111010  = 2*_111101
	//	_1111111  = _101 + _1111010
	//	_11111110 = 2*_1111111
	//	_11111111 = 1 + _11111110
	//	i43       = ((_100001 + _11111111) << 3 + _10111) << 2 + 1
	//	i65       = ((i43 << 9 + _1001) << 7 + _11111) << 4
	//	i82       = ((_111 + i65) << 9 + _1111) << 5 + _111
	//	i111      = ((i82 << 11 + _101011) << 7 + _100011) << 9
	//	i139      = ((_11111 + i111) << 8 + _100101) << 17 + _100111
	//	i161      = ((i139 << 4 + _1101) << 9 + _11111111) << 7
	//	i176      = ((_11111 + i161) << 6 + _10111) << 6 + _1001
	//	i198      = ((i176 << 4 + _11) << 6 + _11) << 10
	//	i214      = ((_110101 + i198) << 2 + 1) << 11 + _11101
	//	i238      = ((i214 << 6 + _101) << 7 + _1101) << 9
	//	i259      = ((_100001 + i238) << 7 + _100101) << 11 + _100111
	//	i287      = ((i259 << 7 + _101111) << 6 + _11111) << 13
	//	i302      = ((_100001 + i287) << 6 + _111011) << 6 + _111001
	//	i329      = ((i302 << 10 + _10111) << 11 + _111101) << 4
	//	i346      = ((_1101 + i329) << 8 + _110001) << 6 + _110001
	//	i366      = ((i346 << 5 + _11001) << 3 + _11) << 10
	//	i382      = ((_100111 + i366) << 5 + _1001) << 8 + _11001
	//	i407      = ((i382 << 10 + _1111) << 7 + _11101) << 6
	//	i427      = ((_11101 + i407) << 9 + _11111111) << 8 + _100101
	//	i454      = ((i427 << 6 + _101101) << 10 + _100011) << 9
	//	i474      = ((_1001 + i454) << 8 + _1101) << 9 + _100111
	//	i499      = ((i474 << 8 + _100011) << 6 + _101101) << 9
	//	i515      = ((_100101 + i499) << 4 + _1111) << 9 + _1111111
	//	i540      = ((i515 << 6 + _11001) << 8 + _111) << 9
	//	i555      = ((_111011 + i540) << 5 + _10011) << 7 + _100111
	//	i577      = ((i555 << 5 + _10111) << 9 + _111001) << 6
	//	i591      = ((_111101 + i577) << 9 + _11111111) << 2 + _11
	//	i612      = ((i591 << 7 + _10111) << 6 + _10011) << 6
	//	i630      = ((_101 + i612) << 9 + _10001) << 6 + _11011
	//	i657      = ((i630 << 10 + _100101) << 7 + _110011) << 8
	//	i670      = ((_111101 + i657) << 7 + _100011) << 3 + _111
	//	i696      = ((i670 << 10 + _1011) << 11 + _110011) << 3
	//	i713      = ((_111 + i696) << 9 + _101011) << 5 + _10111
	//	i734      = ((i713 << 7 + _101011) << 2 + _11) << 10
	//	i753      = ((_101001 + i734) << 10 + _110111) << 6 + _111001
	//	i776      = ((i753 << 6 + _101001) << 9 + _100111) << 6
	//	i788      = ((_110011 + i776) << 7 + _100001) << 2 + _11
	//	i827      = ((i788 << 21 + 1) << 11 + _101111) << 5
	//	i882      = ((_1001 + i827) << 7 + _11101) << 45 + _10001
	//	return      i882 << 2 + 1
	//
	// Operations: 754 squares 131 multiplies

	// Allocate Temporaries.
	var (
		t0  = new(Element)
		t1  = new(Element)
		t2  = new(Element)
		t3  = new(Element)
		t4  = new(Element)
		t5  = new(Element)
		t6  = new(Element)
		t7  = new(Element)
		t8  = new(Element)
		t9  = new(Element)
		t10 = new(Element)
		t11 = new(Element)
		t12 = new(Element)
		t13 = new(Element)
		t14 = new(Element)
		t15 = new(Element)
		t16 = new(Element)
		t17 = new(Element)
		t18 = new(Element)
		t19 = new(Element)
		t20 = new(Element)
		t21 = new(Element)
		t22 = new(Element)
		t23 = new(Element)
		t24 = new(Element)
		t25 = new(Element)
		t26 = new(Element)
		t27 = new(Element)
		t28 = new(Element)
		t29 = new(Element)
		t30 = new(Element)
	)

	// var t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30 Element
	// Step 1: t15 = x^0x2
	t15.Square(&x)

	// Step 2: t3 = x^0x3
	t3.Mul(&x, t15)

	// Step 3: t18 = x^0x5
	t18.Mul(t15, t3)

	// Step 4: t12 = x^0x7
	t12.Mul(t15, t18)

	// Step 5: t1 = x^0x9
	t1.Mul(t15, t12)

	// Step 6: t13 = x^0xb
	t13.Mul(t15, t1)

	// Step 7: t26 = x^0xd
	t26.Mul(t15, t13)

	// Step 8: t24 = x^0xf
	t24.Mul(t15, t26)

	// Step 9: z = x^0x11
	z.Mul(t15, t24)

	// Step 10: t0 = x^0x12
	t0.Mul(&x, z)

	// Step 11: t19 = x^0x13
	t19.Mul(&x, t0)

	// Step 12: t11 = x^0x17
	t11.Mul(t18, t0)

	// Step 13: t22 = x^0x19
	t22.Mul(t15, t11)

	// Step 14: t17 = x^0x1b
	t17.Mul(t15, t22)

	// Step 15: t0 = x^0x1d
	t0.Mul(t15, t17)

	// Step 16: t28 = x^0x1f
	t28.Mul(t15, t0)

	// Step 17: t4 = x^0x21
	t4.Mul(t15, t28)

	// Step 18: t14 = x^0x23
	t14.Mul(t15, t4)

	// Step 19: t16 = x^0x25
	t16.Mul(t15, t14)

	// Step 20: t6 = x^0x27
	t6.Mul(t15, t16)

	// Step 21: t7 = x^0x29
	t7.Mul(t15, t6)

	// Step 22: t10 = x^0x2b
	t10.Mul(t15, t7)

	// Step 23: t25 = x^0x2d
	t25.Mul(t15, t10)

	// Step 24: t2 = x^0x2f
	t2.Mul(t15, t25)

	// Step 25: t27 = x^0x31
	t27.Mul(t15, t2)

	// Step 26: t5 = x^0x33
	t5.Mul(t15, t27)

	// Step 27: t29 = x^0x35
	t29.Mul(t15, t5)

	// Step 28: t9 = x^0x37
	t9.Mul(t15, t29)

	// Step 29: t8 = x^0x39
	t8.Mul(t15, t9)

	// Step 30: t21 = x^0x3b
	t21.Mul(t15, t8)

	// Step 31: t15 = x^0x3d
	t15.Mul(t15, t21)

	// Step 32: t20 = x^0x7a
	t20.Square(t15)

	// Step 33: t23 = x^0x7f
	t23.Mul(t18, t20)

	// Step 34: t20 = x^0xfe
	t20.Square(t23)

	// Step 35: t20 = x^0xff
	t20.Mul(&x, t20)

	// Step 36: t30 = x^0x120
	t30.Mul(t4, t20)

	// Step 39: t30 = x^0x900
	for s := 0; s < 3; s++ {
		t30.Square(t30)
	}

	// Step 40: t30 = x^0x917
	t30.Mul(t11, t30)

	// Step 42: t30 = x^0x245c
	for s := 0; s < 2; s++ {
		t30.Square(t30)
	}

	// Step 43: t30 = x^0x245d
	t30.Mul(&x, t30)

	// Step 52: t30 = x^0x48ba00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 53: t30 = x^0x48ba09
	t30.Mul(t1, t30)

	// Step 60: t30 = x^0x245d0480
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 61: t30 = x^0x245d049f
	t30.Mul(t28, t30)

	// Step 65: t30 = x^0x245d049f0
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 66: t30 = x^0x245d049f7
	t30.Mul(t12, t30)

	// Step 75: t30 = x^0x48ba093ee00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 76: t30 = x^0x48ba093ee0f
	t30.Mul(t24, t30)

	// Step 81: t30 = x^0x9174127dc1e0
	for s := 0; s < 5; s++ {
		t30.Square(t30)
	}

	// Step 82: t30 = x^0x9174127dc1e7
	t30.Mul(t12, t30)

	// Step 93: t30 = x^0x48ba093ee0f3800
	for s := 0; s < 11; s++ {
		t30.Square(t30)
	}

	// Step 94: t30 = x^0x48ba093ee0f382b
	t30.Mul(t10, t30)

	// Step 101: t30 = x^0x245d049f7079c1580
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 102: t30 = x^0x245d049f7079c15a3
	t30.Mul(t14, t30)

	// Step 111: t30 = x^0x48ba093ee0f382b4600
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 112: t30 = x^0x48ba093ee0f382b461f
	t30.Mul(t28, t30)

	// Step 120: t30 = x^0x48ba093ee0f382b461f00
	for s := 0; s < 8; s++ {
		t30.Square(t30)
	}

	// Step 121: t30 = x^0x48ba093ee0f382b461f25
	t30.Mul(t16, t30)

	// Step 138: t30 = x^0x9174127dc1e70568c3e4a0000
	for s := 0; s < 17; s++ {
		t30.Square(t30)
	}

	// Step 139: t30 = x^0x9174127dc1e70568c3e4a0027
	t30.Mul(t6, t30)

	// Step 143: t30 = x^0x9174127dc1e70568c3e4a00270
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 144: t30 = x^0x9174127dc1e70568c3e4a0027d
	t30.Mul(t26, t30)

	// Step 153: t30 = x^0x122e824fb83ce0ad187c94004fa00
	for s := 0; s < 9; s++ {
		t30.Square(t30)
	}

	// Step 154: t30 = x^0x122e824fb83ce0ad187c94004faff
	t30.Mul(t20, t30)

	// Step 161: t30 = x^0x9174127dc1e70568c3e4a0027d7f80
	for s := 0; s < 7; s++ {
		t30.Square(t30)
	}

	// Step 162: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f
	t30.Mul(t28, t30)

	// Step 168: t30 = x^0x245d049f7079c15a30f928009f5fe7c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 169: t30 = x^0x245d049f7079c15a30f928009f5fe7d7
	t30.Mul(t11, t30)

	// Step 175: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 176: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c9
	t30.Mul(t1, t30)

	// Step 180: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c90
	for s := 0; s < 4; s++ {
		t30.Square(t30)
	}

	// Step 181: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c93
	t30.Mul(t3, t30)

	// Step 187: t30 = x^0x245d049f7079c15a30f928009f5fe7d724c0
	for s := 0; s < 6; s++ {
		t30.Square(t30)
	}

	// Step 188: t30 = x^0x245d049f7079c15a30f928009f5fe7d724c3
	t30.Mul(t3, t30)

	// Step 198: t30 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c00
	for s := 0; s < 10; s++ {
		t30.Square(t30)
	}

	// Step 199: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c35
	t29.Mul(t29, t30)

	// Step 201: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d4
	for s := 0; s < 2; s++ {
		t29.Square(t29)
	}

	// Step 202: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d5
	t29.Mul(&x, t29)

	// Step 213: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a800
	for s := 0; s < 11; s++ {
		t29.Square(t29)
	}

	// Step 214: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d
	t29.Mul(t0, t29)

	// Step 220: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa0740
	for s := 0; s < 6; s++ {
		t29.Square(t29)
	}

	// Step 221: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa0745
	t29.Mul(t18, t29)

	// Step 228: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a280
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 229: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d
	t29.Mul(t26, t29)

	// Step 238: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a00
	for s := 0; s < 9; s++ {
		t29.Square(t29)
	}

	// Step 239: t29 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a21
	t29.Mul(t4, t29)

	// Step 246: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d1080
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 247: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a5
	t29.Mul(t16, t29)

	// Step 258: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d1468852800
	for s := 0; s < 11; s++ {
		t29.Square(t29)
	}

	// Step 259: t29 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d1468852827
	t29.Mul(t6, t29)

	// Step 266: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a3442941380
	for s := 0; s < 7; s++ {
		t29.Square(t29)
	}

	// Step 267: t29 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af
	t29.Mul(t2, t29)

	// Step 273: t29 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebc0
	for s := 0; s < 6; s++ {
		t29.Square(t29)
	}

	// Step 274: t28 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf
	t28.Mul(t28, t29)

	// Step 287: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be000
	for s := 0; s < 13; s++ {
		t28.Square(t28)
	}

	// Step 288: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021
	t28.Mul(t4, t28)

	// Step 294: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef80840
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 295: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087b
	t28.Mul(t21, t28)

	// Step 301: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ec0
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 302: t28 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef9
	t28.Mul(t8, t28)

	// Step 312: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be400
	for s := 0; s < 10; s++ {
		t28.Square(t28)
	}

	// Step 313: t28 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be417
	t28.Mul(t11, t28)

	// Step 324: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b800
	for s := 0; s < 11; s++ {
		t28.Square(t28)
	}

	// Step 325: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83d
	t28.Mul(t15, t28)

	// Step 329: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83d0
	for s := 0; s < 4; s++ {
		t28.Square(t28)
	}

	// Step 330: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd
	t28.Mul(t26, t28)

	// Step 338: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd00
	for s := 0; s < 8; s++ {
		t28.Square(t28)
	}

	// Step 339: t28 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31
	t28.Mul(t27, t28)

	// Step 345: t28 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c40
	for s := 0; s < 6; s++ {
		t28.Square(t28)
	}

	// Step 346: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71
	t27.Mul(t27, t28)

	// Step 351: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e20
	for s := 0; s < 5; s++ {
		t27.Square(t27)
	}

	// Step 352: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39
	t27.Mul(t22, t27)

	// Step 355: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71c8
	for s := 0; s < 3; s++ {
		t27.Square(t27)
	}

	// Step 356: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb
	t27.Mul(t3, t27)

	// Step 366: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c00
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 367: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c27
	t27.Mul(t6, t27)

	// Step 372: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e0
	for s := 0; s < 5; s++ {
		t27.Square(t27)
	}

	// Step 373: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e9
	t27.Mul(t1, t27)

	// Step 381: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e900
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 382: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e919
	t27.Mul(t22, t27)

	// Step 392: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a46400
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 393: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f
	t27.Mul(t24, t27)

	// Step 400: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d2320780
	for s := 0; s < 7; s++ {
		t27.Square(t27)
	}

	// Step 401: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d
	t27.Mul(t0, t27)

	// Step 407: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e740
	for s := 0; s < 6; s++ {
		t27.Square(t27)
	}

	// Step 408: t27 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d
	t27.Mul(t0, t27)

	// Step 417: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903ceba00
	for s := 0; s < 9; s++ {
		t27.Square(t27)
	}

	// Step 418: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff
	t27.Mul(t20, t27)

	// Step 426: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff00
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 427: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25
	t27.Mul(t16, t27)

	// Step 433: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc940
	for s := 0; s < 6; s++ {
		t27.Square(t27)
	}

	// Step 434: t27 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d
	t27.Mul(t25, t27)

	// Step 444: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b400
	for s := 0; s < 10; s++ {
		t27.Square(t27)
	}

	// Step 445: t27 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423
	t27.Mul(t14, t27)

	// Step 454: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b684600
	for s := 0; s < 9; s++ {
		t27.Square(t27)
	}

	// Step 455: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b684609
	t27.Mul(t1, t27)

	// Step 463: t27 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b68460900
	for s := 0; s < 8; s++ {
		t27.Square(t27)
	}

	// Step 464: t26 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d
	t26.Mul(t26, t27)

	// Step 473: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a00
	for s := 0; s < 9; s++ {
		t26.Square(t26)
	}

	// Step 474: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a27
	t26.Mul(t6, t26)

	// Step 482: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2700
	for s := 0; s < 8; s++ {
		t26.Square(t26)
	}

	// Step 483: t26 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723
	t26.Mul(t14, t26)

	// Step 489: t26 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8c0
	for s := 0; s < 6; s++ {
		t26.Square(t26)
	}

	// Step 490: t25 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed
	t25.Mul(t25, t26)

	// Step 499: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da00
	for s := 0; s < 9; s++ {
		t25.Square(t25)
	}

	// Step 500: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25
	t25.Mul(t16, t25)

	// Step 504: t25 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da250
	for s := 0; s < 4; s++ {
		t25.Square(t25)
	}

	// Step 505: t24 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f
	t24.Mul(t24, t25)

	// Step 514: t24 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be00
	for s := 0; s < 9; s++ {
		t24.Square(t24)
	}

	// Step 515: t23 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f
	t23.Mul(t23, t24)

	// Step 521: t23 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fc0
	for s := 0; s < 6; s++ {
		t23.Square(t23)
	}

	// Step 522: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9
	t22.Mul(t22, t23)

	// Step 530: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd900
	for s := 0; s < 8; s++ {
		t22.Square(t22)
	}

	// Step 531: t22 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd907
	t22.Mul(t12, t22)

	// Step 540: t22 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e00
	for s := 0; s < 9; s++ {
		t22.Square(t22)
	}

	// Step 541: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b
	t21.Mul(t21, t22)

	// Step 546: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c760
	for s := 0; s < 5; s++ {
		t21.Square(t21)
	}

	// Step 547: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c773
	t21.Mul(t19, t21)

	// Step 554: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b980
	for s := 0; s < 7; s++ {
		t21.Square(t21)
	}

	// Step 555: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7
	t21.Mul(t6, t21)

	// Step 560: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734e0
	for s := 0; s < 5; s++ {
		t21.Square(t21)
	}

	// Step 561: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f7
	t21.Mul(t11, t21)

	// Step 570: t21 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee00
	for s := 0; s < 9; s++ {
		t21.Square(t21)
	}

	// Step 571: t21 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39
	t21.Mul(t8, t21)

	// Step 577: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e40
	for s := 0; s < 6; s++ {
		t21.Square(t21)
	}

	// Step 578: t21 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d
	t21.Mul(t15, t21)

	// Step 587: t21 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfa00
	for s := 0; s < 9; s++ {
		t21.Square(t21)
	}

	// Step 588: t20 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaff
	t20.Mul(t20, t21)

	// Step 590: t20 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebfc
	for s := 0; s < 2; s++ {
		t20.Square(t20)
	}

	// Step 591: t20 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff
	t20.Mul(t3, t20)

	// Step 598: t20 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff80
	for s := 0; s < 7; s++ {
		t20.Square(t20)
	}

	// Step 599: t20 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff97
	t20.Mul(t11, t20)

	// Step 605: t20 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5c0
	for s := 0; s < 6; s++ {
		t20.Square(t20)
	}

	// Step 606: t19 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d3
	t19.Mul(t19, t20)

	// Step 612: t19 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c0
	for s := 0; s < 6; s++ {
		t19.Square(t19)
	}

	// Step 613: t18 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c5
	t18.Mul(t18, t19)

	// Step 622: t18 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a00
	for s := 0; s < 9; s++ {
		t18.Square(t18)
	}

	// Step 623: t18 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a11
	t18.Mul(z, t18)

	// Step 629: t18 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba628440
	for s := 0; s < 6; s++ {
		t18.Square(t18)
	}

	// Step 630: t17 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b
	t17.Mul(t17, t18)

	// Step 640: t17 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c00
	for s := 0; s < 10; s++ {
		t17.Square(t17)
	}

	// Step 641: t16 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25
	t16.Mul(t16, t17)

	// Step 648: t16 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b61280
	for s := 0; s < 7; s++ {
		t16.Square(t16)
	}

	// Step 649: t16 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b3
	t16.Mul(t5, t16)

	// Step 657: t16 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b300
	for s := 0; s < 8; s++ {
		t16.Square(t16)
	}

	// Step 658: t15 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d
	t15.Mul(t15, t16)

	// Step 665: t15 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599e80
	for s := 0; s < 7; s++ {
		t15.Square(t15)
	}

	// Step 666: t14 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3
	t14.Mul(t14, t15)

	// Step 669: t14 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf518
	for s := 0; s < 3; s++ {
		t14.Square(t14)
	}

	// Step 670: t14 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f
	t14.Mul(t12, t14)

	// Step 680: t14 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c00
	for s := 0; s < 10; s++ {
		t14.Square(t14)
	}

	// Step 681: t13 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b
	t13.Mul(t13, t14)

	// Step 692: t13 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05800
	for s := 0; s < 11; s++ {
		t13.Square(t13)
	}

	// Step 693: t13 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833
	t13.Mul(t5, t13)

	// Step 696: t13 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c198
	for s := 0; s < 3; s++ {
		t13.Square(t13)
	}

	// Step 697: t12 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f
	t12.Mul(t12, t13)

	// Step 706: t12 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e00
	for s := 0; s < 9; s++ {
		t12.Square(t12)
	}

	// Step 707: t12 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2b
	t12.Mul(t10, t12)

	// Step 712: t12 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c560
	for s := 0; s < 5; s++ {
		t12.Square(t12)
	}

	// Step 713: t11 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577
	t11.Mul(t11, t12)

	// Step 720: t11 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bb80
	for s := 0; s < 7; s++ {
		t11.Square(t11)
	}

	// Step 721: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbab
	t10.Mul(t10, t11)

	// Step 723: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeac
	for s := 0; s < 2; s++ {
		t10.Square(t10)
	}

	// Step 724: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf
	t10.Mul(t3, t10)

	// Step 734: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc00
	for s := 0; s < 10; s++ {
		t10.Square(t10)
	}

	// Step 735: t10 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc29
	t10.Mul(t7, t10)

	// Step 745: t10 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a400
	for s := 0; s < 10; s++ {
		t10.Square(t10)
	}

	// Step 746: t9 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437
	t9.Mul(t9, t10)

	// Step 752: t9 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290dc0
	for s := 0; s < 6; s++ {
		t9.Square(t9)
	}

	// Step 753: t8 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9
	t8.Mul(t8, t9)

	// Step 759: t8 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e40
	for s := 0; s < 6; s++ {
		t8.Square(t8)
	}

	// Step 760: t7 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e69
	t7.Mul(t7, t8)

	// Step 769: t7 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd200
	for s := 0; s < 9; s++ {
		t7.Square(t7)
	}

	// Step 770: t6 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227
	t6.Mul(t6, t7)

	// Step 776: t6 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489c0
	for s := 0; s < 6; s++ {
		t6.Square(t6)
	}

	// Step 777: t5 = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f3
	t5.Mul(t5, t6)

	// Step 784: t5 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f980
	for s := 0; s < 7; s++ {
		t5.Square(t5)
	}

	// Step 785: t4 = x^0x48ba093ee0f382b461f250013ebfcfae49861aa07451a214a09d7be021ef905c1ee98e39613a4640f3aebfc96d08c121a2723b44be7f641c7734f71cfaffcba62845b09599ea3e05833e2bbabc290df9a44f9a1
	t4.Mul(t4, t5)

	// Step 787: t4 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e684
	for s := 0; s < 2; s++ {
		t4.Square(t4)
	}

	// Step 788: t3 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e687
	t3.Mul(t3, t4)

	// Step 809: t3 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e00000
	for s := 0; s < 21; s++ {
		t3.Square(t3)
	}

	// Step 810: t3 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e00001
	t3.Mul(&x, t3)

	// Step 821: t3 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e68700000800
	for s := 0; s < 11; s++ {
		t3.Square(t3)
	}

	// Step 822: t2 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f
	t2.Mul(t2, t3)

	// Step 827: t2 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e0
	for s := 0; s < 5; s++ {
		t2.Square(t2)
	}

	// Step 828: t1 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e9
	t1.Mul(t1, t2)

	// Step 835: t1 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f480
	for s := 0; s < 7; s++ {
		t1.Square(t1)
	}

	// Step 836: t0 = x^0x122e824fb83ce0ad187c94004faff3eb926186a81d14688528275ef8087be41707ba638e584e91903cebaff25b423048689c8ed12f9fd9071dcd3dc73ebff2e98a116c25667a8f8160cf8aeeaf0a437e6913e6870000082f49d
	t0.Mul(t0, t1)

	// Step 881: t0 = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e93a00000000000
	for s := 0; s < 45; s++ {
		t0.Square(t0)
	}

	// Step 882: z = x^0x245d049f7079c15a30f928009f5fe7d724c30d503a28d10a504ebdf010f7c82e0f74c71cb09d232079d75fe4b6846090d1391da25f3fb20e3b9a7b8e7d7fe5d31422d84accf51f02c19f15dd5e1486fcd227cd0e0000105e93a00000000011
	z.Mul(z, t0)

	// Step 884: z = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f34380000417a4e800000000044
	for s := 0; s < 2; s++ {
		z.Square(z)
	}

	// Step 885: z = x^0x9174127dc1e70568c3e4a0027d7f9f5c930c3540e8a34429413af7c043df20b83dd31c72c2748c81e75d7f92da11824344e476897cfec838ee69ee39f5ff974c508b612b33d47c0b067c577578521bf3489f34380000417a4e800000000045
	z.Mul(&x, z)

	return z
}
