<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/ms_sql_server.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "MS SQL Server"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# MS SQL Server


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibMSSQL

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Microsoft SQL Server statistics.


It queries different SQL objects per instance from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per MSSQL instance

These metrics refer to the Microsoft SQL Servers instances defined on host.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mssql_instance | The instance name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mssql.instance_user_connections | user | connections |
| mssql.instance_sqlstats_batch_requests | batch | requests/s |
| mssql.instance_sql_errors | errors | errors/s |
| mssql.instance_sqlstats_sql_compilations | compilations | compilations/s |
| mssql.instance_sqlstats_sql_recompilations | recompiles | recompiles/s |
| mssql.instance_sqlstats_auto_parameterization_attempts | failed | attempts/s |
| mssql.instance_sqlstats_safe_auto_parameterization_attempts | safe | attempts/s |
| mssql.instance_accessmethods_page_splits | page | splits/s |
| mssql.instance_cache_hit_ratio | hit_ratio | percentage |
| mssql.instance_bufman_iops | read, written | pages/s |
| mssql.instance_bufman_checkpoint_pages | log | pages/s |
| mssql.instance_bufman_page_life_expectancy | life_expectancy | seconds |
| mssql.instance_memmgr_server_memory | memory | bytes |
| mssql.instance_memmgr_connection_memory_bytes | memory | bytes |
| mssql.instance_memmgr_pending_memory_grants | pending | processes |
| mssql.instance_memmgr_external_benefit_of_memory | benefit | bytes |
| mssql.instance_resource_deadlocks | alloc_unit, application, database, extent, file, hobt, key, metadata, oib, object, page, rid, row_group, xact | deadlocks/s |
| mssql.instance_resource_lock_wait | alloc_unit, application, database, extent, file, hobt, key, metadata, oib, object, page, rid, row_group, xact | locks/s |
| mssql.instance_blocked_processes | blocked | processes |

### Per Database

These metrics refer to Microsoft SQL Server databases.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mssql_instance | The instance name. |
| database | The database name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mssql.database_active_transactions | active | transactions |
| mssql.database_transactions | transactions | transactions/s |
| mssql.database_write_transactions | write | transactions/s |
| mssql.database_lockwait | lock | locks/s |
| mssql.database_deadlocks | deadlocks | deadlocks/s |
| mssql.database_lock_timeouts | timeouts | timeouts/s |
| mssql.database_lock_requests | requests | requests/s |
| mssql.database_backup_restore_operations | backup | operations/s |
| mssql.database_log_flushes | log | flushes/s |
| mssql.database_log_flushed | flushed | bytes/s |
| mssql.database_data_files_size | size | bytes |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| PerflibMSSQL | An option to enable or disable the data collection. | yes | no |

#### Examples
There are no configuration examples.


