/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import org.pgpainless.algorithm.StreamEncoding;

public class CRLFGeneratorStream
extends OutputStream {
    protected final OutputStream crlfOut;
    private final boolean isBinary;
    private int lastB = 0;

    public CRLFGeneratorStream(OutputStream crlfOut, StreamEncoding encoding) {
        this.crlfOut = crlfOut;
        this.isBinary = encoding == StreamEncoding.BINARY;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.isBinary) {
            if (b == 10 && this.lastB != 13) {
                this.crlfOut.write(13);
            } else if (this.lastB == 13 && b != 10) {
                this.crlfOut.write(10);
            }
            this.lastB = b;
        }
        this.crlfOut.write(b);
    }

    @Override
    public void close() throws IOException {
        if (!this.isBinary && this.lastB == 13) {
            this.crlfOut.write(10);
        }
        this.crlfOut.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.crlfOut.flush();
    }
}

