/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestFileUpdater {
    public static void prepareHttpRequestFiles(@NotNull List<HttpRequest> requests2) {
        if (requests2 == null) {
            HttpRequestFileUpdater.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        HashSet<HttpRequestPsiFile> files = new HashSet<HttpRequestPsiFile>();
        for (HttpRequest request : requests2) {
            PsiFile file = request.getContainingFile();
            if (!(file instanceof HttpRequestPsiFile)) continue;
            files.add((HttpRequestPsiFile)file);
        }
        for (HttpRequestPsiFile file : files) {
            HttpRequestFileUpdater.prepareHttpRequestFile(file);
        }
    }

    public static void prepareHttpRequestFile(@NotNull HttpRequestPsiFile file) {
        if (file == null) {
            HttpRequestFileUpdater.$$$reportNull$$$0(1);
        }
        Project project = file.getProject();
        Runnable runnable = () -> {
            HttpRequestBlock block;
            int offset;
            HttpRequestBlock[] blocks;
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument((PsiFile)file);
            if (document != null && (blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)file)).length > 0 && (offset = HttpRequestPsiUtils.getNextSeparatorStartOffset(block = blocks[blocks.length - 1])) < 0) {
                int endOffset = block.getTextRange().getEndOffset();
                document.insertString(endOffset, (CharSequence)("\n\n" + HttpRequestPsiConverter.getSeparator()));
                manager.commitDocument(document);
            }
        };
        String title = RestClientBundle.message("http.request.add.http.request.separator.command", new Object[0]);
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, runnable, title, null, UndoConfirmationPolicy.DEFAULT, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestFileUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareHttpRequestFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareHttpRequestFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

