/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.python;

import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.console.DbtCliUtilKt;
import com.intellij.dbt.detection.DbtService;
import com.intellij.dbt.python.PyDbtUtilKt;
import com.intellij.dbt.settings.DbtNewProjectSettings;
import com.intellij.dbt.settings.DbtNewProjectSettingsKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.newProject.DeprecatedUtils;
import com.jetbrains.python.sdk.PySdkUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/dbt/python/PyDbtUtil;", "", "<init>", "()V", "Companion", "intellij.dbt.python"})
public final class PyDbtUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0001\u00a2\u0006\u0002\b\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dbt/python/PyDbtUtil$Companion;", "", "<init>", "()V", "defaultSettingsDirectory", "", "getDefaultSettingsDirectory$intellij_dbt_python", "()Ljava/lang/String;", "getAllProfileNames", "", "getAllProfileNames$intellij_dbt_python", "configureNewDbtProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "dbtSettings", "Lcom/intellij/dbt/settings/DbtNewProjectSettings;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "expandProjectView", "showError", "errorMessage", "intellij.dbt.python"})
    @SourceDebugExtension(value={"SMAP\nPyDbtUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDbtUtil.kt\ncom/intellij/dbt/python/PyDbtUtil$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,132:1\n30#2,2:133\n1137#3,2:135\n*S KotlinDebug\n*F\n+ 1 PyDbtUtil.kt\ncom/intellij/dbt/python/PyDbtUtil$Companion\n*L\n98#1:133,2\n83#1:135,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultSettingsDirectory$intellij_dbt_python() {
            return DbtUtils.Companion.getDbtProfilesDir$default(DbtUtils.Companion, null, 1, null);
        }

        @RequiresBackgroundThread(generateAssertion=false)
        @NotNull
        public final Set<String> getAllProfileNames$intellij_dbt_python() {
            Set set;
            Set $this$getAllProfileNames_u24lambda_u240 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            $this$getAllProfileNames_u24lambda_u240.add(DbtNewProjectSettingsKt.getNEW_PROFILE_OPTION_NAME());
            $this$getAllProfileNames_u24lambda_u240.addAll((Collection)DbtUtils.Companion.getProfileNamesFromDir(Companion.getDefaultSettingsDirectory$intellij_dbt_python()));
            return SetsKt.build((Set)set);
        }

        public final void configureNewDbtProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull DbtNewProjectSettings dbtSettings, @Nullable Sdk sdk, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)dbtSettings, (String)"dbtSettings");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            if (sdk == null || sdk.getHomePath() == null) {
                this.showError(DbtBundle.message("dbt.create.project.invalid.interpreter", new Object[0]), project);
                return;
            }
            DeprecatedUtils.installFrameworkIfNeeded((Project)project, (String)"dbt", (String)"dbt-core", (Sdk)sdk, (boolean)true, () -> Companion.configureNewDbtProject$lambda$3(project, dbtSettings, baseDir, sdk, module));
        }

        private final void expandProjectView(VirtualFile baseDir, Project project) {
            VirtualFile file;
            VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory((VirtualFile)baseDir, (String)"models");
            if (virtualFile == null) {
                VirtualFile[] virtualFileArray = baseDir.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                virtualFile = (VirtualFile)ArraysKt.first((Object[])virtualFileArray);
            }
            if ((file = virtualFile) != null) {
                ProjectView.getInstance((Project)project).selectCB(null, file, true);
            }
        }

        private final void showError(String errorMessage, Project project) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.showError$lambda$4(project, errorMessage));
        }

        private static final void configureNewDbtProject$lambda$3$lambda$2(VirtualFile $baseDir, Project $project, Module $module) {
            Companion.expandProjectView($baseDir, $project);
            ComponentManager $this$service$iv = (ComponentManager)$project;
            boolean $i$f$service = false;
            Class<DbtService> serviceClass$iv = DbtService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbtService dbtService = (DbtService)object;
            BuildersKt.launch$default((CoroutineScope)dbtService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dbtService, $module, null){
                int label;
                final /* synthetic */ DbtService $dbtService;
                final /* synthetic */ Module $module;
                {
                    this.$dbtService = $dbtService;
                    this.$module = $module;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$dbtService.processModule(this.$module, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void configureNewDbtProject$lambda$3(Project $project, DbtNewProjectSettings $dbtSettings, VirtualFile $baseDir, Sdk $sdk, Module $module) {
            File tempDir = null;
            try {
                tempDir = FileUtil.generateRandomTemporaryPath();
                boolean created = tempDir.mkdir();
                if (!created) {
                    Companion.showError(DbtBundle.message("dbt.create.project.failed.to.create.temp.dir", new Object[0]), $project);
                    return;
                }
                String dbtName = DbtCliUtilKt.getDbtExecutableName();
                String initProfileName = $dbtSettings.getDbtProfile();
                if (Intrinsics.areEqual((Object)initProfileName, (Object)DbtNewProjectSettingsKt.getNEW_PROFILE_OPTION_NAME())) {
                    initProfileName = null;
                }
                String string = $baseDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String string2 = $project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                GeneralCommandLine commandLine = DbtUtils.Companion.generateDbtInitCommandLine(dbtName, string, string2, initProfileName, $dbtSettings.getDbtSettingsDirectory());
                ProcessOutput output = PySdkUtil.getProcessOutput((GeneralCommandLine)commandLine, (String)tempDir.getPath(), (Map)PySdkUtil.activateVirtualEnv((Sdk)$sdk), (int)30000, null, (boolean)false, (String)DbtBundle.message("dbt.create.project.title", new Object[0]));
                String string3 = output.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
                String dbtInitErrors = string3;
                if (StringsKt.startsWith$default((String)dbtInitErrors, (String)"\u001b[0m", (boolean)false, (int)2, null)) {
                    String string4 = dbtInitErrors.substring(4);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    dbtInitErrors = string4;
                }
                if (((CharSequence)dbtInitErrors).length() == 0) {
                    File rootRepoFile;
                    block19: {
                        File file;
                        File[] fileArray = tempDir.listFiles();
                        if (fileArray != null) {
                            File[] $this$first$iv = fileArray;
                            boolean $i$f$first = false;
                            int n = $this$first$iv.length;
                            for (int i = 0; i < n; ++i) {
                                File element$iv;
                                File file2 = element$iv = $this$first$iv[i];
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)file2.getName(), (Object)$project.getName())) continue;
                                file = element$iv;
                                break block19;
                            }
                            throw new NoSuchElementException("Array contains no element matching the predicate.");
                        }
                        file = rootRepoFile = null;
                    }
                    if (rootRepoFile == null) {
                        PyDbtUtilKt.access$getLOG$p().warn(DbtBundle.message("dbt.create.project.failed.to.get.project.in.temp.dir", new Object[0]));
                        return;
                    }
                    File[] fileArray = rootRepoFile.listFiles();
                    Intrinsics.checkNotNull((Object)fileArray);
                    for (File file : fileArray) {
                        String[] stringArray = new String[]{file.getName()};
                        file.renameTo(Paths.get($baseDir.getPath(), stringArray).toFile());
                    }
                } else {
                    String string5 = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getStderr(...)");
                    Companion.showError(string5, $project);
                }
                $baseDir.refresh(true, true, () -> Companion.configureNewDbtProject$lambda$3$lambda$2($baseDir, $project, $module));
            }
            catch (IOException e) {
                Companion.showError(DbtBundle.message("dbt.create.project.failed.to.initialize", new Object[0]), $project);
            }
            finally {
                if (tempDir != null) {
                    if (FileUtil.delete((File)tempDir)) {
                        PyDbtUtilKt.access$getLOG$p().info("Temp dir removed: " + tempDir);
                    } else {
                        PyDbtUtilKt.access$getLOG$p().warn("Failed to remove temp directory: " + tempDir);
                    }
                }
            }
        }

        private static final void showError$lambda$4(Project $project, String $errorMessage) {
            Object[] objectArray = new Object[]{$errorMessage};
            Messages.showErrorDialog((Project)$project, (String)DbtBundle.message("dbt.create.project.error", objectArray), (String)DbtBundle.message("dbt.create.project", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

