/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ml.features.imports;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.ml.api.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.ml.models.PythonImportsRankingModelHolder;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.catboost.prediction.CatBoostRegressionResult;
import com.jetbrains.ml.tools.model.pipeline.ModelPipeline;
import com.jetbrains.ml.tools.model.pipeline.ModelPipelineLoader;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000RF\u0010\u000b\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u001a\u0010\u0007\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/ml/features/imports/ImportsRankingModelService;", "", "<init>", "()V", "modelFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "value", "Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "Lcom/jetbrains/ml/tools/model/MLModel;", "Lcom/jetbrains/ml/tools/model/catboost/prediction/CatBoostRegressionResult;", "model", "getModel", "()Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "loadModel", "", "Companion", "intellij.python.ml.features"})
@SourceDebugExtension(value={"SMAP\nmlModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 mlModel.kt\ncom/intellij/python/ml/features/imports/ImportsRankingModelService\n+ 2 ModelPipeline.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipeline\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n55#2,5:61\n14#3:66\n*S KotlinDebug\n*F\n+ 1 mlModel.kt\ncom/intellij/python/ml/features/imports/ImportsRankingModelService\n*L\n39#1:61,5\n50#1:66\n*E\n"})
public final class ImportsRankingModelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompletableFuture<Void> modelFuture;
    @Nullable
    private ModelPipeline<MLModel<CatBoostRegressionResult>, CatBoostRegressionResult> model;
    @NotNull
    private static final Logger LOG;

    public ImportsRankingModelService() {
        this.loadModel();
    }

    @Nullable
    public final ModelPipeline<MLModel<CatBoostRegressionResult>, CatBoostRegressionResult> getModel() {
        return this.model;
    }

    private final void loadModel() {
        CompletableFuture<Void> completableFuture = this.modelFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        LOG.info("Loading CatBoost Imports Ranking model");
        InputStream inputStream = PythonImportsRankingModelHolder.getStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getStream(...)");
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        this.modelFuture = ((CompletableFuture)ModelPipelineLoader.INSTANCE.load(inputStream, executorService).thenAccept(arg_0 -> ImportsRankingModelService.loadModel$lambda$1(arg_0 -> ImportsRankingModelService.loadModel$lambda$0(this, arg_0), arg_0))).exceptionally(ImportsRankingModelService::loadModel$lambda$2);
    }

    private static final Unit loadModel$lambda$0(ImportsRankingModelService this$0, ModelPipeline model) {
        LOG.info("Successfully loaded imports ranking model");
        ModelPipeline this_$iv = model;
        boolean $i$f$predicting = false;
        if (!CatBoostRegressionResult.class.isAssignableFrom(this_$iv.getBaseModel().getPredictedType())) {
            boolean bl = false;
            String string = "ML model predicts " + this_$iv.getBaseModel().getPredictedType().getName() + ", which is not a kind of " + CatBoostRegressionResult.class.getName();
            throw new IllegalArgumentException(string.toString());
        }
        FeaturePreprocessor featurePreprocessor = this_$iv.getPreprocessing();
        MLModel mLModel = this_$iv.getBaseModel();
        Intrinsics.checkNotNull((Object)mLModel, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
        this$0.model = new ModelPipeline(featurePreprocessor, mLModel, this_$iv.getInfo());
        return Unit.INSTANCE;
    }

    private static final void loadModel$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void loadModel$lambda$2(Throwable e) {
        LOG.warn("Failed to load CatBoost imports ranking model", e);
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ImportsRankingModelService getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImportsRankingModelService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/python/ml/features/imports/ImportsRankingModelService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/python/ml/features/imports/ImportsRankingModelService;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.ml.features"})
    @SourceDebugExtension(value={"SMAP\nmlModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 mlModel.kt\ncom/intellij/python/ml/features/imports/ImportsRankingModelService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,60:1\n40#2,3:61\n*S KotlinDebug\n*F\n+ 1 mlModel.kt\ncom/intellij/python/ml/features/imports/ImportsRankingModelService$Companion\n*L\n48#1:61,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ImportsRankingModelService getInstance() {
            boolean $i$f$service = false;
            Class<ImportsRankingModelService> serviceClass$iv = ImportsRankingModelService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ImportsRankingModelService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

