/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.FilePropertyPusherBase;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FilePropertyKey;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlDialectPusher
extends FilePropertyPusherBase<SqlLanguageDialect> {
    @NotNull
    public FilePropertyKey<SqlLanguageDialect> getFilePropertyKey() {
        FilePropertyKey<SqlLanguageDialect> filePropertyKey = SqlDialectMappings.SQL_DIALECT_KEY;
        if (filePropertyKey == null) {
            SqlDialectPusher.$$$reportNull$$$0(0);
        }
        return filePropertyKey;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    private static FileType getFileType(VirtualFile file) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence());
    }

    @NotNull
    public SqlLanguageDialect getDefaultValue() {
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialect == null) {
            SqlDialectPusher.$$$reportNull$$$0(1);
        }
        return sqlLanguageDialect;
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        LocalDataSource source;
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(2);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file) && (source = DbSrcUtilsCore.findDataSource(file)) != null) {
            return DbSqlUtilCore.getSqlDialect(source);
        }
        return (SqlLanguageDialect)SqlDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    public SqlLanguageDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            SqlDialectPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(5);
        }
        return ((Object)((Object)SqlFileType.INSTANCE)).equals(SqlDialectPusher.getFileType(file));
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlDialectPusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull SqlLanguageDialect actualProperty) {
        if (project == null) {
            SqlDialectPusher.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            SqlDialectPusher.$$$reportNull$$$0(9);
        }
        if (actualProperty == null) {
            SqlDialectPusher.$$$reportNull$$$0(10);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file -> this.acceptsFile((VirtualFile)file, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlDialectPusher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

