/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternSerialization;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.util.ObjectUtils;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jettison.mapped.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlResolveMappings", storages={@Storage(value="sqldialects.xml")})
public class SqlResolveMappings
extends PerFileMappingsBase<TreePattern> {
    private static final JsonWriter.Format JSON_FORMAT = new JsonWriter.Format(new char[]{' '}, new char[]{' '}, JsonWriter.Format.COMPACT_EMPTY_ELEMENT);
    public static final TreePattern ALL_DATA_SOURCES = new TreePattern(TreePatternUtils.create((ObjectName)null, SqlImportUtil.DATA_SOURCE, new TreePatternNode.Group[0]));

    public static SqlResolveMappings getInstance(Project project) {
        return (SqlResolveMappings)((Object)project.getService(SqlResolveMappings.class));
    }

    public SqlResolveMappings(@NotNull Project project) {
        if (project == null) {
            SqlResolveMappings.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    protected Project getProject() {
        Project project = Objects.requireNonNull(super.getProject());
        if (project == null) {
            SqlResolveMappings.$$$reportNull$$$0(1);
        }
        return project;
    }

    @NotNull
    protected String getValueAttribute() {
        return "scope";
    }

    @NotNull
    public List<TreePattern> getAvailableValues() {
        List<TreePattern> list = Collections.emptyList();
        if (list == null) {
            SqlResolveMappings.$$$reportNull$$$0(2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String serialize(@NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlResolveMappings.$$$reportNull$$$0(3);
        }
        StringWriter res = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)res, JSON_FORMAT);){
            TreePatternSerialization.serialize((HierarchicalStreamWriter)writer, pattern, false);
        }
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TreePattern handleUnknownMapping(VirtualFile file, String value) {
        if (StringUtil.isEmpty((String)value)) {
            return TreePattern.EMPTY;
        }
        Configuration config = new Configuration();
        config.setRootElementArrayWrapper(true);
        try (HierarchicalStreamReader reader = new JettisonMappedXmlDriver(config).createReader((Reader)new StringReader(value));){
            TreePattern treePattern = TreePatternSerialization.deserialize(reader);
            return treePattern;
        }
    }

    @Nullable
    protected TreePattern getNotInHierarchy(@Nullable VirtualFile file, @NotNull Map<VirtualFile, TreePattern> mappings) {
        TreePattern mapping;
        if (mappings == null) {
            SqlResolveMappings.$$$reportNull$$$0(4);
        }
        if ((mapping = (TreePattern)super.getNotInHierarchy(file, mappings)) != null) {
            return mapping;
        }
        if (DbVFSUtils.isConsoleFile(file)) {
            DbDataSource dataSource = DbVFSUtils.getDataSource(this.getProject(), file);
            LocalDataSource localDataSource = dataSource == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
            boolean nonProject = dataSource == null || localDataSource != null && localDataSource.isGlobal();
            return nonProject ? null : mappings.get(null);
        }
        return null;
    }

    @Nullable
    public TreePattern getDefaultMapping(@Nullable VirtualFile file) {
        return ALL_DATA_SOURCES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlResolveMappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlResolveMappings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNotInHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

