/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementFileType;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.intellij.psi.util.PsiAwareObject;
import com.intellij.sql.editor.SqlEditorTabsSettings;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ElementPresentation.class)
public abstract class DatabaseElementVirtualFileImpl
extends VirtualFile
implements ProjectAwareVirtualFile,
VirtualFilePathWrapper,
PsiAwareObject {
    public static final int DATASOURCE_NAME_LENGTH = 36;
    @Nullable
    private final ObjectPath myPath;
    @Nullable
    private final ObjectKind myFamily;
    private boolean myWritable;
    private final String myDataSourceId;
    private Pair<Reference<DbElement>, Long> myCachedPsi;

    protected DatabaseElementVirtualFileImpl(@NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind family) {
        if (dataSourceId == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(0);
        }
        this.myWritable = true;
        this.myDataSourceId = dataSourceId;
        this.myPath = path != null && path.kind == ObjectKind.ROOT ? null : path;
        this.myFamily = family;
    }

    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    @Nullable
    public ObjectPath getObjectPath() {
        return this.myPath;
    }

    @Nullable
    public ObjectKind getFamily() {
        return this.myFamily;
    }

    public DbDataSource findDataSource(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(1);
        }
        return DbPsiFacade.getInstance(project).findDataSource(this.myDataSourceId);
    }

    public boolean isSource() {
        return false;
    }

    @NotNull
    public String getPath() {
        String string = DatabaseVirtualFileSystem.getPath(this.getDataSourceId(), this.myPath, this.myFamily, this.isSource());
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String getUrl(String dataSourceId, ObjectPath path, ObjectKind family, boolean source) {
        return "das://" + DatabaseVirtualFileSystem.getPath(dataSourceId, path, family, source);
    }

    @NotNull
    public String getName() {
        String string = this.getNameWithoutExtension();
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = this.myFamily == null ? DbSrcUtilsCore.escapeChars(this.myPath == null ? this.getDataSourceId() : this.myPath.name) : this.myFamily.code();
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isInProject(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return this.findDataSource(project) != null;
    }

    @NotNull
    public ObjectKind getObjectKind() {
        ObjectKind objectKind = this.myPath == null ? ObjectKind.ROOT : this.myPath.kind;
        if (objectKind == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Nullable
    public DbElement findElement(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return this.findElementInner(this.findDataSource(project));
    }

    @Nullable
    DbDataSource findDataSourceInAnyProject() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource result2 = this.findDataSource(project);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private DbElement findElementInner(@Nullable DbDataSource dataSource) {
        DbElement cached;
        if (dataSource == null) {
            return null;
        }
        if (this.myPath == null) {
            return dataSource;
        }
        Project project = dataSource.getProject();
        long timestamp = DbPsiFacade.getInstance(project).getModificationCount();
        Pair<Reference<DbElement>, Long> cachedPsi = this.myCachedPsi;
        DbElement dbElement = cached = cachedPsi != null && (Long)cachedPsi.second == timestamp ? (DbElement)((Reference)cachedPsi.first).get() : null;
        if (cached != null && cached.getProject() == project) {
            return cached;
        }
        DbElement found = dataSource.findElement(this.myPath);
        this.myCachedPsi = found != null ? Pair.create(new WeakReference<DbElement>(found), (Object)timestamp) : null;
        return found;
    }

    @NotNull
    public FileType getFileType() {
        DatabaseElementFileType databaseElementFileType = DatabaseElementFileType.INSTANCE;
        if (databaseElementFileType == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(8);
        }
        return databaseElementFileType;
    }

    @NotNull
    public DatabaseVirtualFileSystem getFileSystem() {
        DatabaseVirtualFileSystem databaseVirtualFileSystem = DatabaseVirtualFileSystem.getDatabaseFileSystem();
        if (databaseVirtualFileSystem == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(9);
        }
        return databaseVirtualFileSystem;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setWritable(boolean writable) {
        boolean prev = this.myWritable;
        DbDataSource dataSource = !writable ? null : this.findDataSourceInAnyProject();
        boolean bl = this.myWritable = dataSource != null && dataSource.isWritable();
        if (prev != this.myWritable) {
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, (VirtualFile)this, "writable", (Object)prev, (Object)this.myWritable));
            publisher.before(events);
            publisher.after(events);
        }
    }

    public final void setWritableInner(boolean writable) {
        this.myWritable = writable;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        ObjectKind parentFamily;
        ObjectPath prentPath;
        if (this.myPath == null && this.myFamily == null) {
            return null;
        }
        if (this.myFamily == null) {
            prentPath = this.myPath.parent;
            parentFamily = this.myPath.kind;
        } else {
            prentPath = this.myPath;
            parentFamily = null;
        }
        String path = DatabaseVirtualFileSystem.getPath(this.getDataSourceId(), prentPath, parentFamily, this.isSource());
        return DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("No read for table file");
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("No write for table file");
    }

    public byte @NotNull [] contentsToByteArray() {
        throw new UnsupportedOperationException("No read for table file");
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isValid() {
        return DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(this.getPath()) != null;
    }

    private static boolean isLoadingDS(@NotNull DbDataSource dataSource) {
        LocalDataSource localDataSource;
        if (dataSource == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(10);
        }
        return (localDataSource = DbImplUtilCore.getMaybeLocalDataSource(dataSource)) != null && dataSource.isLoading();
    }

    public boolean shouldBeValid() {
        if (!LoadingState.PROJECT_OPENED.isOccurred()) {
            return true;
        }
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        if (dataSource == null || !dataSource.isValid()) {
            return false;
        }
        if (DatabaseElementVirtualFileImpl.isLoadingDS(dataSource)) {
            return true;
        }
        return this.findElementInner(dataSource) != null;
    }

    private String validnessStatus() {
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        if (dataSource == null) {
            return "DS not found";
        }
        if (!dataSource.isValid()) {
            return "DS invalid";
        }
        if (DatabaseElementVirtualFileImpl.isLoadingDS(dataSource)) {
            return "DS loading";
        }
        if (this.findElementInner(dataSource) == null) {
            return "Element not found";
        }
        return "Valid";
    }

    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(11);
        }
        return (T)(key2 == FileDocumentManagerBase.TRACK_NON_PHYSICAL ? Boolean.TRUE : super.getUserData(key2));
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable DbElement element, boolean source) {
        if (element == null || !element.isValid()) {
            return null;
        }
        Project project = element.getProject();
        String path = DatabaseElementVirtualFileImpl.getPath(element, source);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && file.findElement(project) != element) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    public static String getPath(@NotNull DasDataSource dataSource, @NotNull DasObject object, boolean source) {
        if (dataSource == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(12);
        }
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(13);
        }
        ObjectPath path = object == dataSource ? null : ObjectPaths.of(object, dataSource.getModel());
        return DatabaseVirtualFileSystem.getPath(dataSource.getUniqueId(), path, null, source);
    }

    private static String getPath(@NotNull DbElement element, boolean source) {
        if (element == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(14);
        }
        return DatabaseElementVirtualFileImpl.getPath(element.getDataSource(), element, source);
    }

    @NotNull
    public String getPresentableName() {
        return this.getPresentableName(true);
    }

    @NotNull
    private String getPresentableName(boolean shorten) {
        return this.adjustPresentableName(this.getSimplePresentableName(shorten), shorten);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getPresentablePath(true);
    }

    @NotNull
    private String getPresentablePath(boolean shorten) {
        return this.adjustPresentableName(this.getSimplePresentablePath(shorten), shorten);
    }

    @NotNull
    private String getSimplePresentablePath(boolean shorten) {
        if (this.myPath == null && this.myFamily == null) {
            String string = DatabaseBundle.message("ObjectKind.server", new Object[0]);
            if (string == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (this.myPath == null) {
            String string = this.myFamily.getPluralPresentableName();
            if (string == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        String displayName = this.myPath.getDisplayName();
        int size = this.myPath.getSize();
        int maxLength = 36;
        String pathName = displayName.length() <= maxLength || !shorten ? displayName : this.myPath.reduce(new StringBuilder(), (sb, p2) -> (!sb.isEmpty() && !p2.name.isEmpty() ? sb.append(".") : sb).append(StringUtil.trimMiddle((String)p2.name, (int)(maxLength / size)))).toString();
        Object object = this.myFamily != null ? this.myFamily.getPluralPresentableName() + " in " + pathName : pathName;
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(17);
        }
        return object;
    }

    @NotNull
    private String getSimplePresentableName(boolean shorten) {
        String pathName;
        if (this.myPath == null && this.myFamily == null) {
            String string = DatabaseBundle.message("ObjectKind.server", new Object[0]);
            if (string == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = this.myPath == null ? null : (pathName = shorten ? StringUtil.trimMiddle((String)this.myPath.name, (int)20) : this.myPath.name);
        if (this.myFamily == null) {
            String string2 = pathName;
            if (string2 == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(19);
            }
            return string2;
        }
        String string3 = this.myFamily.getPluralPresentableName() + (String)(pathName == null ? "" : " in " + pathName);
        if (string3 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(20);
        }
        return string3;
    }

    @NotNull
    private String adjustPresentableName(@NotNull String name2, boolean shorten) {
        if (name2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(21);
        }
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        String string = (String)(this.isSource() ? name2 + " (DDL)" : name2) + DatabaseElementVirtualFileImpl.getDataSourceText(dataSource, this.getObjectKind(), shorten);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String getDataSourceText(@Nullable DbDataSource dataSource, @Nullable ObjectKind kind, boolean shorten) {
        if (dataSource == null || kind == ObjectKind.ROOT) {
            return "";
        }
        String name2 = shorten ? StringUtil.trimMiddle((String)dataSource.getName(), (int)36) : dataSource.getName();
        String string = " [" + name2 + "]";
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    public String toString() {
        return "DB VirtualFile: " + String.valueOf(this.getObjectKind()) + (String)(this.myFamily == null ? "" : "[" + this.myFamily.code() + "]") + ", " + this.getPresentableUrl() + " (" + this.validnessStatus() + ")";
    }

    @NlsContexts.TabTitle
    public static String getEditorTabTitleImpl(@NotNull Project project, @NotNull DatabaseElementVirtualFileImpl file, boolean dataSourceSuffix, boolean shorten) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(24);
        }
        if (file == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(25);
        }
        return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, file.myPath, file.findDataSource(project), dataSourceSuffix, shorten);
    }

    @NlsSafe
    public static String getEditorTabTitleImpl(@NotNull Project project, @NotNull VirtualFile file, @Nullable ObjectPath path, @Nullable DbDataSource dataSource, boolean dataSourceSuffix, boolean shorten) {
        boolean qualify;
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(27);
        }
        boolean bl = qualify = SqlEditorTabsSettings.getInstance().isAlwaysQualifyTabNames() || JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getOpenFiles()).find(o -> !file.equals(o) && o.getName().equals(file.getName())) != null;
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return qualify ? (dataSourceSuffix ? dbFile.getPresentablePath(shorten) : dbFile.getSimplePresentablePath(shorten)) : (dataSourceSuffix ? dbFile.getPresentableName(shorten) : dbFile.getSimplePresentableName(shorten));
        }
        return (path == null ? "" : (qualify ? path.getDisplayName() : path.getName())) + (dataSourceSuffix ? DatabaseElementVirtualFileImpl.getDataSourceText(dataSource, path == null ? ObjectKind.ROOT : path.kind, shorten) : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8, 9, 15, 16, 17, 18, 19, 20, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKind";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplePresentablePath";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplePresentableName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLoadingDS";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "adjustPresentableName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitleImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8, 9, 15, 16, 17, 18, 19, 20, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static class ElementPresentation
    extends PresentationProvider<DatabaseElementVirtualFileImpl> {
        public Icon getIcon(DatabaseElementVirtualFileImpl file) {
            DbDataSource dataSource = file.findDataSourceInAnyProject();
            Dbms dbms = DbImplUtilCore.getDbms(dataSource);
            if (file.myFamily != null) {
                return DbPresentationCore.getIcon(dbms, file.myFamily);
            }
            DbElement element = file.findElementInner(dataSource);
            return element == null ? DbPresentationCore.getIcon(dbms, file.getObjectKind()) : element.getIcon();
        }
    }
}

