/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.compose.target;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.compose.target.DockerComposeEnvironmentRequest;
import com.intellij.docker.remote.compose.target.DockerComposeTargetEnvironmentConfiguration;
import com.intellij.docker.remote.compose.target.DockerComposeTargetType;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.wsl.target.WslTargetType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.docker.compose.target.HelpersAwareDockerComposeTargetEnvironmentRequest;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.ui.TargetPanelExtension;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020&*\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R&\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Lcom/intellij/python/docker/compose/target/PyDockerComposeTargetEnvironmentFactory;", "Lcom/jetbrains/python/run/PythonInterpreterTargetEnvironmentFactory;", "<init>", "()V", "canProbablyRunCodeForeignTypes", "", "Ljava/lang/Class;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "getCanProbablyRunCodeForeignTypes", "()Ljava/util/List;", "getPythonTargetInterpreter", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "packageManagementSupported", "", "evConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)Ljava/lang/Boolean;", "getTargetType", "isMutable", "configuration", "getDefaultSdkName", "", "data", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "version", "getPanelExtension", "Lcom/jetbrains/python/target/ui/TargetPanelExtension;", "isFor", "needAssociateWithModule", "createDockerComposeEnvironmentRequest", "Lcom/intellij/docker/remote/compose/target/DockerComposeEnvironmentRequest;", "holder", "Lcom/intellij/docker/remote/DockerComposeCredentialsHolder;", "addProjectBasePathToUploads", "", "intellij.python.docker"})
@SourceDebugExtension(value={"SMAP\nPyDockerComposeTargetEnvironmentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDockerComposeTargetEnvironmentFactory.kt\ncom/intellij/python/docker/compose/target/PyDockerComposeTargetEnvironmentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class PyDockerComposeTargetEnvironmentFactory
implements PythonInterpreterTargetEnvironmentFactory {
    @NotNull
    private final List<Class<? extends TargetEnvironmentType<?>>> canProbablyRunCodeForeignTypes = CollectionsKt.listOf(WslTargetType.class);

    @NotNull
    public List<Class<? extends TargetEnvironmentType<?>>> getCanProbablyRunCodeForeignTypes() {
        return this.canProbablyRunCodeForeignTypes;
    }

    @Nullable
    public HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter(@NotNull Sdk sdk, @NotNull Project project) {
        DockerComposeEnvironmentRequest targetEnvironmentRequest;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalData) {
            Object credentials = ((PyRemoteSdkAdditionalData)sdkAdditionalData).connectionCredentials().getCredentials();
            DockerComposeCredentialsHolder dockerComposeCredentialsHolder = credentials instanceof DockerComposeCredentialsHolder ? (DockerComposeCredentialsHolder)credentials : null;
            if (dockerComposeCredentialsHolder != null) {
                DockerComposeCredentialsHolder it = dockerComposeCredentialsHolder;
                boolean bl = false;
                v1 = this.createDockerComposeEnvironmentRequest(it);
            } else {
                v1 = null;
            }
        } else {
            TargetEnvironmentRequest targetEnvironmentRequest2;
            v1 = sdkAdditionalData instanceof PyTargetAwareAdditionalData ? ((targetEnvironmentRequest2 = TargetBasedSdks.getTargetEnvironmentRequest((TargetBasedSdkAdditionalData)((TargetBasedSdkAdditionalData)sdkAdditionalData), (Project)project)) instanceof DockerComposeEnvironmentRequest ? (DockerComposeEnvironmentRequest)targetEnvironmentRequest2 : null) : (targetEnvironmentRequest = null);
        }
        if (targetEnvironmentRequest == null) {
            return null;
        }
        this.addProjectBasePathToUploads(targetEnvironmentRequest, project);
        return new HelpersAwareDockerComposeTargetEnvironmentRequest(targetEnvironmentRequest);
    }

    @Nullable
    public Boolean packageManagementSupported(@NotNull TargetEnvironmentConfiguration evConfiguration) {
        Intrinsics.checkNotNullParameter((Object)evConfiguration, (String)"evConfiguration");
        return evConfiguration instanceof DockerComposeTargetEnvironmentConfiguration ? Boolean.valueOf(false) : null;
    }

    @NotNull
    public TargetEnvironmentType<?> getTargetType() {
        return (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findExtensionOrFail(DockerComposeTargetType.class);
    }

    @NotNull
    public Boolean isMutable(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return false;
    }

    @Nullable
    public String getDefaultSdkName(@Nullable Project project, @NotNull PyTargetAwareAdditionalData data, @Nullable String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = data.getTargetEnvironmentConfiguration();
        DockerComposeTargetEnvironmentConfiguration dockerComposeTargetEnvironmentConfiguration = targetEnvironmentConfiguration instanceof DockerComposeTargetEnvironmentConfiguration ? (DockerComposeTargetEnvironmentConfiguration)targetEnvironmentConfiguration : null;
        if (dockerComposeTargetEnvironmentConfiguration != null) {
            DockerComposeTargetEnvironmentConfiguration configuration = dockerComposeTargetEnvironmentConfiguration;
            boolean bl = false;
            String serviceName = configuration.getServiceName();
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown interpreter";
            }
            string = "Remote " + string2 + " Docker Compose (" + serviceName + ")";
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public TargetPanelExtension getPanelExtension(@NotNull Project project, @NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return null;
    }

    public boolean isFor(@NotNull TargetEnvironmentConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof DockerComposeTargetEnvironmentConfiguration;
    }

    public boolean needAssociateWithModule() {
        return true;
    }

    private final DockerComposeEnvironmentRequest createDockerComposeEnvironmentRequest(DockerComposeCredentialsHolder holder) {
        RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(holder.getAccountName(), (ServerType)DockerCloudType.getInstance());
        if (remoteServer == null) {
            throw new IllegalStateException("Cannot find Docker Server " + holder.getAccountName());
        }
        RemoteServer dockerServer = remoteServer;
        ServerConfiguration serverConfiguration = dockerServer.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)serverConfiguration;
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.Companion.create(dockerCloudConfiguration, null);
        DockerComposeTargetEnvironmentConfiguration configuration = new DockerComposeTargetEnvironmentConfiguration();
        configuration.setDockerServer(dockerServer);
        List list = holder.getComposeFilePaths();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComposeFilePaths(...)");
        configuration.setConfigurationFiles(list);
        configuration.setServiceName(holder.getComposeServiceName());
        return new DockerComposeEnvironmentRequest(dockerRuntime, configuration);
    }

    private final void addProjectBasePathToUploads(DockerComposeEnvironmentRequest $this$addProjectBasePathToUploads, Project project) {
        block0: {
            String string = project.getBasePath();
            if (string == null) break block0;
            String basePath = string;
            boolean bl = false;
            Collection collection = $this$addProjectBasePathToUploads.getUploadVolumes();
            Path path2 = Paths.get(basePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            collection.add(new TargetEnvironment.UploadRoot(path2, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Persistent("/opt/project"), false, 4, null));
        }
    }
}

