/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.testRunner;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.django.DjangoRunnerUtilsKt;
import com.intellij.python.django.testRunner.DjangoTestTestIdUrlProvider;
import com.intellij.python.django.testRunner.DjangoTestsRunConfiguration;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.testing.PythonTRunnerConsoleProperties;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DjangoTestsCommandLineState
extends PythonTestCommandLineStateBase<DjangoTestsRunConfiguration> {
    public DjangoTestsCommandLineState(DjangoTestsRunConfiguration configuration, ExecutionEnvironment env) {
        super((AbstractPythonRunConfiguration)configuration, env);
    }

    protected Collection<String> collectPythonPath() {
        String root;
        ArrayList<String> paths = new ArrayList<String>();
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        if (module != null && (root = DjangoUtil.getProjectRoot((Module)module)) != null) {
            return DjangoTestsCommandLineState.addDjangoRoot(paths, root);
        }
        return paths;
    }

    private static Collection<String> addDjangoRoot(@NotNull Collection<String> paths, @NotNull String root) {
        String filePath;
        if (paths == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(1);
        }
        ArrayList<String> pathsList = new ArrayList<String>(paths);
        HashSet vals = Sets.newHashSet(paths);
        if (!vals.contains(filePath = FileUtil.toSystemDependentName((String)root))) {
            pathsList.add(0, filePath);
        }
        return pathsList;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.withEnvironment(DjangoRunnerUtilsKt.fixEnvsIfNeeded(SystemInfo.isWin10OrNewer, commandLine.getEnvironment(), System.getenv()));
        return super.doCreateProcess(commandLine);
    }

    protected void addBeforeParameters(GeneralCommandLine cmd) {
        ParamsGroup scriptGroup = Objects.requireNonNull(cmd.getParametersList().getParamsGroup("Script"));
        scriptGroup.addParameter("test");
        String options = ((DjangoTestsRunConfiguration)this.myConfiguration).getDjangoOptions();
        if (((DjangoTestsRunConfiguration)this.myConfiguration).isUseOptions() && !StringUtil.isEmptyOrSpaces((String)options)) {
            scriptGroup.addParametersString(options);
        }
    }

    protected void addAfterParameters(GeneralCommandLine cmd) {
        ParamsGroup scriptGroup = Objects.requireNonNull(cmd.getParametersList().getParamsGroup("Script"));
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        Project project = ((DjangoTestsRunConfiguration)this.myConfiguration).getProject();
        if (module == null) {
            module = DjangoUtil.getDjangoModule((Project)project);
        }
        if (module != null) {
            VirtualFile manageFile = DjangoUtil.getManageFile((Module)module);
            String projectRoot = null;
            if (manageFile != null) {
                projectRoot = manageFile.getParent().getPath();
            }
            if (projectRoot == null) {
                projectRoot = project.getBasePath();
            }
            assert (projectRoot != null);
            scriptGroup.addParameters(new String[]{FileUtil.toSystemDependentName((String)projectRoot)});
        }
    }

    protected void addBeforeParameters(@NotNull PythonScriptExecution testScriptExecution) {
        if (testScriptExecution == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(2);
        }
        testScriptExecution.addParameter("test");
        String options = ((DjangoTestsRunConfiguration)this.myConfiguration).getDjangoOptions();
        if (((DjangoTestsRunConfiguration)this.myConfiguration).isUseOptions() && !StringUtil.isEmptyOrSpaces((String)options)) {
            PythonScripts.addParametersString((PythonExecution)testScriptExecution, (String)options);
        }
    }

    protected void addAfterParameters(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull PythonScriptExecution testScriptExecution) {
        if (targetEnvironmentRequest == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(3);
        }
        if (testScriptExecution == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(4);
        }
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        Project project = ((DjangoTestsRunConfiguration)this.myConfiguration).getProject();
        if (module == null) {
            module = DjangoUtil.getDjangoModule((Project)project);
        }
        if (module != null) {
            VirtualFile manageFile = DjangoUtil.getManageFile((Module)module);
            String projectRoot = null;
            if (manageFile != null) {
                projectRoot = manageFile.getParent().getPath();
            }
            if (projectRoot == null) {
                projectRoot = project.getBasePath();
            }
            assert (projectRoot != null);
            testScriptExecution.addParameter(TargetEnvironmentFunctions.targetPath((Path)Path.of(projectRoot, new String[0])));
        }
    }

    protected PythonHelper getRunner() {
        return PythonHelper.DJANGO_TEST_MANAGE;
    }

    @NotNull
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String target = ((DjangoTestsRunConfiguration)this.myConfiguration).getTarget();
        if (!StringUtil.isEmptyOrSpaces((String)target)) {
            specs.addAll(StringUtil.split((String)target, (String)" "));
        }
        ArrayList<String> arrayList = specs;
        if (arrayList == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    protected List<Function<TargetEnvironment, String>> getTestSpecs(@NotNull TargetEnvironmentRequest request) {
        String target;
        if (request == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)(target = ((DjangoTestsRunConfiguration)this.myConfiguration).getTarget()))) {
            List<Function<TargetEnvironment, String>> list = List.of();
            if (list == null) {
                DjangoTestsCommandLineState.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.map((Collection)StringUtil.split((String)target, (String)" "), TargetEnvironmentFunctions::constant);
        if (list == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        if (module != null) {
            DjangoUtil.addCustomTestSettingsModule(module, envs, (DjangoTestsRunConfiguration)this.myConfiguration);
            DjangoUtil.addPyCharmManageModule(module, envs);
        }
        Collection<String> paths = this.collectPythonPath();
        PythonEnvUtil.addToPythonPath(envs, paths);
    }

    protected void customizePythonExecutionEnvironmentVars(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (helpersAwareTargetRequest == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(9);
        }
        if (envs == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(10);
        }
        super.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, envs, passParentEnvs);
        Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        if (module != null) {
            DjangoUtil.addCustomTestSettingsModule(helpersAwareTargetRequest, module, envs, (DjangoTestsRunConfiguration)this.myConfiguration);
            DjangoUtil.addPyCharmManageModule(helpersAwareTargetRequest, module, envs);
            String root = DjangoUtil.getProjectRoot((Module)module);
            if (root != null) {
                Function rootTargetPath = TargetEnvironmentFunctions.targetPath((Path)Path.of(root, new String[0]));
                PythonScripts.appendToPythonPath(envs, (Function)rootTargetPath, (TargetPlatform)targetEnvironmentRequest.getTargetPlatform());
            }
        }
    }

    protected PythonTRunnerConsoleProperties createConsoleProperties(Executor executor) {
        return new PythonTRunnerConsoleProperties((ModuleRunConfiguration)this.myConfiguration, executor, true, this.getTestLocator());
    }

    protected SMTestLocator getTestLocator() {
        return DjangoTestTestIdUrlProvider.INSTANCE;
    }

    protected void setWorkingDirectory(@NotNull GeneralCommandLine cmd) {
        String workingDirectory;
        if (cmd == null) {
            DjangoTestsCommandLineState.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(workingDirectory = PythonScriptCommandLineState.getExpandedWorkingDir((AbstractPythonRunConfiguration)this.myConfiguration)))) {
            cmd.withWorkDirectory(workingDirectory);
        } else {
            String baseDir;
            Module module = ((DjangoTestsRunConfiguration)this.myConfiguration).getModule();
            if (module != null && !StringUtil.isEmptyOrSpaces((String)(baseDir = DjangoUtil.getProjectRoot((Module)module)))) {
                cmd.withWorkDirectory(baseDir);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScriptExecution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/testRunner/DjangoTestsCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/testRunner/DjangoTestsCommandLineState";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeParameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAfterParameters";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestSpecs";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

