/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.AbstractPsiCachedValue;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlSymbolDeclaration;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.descriptors.AttributeFinder;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.RngNsDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngXmlAttributeDescriptor;
import org.intellij.plugins.relaxNG.validation.RngSchemaValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DEmptyPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DTextPattern;
import org.kohsuke.rngom.nc.NameClass;
import org.kohsuke.rngom.nc.NameClassVisitor;
import org.xml.sax.Locator;

public class RngElementDescriptor
implements XmlElementDescriptor {
    @NonNls
    private static final QName UNKNOWN = new QName("", "#unknown");
    private static final Logger LOG = Logger.getInstance(RngElementDescriptor.class);
    private static final Key<ParameterizedCachedValue<XmlElementDescriptor, RngElementDescriptor>> DESCR_KEY = Key.create((String)"DESCR");
    private static final Key<ParameterizedCachedValue<XmlAttributeDescriptor[], RngElementDescriptor>> ATTRS_KEY = Key.create((String)"ATTRS");
    protected static final XmlElementDescriptor NULL = null;
    private final DElementPattern myElementPattern;
    protected final RngNsDescriptor myNsDescriptor;
    private final AbstractPsiCachedValue<PsiElement> myCachedElement;

    RngElementDescriptor(RngNsDescriptor nsDescriptor, DElementPattern pattern) {
        this.myNsDescriptor = nsDescriptor;
        this.myElementPattern = pattern;
        this.myCachedElement = new PsiCachedValueImpl.Soft(nsDescriptor.getDescriptorFile().getManager(), () -> {
            PsiElement decl = this.myNsDescriptor.getDeclaration();
            if (decl == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            }
            PsiElement element = RngElementDescriptor.getDeclarationImpl(decl, this.myElementPattern.getLocation());
            return CachedValueProvider.Result.create((Object)element, (Object[])new Object[]{element.getContainingFile()});
        });
    }

    public String getQualifiedName() {
        QName qName = this.getQName();
        return qName != null ? RngElementDescriptor.format(qName, "") : "#unknown";
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        DElementPattern p;
        if (context == null) {
            return EMPTY_ARRAY;
        }
        XmlElementDescriptor descriptor = this.myNsDescriptor.getElementDescriptor(context);
        DElementPattern pattern = descriptor instanceof RngElementDescriptor ? ((p = ((RngElementDescriptor)descriptor).myElementPattern) != null ? p : this.myElementPattern) : this.myElementPattern;
        List<DElementPattern> patterns = ChildElementFinder.find(2, pattern);
        return this.myNsDescriptor.convertElementDescriptors(patterns);
    }

    protected XmlElementDescriptor findElementDescriptor(XmlTag childTag) {
        List<DElementPattern> patterns = ChildElementFinder.find(2, this.myElementPattern);
        XmlElementDescriptor d = this.myNsDescriptor.findDescriptor(childTag, patterns);
        return d == null ? NULL : d;
    }

    public final XmlElementDescriptor getElementDescriptor(XmlTag childTag) {
        return this.getElementDescriptor(childTag, null);
    }

    public final XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        ConcurrentMap descriptorMap = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)childTag, () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakMap(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        XmlElementDescriptor value = (XmlElementDescriptor)descriptorMap.computeIfAbsent(this, descr -> CachedValuesManager.getManager((Project)childTag.getProject()).createCachedValue(() -> {
            XmlElementDescriptor descriptor = descr.findElementDescriptor(childTag);
            return CachedValueProvider.Result.create((Object)descriptor, (Object[])new Object[]{descr.getDependencies(), childTag});
        })).getValue();
        return value == NULL ? null : value;
    }

    public final XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context != null) {
            return RngElementDescriptor.getCachedValue(context, this, ATTRS_KEY, p -> {
                XmlAttributeDescriptor[] value = p.collectAttributeDescriptors(context);
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{p.getDependencies(), context});
            });
        }
        return this.collectAttributeDescriptors(null);
    }

    private static <D extends PsiElement, T, P> T getCachedValue(D context, P p, Key<ParameterizedCachedValue<T, P>> key, ParameterizedCachedValueProvider<T, P> provider) {
        CachedValuesManager mgr = CachedValuesManager.getManager((Project)context.getProject());
        return (T)mgr.getParameterizedCachedValue(context, key, provider, false, p);
    }

    protected XmlAttributeDescriptor[] collectAttributeDescriptors(@Nullable XmlTag context) {
        return this.computeAttributeDescriptors(AttributeFinder.find((QName)null, this.myElementPattern));
    }

    protected XmlAttributeDescriptor[] computeAttributeDescriptors(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> map) {
        MultiMap name2patterns = new MultiMap();
        for (DAttributePattern pattern : map.keySet()) {
            for (QName name : pattern.getName().listNames()) {
                name2patterns.putValue((Object)name, (Object)pattern);
            }
        }
        return (XmlAttributeDescriptor[])name2patterns.entrySet().stream().map(entry -> {
            Collection patterns = (Collection)entry.getValue();
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            boolean isOptional = false;
            SmartList declarations = new SmartList();
            QName name = UNKNOWN;
            for (DAttributePattern pattern : patterns) {
                QName patternName;
                if (name == UNKNOWN && (patternName = (QName)ContainerUtil.getFirstItem(pattern.getName().listNames())) != null) {
                    name = patternName;
                }
                Pair value = (Pair)map.get(pattern);
                values.putAll((Map)value.first);
                isOptional |= ((Boolean)value.second).booleanValue();
                declarations.add((Object)pattern.getLocation());
            }
            return new RngXmlAttributeDescriptor(this, name, values, isOptional, (List<Locator>)declarations);
        }).toArray(RngXmlAttributeDescriptor[]::new);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        return this.getAttributeDescriptor("", attributeName);
    }

    public final XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getNamespace(), attribute.getLocalName());
    }

    protected XmlAttributeDescriptor getAttributeDescriptor(String namespace, String localName) {
        QName qname = new QName(namespace, localName);
        return this.computeAttributeDescriptor(AttributeFinder.find(qname, this.myElementPattern));
    }

    protected XmlAttributeDescriptor computeAttributeDescriptor(Map<DAttributePattern, Pair<? extends Map<String, String>, Boolean>> attributes) {
        if (!attributes.isEmpty()) {
            QName name = UNKNOWN;
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            boolean isOptional = false;
            SmartList declarations = new SmartList();
            for (DAttributePattern pattern : attributes.keySet()) {
                QName patternName;
                if (name == UNKNOWN && (patternName = (QName)ContainerUtil.getFirstItem(pattern.getName().listNames())) != null) {
                    name = patternName;
                }
                Pair<? extends Map<String, String>, Boolean> value = attributes.get(pattern);
                values.putAll((Map)value.first);
                isOptional |= ((Boolean)value.second).booleanValue();
                declarations.add((Object)pattern.getLocation());
            }
            return new RngXmlAttributeDescriptor(this, name, values, isOptional, (List<Locator>)declarations);
        }
        return null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myNsDescriptor;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        DPattern child = this.myElementPattern.getChild();
        if (child instanceof DEmptyPattern) {
            return 0;
        }
        if (child instanceof DTextPattern) {
            return 3;
        }
        if (child instanceof DElementPattern) {
            return ((DElementPattern)child).getName().accept(MyNameClassVisitor.INSTANCE);
        }
        return 2;
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return (PsiElement)this.myCachedElement.getValue();
    }

    public PsiElement getDeclaration(Locator location) {
        PsiElement element = this.myNsDescriptor.getDeclaration();
        if (element == null) {
            return null;
        }
        return RngElementDescriptor.getDeclarationImpl(element, location);
    }

    private static PsiElement getDeclarationImpl(PsiElement decl, Locator location) {
        VirtualFile virtualFile = RngSchemaValidator.findVirtualFile(location.getSystemId());
        if (virtualFile == null) {
            return decl;
        }
        Project project = decl.getProject();
        PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (file == null) {
            return decl;
        }
        return (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> RngElementDescriptor.getDeclarationImpl(project, decl, location, file));
    }

    @NonNls
    public String getName(PsiElement context) {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
        String prefix = xmlTag != null ? xmlTag.getPrefixByNamespace(qName.getNamespaceURI()) : null;
        return RngElementDescriptor.format(qName, prefix != null ? prefix : qName.getPrefix());
    }

    @NonNls
    public String getName() {
        QName qName = this.getQName();
        if (qName == null) {
            return "#unknown";
        }
        return qName.getLocalPart();
    }

    @Nullable
    private QName getQName() {
        Iterator<QName> iterator = this.myElementPattern.getName().listNames().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    private static String format(QName qName, String p) {
        String localPart = qName.getLocalPart();
        return !p.isEmpty() ? p + ":" + localPart : localPart;
    }

    @Nullable
    private static PsiElement getDeclarationImpl(@NotNull Project project, PsiElement decl, Locator location, PsiFile file) {
        PsiElement at;
        if (project == null) {
            RngElementDescriptor.$$$reportNull$$$0(0);
        }
        int column = location.getColumnNumber();
        int line = location.getLineNumber();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        assert (document != null);
        if (line <= 0 || document.getLineCount() < line - 1) {
            return decl;
        }
        int startOffset = document.getLineStartOffset(line - 1);
        if (column > 0) {
            if (decl.getContainingFile().getFileType() == RncFileType.getInstance()) {
                return new RncLocationPsiElement(file, startOffset, column);
            }
            at = file.findElementAt(startOffset + column - 2);
        } else {
            PsiElement element = file.findElementAt(startOffset);
            at = element != null ? PsiTreeUtil.nextLeaf((PsiElement)element) : null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class);
    }

    public void init(PsiElement element) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RngElementDescriptor that = (RngElementDescriptor)o;
        return this.myElementPattern.equals(that.myElementPattern);
    }

    public int hashCode() {
        return this.myElementPattern.hashCode();
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myNsDescriptor.getDependencies();
        if (objectArray == null) {
            RngElementDescriptor.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public DElementPattern getElementPattern() {
        return this.myElementPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationImpl";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyNameClassVisitor
    implements NameClassVisitor<Integer> {
        public static final MyNameClassVisitor INSTANCE = new MyNameClassVisitor();

        private MyNameClassVisitor() {
        }

        @Override
        public Integer visitAnyName() {
            return 1;
        }

        @Override
        public Integer visitAnyNameExcept(NameClass nc) {
            return 1;
        }

        @Override
        public Integer visitChoice(NameClass nc1, NameClass nc2) {
            return 2;
        }

        @Override
        public Integer visitName(QName name) {
            return 2;
        }

        @Override
        public Integer visitNsName(String ns) {
            return 2;
        }

        @Override
        public Integer visitNsNameExcept(String ns, NameClass nc) {
            return 2;
        }

        @Override
        public Integer visitNull() {
            return 0;
        }
    }

    private static final class RncLocationPsiElement
    extends FakePsiElement
    implements NavigationItem,
    HtmlSymbolDeclaration {
        private final PsiFile myFile;
        private final int myStartOffset;
        private final int myColumn;
        private final String myName;
        private final HtmlSymbolDeclaration.Kind myKind;

        private RncLocationPsiElement(PsiFile file, int startOffset, int column) {
            PsiElement prevPrevSibling;
            this.myFile = file;
            this.myStartOffset = startOffset;
            this.myColumn = column;
            PsiElement definition = this.getNavigationElement();
            this.myName = definition.getText();
            PsiElement obj = definition.getPrevSibling();
            PsiElement psiElement = prevPrevSibling = obj == null ? null : obj.getPrevSibling();
            if (prevPrevSibling == null) {
                LOG.error("Failed to locate type for RNC element - " + this.myName);
            }
            this.myKind = prevPrevSibling != null && "element".equals(prevPrevSibling.getText()) ? HtmlSymbolDeclaration.Kind.ELEMENT : HtmlSymbolDeclaration.Kind.ATTRIBUTE;
        }

        public String getName() {
            return this.myName;
        }

        @NotNull
        public HtmlSymbolDeclaration.Kind getKind() {
            HtmlSymbolDeclaration.Kind kind = this.myKind;
            if (kind == null) {
                RncLocationPsiElement.$$$reportNull$$$0(0);
            }
            return kind;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement rncElement = this.myFile.findElementAt(this.myStartOffset + this.myColumn);
            ASTNode pattern = rncElement != null ? TreeUtil.findParent((ASTNode)rncElement.getNode(), (IElementType)RncElementTypes.PATTERN) : null;
            ASTNode nameClass = pattern != null ? pattern.findChildByType(RncElementTypes.NAME_CLASS) : null;
            PsiElement psiElement = nameClass != null ? nameClass.getPsi() : rncElement;
            if (psiElement == null) {
                RncLocationPsiElement.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        public PsiElement getParent() {
            return this.getNavigationElement();
        }

        public PsiFile getContainingFile() {
            return this.myFile;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean equals(Object another) {
            return another instanceof RncLocationPsiElement && ((RncLocationPsiElement)((Object)another)).myFile == this.myFile && ((RncLocationPsiElement)((Object)another)).myStartOffset == this.myStartOffset && ((RncLocationPsiElement)((Object)another)).myColumn == this.myColumn;
        }

        public int hashCode() {
            return Objects.hash(this.myFile, this.myStartOffset, this.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngElementDescriptor$RncLocationPsiElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

