/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.models.settings;

import com.intellij.aiplayground.models.CredentialStorage;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/aiplayground/models/settings/PasswordSafeCredentialStorage;", "Lcom/intellij/aiplayground/models/CredentialStorage;", "<init>", "()V", "SERVICE_NAME", "", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "key", "storeCredential", "", "value", "retrieveCredential", "removeCredential", "", "intellij.aiplayground.models"})
public final class PasswordSafeCredentialStorage
implements CredentialStorage {
    @NotNull
    private final String SERVICE_NAME;

    public PasswordSafeCredentialStorage() {
        this.SERVICE_NAME = "AI.Playground";
    }

    private final CredentialAttributes createCredentialAttributes(String key) {
        return new CredentialAttributes(this.SERVICE_NAME + "." + key, null);
    }

    @Override
    public void storeCredential(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(key);
        Credentials credentials = new Credentials(null, value);
        PasswordSafe.Companion.getInstance().set(credentialAttributes, credentials);
    }

    @Override
    @Nullable
    public String retrieveCredential(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(key);
        return PasswordSafe.Companion.getInstance().getPassword(credentialAttributes);
    }

    @Override
    public boolean removeCredential(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(key);
        PasswordSafe.Companion.getInstance().set(credentialAttributes, null);
        return true;
    }
}

