/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.refactoring.ES6MoveFileHandler;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.codeInsight.refs.Angular2TemplateReferencesProvider;
import org.angular2.lang.Angular2LangUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/angular2/refactoring/Angular2MoveFileHandler;", "Lcom/intellij/lang/typescript/refactoring/ES6MoveFileHandler;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiFile;", "doFindUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "updateMovedFile", "", "file", "MyRestoreReferencesUsage", "intellij.angular"})
public final class Angular2MoveFileHandler
extends ES6MoveFileHandler {
    public boolean canProcessElement(@NotNull PsiFile element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof JSFile && DialectDetector.isTypeScript((PsiElement)((PsiElement)element)) && Angular2LangUtil.isAngular2Context((PsiElement)element);
    }

    @NotNull
    protected List<UsageInfo> doFindUsages(@NotNull PsiFile psiFile) {
        List list;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Map<String, Angular2TemplateReferencesProvider.Angular2TemplateReferenceData> map = Angular2TemplateReferencesProvider.Angular2SoftFileReferenceSet.encodeTemplateReferenceData(psiFile);
        if (map.isEmpty()) {
            List list2 = super.doFindUsages(psiFile);
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"doFindUsages(...)");
        } else {
            List list3 = super.doFindUsages(psiFile);
            Object[] objectArray = new UsageInfo[1];
            Intrinsics.checkNotNull(map);
            objectArray[0] = new MyRestoreReferencesUsage(psiFile, map);
            List list4 = ContainerUtil.append((List)list3, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"append(...)");
            list = list4;
        }
        return list;
    }

    public void updateMovedFile(@NotNull PsiFile file) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.updateMovedFile(file);
        Angular2TemplateReferencesProvider.Angular2SoftFileReferenceSet.decodeTemplateReferenceData(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0014\u00a8\u0006\r"}, d2={"Lorg/angular2/refactoring/Angular2MoveFileHandler$MyRestoreReferencesUsage;", "Lcom/intellij/lang/typescript/refactoring/ES6MoveFileHandler$RestoreReferencesUsage;", "", "", "Lorg/angular2/codeInsight/refs/Angular2TemplateReferencesProvider$Angular2TemplateReferenceData;", "element", "Lcom/intellij/psi/PsiFile;", "refs", "<init>", "(Lcom/intellij/psi/PsiFile;Ljava/util/Map;)V", "restore", "", "file", "intellij.angular"})
    private static final class MyRestoreReferencesUsage
    extends ES6MoveFileHandler.RestoreReferencesUsage<Map<String, ? extends Angular2TemplateReferencesProvider.Angular2TemplateReferenceData>> {
        public MyRestoreReferencesUsage(@NotNull PsiFile element, @NotNull Map<String, Angular2TemplateReferencesProvider.Angular2TemplateReferenceData> refs) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            super(element, refs);
        }

        protected void restore(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Angular2TemplateReferencesProvider.Angular2SoftFileReferenceSet.decodeTemplateReferenceData(file, (Map)this.myRefs);
        }
    }
}

