/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.ide.projectView.actions.MarkRootsManager;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.cli.Angular2CliFramework;
import org.angular2.cli.Angular2ProjectConfiguratorKt;
import org.angular2.cli.AngularCliUtil;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/angular2/cli/Angular2CliFrameworkDetector;", "Lcom/intellij/framework/detection/FrameworkDetector;", "<init>", "()V", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "createSuitableFilePattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/util/indexing/FileContent;", "detect", "", "Lcom/intellij/framework/detection/DetectedFrameworkDescription;", "newFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/framework/detection/FrameworkDetectionContext;", "isConfigured", "", "files", "project", "Lcom/intellij/openapi/project/Project;", "getFrameworkType", "Lcom/intellij/framework/FrameworkType;", "AngularCLIFrameworkDescription", "intellij.angular"})
public final class Angular2CliFrameworkDetector
extends FrameworkDetector {
    public Angular2CliFrameworkDetector() {
        super("AngularCLI");
    }

    @NotNull
    public FileType getFileType() {
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)jsonFileType, (String)"INSTANCE");
        return (FileType)jsonFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName((StringPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>(){

            public boolean accepts(String s, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return AngularCliUtil.isAngularJsonFile(s);
            }
        })).with((PatternCondition)new PatternCondition<FileContent>(){

            public boolean accepts(FileContent content, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)content.getFile());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (ElementPattern)objectPattern;
    }

    @NotNull
    public List<DetectedFrameworkDescription> detect(@NotNull Collection<? extends VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        Intrinsics.checkNotNullParameter(newFiles, (String)"newFiles");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Registry.Companion.is("angular.detect.cli.configuration")) {
            return CollectionsKt.emptyList();
        }
        return !newFiles.isEmpty() && !this.isConfigured(newFiles, context.getProject()) ? CollectionsKt.listOf((Object)((Object)new AngularCLIFrameworkDescription(newFiles))) : CollectionsKt.emptyList();
    }

    private final boolean isConfigured(Collection<? extends VirtualFile> files, Project project) {
        if (project == null) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (module == null) continue;
            for (String root : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                if (!Intrinsics.areEqual((Object)root, (Object)(virtualFile.getParent().getUrl() + "/tmp"))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public FrameworkType getFrameworkType() {
        return Angular2CliFramework.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/angular2/cli/Angular2CliFrameworkDetector$AngularCLIFrameworkDescription;", "Lcom/intellij/framework/detection/DetectedFrameworkDescription;", "myNewFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lorg/angular2/cli/Angular2CliFrameworkDetector;Ljava/util/Collection;)V", "getRelatedFiles", "getSetupText", "", "getDetector", "Lcom/intellij/framework/detection/FrameworkDetector;", "setupFramework", "", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "equals", "", "other", "", "hashCode", "", "intellij.angular"})
    private final class AngularCLIFrameworkDescription
    extends DetectedFrameworkDescription {
        @NotNull
        private final Collection<VirtualFile> myNewFiles;

        public AngularCLIFrameworkDescription(Collection<? extends VirtualFile> myNewFiles) {
            Intrinsics.checkNotNullParameter(myNewFiles, (String)"myNewFiles");
            this.myNewFiles = myNewFiles;
        }

        @NotNull
        public Collection<VirtualFile> getRelatedFiles() {
            return this.myNewFiles;
        }

        @NotNull
        public String getSetupText() {
            return Angular2Bundle.Companion.message("angular.description.angular-cli", new Object[0]);
        }

        @NotNull
        public FrameworkDetector getDetector() {
            return Angular2CliFrameworkDetector.this;
        }

        public void setupFramework(@NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull ModulesProvider modulesProvider) {
            Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
            Intrinsics.checkNotNullParameter((Object)modulesProvider, (String)"modulesProvider");
            for (Module module : modulesProvider.getModules()) {
                ContentEntry entry;
                ModifiableRootModel model = modifiableModelsProvider.getModuleModifiableModel(module);
                VirtualFile item = (VirtualFile)CollectionsKt.firstOrNull((Iterable)this.myNewFiles);
                ContentEntry contentEntry = entry = item != null ? MarkRootsManager.findContentEntry((ModuleRootModel)((ModuleRootModel)model), (VirtualFile)item) : null;
                if (entry == null) {
                    modifiableModelsProvider.disposeModuleModifiableModel(model);
                    continue;
                }
                VirtualFile virtualFile = item;
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
                Angular2ProjectConfiguratorKt.addDefaultAngularExcludes(entry, virtualFile2);
                modifiableModelsProvider.commitModuleModifiableModel(model);
                for (VirtualFile vf : this.myNewFiles) {
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    VirtualFile virtualFile3 = vf.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                    AngularCliUtil.createRunConfigurations(project, virtualFile3);
                }
            }
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof AngularCLIFrameworkDescription && Intrinsics.areEqual(this.myNewFiles, ((AngularCLIFrameworkDescription)((Object)other)).myNewFiles);
        }

        public int hashCode() {
            return ((Object)this.myNewFiles).hashCode();
        }
    }
}

