/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class FixedBindParserBase {
    private static final Pattern WINDOWS_DRIVE = Pattern.compile("[a-zA-Z]");
    private static final String COLON = ":";

    public static String[] fixedSplit(String serialized) {
        List<String> partsList = FixedBindParserBase.fixedSplitToList(serialized);
        return partsList.toArray(new String[0]);
    }

    public static List<String> fixedSplitToList(String serialized) {
        String nextPart;
        LinkedList<String> result2 = new LinkedList<String>();
        for (int idx = 0; idx < serialized.length() && !(nextPart = FixedBindParserBase.nextBindPart(serialized, idx, result2.size() < 2)).isEmpty(); idx += nextPart.length() + COLON.length()) {
            result2.add(nextPart);
        }
        return result2;
    }

    private static String nextBindPart(String src, int startIndex, boolean mayBeDrive) {
        int nextColon = src.indexOf(COLON, startIndex);
        if (nextColon < 0) {
            return src.substring(startIndex);
        }
        Object part = src.substring(startIndex, nextColon);
        if (mayBeDrive && WINDOWS_DRIVE.matcher((CharSequence)part).matches()) {
            String nextPart = FixedBindParserBase.nextBindPart(src, startIndex + ((String)part).length() + COLON.length(), false);
            part = (String)part + COLON + nextPart;
        }
        return part;
    }
}

