/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.ui.DeferredIconRepaintScheduler;
import com.intellij.ui.RepaintRequest;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RotatedIconModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/RotatedIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/jetbrains/rd/ui/icons/converters/RotatedIconConverter$RotatedIcon;", "Lcom/jetbrains/rd/ide/model/RotatedIconModel;", "<init>", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "RotatedIcon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nRotatedIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RotatedIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/RotatedIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class RotatedIconConverter
implements ProtocolIconConverter<RotatedIcon, RotatedIconModel> {
    @NotNull
    public Icon createIcon(@NotNull RotatedIconModel model, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Icon staticIcon = registry.createIcon(model.getStaticNode());
        return new RotatedIcon(staticIcon, 0, 0, 6, null);
    }

    @Nullable
    public IconModel createModel(@NotNull RotatedIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        RotatedIconModel rotatedIconModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = registry.createModel(icon.getStaticIcon());
        if (iconModel != null) {
            IconModel it = iconModel;
            boolean bl = false;
            rotatedIconModel = new RotatedIconModel(it);
        } else {
            rotatedIconModel = null;
        }
        return (IconModel)rotatedIconModel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\"\u0010\u0014\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/RotatedIconConverter$RotatedIcon;", "Ljavax/swing/Icon;", "staticIcon", "speedFactor", "", "direction", "<init>", "(Ljavax/swing/Icon;II)V", "getStaticIcon", "()Ljavax/swing/Icon;", "getDirection", "()I", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "requestRepaint", "getIconWidth", "getIconHeight", "Companion", "intellij.rd.ui"})
    public static final class RotatedIcon
    implements Icon {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Icon staticIcon;
        private final int speedFactor;
        private final int direction;
        @NotNull
        private static final DeferredIconRepaintScheduler ourRepaintScheduler = new DeferredIconRepaintScheduler();
        @NotNull
        private static final ExecutorService ourIconsCalculatingExecutor;
        @NotNull
        private static final TransferToEDTQueue<Runnable> ourLaterInvocator;

        public RotatedIcon(@NotNull Icon staticIcon, int speedFactor, int direction) {
            Intrinsics.checkNotNullParameter((Object)staticIcon, (String)"staticIcon");
            this.staticIcon = staticIcon;
            this.speedFactor = speedFactor;
            this.direction = direction;
        }

        public /* synthetic */ RotatedIcon(Icon icon, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 5;
            }
            if ((n3 & 4) != 0) {
                n2 = 1;
            }
            this(icon, n, n2);
        }

        @NotNull
        public final Icon getStaticIcon() {
            return this.staticIcon;
        }

        public final int getDirection() {
            return this.direction;
        }

        @Override
        public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            long time = System.nanoTime() / (long)1000 / (long)1000 / (long)this.speedFactor;
            double angle = Math.toRadians(time % (long)360) * (double)this.direction;
            RotatedIcon.Companion.paintRotatedIcon(this.staticIcon, c, g, x, y, angle);
            this.requestRepaint(c, x, y);
        }

        private final void requestRepaint(Component c, int x, int y) {
            if (c == null) {
                return;
            }
            RepaintRequest repaintRequest = ourRepaintScheduler.createRepaintRequest(c, x, y);
            ourIconsCalculatingExecutor.execute(() -> RotatedIcon.requestRepaint$lambda$1(repaintRequest, this));
        }

        @Override
        public int getIconWidth() {
            return this.staticIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.staticIcon.getIconHeight();
        }

        private static final void requestRepaint$lambda$1$lambda$0(RepaintRequest $repaintRequest, RotatedIcon this$0) {
            ourRepaintScheduler.scheduleRepaint($repaintRequest, this$0.getIconWidth(), this$0.getIconHeight(), true);
        }

        private static final void requestRepaint$lambda$1(RepaintRequest $repaintRequest, RotatedIcon this$0) {
            ourLaterInvocator.offer(() -> RotatedIcon.requestRepaint$lambda$1$lambda$0($repaintRequest, this$0));
        }

        static {
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IconsCalculatingExecutor", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
            ourIconsCalculatingExecutor = executorService;
            TransferToEDTQueue transferToEDTQueue = TransferToEDTQueue.createRunnableMerger((String)"Rotated icon later invocator", (int)200);
            Intrinsics.checkNotNullExpressionValue((Object)transferToEDTQueue, (String)"createRunnableMerger(...)");
            ourLaterInvocator = transferToEDTQueue;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/RotatedIconConverter$RotatedIcon$Companion;", "", "<init>", "()V", "ourRepaintScheduler", "Lcom/intellij/ui/DeferredIconRepaintScheduler;", "ourIconsCalculatingExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "ourLaterInvocator", "Lcom/intellij/util/containers/TransferToEDTQueue;", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "paintRotatedIcon", "", "Ljavax/swing/Icon;", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "angle", "", "intellij.rd.ui"})
        public static final class Companion {
            private Companion() {
            }

            private final void paintRotatedIcon(Icon $this$paintRotatedIcon, Component c, Graphics g, int x, int y, double angle) {
                double cx = (double)x + (double)$this$paintRotatedIcon.getIconWidth() / 2.0;
                double cy = (double)y + (double)$this$paintRotatedIcon.getIconHeight() / 2.0;
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D gg = (Graphics2D)graphics;
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gg.rotate(angle, cx, cy);
                Graphics graphics2 = gg;
                Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                UIUtil.drawImage((Graphics)graphics2, (Image)IconUtil.toImage((Icon)$this$paintRotatedIcon, (ScaleContext)ScaleContext.Companion.create((Graphics2D)g)), (int)x, (int)y, (ImageObserver)c);
                gg.dispose();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

