/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class VcsRareLineAnnotationData
implements VcsLineAnnotationData {
    private final Int2ObjectMap<VcsRevisionNumber> myMap = new Int2ObjectOpenHashMap();
    private final int mySize;

    public VcsRareLineAnnotationData(int size) {
        this.mySize = size;
    }

    public void put(int lineNumber, VcsRevisionNumber revisionNumber) {
        assert (lineNumber >= 0 && this.mySize > lineNumber);
        this.myMap.put(lineNumber, (Object)revisionNumber);
    }

    public int getNumLines() {
        return this.mySize;
    }

    public VcsRevisionNumber getRevision(int lineNumber) {
        assert (lineNumber >= 0 && this.mySize > lineNumber);
        return (VcsRevisionNumber)this.myMap.get(lineNumber);
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }
}

