/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clouds/docker/gateway/statistics/DevcontainerFileLocationStatCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP_ID", "", "EVENT_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOCATION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/clouds/docker/gateway/statistics/DevcontainerFileLocationStatCollector$Location;", "BUILD_TYPE_FIELD", "Lcom/intellij/clouds/docker/gateway/statistics/DevcontainerFileLocationStatCollector$BuildType;", "BUILD_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "getGroup", "logMount", "", "path", "Ljava/nio/file/Path;", "logClone", "getLocation", "Location", "BuildType", "intellij.clouds.docker.gateway"})
public final class DevcontainerFileLocationStatCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DevcontainerFileLocationStatCollector INSTANCE = new DevcontainerFileLocationStatCollector();
    @NotNull
    private static final String GROUP_ID = "devcontainer.file.location";
    @NotNull
    private static final EventLogGroup EVENT_GROUP = new EventLogGroup("devcontainer.file.location", 1, null, 4, null);
    @NotNull
    private static final EnumEventField<Location> LOCATION_FIELD = EventFields.Enum$default((String)"location", Location.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<BuildType> BUILD_TYPE_FIELD = EventFields.Enum$default((String)"build_type", BuildType.class, null, (int)4, null);
    @NotNull
    private static final EventId2<Location, BuildType> BUILD_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)EVENT_GROUP, (String)"build", (EventField)((EventField)LOCATION_FIELD), (EventField)((EventField)BUILD_TYPE_FIELD), null, (int)8, null);

    private DevcontainerFileLocationStatCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return EVENT_GROUP;
    }

    public final void logMount(@NotNull Path path) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Location location = this.getLocation(path);
            if (location == null) break block0;
            Location it = location;
            boolean bl = false;
            BUILD_EVENT.log((Object)it, (Object)BuildType.mount);
        }
    }

    public final void logClone(@NotNull Path path) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Location location = this.getLocation(path);
            if (location == null) break block0;
            Location it = location;
            boolean bl = false;
            BUILD_EVENT.log((Object)it, (Object)BuildType.clone);
        }
    }

    private final Location getLocation(Path path) {
        Location location;
        Path path2 = path.getFileName();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            String string = ((Object)it).toString();
            if (Intrinsics.areEqual((Object)string, (Object)".devcontainer.json")) {
                return Location.standard_dot_file;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"devcontainer.json")) {
                Path path3 = path.getParent();
                if (path3 != null) {
                    Path parent = path3;
                    boolean bl2 = false;
                    location = Intrinsics.areEqual((Object)((Object)parent.getFileName()).toString(), (Object)".devcontainer") ? Location.standard_dot_dir : Location.non_standard;
                } else {
                    location = null;
                }
            } else {
                location = null;
            }
        } else {
            location = null;
        }
        return location;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clouds/docker/gateway/statistics/DevcontainerFileLocationStatCollector$BuildType;", "", "<init>", "(Ljava/lang/String;I)V", "mount", "clone", "intellij.clouds.docker.gateway"})
    public static final class BuildType
    extends Enum<BuildType> {
        public static final /* enum */ BuildType mount = new BuildType();
        public static final /* enum */ BuildType clone = new BuildType();
        private static final /* synthetic */ BuildType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BuildType[] values() {
            return (BuildType[])$VALUES.clone();
        }

        public static BuildType valueOf(String value) {
            return Enum.valueOf(BuildType.class, value);
        }

        @NotNull
        public static EnumEntries<BuildType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = buildTypeArray = new BuildType[]{BuildType.mount, BuildType.clone};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/clouds/docker/gateway/statistics/DevcontainerFileLocationStatCollector$Location;", "", "<init>", "(Ljava/lang/String;I)V", "standard_dot_file", "standard_dot_dir", "non_standard", "intellij.clouds.docker.gateway"})
    public static final class Location
    extends Enum<Location> {
        public static final /* enum */ Location standard_dot_file = new Location();
        public static final /* enum */ Location standard_dot_dir = new Location();
        public static final /* enum */ Location non_standard = new Location();
        private static final /* synthetic */ Location[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Location[] values() {
            return (Location[])$VALUES.clone();
        }

        public static Location valueOf(String value) {
            return Enum.valueOf(Location.class, value);
        }

        @NotNull
        public static EnumEntries<Location> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = locationArray = new Location[]{Location.standard_dot_file, Location.standard_dot_dir, Location.non_standard};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

