/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.formatting;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.prettierjs.formatting.PrettierFormattingContext;
import com.intellij.util.LineSeparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"createFormattingContext", "Lcom/intellij/prettierjs/formatting/PrettierFormattingContext;", "document", "Lcom/intellij/openapi/editor/Document;", "formattedContent", "", "cursorOffset", "", "intellij.prettierJS"})
public final class PrettierFormattingContextKt {
    @NotNull
    public static final PrettierFormattingContext createFormattingContext(@NotNull Document document, @NotNull String formattedContent, int cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)formattedContent, (String)"formattedContent");
        LineSeparator detectedLineSeparator = StringUtil.detectSeparators((CharSequence)formattedContent);
        int[] nArray = new int[]{cursorOffset};
        int[] offsetsToKeep = nArray;
        String string = StringUtil.convertLineSeparators((String)formattedContent, (String)"\n", (int[])offsetsToKeep);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String normalized = string;
        int contentLengthDelta = formattedContent.length() - document.getCharsSequence().length();
        int n = offsetsToKeep[0];
        return new PrettierFormattingContext(document, normalized, detectedLineSeparator, n, contentLengthDelta);
    }
}

