/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates.contextTypes;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.database.liveTemplates.SqlTemplateContextTypeCommon;
import com.intellij.lang.Language;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlAllDialectsStatementContextType
extends TemplateContextType
implements SqlTemplateContextTypeCommon {
    public SqlAllDialectsStatementContextType() {
        super(SqlBundle.message((String)"label.sql.statements", (Object[])new Object[0]));
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        TemplateContextType baseType;
        if (file == null) {
            SqlAllDialectsStatementContextType.$$$reportNull$$$0(0);
        }
        return ((baseType = this.getBaseContextType()) == null || baseType.isInContext(file, offset)) && SqlAllDialectsStatementContextType.isAtSqlStatementStart(file, offset);
    }

    private static boolean isAtSqlStatementStart(@NotNull PsiFile file, int offset) {
        PsiElement prevSibling;
        PsiElement parentParent;
        PsiElement par;
        PsiElement element;
        if (file == null) {
            SqlAllDialectsStatementContextType.$$$reportNull$$$0(1);
        }
        if ((element = file.findElementAt(offset)) == null || element instanceof PsiComment) {
            return false;
        }
        SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        if (statement2 != null && statement2.getTextOffset() == element.getTextOffset()) {
            return true;
        }
        PsiElement parent = SqlImplUtil.sqlParent((PsiElement)element);
        if (!(parent instanceof PsiErrorElement)) {
            parent = element;
        }
        if (parent instanceof LeafPsiElement && SqlImplUtil.getElementType((PsiElement)(par = SqlImplUtil.sqlParent((PsiElement)parent))) == SqlCompositeElementTypes.SQL_IDENTIFIER) {
            parent = par;
        }
        PsiElement psiElement = parentParent = parent == null ? null : SqlImplUtil.sqlParent((PsiElement)parent);
        if (!(parentParent instanceof SqlFile || (parentParent instanceof SqlStatement || parentParent instanceof SqlExpression) && parentParent.getLastChild() == parent)) {
            return false;
        }
        if (parentParent instanceof SqlStatement || parentParent instanceof SqlFile) {
            prevSibling = parent.getPrevSibling();
            if ((prevSibling = SqlAllDialectsStatementContextType.enterDummyBlockIfNeeded(prevSibling)) == null) {
                return true;
            }
        } else {
            PsiElement par2 = parent;
            while (par2 != null && par2.getPrevSibling() == null) {
                par2 = SqlImplUtil.sqlParent((PsiElement)par2);
            }
            PsiElement psiElement2 = prevSibling = par2 == null ? null : par2.getPrevSibling();
            if (prevSibling == null) {
                return false;
            }
        }
        while (prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling.getText().contains("\n")) {
                return true;
            }
            prevSibling = SqlAllDialectsStatementContextType.enterDummyBlockIfNeeded(prevSibling.getPrevSibling());
        }
        if (!(prevSibling instanceof LeafPsiElement)) {
            return false;
        }
        Language language = file.getLanguage();
        if (!(language instanceof SqlLanguageDialect)) {
            return false;
        }
        IElementType elementType = ((LeafPsiElement)prevSibling).getElementType();
        return ((SqlLanguageDialect)language).getStatementSeparators().contains(elementType);
    }

    @Nullable
    private static PsiElement enterDummyBlockIfNeeded(@Nullable PsiElement prevSibling) {
        while (SqlAllDialectsStatementContextType.isDummyBlock(prevSibling)) {
            prevSibling = prevSibling.getLastChild();
        }
        return prevSibling;
    }

    @Contract(value="null -> false")
    private static boolean isDummyBlock(@Nullable PsiElement psiElement) {
        return PsiUtilCore.getElementType((PsiElement)psiElement) == SqlElementTypes.SQL_DUMMY_BLOCK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/sql/liveTemplates/contextTypes/SqlAllDialectsStatementContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtSqlStatementStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

