/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKind;
import com.intellij.database.debugger.SqlVariableKt;
import com.intellij.database.debugger.SqlVariableValue;
import com.intellij.database.dialects.oracle.debugger.ApiResult;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.CallParams;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.DebugContinuationCommand;
import com.intellij.database.dialects.oracle.debugger.DebugGracefulResumingCommand;
import com.intellij.database.dialects.oracle.debugger.DebugImmediateCommand;
import com.intellij.database.dialects.oracle.debugger.DebugNativeResumingCommand;
import com.intellij.database.dialects.oracle.debugger.DeregisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.EvaluateExpressionCommand;
import com.intellij.database.dialects.oracle.debugger.ExecuteFragmentCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulResumeCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInProgramCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInScriptCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOutCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOverCommand;
import com.intellij.database.dialects.oracle.debugger.IterateImmediateCommand;
import com.intellij.database.dialects.oracle.debugger.OraBaseSession;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugException;
import com.intellij.database.dialects.oracle.debugger.OraDebugExecutionResult;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerEnumsKt;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSessionQueries;
import com.intellij.database.dialects.oracle.debugger.OraExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OraStringArrayOutParameter;
import com.intellij.database.dialects.oracle.debugger.OraUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.PauseReason;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.RegisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.RetrieveVariablesCommand;
import com.intellij.database.dialects.oracle.debugger.RunToPositionCommand;
import com.intellij.database.dialects.oracle.debugger.StepOutCommand;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.dialects.oracle.debugger.TransferHolder;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.SqlUtilFun;
import com.intellij.util.text.StringKt;
import java.rmi.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00ca\u00012\u00020\u0001:\u0002\u00ca\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010c\u001a\u00020\u000fH\u0016J\b\u0010d\u001a\u00020\u000fH\u0002J\b\u0010e\u001a\u00020\u000fH\u0002JM\u0010f\u001a\u0002Hg\"\b\b\u0000\u0010h*\u00020i\"\u0004\b\u0001\u0010g2\u0006\u0010j\u001a\u0002Hh2\u0012\u0010k\u001a\n\u0012\u0006\b\u0001\u0012\u00020m0l\"\u00020m2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u0002Hg0\rH\u0014\u00a2\u0006\u0002\u0010pJ\u0017\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010r\u001a\u00020IH\u0002\u00a2\u0006\u0002\u0010sJ\u000e\u0010t\u001a\u00020\u000f2\u0006\u0010u\u001a\u00020vJ\u0006\u0010w\u001a\u00020\u0007J\b\u0010x\u001a\u00020\u000fH\u0002J\u0006\u0010y\u001a\u00020\u000fJ\b\u0010z\u001a\u00020\u000fH\u0002J\u0006\u0010{\u001a\u00020\u000fJ\u0006\u0010|\u001a\u00020\u000fJ\u0006\u0010}\u001a\u00020\u000fJ\b\u0010~\u001a\u00020\u000fH\u0002J\b\u0010\u007f\u001a\u00020\u000fH\u0002J\u0012\u0010\u0080\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u0081\u0001H\u0002J\u001f\u0010\u0080\u0001\u001a\u00020\u000f2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\n\b\u0002\u0010u\u001a\u0004\u0018\u00010vH\u0002J\u0012\u0010\u0084\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u0085\u0001H\u0002J\u0012\u0010\u0086\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u0087\u0001H\u0002J5\u0010\u0088\u0001\u001a\u00020\u000f2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u000f\u0010\u008b\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020m0l2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010vH\u0002\u00a2\u0006\u0003\u0010\u008d\u0001J\u0012\u0010\u008e\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u008f\u0001H\u0002J\u0088\u0001\u0010\u0090\u0001\u001a\u00020\u000f2\u0007\u0010\u0091\u0001\u001a\u00020\u00072\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u0094\u0001\u001a\u00030\u0093\u00012\u0007\u0010\u0095\u0001\u001a\u00020(2\u0007\u0010\u0096\u0001\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\b\u0010\u0097\u0001\u001a\u00030\u0083\u00012\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u000e2\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u000e2\t\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u000e2\u0007\u0010\u009b\u0001\u001a\u00020\u00072\u0007\u0010\u009c\u0001\u001a\u00020\u00072\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010vH\u0002J\u0013\u0010\u009d\u0001\u001a\u00020\u000f2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0002J\t\u0010\u00a0\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00a1\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00a2\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00a3\u0001\u001a\u00020\u000fH\u0002J\u0018\u0010\u00a4\u0001\u001a\u00020\u000f2\r\u0010\u00a5\u0001\u001a\b\u0012\u0004\u0012\u00020\u000e0,H\u0002J2\u0010\u00a6\u0001\u001a\u00020-2\b\u0010\u0097\u0001\u001a\u00030\u0083\u00012\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u000e2\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u000e2\u0007\u0010\u0095\u0001\u001a\u00020(H\u0002J\u0012\u0010\u00a7\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u00a8\u0001H\u0002J \u0010\u00a9\u0001\u001a\t\u0012\u0005\u0012\u00030\u00aa\u00010,*\u000e\u0012\u0005\u0012\u00030\u00aa\u00010,j\u0003`\u00ab\u0001H\u0002J\u001f\u0010\u00ac\u0001\u001a\u00020\u000f*\u00030\u00aa\u00012\u000f\u0010\u00ad\u0001\u001a\n\u0012\u0005\u0012\u00030\u00aa\u00010\u00ae\u0001H\u0002J\u0012\u0010\u00af\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u00b0\u0001H\u0002J\u0012\u0010\u00b1\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u00b2\u0001H\u0002J\u001e\u0010\u00b3\u0001\u001a\u00020\u000f2\u0013\u0010\u00b4\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0013\u0010\u00b5\u0001\u001a\u00030\u00b6\u00012\u0007\u0010\u00b7\u0001\u001a\u00020\u000eH\u0002J\u0012\u0010\u00b8\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u00b9\u0001H\u0002JL\u0010\u00ba\u0001\u001a\u00020\u000f2\u0007\u0010\u00bb\u0001\u001a\u00020-28\u0010n\u001a4\u0012\u0014\u0012\u001205\u00a2\u0006\r\bP\u0012\t\bQ\u0012\u0005\b\b(\u00bc\u0001\u0012\u0014\u0012\u00120(\u00a2\u0006\r\bP\u0012\t\bQ\u0012\u0005\b\b(\u00bd\u0001\u0012\u0004\u0012\u00020\u000f0OH\u0002J\u0012\u0010\u00be\u0001\u001a\u00020\u000f2\u0007\u0010u\u001a\u00030\u00bf\u0001H\u0002J&\u0010\u00c0\u0001\u001a\u00020\u000f2\u0007\u0010\u00bd\u0001\u001a\u00020(2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\t\u0010\u00c1\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00c2\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00c3\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00c4\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00c5\u0001\u001a\u00020\u000fH\u0002J\u0007\u0010\u00c6\u0001\u001a\u00020\u000fJ\u0019\u0010\u00c7\u0001\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020:2\u0006\u00109\u001a\u00020:H\u0002J\t\u0010\u00c8\u0001\u001a\u00020\u000fH\u0002J\t\u0010\u00c9\u0001\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R*\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020-0,@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001e\u00102\u001a\u0002012\u0006\u0010'\u001a\u000201@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00106\u001a\u0002052\u0006\u0010'\u001a\u000205@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R$\u0010;\u001a\u00020:2\u0006\u00109\u001a\u00020:8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0010\u0012\f\u0012\n B*\u0004\u0018\u00010:0:0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010J\u001a\u00020I2\u0006\u0010'\u001a\u00020I@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bK\u0010LR\u000e\u0010M\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000RJ\u0010N\u001a2\u0012\u0013\u0012\u00110:\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(R\u0012\u0013\u0012\u00110:\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020\u000f0OX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VRP\u0010W\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020-0,\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110:\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020\u000f0OX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010T\"\u0004\bY\u0010VR5\u0010Z\u001a\u001d\u0012\u0013\u0012\u00110:\u00a2\u0006\f\bP\u0012\b\bQ\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020\u000f0\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0011\"\u0004\b\\\u0010\u0013R \u0010]\u001a\b\u0012\u0004\u0012\u00020\u000f0^X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010b\u00a8\u0006\u00cb\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OraBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "target", "Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "scriptIsMeaningful", "", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;Z)V", "getTarget", "()Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "dbmsOutputConsumer", "Lkotlin/Function1;", "", "", "getDbmsOutputConsumer", "()Lkotlin/jvm/functions/Function1;", "setDbmsOutputConsumer", "(Lkotlin/jvm/functions/Function1;)V", "probeVersion", "Lcom/intellij/database/util/Version;", "getProbeVersion", "()Lcom/intellij/database/util/Version;", "setProbeVersion", "(Lcom/intellij/database/util/Version;)V", "attached", "getAttached", "()Z", "setAttached", "(Z)V", "processIsActive", "getProcessIsActive", "setProcessIsActive", "processIsInsideMainLoop", "processIsInsideGracefulLoop", "processIsRunning", "processIsWaiting", "processIsTerminated", "value", "", "stackDepth", "getStackDepth", "()I", "", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "stack", "getStack", "()Ljava/util/List;", "Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "reason", "getReason", "()Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "result", "getResult", "()Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "newState", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "state", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "setState", "(Lcom/intellij/database/dialects/oracle/debugger/ProcessState;)V", "stateHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "commandHolder", "Lcom/intellij/database/dialects/oracle/debugger/TransferHolder;", "Lcom/intellij/database/dialects/oracle/debugger/DebugContinuationCommand;", "commandQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/database/dialects/oracle/debugger/DebugImmediateCommand;", "", "stoppingMoment", "setStoppingMoment", "(J)V", "dataPending", "onStateTransition", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "oldState", "getOnStateTransition$intellij_database_dialects_oracle_ex", "()Lkotlin/jvm/functions/Function2;", "setOnStateTransition$intellij_database_dialects_oracle_ex", "(Lkotlin/jvm/functions/Function2;)V", "onEventInfo", "getOnEventInfo$intellij_database_dialects_oracle_ex", "setOnEventInfo$intellij_database_dialects_oracle_ex", "onMainLoopIteration", "getOnMainLoopIteration$intellij_database_dialects_oracle_ex", "setOnMainLoopIteration$intellij_database_dialects_oracle_ex", "onGoodTimeToRetrieveAdditionalData", "Lkotlin/Function0;", "getOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle_ex", "()Lkotlin/jvm/functions/Function0;", "setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle_ex", "(Lkotlin/jvm/functions/Function0;)V", "initRemote", "attachToTargetSession", "detachFromTargetSession", "call", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "parameters", "", "", "handler", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkSessionActivity", "sessionId", "(J)Ljava/lang/Boolean;", "issueCommand", "command", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "goingToRelax", "buckUpTheLoop", "performMainLoop", "performImmediateCommands", "completeTheProcess", "abortTheProcess", "performFinishLoop", "doPause", "doSynchronize", "doContinue", "Lcom/intellij/database/dialects/oracle/debugger/DebugNativeResumingCommand;", "breakFlags", "", "doStepOut", "Lcom/intellij/database/dialects/oracle/debugger/StepOutCommand;", "doRunToPosition", "Lcom/intellij/database/dialects/oracle/debugger/RunToPositionCommand;", "handleSyncOrContinue", "proc", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "params", "lastCommand", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;[Ljava/lang/Object;Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;)V", "doGracefulResume", "Lcom/intellij/database/dialects/oracle/debugger/DebugGracefulResumingCommand;", "handleSyncResult", "graceful", "resultCode", "", "reasonCode", "lineNr", "breakpoint", "namespaceCode", "programSchema", "programName", "entryPointName", "terminated", "isProcedure", "handleSyncException", "thrownException", "", "markProcessTerminated", "retrieveData", "retrieveIntermediateData", "retrieveStack", "handleStack", "listing", "makeFrame", "doRetrieveVariables", "Lcom/intellij/database/dialects/oracle/debugger/RetrieveVariablesCommand;", "flatten", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "flattenTo", "container", "", "doEvaluateExpression", "Lcom/intellij/database/dialects/oracle/debugger/EvaluateExpressionCommand;", "doExecuteFragment", "Lcom/intellij/database/dialects/oracle/debugger/ExecuteFragmentCommand;", "retrieveDbmsOutput", "consumer", "executeAndFetchResult", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugExecutionResult;", "block", "doRegisterLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/RegisterBreakpointCommand;", "registerLineBreakpoint", "position", "r", "id", "doDeregisterLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/DeregisterBreakpointCommand;", "deregisterLineBreakpoint", "deregisterAllBreakpoints", "printListing", "connectionBroken", "resetResult", "resetProcessState", "resetState", "stateChanged", "deactivateTargetSessionDataSource", "close", "Companion", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraDebuggingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDebuggingSession.kt\ncom/intellij/database/dialects/oracle/debugger/OraDebuggingSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1124:1\n1#2:1125\n1869#3,2:1126\n1869#3,2:1128\n*S KotlinDebug\n*F\n+ 1 OraDebuggingSession.kt\ncom/intellij/database/dialects/oracle/debugger/OraDebuggingSession\n*L\n873#1:1126,2\n932#1:1128,2\n*E\n"})
public final class OraDebuggingSession
extends OraBaseSession {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OraExecutingSession target;
    private final boolean scriptIsMeaningful;
    @NotNull
    private Function1<? super String, Unit> dbmsOutputConsumer;
    @Nullable
    private Version probeVersion;
    private boolean attached;
    private boolean processIsActive;
    private boolean processIsInsideMainLoop;
    private boolean processIsInsideGracefulLoop;
    private boolean processIsRunning;
    private boolean processIsWaiting;
    private boolean processIsTerminated;
    private int stackDepth;
    @NotNull
    private List<? extends OraPosition> stack;
    @NotNull
    private PauseReason reason;
    @NotNull
    private ApiResult result;
    @NotNull
    private final AtomicReference<ProcessState> stateHolder;
    @NotNull
    private final TransferHolder<DebugContinuationCommand> commandHolder;
    @NotNull
    private final ConcurrentLinkedQueue<DebugImmediateCommand> commandQueue;
    private long stoppingMoment;
    private boolean dataPending;
    @NotNull
    private Function2<? super ProcessState, ? super ProcessState, Unit> onStateTransition;
    @NotNull
    private Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit> onEventInfo;
    @NotNull
    private Function1<? super ProcessState, Unit> onMainLoopIteration;
    @NotNull
    private Function0<Unit> onGoodTimeToRetrieveAdditionalData;
    @Deprecated
    public static final byte stopOnReturnWhenStepOut = 0;

    public OraDebuggingSession(@NotNull DatabaseConnection connection2, @NotNull OraExecutingSession target, boolean scriptIsMeaningful) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(connection2);
        this.target = target;
        this.scriptIsMeaningful = scriptIsMeaningful;
        this.dbmsOutputConsumer = (Function1)new Function1<String, Unit>((Object)this.getLog()){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        };
        this.stack = CollectionsKt.emptyList();
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
        this.stateHolder = new AtomicReference<ProcessState>(ProcessState.STATE_ASLEEP);
        this.commandHolder = new TransferHolder();
        this.commandQueue = new ConcurrentLinkedQueue();
        this.onStateTransition = OraDebuggingSession::onStateTransition$lambda$0;
        this.onEventInfo = OraDebuggingSession::onEventInfo$lambda$1;
        this.onMainLoopIteration = OraDebuggingSession::onMainLoopIteration$lambda$2;
        this.onGoodTimeToRetrieveAdditionalData = OraDebuggingSession::onGoodTimeToRetrieveAdditionalData$lambda$3;
    }

    @NotNull
    public final OraExecutingSession getTarget() {
        return this.target;
    }

    @NotNull
    public final Function1<String, Unit> getDbmsOutputConsumer() {
        return this.dbmsOutputConsumer;
    }

    public final void setDbmsOutputConsumer(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.dbmsOutputConsumer = function1;
    }

    @Nullable
    public final Version getProbeVersion() {
        return this.probeVersion;
    }

    public final void setProbeVersion(@Nullable Version version) {
        this.probeVersion = version;
    }

    public final boolean getAttached() {
        return this.attached;
    }

    public final void setAttached(boolean bl) {
        this.attached = bl;
    }

    public final boolean getProcessIsActive() {
        return this.processIsActive;
    }

    public final void setProcessIsActive(boolean bl) {
        this.processIsActive = bl;
    }

    public final int getStackDepth() {
        return this.stackDepth;
    }

    @NotNull
    public final List<OraPosition> getStack() {
        return this.stack;
    }

    @NotNull
    public final PauseReason getReason() {
        return this.reason;
    }

    @NotNull
    public final ApiResult getResult() {
        return this.result;
    }

    @NotNull
    public final ProcessState getState() {
        ProcessState processState = this.stateHolder.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)processState), (String)"get(...)");
        return processState;
    }

    private final void setState(ProcessState newState) {
        ProcessState oldState = this.stateHolder.getAndSet(newState);
        if (oldState != newState) {
            Intrinsics.checkNotNull((Object)((Object)oldState));
            this.stateChanged(oldState, newState);
        }
    }

    private final void setStoppingMoment(long value) {
        this.stoppingMoment = value;
    }

    @NotNull
    public final Function2<ProcessState, ProcessState, Unit> getOnStateTransition$intellij_database_dialects_oracle_ex() {
        return this.onStateTransition;
    }

    public final void setOnStateTransition$intellij_database_dialects_oracle_ex(@NotNull Function2<? super ProcessState, ? super ProcessState, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onStateTransition = function2;
    }

    @NotNull
    public final Function2<List<? extends OraPosition>, ProcessState, Unit> getOnEventInfo$intellij_database_dialects_oracle_ex() {
        return this.onEventInfo;
    }

    public final void setOnEventInfo$intellij_database_dialects_oracle_ex(@NotNull Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onEventInfo = function2;
    }

    @NotNull
    public final Function1<ProcessState, Unit> getOnMainLoopIteration$intellij_database_dialects_oracle_ex() {
        return this.onMainLoopIteration;
    }

    public final void setOnMainLoopIteration$intellij_database_dialects_oracle_ex(@NotNull Function1<? super ProcessState, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onMainLoopIteration = function1;
    }

    @NotNull
    public final Function0<Unit> getOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle_ex() {
        return this.onGoodTimeToRetrieveAdditionalData;
    }

    public final void setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle_ex(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onGoodTimeToRetrieveAdditionalData = function0;
    }

    @Override
    public void initRemote() {
        boolean bl;
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
        boolean bl2 = bl = this.getSessionId() != 0L;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-OraDebuggingSession$initRemote$32 = false;
            String $i$a$-assert-OraDebuggingSession$initRemote$32 = "The debugging session Id is zero";
            throw new AssertionError((Object)$i$a$-assert-OraDebuggingSession$initRemote$32);
        }
        boolean bl3 = bl = this.target.getSessionId() != 0L;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "The target session Id is zero";
            throw new AssertionError((Object)string);
        }
        if (this.getSessionId() == this.target.getSessionId()) {
            String errorMessage = "The target and debug sessions are the same one (" + this.getSessionId() + "). Impossible to debug.";
            this.getLog().error(errorMessage);
            if (this.getConnection().getConnectionPoint().getDataSource().isSingleConnection()) {
                this.getLog().error("The data source is configured for single-connection mode, the debugger is not enabled in this mode. ");
            }
            throw new IllegalStateException(errorMessage);
        }
        this.attachToTargetSession();
    }

    private final void attachToTargetSession() {
        this.resetResult();
        this.attached = false;
        try {
            Boolean targetIsActive = this.checkSessionActivity(this.target.getSessionId());
            if (targetIsActive == null) {
                String message = "Cannot attach to the target session: the session " + this.getSessionId() + " doesn't exist";
                throw new OraDebugException(message);
            }
        }
        catch (SQLException sqle) {
            int errorCode = sqle.getErrorCode();
            Object object = sqle.getMessage();
            if (object == null) {
                object = "Error " + errorCode;
            }
            String errorMessage = object;
            Object message = null;
            message = errorCode == 6550 && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"ORA-00942", (boolean)false, (int)2, null) ? "Cannot access the SYS.V_$SESSION table, debugging is not possible." : "Cannot check the target session status: Error " + errorCode + ": " + errorMessage;
            this.trace((String)message);
            throw new OraDebugException((String)message, sqle);
        }
        catch (Exception e) {
            String message = "Cannot check the target session status: Exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            this.trace(message);
            throw new OraDebugException(message, e);
        }
        String string = this.target.getDebugId();
        if (string == null) {
            throw new OraDebugException("Cannot attach to the session that is not debuggable yet.");
        }
        String debugId = string;
        try {
            Object[] message = new Object[]{debugId};
            this.call((CallDefinition)OraDebuggingSessionQueries.AttachProc.INSTANCE, message, arg_0 -> OraDebuggingSession.attachToTargetSession$lambda$6(this, arg_0));
            this.trace("Attached to the target session");
            this.attached = true;
        }
        catch (Exception e) {
            this.attached = false;
            String message = "Failed to attach: " + e.getClass().getSimpleName() + ": " + e.getMessage();
            this.trace(message);
            throw new OraDebugException(message, e);
        }
    }

    private final void detachFromTargetSession() {
        this.resetResult();
        if (this.attached) {
            try {
                this.callProcedure("sys.dbms_debug.detach_session", new Object[0]);
                this.trace("Detached from the target session");
            }
            catch (ConnectException rmiConnectException) {
                this.trace("Connection broken");
            }
            this.attached = false;
        }
    }

    @Override
    protected <D extends CallDefinition, R> R call(@NotNull D definition, @NotNull Object[] parameters, @NotNull Function1<? super ResultsProducer, ? extends R> handler2) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        try {
            return super.call(definition, Arrays.copyOf(parameters, parameters.length), handler2);
        }
        catch (ConnectException rmiConnectException) {
            if (this.getState().compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0) {
                this.setState(ProcessState.STATE_BROKEN);
            }
            throw rmiConnectException;
        }
    }

    private final Boolean checkSessionActivity(long sessionId) {
        Ref.ObjectRef statusStr = new Ref.ObjectRef();
        Object[] objectArray = new Object[]{sessionId};
        this.call((CallDefinition)OraDebuggingSessionQueries.CheckSessionActivityProc.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.checkSessionActivity$lambda$7(statusStr, arg_0));
        String string = (String)statusStr.element;
        return string != null ? Boolean.valueOf(ModelSerializationFun.startsWith((String)string, (char)'A')) : null;
    }

    public final void issueCommand(@NotNull DebugCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DebugCommand debugCommand = command;
        if (debugCommand instanceof DebugImmediateCommand) {
            this.commandQueue.offer((DebugImmediateCommand)command);
            if (!this.processIsInsideGracefulLoop) {
                this.buckUpTheLoop();
            }
        } else if (debugCommand instanceof DebugContinuationCommand) {
            this.commandHolder.offer((DebugContinuationCommand)command);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final boolean goingToRelax() {
        return this.commandHolder.isEmpty();
    }

    private final void buckUpTheLoop() {
        if (this.processIsInsideMainLoop) {
            this.commandHolder.offerIfEmpty(IterateImmediateCommand.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performMainLoop() {
        this.processIsTerminated = false;
        this.trace("Entering the Main Loop");
        this.setState(ProcessState.STATE_KICKED_OFF);
        try {
            this.processIsInsideMainLoop = true;
            this.doSynchronize();
            boolean bl = this.target.getExecuting();
            if (bl) {
                this.setState(ProcessState.STATE_STARTING_UP);
                this.performImmediateCommands();
                this.dataPending = true;
            } else if (!bl) {
                this.trace("execution failed");
                this.setState(ProcessState.STATE_FAIL);
                this.onMainLoopIteration.invoke((Object)this.getState());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            block13: while (this.target.getExecuting() && !this.processIsTerminated && this.getState().compareTo((Enum)ProcessState.STATE_COMPLETED) < 0) {
                try {
                    if (!this.target.getUnderDebug()) {
                        this.markProcessTerminated();
                        this.setState(ProcessState.STATE_COMPLETED);
                        break;
                    }
                    this.onMainLoopIteration.invoke((Object)this.getState());
                    if (this.dataPending && this.getState().isInteractive() && this.goingToRelax()) {
                        this.retrieveData();
                    }
                    if (SqlDebugFunKt.elapsedTime(this.stoppingMoment) > 3000L) {
                        this.deactivateTargetSessionDataSource();
                    }
                    if (!((Collection)this.commandQueue).isEmpty()) {
                        ProcessState processState = ProcessState.STATE_RESUMING;
                        ProcessState processState2 = ProcessState.STATE_RUNNING;
                        ProcessState processState3 = this.getState();
                        boolean bl2 = 0 <= ((Comparable)((Object)processState3)).compareTo(processState) ? ((Comparable)((Object)processState3)).compareTo(processState2) <= 0 : false;
                        if (bl2) {
                            this.setState(ProcessState.STATE_RELAXING);
                        }
                        this.performImmediateCommands();
                        continue;
                    }
                    DebugContinuationCommand command = this.commandHolder.take(this.getState().isInteractive() ? 1000L : 0L);
                    if (command != null) {
                        this.trace("Took command " + command);
                        DebugContinuationCommand debugContinuationCommand = command;
                        if (debugContinuationCommand instanceof IterateImmediateCommand) continue;
                        if (debugContinuationCommand instanceof DebugGracefulResumingCommand) {
                            this.doGracefulResume((DebugGracefulResumingCommand)command);
                        } else if (debugContinuationCommand instanceof PauseCommand) {
                            this.doPause();
                        } else if (debugContinuationCommand instanceof StepOutCommand) {
                            this.doStepOut((StepOutCommand)command);
                        } else if (debugContinuationCommand instanceof RunToPositionCommand) {
                            this.doRunToPosition((RunToPositionCommand)command);
                        } else if (debugContinuationCommand instanceof StopCommand) {
                            this.setStoppingMoment(System.currentTimeMillis());
                            this.doContinue((DebugNativeResumingCommand)command);
                        } else if (debugContinuationCommand instanceof DebugNativeResumingCommand) {
                            this.doContinue((DebugNativeResumingCommand)command);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        this.dataPending = this.result == ApiResult.RESULT_OK;
                        continue;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
                        case 1: {
                            OraDebuggingSession.doContinue$default(this, (short)((short)(2 | 0x20) | 0xC), null, 2, null);
                            continue block13;
                        }
                        case 2: {
                            this.doSynchronize();
                            continue block13;
                        }
                        case 3: {
                            continue block13;
                        }
                        case 4: {
                            OraDebuggingSession.doContinue$default(this, (short)0, null, 2, null);
                            continue block13;
                        }
                    }
                    OraDebuggingSession.doContinue$default(this, (short)2, null, 2, null);
                }
                catch (InterruptedException i) {
                    this.trace("InterruptedException \u2014\u00a0attempting to stop the executing process");
                    this.commandHolder.offer(StopCommand.INSTANCE);
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    this.trace("Error " + errorCode + " state " + e.getSQLState() + ": " + e.getMessage());
                    if (errorCode != 17008) continue;
                    this.connectionBroken();
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.processIsInsideMainLoop = false;
            this.commandHolder.clear();
            this.commandQueue.clear();
            this.trace("Leaving the Main Loop");
        }
    }

    private final void performImmediateCommands() {
        if (this.commandQueue.isEmpty()) {
            return;
        }
        while (this.commandQueue.poll() != null) {
            DebugImmediateCommand command;
            DebugImmediateCommand debugImmediateCommand = command;
            if (debugImmediateCommand instanceof RegisterBreakpointCommand) {
                this.doRegisterLineBreakpoint((RegisterBreakpointCommand)command);
                continue;
            }
            if (debugImmediateCommand instanceof DeregisterBreakpointCommand) {
                this.doDeregisterLineBreakpoint((DeregisterBreakpointCommand)command);
                continue;
            }
            if (debugImmediateCommand instanceof RetrieveVariablesCommand) {
                this.doRetrieveVariables((RetrieveVariablesCommand)command);
                continue;
            }
            if (debugImmediateCommand instanceof EvaluateExpressionCommand) {
                this.doEvaluateExpression((EvaluateExpressionCommand)command);
                continue;
            }
            if (debugImmediateCommand instanceof ExecuteFragmentCommand) {
                this.doExecuteFragment((ExecuteFragmentCommand)command);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void completeTheProcess() {
        if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0) {
            this.setState(ProcessState.STATE_COMPLETING);
        }
    }

    public final void abortTheProcess() {
        this.issueCommand(StopCommand.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performFinishLoop() {
        this.commandHolder.clear();
        long targetSessionId = this.target.getSessionId();
        Boolean targetIsActive = this.checkSessionActivity(targetSessionId);
        if (targetIsActive == null) {
            this.trace("Target session " + targetSessionId + " disappeared unexpectedly. Stopping the debugger.");
            this.setState(ProcessState.STATE_BROKEN);
            this.markProcessTerminated();
            return;
        }
        long t1 = System.currentTimeMillis();
        while (this.target.getUnderDebug() && !this.target.getTurningDebugOFF()) {
            if (SqlDebugFunKt.elapsedTime(t1) > 3000L) {
                this.trace("Target session " + targetSessionId + " seems hung. Disconnecting.");
                this.target.disconnectAndAbandonConnection();
                this.setState(ProcessState.STATE_BROKEN);
                this.markProcessTerminated();
                return;
            }
            Thread.sleep(250L);
        }
        this.processIsTerminated = false;
        this.trace("Entering the Finishing Loop");
        this.setState(ProcessState.STATE_FINISHING);
        try {
            this.doSynchronize();
            this.deregisterAllBreakpoints();
            this.retrieveDbmsOutput(this.dbmsOutputConsumer);
            while (this.target.getTurningDebugOFF() && !this.processIsTerminated && !this.getState().isTerminated()) {
                try {
                    OraDebuggingSession.doContinue$default(this, (short)0, null, 2, null);
                }
                catch (ConnectException rmiConnectException) {
                    this.trace("Connection broken");
                    break;
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.trace("Leaving the Finishing Loop");
        }
    }

    private final void doPause() {
        if (this.getState() == ProcessState.STATE_RESUMING || this.getState() == ProcessState.STATE_RUNNING) {
            short breakFlags = (short)((short)((short)((short)(2 | 0xC) | 0x10) | 0x20) | 0x200);
            this.trace("doContinue with flags = " + breakFlags + " for pausing");
            Object[] objectArray = new Number[]{breakFlags};
            this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, objectArray, null);
        }
    }

    private final void doSynchronize() {
        this.resetResult();
        this.trace("doSynchronize");
        this.handleSyncOrContinue(OraDebuggingSessionQueries.SynchronizeProc.INSTANCE, new Object[0], null);
    }

    private final void doContinue(DebugNativeResumingCommand command) {
        this.doContinue(command.getBreakFlags(), command);
    }

    private final void doContinue(short breakFlags, DebugCommand command) {
        this.resetResult();
        this.trace("doContinue with flags = " + breakFlags);
        Object[] objectArray = new Number[]{breakFlags};
        this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, objectArray, command);
    }

    static /* synthetic */ void doContinue$default(OraDebuggingSession oraDebuggingSession, short s, DebugCommand debugCommand, int n, Object object) {
        if ((n & 2) != 0) {
            debugCommand = null;
        }
        oraDebuggingSession.doContinue(s, debugCommand);
    }

    private final void doStepOut(StepOutCommand command) {
        this.resetResult();
        int depth = command.getDepth();
        short bf = command.getBreakFlags();
        this.trace("doStepOut with stack depth = " + depth + " and flags = " + bf);
        Object[] objectArray = new Number[]{depth, bf, (byte)0};
        this.handleSyncOrContinue(OraDebuggingSessionQueries.StepOutProc.INSTANCE, objectArray, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRunToPosition(RunToPositionCommand command) {
        OraPosition position = command.getPosition();
        this.trace("doRunToPosition " + position);
        Ref.IntRef breakpointId = new Ref.IntRef();
        breakpointId.element = -1;
        Ref.ObjectRef breakpointResult = new Ref.ObjectRef();
        breakpointResult.element = ApiResult.RESULT_UNRECOGNIZED;
        this.registerLineBreakpoint(position, (Function2<? super ApiResult, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> OraDebuggingSession.doRunToPosition$lambda$8(breakpointResult, breakpointId, arg_0, arg_1)));
        if (breakpointResult.element != ApiResult.RESULT_OK) {
            this.trace("Cannot run to position " + position + ": failed to register breakpoint: " + breakpointResult.element);
            return;
        }
        try {
            Object[] objectArray = new Number[]{command.getBreakFlags()};
            this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, objectArray, command);
        }
        finally {
            this.deregisterLineBreakpoint(breakpointId.element, (Function1<? super ApiResult, Unit>)((Function1)arg_0 -> OraDebuggingSession.doRunToPosition$lambda$9(this, breakpointId, arg_0)));
        }
    }

    private final void handleSyncOrContinue(OraDebuggingSessionQueries.SyncLikeProc proc, Object[] params, DebugCommand lastCommand) {
        boolean bl;
        boolean bl2 = bl = proc.getSkip() == params.length;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22 = false;
            String $i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22 = "Input parameters number mismatch: skip number is " + proc.getSkip() + " but passed " + params.length;
            throw new AssertionError((Object)$i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22);
        }
        CallableStatementBasis basis = new CallableStatementBasis(proc.getText(), new BitSet(0), proc.getOutParams());
        CallableStatementData csd = new CallableStatementData(basis, OraConnectionHelperKt.decorateInParameters(params));
        CallableSmartStatement executor = SmartStatements.Companion.poweredBy(this.getConnection()).call();
        this.trace("\texecuting\u2026");
        Ref.ByteRef resultCode = new Ref.ByteRef();
        resultCode.element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.ByteRef reasonCode = new Ref.ByteRef();
        reasonCode.element = PauseReason.REASON_UNEXPECTED.getCode();
        Ref.IntRef lineNr = new Ref.IntRef();
        Ref.IntRef breakpoint = new Ref.IntRef();
        Ref.IntRef stackDepth = new Ref.IntRef();
        Ref.ShortRef namespaceCode = new Ref.ShortRef();
        namespaceCode.element = OraNamespace.NS_NONE.code;
        Ref.ObjectRef programSchema = new Ref.ObjectRef();
        Ref.ObjectRef programName = new Ref.ObjectRef();
        Ref.ObjectRef entryPointName = new Ref.ObjectRef();
        Ref.BooleanRef terminated = new Ref.BooleanRef();
        Ref.BooleanRef isProcedure = new Ref.BooleanRef();
        if (this.getState().isInteractive()) {
            this.setState(ProcessState.STATE_RESUMING);
        }
        try {
            executor.noisy().execute((Object)csd, (ExecutionMode)StandardExecutionMode.GENERIC, arg_0 -> OraDebuggingSession.handleSyncOrContinue$lambda$11(resultCode, proc, reasonCode, lineNr, breakpoint, stackDepth, namespaceCode, programSchema, programName, entryPointName, terminated, isProcedure, arg_0));
            this.handleSyncResult(false, resultCode.element, reasonCode.element, lineNr.element, breakpoint.element, stackDepth.element, namespaceCode.element, (String)programSchema.element, (String)programName.element, (String)entryPointName.element, terminated.element, isProcedure.element, lastCommand);
        }
        catch (Throwable exception) {
            this.handleSyncException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doGracefulResume(DebugGracefulResumingCommand command) {
        Ref.ObjectRef proc = new Ref.ObjectRef();
        proc.element = OraDebuggingSessionQueries.GracefulResumeProc.INSTANCE;
        byte stepCmd = 0;
        int stepDepth = 0;
        int stepLine = 0;
        short stepPrgNsp = 0;
        String stepPrgName = "";
        DebugGracefulResumingCommand debugGracefulResumingCommand = command;
        if (debugGracefulResumingCommand instanceof GracefulStepOverCommand) {
            stepCmd = 2;
            stepDepth = ((GracefulStepOverCommand)command).getDepth();
            stepLine = ((GracefulStepOverCommand)command).getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulStepOutCommand) {
            stepCmd = 3;
            stepDepth = ((GracefulStepOutCommand)command).getDepth();
        } else if (debugGracefulResumingCommand instanceof GracefulRunToPositionInProgramCommand) {
            stepCmd = 4;
            stepPrgNsp = ((GracefulRunToPositionInProgramCommand)command).getPosition().getNamespace().code;
            String string = ((GracefulRunToPositionInProgramCommand)command).getPosition().getProgramName();
            if (string == null) {
                string = "";
            }
            stepPrgName = string;
            stepLine = ((GracefulRunToPositionInProgramCommand)command).getPosition().getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulRunToPositionInScriptCommand) {
            stepCmd = 5;
            stepLine = ((GracefulRunToPositionInScriptCommand)command).getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulResumeCommand) {
            stepCmd = 6;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Ref.ByteRef resultCode = new Ref.ByteRef();
        resultCode.element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.ByteRef reasonCode = new Ref.ByteRef();
        reasonCode.element = PauseReason.REASON_UNEXPECTED.getCode();
        Ref.IntRef lineNr = new Ref.IntRef();
        Ref.IntRef breakpoint = new Ref.IntRef();
        Ref.IntRef stackDepth = new Ref.IntRef();
        Ref.ShortRef namespaceCode = new Ref.ShortRef();
        namespaceCode.element = OraNamespace.NS_NONE.code;
        Ref.ObjectRef programSchema = new Ref.ObjectRef();
        Ref.ObjectRef programName = new Ref.ObjectRef();
        Ref.ObjectRef entryPointName = new Ref.ObjectRef();
        Ref.BooleanRef terminated = new Ref.BooleanRef();
        Ref.BooleanRef isProcedure = new Ref.BooleanRef();
        Ref.IntRef stepsDone = new Ref.IntRef();
        Ref.BooleanRef coffeeBreak = new Ref.BooleanRef();
        this.setState(ProcessState.STATE_RUNNING);
        long t1 = System.nanoTime();
        int totalStepsDone = 0;
        try {
            try {
                this.processIsInsideGracefulLoop = true;
                do {
                    Object[] objectArray;
                    try {
                        Object[] objectArray2 = new Object[]{stepCmd, stepDepth, stepLine, stepPrgNsp, stepPrgName};
                        this.call((CallDefinition)proc.element, objectArray2, arg_0 -> OraDebuggingSession.doGracefulResume$lambda$12(resultCode, proc, reasonCode, lineNr, breakpoint, stackDepth, namespaceCode, programSchema, programName, entryPointName, terminated, isProcedure, stepsDone, coffeeBreak, arg_0));
                        totalStepsDone += stepsDone.element;
                    }
                    catch (Throwable t2) {
                        totalStepsDone += stepsDone.element;
                        long t22 = System.nanoTime();
                        float elapsed = (float)(t22 - t1) / 1.0E9f;
                        objectArray = "%.3f";
                        Object[] objectArray3 = new Object[]{Float.valueOf(elapsed)};
                        String string = String.format((String)objectArray, Arrays.copyOf(objectArray3, objectArray3.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                        this.trace("Graceful running: " + totalStepsDone + " steps done in " + string + " s");
                        throw t2;
                    }
                    long t2 = System.nanoTime();
                    float elapsed = (float)(t2 - t1) / 1.0E9f;
                    String string = "%.3f";
                    objectArray = new Object[]{Float.valueOf(elapsed)};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    this.trace("Graceful running: " + totalStepsDone + " steps done in " + string2 + " s");
                    if (resultCode.element != 0) break;
                    if (terminated.element) {
                        break;
                    }
                    if (reasonCode.element == PauseReason.REASON_STARTED.getCode()) {
                        coffeeBreak.element = true;
                    }
                    if (stackDepth.element == 1 && !this.scriptIsMeaningful) {
                        coffeeBreak.element = true;
                    }
                    if (!coffeeBreak.element) continue;
                    this.performImmediateCommands();
                    this.retrieveIntermediateData();
                } while (coffeeBreak.element && this.commandHolder.isEmpty());
            }
            finally {
                this.processIsInsideGracefulLoop = false;
            }
        }
        catch (Throwable exception) {
            this.handleSyncException(exception);
        }
        this.handleSyncResult(true, resultCode.element, reasonCode.element, lineNr.element, breakpoint.element, stackDepth.element, namespaceCode.element, (String)programSchema.element, (String)programName.element, (String)entryPointName.element, terminated.element, isProcedure.element, null);
    }

    private final void handleSyncResult(boolean graceful, byte resultCode, byte reasonCode, int lineNr, int breakpoint, int stackDepth, short namespaceCode, String programSchema, String programName, String entryPointName, boolean terminated, boolean isProcedure, DebugCommand lastCommand) {
        ApiResult apiResult;
        this.trace("\thandling\u2026");
        PauseReason pauseReason = OraDebuggerEnumsKt.getPAUSE_REASONS().get(reasonCode);
        if (pauseReason == null) {
            pauseReason = this.reason = PauseReason.REASON_UNEXPECTED;
        }
        if ((apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(resultCode)) == null) {
            apiResult = ApiResult.RESULT_UNEXPECTED;
        }
        this.result = apiResult;
        this.stackDepth = stackDepth;
        OraNamespace namespace = OraNamespace.Companion.byCode(namespaceCode);
        if (this.result == ApiResult.RESULT_OK) {
            this.trace("\t\tsync: " + this.reason + " \u2014\u00a0namespace " + namespace + ", program " + programSchema + "." + programName + " at line " + lineNr + ", proc " + SqlUtilFun.toInt((boolean)isProcedure) + ", breakpoint " + breakpoint + ", stack depth " + stackDepth);
        } else if (!(this.getState() != ProcessState.STATE_RESUMING && this.getState() != ProcessState.STATE_RUNNING || terminated)) {
            this.trace("\t\tsync: running, stack depth = " + stackDepth);
        } else if (terminated) {
            this.trace("\t\tsync: the process is terminated");
        } else {
            this.trace("\t\tsync: problem " + this.result);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.result.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setState(ProcessState.STATE_BROKEN);
                break;
            }
            default: {
                return;
            }
        }
        this.processIsTerminated = terminated;
        if (this.processIsTerminated) {
            this.trace("Terminated");
            this.setStoppingMoment(0L);
            this.commandHolder.clear();
            switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
                case 4: {
                    this.setState(ProcessState.STATE_COMPLETED);
                    break;
                }
                case 5: {
                    this.setState(ProcessState.STATE_FINISHED);
                }
            }
            this.markProcessTerminated();
        } else if (graceful) {
            this.processIsActive = true;
            this.processIsRunning = false;
            this.processIsWaiting = true;
            ProcessState processState = ProcessState.STATE_RESUMING;
            ProcessState processState2 = ProcessState.STATE_RUNNING;
            ProcessState processState3 = this.getState();
            boolean bl = 0 <= ((Comparable)((Object)processState3)).compareTo(processState) ? ((Comparable)((Object)processState3)).compareTo(processState2) <= 0 : false;
            if (bl) {
                this.setState(ProcessState.STATE_RELAXING);
            }
        } else {
            this.processIsActive = true;
            this.processIsRunning = this.reason == PauseReason.REASON_NONE;
            this.processIsWaiting = !this.processIsRunning;
            ProcessState processState = ProcessState.STATE_RESUMING;
            ProcessState processState4 = ProcessState.STATE_RUNNING;
            ProcessState processState5 = this.getState();
            boolean bl = 0 <= ((Comparable)((Object)processState5)).compareTo(processState) ? ((Comparable)((Object)processState5)).compareTo(processState4) <= 0 : false;
            if (bl && this.reason.getRelaxing()) {
                this.setState(ProcessState.STATE_RELAXING);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$2[this.reason.ordinal()]) {
            case 1: {
                DebugContinuationCommand lc;
                if (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()] != 3) break;
                DebugContinuationCommand debugContinuationCommand = lc = lastCommand instanceof DebugContinuationCommand ? (DebugContinuationCommand)lastCommand : null;
                if (lc == null) break;
                this.commandHolder.offerIfEmpty(lc);
                break;
            }
            case 2: {
                if (stackDepth > 0) break;
                this.trace("Leaving the Debugging level (reason " + this.reason + ")");
                this.setState(terminated ? ProcessState.STATE_COMPLETED : ProcessState.STATE_COMPLETING);
                break;
            }
            case 3: 
            case 4: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) > 0) break;
                this.setState(terminated ? ProcessState.STATE_COMPLETED : ProcessState.STATE_COMPLETING);
                break;
            }
            case 5: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) >= 0) break;
                this.setState(ProcessState.STATE_RUNNING);
                break;
            }
            case 6: 
            case 7: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) >= 0) break;
                this.setState(ProcessState.STATE_RELAXING);
            }
        }
    }

    private final void handleSyncException(Throwable thrownException) {
        Throwable e = OraConnectionHelperKt.unwrapException(thrownException);
        String message = OraConnectionHelperKt.prepareGoodMessage(e, "debugger sync fail");
        this.trace(message);
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            switch (((SQLException)e).getErrorCode()) {
                case 17009: {
                    this.setState(ProcessState.STATE_FINISHED);
                    this.markProcessTerminated();
                    break;
                }
                case 17008: {
                    this.setState(ProcessState.STATE_BROKEN);
                    this.markProcessTerminated();
                }
            }
        } else if (throwable instanceof ConnectException) {
            this.setState(ProcessState.STATE_BROKEN);
        }
    }

    private final void markProcessTerminated() {
        this.processIsActive = false;
        this.processIsRunning = false;
        this.processIsWaiting = false;
        this.stack = CollectionsKt.emptyList();
        this.setStoppingMoment(0L);
    }

    private final void retrieveData() {
        this.dataPending = false;
        if (this.stackDepth > 0) {
            this.retrieveStack();
        } else {
            this.stack = CollectionsKt.emptyList();
        }
        this.onEventInfo.invoke(this.stack, (Object)this.getState());
        this.retrieveIntermediateData();
        this.onGoodTimeToRetrieveAdditionalData.invoke();
    }

    private final void retrieveIntermediateData() {
        this.retrieveDbmsOutput(this.dbmsOutputConsumer);
    }

    private final void retrieveStack() {
        try {
            List listing = (List)this.call((CallDefinition)OraDebuggingSessionQueries.ObtainBacktraceProc.INSTANCE, new Object[0], OraDebuggingSession::retrieveStack$lambda$13);
            this.handleStack(listing);
        }
        catch (SQLException e) {
            this.trace("Error during obtaining stack trace: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during obtaining stack trace: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final void handleStack(List<String> listing) {
        ArrayList newStack = new ArrayList(listing.size());
        for (String frameLine : CollectionsKt.asReversed(listing)) {
            char[] cArray = new char[]{'\u0001'};
            List frameElements = StringsKt.split$default((CharSequence)frameLine, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            OraPosition frame = null;
            if (frameElements.size() >= 4) {
                Short s = StringsKt.toShortOrNull((String)((String)frameElements.get(0)));
                short namespaceCode = s != null ? s : OraNamespace.NS_NONE.code;
                String programSchema = StringKt.nullize$default((String)((String)frameElements.get(1)), (boolean)false, (int)1, null);
                String programName = StringKt.nullize$default((String)((String)frameElements.get(2)), (boolean)false, (int)1, null);
                Integer n = StringsKt.toIntOrNull((String)((String)frameElements.get(3)));
                int lineNr = n != null ? n : 0;
                frame = this.makeFrame(namespaceCode, programSchema, programName, lineNr);
            } else {
                frame = new OraUnknownPosition(OraNamespace.NS_NONE, null, frameLine, 0);
            }
            ((Collection)newStack).add(frame);
        }
        this.stack = newStack;
    }

    private final OraPosition makeFrame(short namespaceCode, String programSchema, String programName, int lineNr) {
        OraNamespace namespace = OraNamespace.Companion.byCode(namespaceCode);
        return programSchema != null && programName != null ? (OraPosition)new OraProgramPosition(namespace, programSchema, programName, lineNr) : (namespace == OraNamespace.NS_CURSOR && lineNr > 0 ? (OraPosition)new OraScriptPosition(lineNr) : (OraPosition)new OraUnknownPosition(namespace, programSchema, programName, lineNr));
    }

    private final void doRetrieveVariables(RetrieveVariablesCommand command) {
        List<SqlVariable> variables = command.getVariables();
        List<SqlVariable> entries = this.flatten(variables);
        int n = entries.size();
        if (n == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (SqlVariable v : entries) {
            StringBuilder stringBuilder;
            String nameLit = "'" + v.getQname() + "'";
            if (WhenMappings.$EnumSwitchMapping$3[v.getRootKind().ordinal()] == 1) {
                Object object;
                String schemaNameLit;
                if (v.getSchemaName() != null) {
                    String string = v.getSchemaName();
                    Intrinsics.checkNotNull((Object)string);
                    v1 = "'" + string + "'";
                } else {
                    v1 = schemaNameLit = "null";
                }
                if (v.getPackageName() != null) {
                    String string = v.getPackageName();
                    Intrinsics.checkNotNull((Object)string);
                    object = "'" + string + "'";
                } else {
                    object = "null";
                }
                String packageNameLit = object;
                stringBuilder = b.append("\t? := getFieldValue(" + schemaNameLit + ", " + packageNameLit + ", " + nameLit + ");\n");
                continue;
            }
            stringBuilder = b.append("\t? := getVarValue(" + command.getFrameLevel() + ", " + nameLit + ");\n");
        }
        String string = Companion.getPeekVariablesTemplate$intellij_database_dialects_oracle_ex();
        String string2 = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String statementText = StringsKt.replace$default((String)string, (String)"@", (String)string2, (boolean)false, (int)4, null);
        List resultParams = new ArrayList(n);
        CallDefinition cmd2 = new CallDefinition(n, resultParams, statementText){
            {
                for (int i = 0; i < $n; ++i) {
                    ((Collection)$resultParams).add(CallParams.registerString$default(this, i + 1, Short.MAX_VALUE, null, 4, null));
                }
            }
        };
        HashMap result = new HashMap(n);
        Ref.IntRef numberOfCorrect = new Ref.IntRef();
        Ref.IntRef numberOfNotInScope = new Ref.IntRef();
        Ref.IntRef numberOfErrors = new Ref.IntRef();
        this.call((CallDefinition)cmd2, new Object[0], arg_0 -> OraDebuggingSession.doRetrieveVariables$lambda$14(n, resultParams, numberOfNotInScope, numberOfErrors, numberOfCorrect, entries, result, arg_0));
        this.trace("Retrieved variables from frame " + command.getFrameLevel() + ": " + numberOfCorrect.element + " ok, " + numberOfNotInScope.element + " not in the scope, " + numberOfErrors.element + " errors");
        command.getConsumer().invoke(result);
    }

    private final List<SqlVariable> flatten(List<SqlVariable> $this$flatten) {
        ArrayList container = new ArrayList($this$flatten.size());
        for (SqlVariable variable : $this$flatten) {
            this.flattenTo(variable, container);
        }
        return container;
    }

    private final void flattenTo(SqlVariable $this$flattenTo, List<SqlVariable> container) {
        List<SqlVariable> fields = $this$flattenTo.getFields();
        if (fields == null) {
            container.add($this$flattenTo);
        } else {
            Iterable $this$forEach$iv = fields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlVariable it = (SqlVariable)element$iv;
                boolean bl = false;
                this.flattenTo(it, container);
            }
        }
    }

    private final void doEvaluateExpression(EvaluateExpressionCommand command) {
        DasType dasType = command.getInfo().getType();
        String template = (dasType != null ? DasTypeUtilsKt.getCategory((DasType)dasType) : null) == DasTypeCategory.BOOLEAN ? Companion.getEvaluateScalarExpressionFragmentBoolean$intellij_database_dialects_oracle_ex() : Companion.getEvaluateScalarExpressionFragment$intellij_database_dialects_oracle_ex();
        String block = StringsKt.replace$default((String)template, (String)"@", (String)command.getExpression(), (boolean)false, (int)4, null);
        Ref.ObjectRef error = new Ref.ObjectRef();
        Ref.ObjectRef value = new Ref.ObjectRef();
        value.element = "???";
        Object[] objectArray = new Object[]{block};
        this.call((CallDefinition)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.doEvaluateExpression$lambda$16(error, value, arg_0));
        Function1<String, Unit> function1 = command.getConsumer();
        String string = (String)error.element;
        if (string == null && (string = (String)value.element) == null) {
            string = "null";
        }
        function1.invoke((Object)string);
    }

    private final void doExecuteFragment(ExecuteFragmentCommand command) {
        Object f = ((Object)StringsKt.trim((CharSequence)command.getFragment())).toString();
        if (!StringsKt.endsWith$default((CharSequence)((CharSequence)f), (char)';', (boolean)false, (int)2, null)) {
            f = (String)f + ";";
        }
        String block = StringsKt.replace$default((String)Companion.getExecuteFragmentTemplate$intellij_database_dialects_oracle_ex(), (String)"@", (String)f, (boolean)false, (int)4, null);
        Ref.ObjectRef error = new Ref.ObjectRef();
        try {
            Object[] objectArray = new Object[]{block};
            this.call((CallDefinition)OraDebuggingSessionQueries.ExecuteFragmentStatement.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.doExecuteFragment$lambda$17(error, arg_0));
        }
        catch (SQLException e) {
            error.element = "SQL error " + e.getErrorCode() + ": " + e.getMessage();
        }
        catch (Exception e) {
            error.element = "Exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        if (error.element != null) {
            Function1<String, Unit> function1 = command.getConsumer();
            Object object = error.element;
            Intrinsics.checkNotNull((Object)object);
            function1.invoke(object);
            return;
        }
        StringBuilder b = new StringBuilder();
        this.retrieveDbmsOutput((Function1<? super String, Unit>)((Function1)arg_0 -> OraDebuggingSession.doExecuteFragment$lambda$18(b, arg_0)));
        if (((CharSequence)b).length() > 0) {
            Function1<String, Unit> function1 = command.getConsumer();
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            function1.invoke((Object)string);
        } else {
            command.getConsumer().invoke((Object)"Performed successfully");
        }
    }

    private final void retrieveDbmsOutput(Function1<? super String, Unit> consumer) {
        if (!this.target.getUnderDebug()) {
            return;
        }
        int iterationsLimit = 15;
        try {
            OraDebugExecutionResult r;
            do {
                if (!((Collection)(r = this.executeAndFetchResult(Companion.getRetrieveDbmsOutputBlock$intellij_database_dialects_oracle_ex())).getResult()).isEmpty()) {
                    Iterable $this$forEach$iv = r.getResult();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        consumer.invoke(element$iv);
                    }
                }
                if (r.getError() == null) continue;
                this.trace("Failed to fetch dbms_output lines: " + r.getError());
            } while (r.getResult().size() >= Companion.getRetrieveDbmsOutputPortionSize$intellij_database_dialects_oracle_ex() && --iterationsLimit > 0);
        }
        catch (SQLException e) {
            this.trace("Error during dbms_output lines fetching: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during dbms_output lines fetching: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final OraDebugExecutionResult executeAndFetchResult(String block) {
        Object[] objectArray = new Object[]{block};
        Pair p2 = OraConnectionHelperKt.call(this.getConnection(), "{ call sys.dbms_debug.execute(?, -1, 1, ?, ?) }", (IndexedOutParameter)new OraStringArrayOutParameter(2, "SYS.DBMS_DEBUG_VC2COLL"), (IndexedOutParameter)new StringOutParam(3, 4000, null, 4, null), objectArray);
        return new OraDebugExecutionResult((List)p2.getFirst(), (String)p2.getSecond());
    }

    private final void doRegisterLineBreakpoint(RegisterBreakpointCommand command) {
        OraRealLineBreakpoint bp2 = command.getBp();
        if (bp2.getId() > 0) {
            this.deregisterLineBreakpoint(bp2.getId(), (Function1<? super ApiResult, Unit>)((Function1)OraDebuggingSession::doRegisterLineBreakpoint$lambda$19));
        }
        this.registerLineBreakpoint(bp2.getPosition(), (Function2<? super ApiResult, ? super Integer, Unit>)((Function2)new Function2<ApiResult, Integer, Unit>(bp2, this, command){
            final /* synthetic */ OraRealLineBreakpoint $bp;
            final /* synthetic */ OraDebuggingSession this$0;
            final /* synthetic */ RegisterBreakpointCommand $command;
            {
                this.$bp = $bp;
                this.this$0 = $receiver;
                this.$command = $command;
                super(2, Intrinsics.Kotlin.class, "handleLineBreakpointRegistration", "doRegisterLineBreakpoint$handleLineBreakpointRegistration(Lcom/intellij/database/dialects/oracle/debugger/OraRealLineBreakpoint;Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;Lcom/intellij/database/dialects/oracle/debugger/RegisterBreakpointCommand;Lcom/intellij/database/dialects/oracle/debugger/ApiResult;I)V", 0);
            }

            public final void invoke(ApiResult p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                OraDebuggingSession.access$doRegisterLineBreakpoint$handleLineBreakpointRegistration(this.$bp, this.this$0, this.$command, p0, p1);
            }
        }));
    }

    private final void registerLineBreakpoint(OraPosition position, Function2<? super ApiResult, ? super Integer, Unit> handler2) {
        ApiResult apiResult;
        Ref.ByteRef rc = new Ref.ByteRef();
        rc.element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.IntRef id = new Ref.IntRef();
        OraPosition oraPosition = position;
        if (oraPosition instanceof OraScriptPosition) {
            Object[] objectArray = new Object[]{((OraScriptPosition)position).getLineNr()};
            this.call((CallDefinition)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.registerLineBreakpoint$lambda$20(rc, id, arg_0));
        } else if (oraPosition instanceof OraProgramPosition) {
            Object[] objectArray = new Object[]{((OraProgramPosition)position).getNamespace().code, ((OraProgramPosition)position).getSchemaName(), ((OraProgramPosition)position).getProgramName(), ((OraProgramPosition)position).getLineNr()};
            this.call((CallDefinition)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.registerLineBreakpoint$lambda$21(rc, id, arg_0));
        } else if (!(oraPosition instanceof OraUnknownPosition)) {
            throw new NoWhenBranchMatchedException();
        }
        if ((apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(rc.element)) == null) {
            apiResult = ApiResult.RESULT_UNEXPECTED;
        }
        ApiResult r = apiResult;
        handler2.invoke((Object)r, (Object)id.element);
    }

    private final void doDeregisterLineBreakpoint(DeregisterBreakpointCommand command) {
        OraRealLineBreakpoint bp2 = command.getBp();
        int id = bp2.getId();
        if (id <= 0) {
            return;
        }
        this.deregisterLineBreakpoint(id, (Function1<? super ApiResult, Unit>)((Function1)arg_0 -> OraDebuggingSession.doDeregisterLineBreakpoint$lambda$22(this, bp2, command, arg_0)));
    }

    private final void deregisterLineBreakpoint(int id, Function1<? super ApiResult, Unit> handler2) {
        Ref.ByteRef rc = new Ref.ByteRef();
        rc.element = ApiResult.RESULT_UNEXPECTED.getCode();
        try {
            Object[] objectArray = new Object[]{id};
            this.call((CallDefinition)OraDebuggingSessionQueries.DeregisterLineBreakpointBlock.INSTANCE, objectArray, arg_0 -> OraDebuggingSession.deregisterLineBreakpoint$lambda$23(rc, arg_0));
            ApiResult apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(rc.element);
            if (apiResult == null) {
                apiResult = ApiResult.RESULT_UNEXPECTED;
            }
            ApiResult r = apiResult;
            handler2.invoke((Object)r);
        }
        catch (Exception e) {
            this.trace(OraConnectionHelperKt.prepareGoodMessage(OraConnectionHelperKt.unwrapException(e), "Failed to remove the breakpoint " + id));
        }
    }

    private final void deregisterAllBreakpoints() {
        try {
            OraConnectionHelperKt.perform(this.getConnection(), Companion.getDeregisterAllBreakpointsStatement$intellij_database_dialects_oracle_ex(), new Object[0]);
        }
        catch (Exception e) {
            this.trace(OraConnectionHelperKt.prepareGoodMessage(OraConnectionHelperKt.unwrapException(e), "Failed to remove breakpoints"));
        }
    }

    private final void printListing() {
        this.call((CallDefinition)OraDebuggingSessionQueries.PrintBacktraceProc.INSTANCE, new Object[0], arg_0 -> OraDebuggingSession.printListing$lambda$24(this, arg_0));
    }

    private final void connectionBroken() {
        this.setState(ProcessState.STATE_BROKEN);
        this.resetProcessState();
        this.processIsTerminated = true;
    }

    private final void resetResult() {
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
    }

    private final void resetProcessState() {
        this.processIsActive = false;
        this.processIsRunning = false;
        this.processIsWaiting = false;
        this.setStoppingMoment(0L);
    }

    public final void resetState() {
        this.setState(ProcessState.STATE_ASLEEP);
        this.resetResult();
        this.resetProcessState();
    }

    private final void stateChanged(ProcessState oldState, ProcessState newState) {
        this.trace("state transition: " + oldState + " -> " + newState);
        this.onStateTransition.invoke((Object)oldState, (Object)newState);
    }

    private final void deactivateTargetSessionDataSource() {
        this.target.deactivateDataSource();
        this.connectionBroken();
    }

    @Override
    public void close() {
        this.silently((Function0<Unit>)((Function0)() -> OraDebuggingSession.close$lambda$25(this)));
        super.close();
    }

    private static final Unit onStateTransition$lambda$0(ProcessState processState, ProcessState processState2) {
        Intrinsics.checkNotNullParameter((Object)((Object)processState), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)processState2), (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit onEventInfo$lambda$1(List list, ProcessState processState) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)processState), (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit onMainLoopIteration$lambda$2(ProcessState processState) {
        Intrinsics.checkNotNullParameter((Object)((Object)processState), (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit onGoodTimeToRetrieveAdditionalData$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit attachToTargetSession$lambda$6(OraDebuggingSession this$0, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        int major = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.AttachProc.INSTANCE.getVersionMajor())).intValue();
        int minor = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.AttachProc.INSTANCE.getVersionMinor())).intValue();
        int[] nArray = new int[]{major, minor};
        this$0.probeVersion = Version.of((int[])nArray);
        return Unit.INSTANCE;
    }

    private static final Unit checkSessionActivity$lambda$7(Ref.ObjectRef $statusStr, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $statusStr.element = producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.CheckSessionActivityProc.INSTANCE.getStatus());
        return Unit.INSTANCE;
    }

    private static final Unit doRunToPosition$lambda$8(Ref.ObjectRef $breakpointResult, Ref.IntRef $breakpointId, ApiResult r, int id) {
        Intrinsics.checkNotNullParameter((Object)((Object)r), (String)"r");
        $breakpointResult.element = r;
        $breakpointId.element = id;
        return Unit.INSTANCE;
    }

    private static final Unit doRunToPosition$lambda$9(OraDebuggingSession this$0, Ref.IntRef $breakpointId, ApiResult r) {
        Intrinsics.checkNotNullParameter((Object)((Object)r), (String)"r");
        if (r != ApiResult.RESULT_OK) {
            this$0.trace("Failed to deregister temporary breakpoint " + $breakpointId.element + " after running to position");
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleSyncOrContinue$lambda$11(Ref.ByteRef $resultCode, OraDebuggingSessionQueries.SyncLikeProc $proc, Ref.ByteRef $reasonCode, Ref.IntRef $lineNr, Ref.IntRef $breakpoint, Ref.IntRef $stackDepth, Ref.ShortRef $namespaceCode, Ref.ObjectRef $programSchema, Ref.ObjectRef $programName, Ref.ObjectRef $entryPointName, Ref.BooleanRef $terminated, Ref.BooleanRef $isProcedure, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $resultCode.element = ((Number)producer.getParameterValue((OutParameter)$proc.getResult())).byteValue();
        $reasonCode.element = ((Number)producer.getParameterValue((OutParameter)$proc.getReason())).byteValue();
        $lineNr.element = ((Number)producer.getParameterValue((OutParameter)$proc.getLineNr())).intValue();
        $breakpoint.element = ((Number)producer.getParameterValue((OutParameter)$proc.getBreakpoint())).intValue();
        $stackDepth.element = ((Number)producer.getParameterValue((OutParameter)$proc.getStackDepth())).intValue();
        $namespaceCode.element = ((Number)producer.getParameterValue((OutParameter)$proc.getNamespaceCode())).shortValue();
        $programSchema.element = producer.getParameterValue((OutParameter)$proc.getProgramSchema());
        $programName.element = producer.getParameterValue((OutParameter)$proc.getProgramName());
        $entryPointName.element = producer.getParameterValue((OutParameter)$proc.getEntryPointName());
        $terminated.element = (Boolean)producer.getParameterValue((OutParameter)$proc.getTerminated());
        $isProcedure.element = (Boolean)producer.getParameterValue((OutParameter)$proc.isProcedure());
        return Unit.INSTANCE;
    }

    private static final Unit doGracefulResume$lambda$12(Ref.ByteRef $resultCode, Ref.ObjectRef $proc, Ref.ByteRef $reasonCode, Ref.IntRef $lineNr, Ref.IntRef $breakpoint, Ref.IntRef $stackDepth, Ref.ShortRef $namespaceCode, Ref.ObjectRef $programSchema, Ref.ObjectRef $programName, Ref.ObjectRef $entryPointName, Ref.BooleanRef $terminated, Ref.BooleanRef $isProcedure, Ref.IntRef $stepsDone, Ref.BooleanRef $coffeeBreak, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $resultCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getResult())).byteValue();
        $reasonCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getReason())).byteValue();
        $lineNr.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getLineNr())).intValue();
        $breakpoint.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getBreakpoint())).intValue();
        $stackDepth.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getStackDepth())).intValue();
        $namespaceCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getNamespaceCode())).shortValue();
        $programSchema.element = producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getProgramSchema());
        $programName.element = producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getProgramName());
        $entryPointName.element = producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getEntryPointName());
        $terminated.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getTerminated());
        $isProcedure.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).isProcedure());
        $stepsDone.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getStepsDone())).intValue();
        $coffeeBreak.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)$proc.element).getCoffeeBreak());
        return Unit.INSTANCE;
    }

    private static final List retrieveStack$lambda$13(ResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)it.getParameterValue((OutParameter)OraDebuggingSessionQueries.ObtainBacktraceProc.INSTANCE.getListing());
    }

    private static final Unit doRetrieveVariables$lambda$14(int $n, List $resultParams, Ref.IntRef $numberOfNotInScope, Ref.IntRef $numberOfErrors, Ref.IntRef $numberOfCorrect, List $entries, HashMap $result, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        for (int i = 0; i < $n; ++i) {
            String string = (String)producer.getParameterValue((OutParameter)$resultParams.get(i));
            if (string == null) {
                string = "null";
            }
            String value = string;
            if (Intrinsics.areEqual((Object)value, (Object)"\u001a")) {
                value = SqlVariableKt.getNOT_ASSIGNED();
                var10_11 = $numberOfNotInScope.element;
                $numberOfNotInScope.element = var10_11 + 1;
            } else if (ModelSerializationFun.startsWith((String)value, (char)'\u001b')) {
                String string2 = value.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                value = string2;
                var10_11 = $numberOfErrors.element;
                $numberOfErrors.element = var10_11 + 1;
            } else {
                var10_11 = $numberOfCorrect.element;
                $numberOfCorrect.element = var10_11 + 1;
            }
            SqlVariable v = (SqlVariable)$entries.get(i);
            ((Map)$result).put(v, new SqlVariableValue(v, value));
        }
        return Unit.INSTANCE;
    }

    private static final Unit doEvaluateExpression$lambda$16(Ref.ObjectRef $error, Ref.ObjectRef $value, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $error.element = producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getError());
        $value.element = producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getValue());
        return Unit.INSTANCE;
    }

    private static final Unit doExecuteFragment$lambda$17(Ref.ObjectRef $error, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $error.element = producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getError());
        return Unit.INSTANCE;
    }

    private static final Unit doExecuteFragment$lambda$18(StringBuilder $b, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $b.append(s).append('\n');
        return Unit.INSTANCE;
    }

    private static final void doRegisterLineBreakpoint$handleLineBreakpointRegistration(OraRealLineBreakpoint bp2, OraDebuggingSession this$0, RegisterBreakpointCommand $command, ApiResult r, int id) {
        switch (WhenMappings.$EnumSwitchMapping$1[r.ordinal()]) {
            case 1: {
                bp2.setId(id);
                bp2.setAppropriate(true);
                bp2.setActive(true);
                bp2.setProblem(null);
                this$0.trace("Set breakpoint " + bp2 + ": successfully");
                break;
            }
            case 4: {
                bp2.setId(0);
                bp2.setAppropriate(false);
                bp2.setActive(false);
                bp2.setProblem(null);
                this$0.trace("Set breakpoint " + bp2 + ": wrong line");
                break;
            }
            default: {
                bp2.setId(0);
                bp2.setAppropriate(false);
                bp2.setActive(false);
                bp2.setProblem(r.name());
                this$0.trace("Set breakpoint " + bp2 + ": " + bp2.getProblem());
            }
        }
        $command.getHandled().invoke();
    }

    private static final Unit doRegisterLineBreakpoint$lambda$19(ApiResult it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit registerLineBreakpoint$lambda$20(Ref.ByteRef $rc, Ref.IntRef $id, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $rc.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE.getResult())).byteValue();
        $id.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE.getId())).intValue();
        return Unit.INSTANCE;
    }

    private static final Unit registerLineBreakpoint$lambda$21(Ref.ByteRef $rc, Ref.IntRef $id, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $rc.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE.getResult())).byteValue();
        $id.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE.getId())).intValue();
        return Unit.INSTANCE;
    }

    private static final Unit doDeregisterLineBreakpoint$lambda$22(OraDebuggingSession this$0, OraRealLineBreakpoint $bp, DeregisterBreakpointCommand $command, ApiResult r) {
        Intrinsics.checkNotNullParameter((Object)((Object)r), (String)"r");
        switch (WhenMappings.$EnumSwitchMapping$1[r.ordinal()]) {
            case 1: {
                this$0.trace("Remove breakpoint " + $bp + ": successfully");
                $bp.setId(0);
                $bp.setActive(false);
                $bp.setProblem(null);
                break;
            }
            case 5: {
                this$0.trace("Remove breakpoint " + $bp + ": no such breakpoint");
                $bp.setId(0);
                $bp.setActive(false);
                $bp.setAppropriate(false);
                $bp.setProblem(null);
                break;
            }
            case 6: {
                this$0.trace("Remove breakpoint " + $bp + ": cannot delete an unused breakpoint");
                $bp.setId(0);
                $bp.setActive(false);
                $bp.setAppropriate(false);
                $bp.setProblem(null);
                break;
            }
            default: {
                $bp.setProblem(r.name());
                this$0.trace("Remove breakpoint " + $bp + ": " + $bp.getProblem());
                $bp.setId(0);
                $bp.setActive(false);
                $bp.setAppropriate(false);
            }
        }
        $command.getHandled().invoke();
        return Unit.INSTANCE;
    }

    private static final Unit deregisterLineBreakpoint$lambda$23(Ref.ByteRef $rc, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        $rc.element = (byte)((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.DeregisterLineBreakpointBlock.INSTANCE.getResult())).intValue();
        return Unit.INSTANCE;
    }

    private static final Unit printListing$lambda$24(OraDebuggingSession this$0, ResultsProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        String listing = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.PrintBacktraceProc.INSTANCE.getListing());
        this$0.trace("Listing:\n" + listing);
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$25(OraDebuggingSession this$0) {
        this$0.detachFromTargetSession();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doRegisterLineBreakpoint$handleLineBreakpointRegistration(OraRealLineBreakpoint bp2, OraDebuggingSession this$0, RegisterBreakpointCommand $command, ApiResult r, int id) {
        OraDebuggingSession.doRegisterLineBreakpoint$handleLineBreakpointRegistration(bp2, this$0, $command, r, id);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession$Companion;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries;", "<init>", "()V", "stopOnReturnWhenStepOut", "", "intellij.database.dialects.oracle.ex"})
    private static final class Companion
    extends OraDebuggingSessionQueries {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ProcessState.values().length];
            try {
                nArray[ProcessState.STATE_STARTING_UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_RELAXING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_COMPLETING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_FINISHING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ApiResult.values().length];
            try {
                nArray[ApiResult.RESULT_OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ApiResult.RESULT_TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ApiResult.RESULT_COMMUNICATION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ApiResult.RESULT_ILLEGAL_LINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ApiResult.RESULT_NO_SUCH_BREAKPOINT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ApiResult.RESULT_IDLE_BREAKPOINT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PauseReason.values().length];
            try {
                nArray[PauseReason.REASON_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_RETURN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_EXIT_KNL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_EXIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_LINE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PauseReason.REASON_BREAKPOINT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[SqlVariableKind.values().length];
            try {
                nArray[SqlVariableKind.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

