/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeGuardEvaluator
extends JSTypeGuardEvaluator {
    public static final TypeScriptTypeGuardEvaluator INSTANCE = new TypeScriptTypeGuardEvaluator();

    @Override
    protected boolean shouldGetTypeFromTypeGuard(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            TypeScriptTypeGuardEvaluator.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @NotNull
    protected JSTypeGuardChecker createGuard(@NotNull PsiElement place, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (place == null) {
            TypeScriptTypeGuardEvaluator.$$$reportNull$$$0(1);
        }
        return TypeScriptTypeGuardEvaluator.createTypeScriptTypeGuard(place, startType, resolveElement);
    }

    @NotNull
    private static JSTypeGuardChecker createTypeScriptTypeGuard(@NotNull PsiElement element2, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        Pair<Boolean, Boolean> states;
        if (element2 == null) {
            TypeScriptTypeGuardEvaluator.$$$reportNull$$$0(2);
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(element2.getContainingFile());
        boolean useAutoVariableType = false;
        boolean useAutoArrayType = false;
        if (resolveResult != null && TypeScriptTypeGuard.checkUseAutoTypeFromConfig(element2, resolveResult, config) && (states = JSTypeGuardUtil.getAutoTypeStates(resolveResult)) != null) {
            useAutoVariableType = (Boolean)states.first;
            useAutoArrayType = (Boolean)states.second;
        }
        boolean strictNullCheck = config != null && config.strictNullChecks();
        return new JSTypeGuardChecker(element2, TypeScriptTypeGuardEvaluator.addUndefinedTypeForOptionalProperties(startType, resolveResult, config), useAutoArrayType, useAutoVariableType, strictNullCheck);
    }

    private static boolean isOptionalProperty(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof JSProperty) {
            return false;
        }
        if (resolveResult instanceof JSInitializerOwner && ((JSInitializerOwner)resolveResult).hasInitializer()) {
            return false;
        }
        return resolveResult instanceof JSOptionalOwner && ((JSOptionalOwner)resolveResult).isOptional();
    }

    @Nullable
    private static JSType addUndefinedTypeForOptionalProperties(@Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config) {
        if (config == null) {
            return startType;
        }
        if (TypeScriptTypeGuardEvaluator.isOptionalProperty(resolveResult) && startType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            return JSTypeGuardUtil.wrapWithUndefined(startType, source);
        }
        return startType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptTypeGuardEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldGetTypeFromTypeGuard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createGuard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeScriptTypeGuard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

