/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiFile file;
        if (holder == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(1);
        }
        if (!((file = holder.getFile()).getFileType() instanceof TypeScriptConfigFileType)) {
            return new JsonElementVisitor();
        }
        return new JsonElementVisitor(){

            public void visitProperty(@NotNull JsonProperty property) {
                JsonValue value;
                String name;
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("checkJs".equals(name = property.getName())) {
                    this.validateCheckJs(property);
                } else if ("extends".equals(name) && (value = property.getValue()) != null) {
                    JSFileReferencesInspection.checkReferences((PsiElement)value, holder, false);
                }
                super.visitProperty(property);
            }

            private void validateCheckJs(@NotNull JsonProperty property) {
                if (property == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (TypeScriptConfigInspection.hasPropertyInParentObject(property, "allowJs")) {
                    return;
                }
                TypeScriptConfig config = TypeScriptConfigInspection.getConfig(holder, file);
                if (config == null) {
                    return;
                }
                if (!config.checkJs() || config.allowJs()) {
                    return;
                }
                this.reportError(property, JavaScriptBundle.message("typescript.config.inspection.checkjs.info", new Object[0]), "allowJs", "true");
            }

            private void reportError(@NotNull JsonProperty jsonProperty, @NotNull @InspectionMessage String text, String property, String value) {
                if (jsonProperty == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                JsonValue element2 = jsonProperty.getNameElement();
                TextRange range = element2.getTextRange();
                holder.registerProblem((PsiElement)element2, range.shiftLeft(range.getStartOffset()), text, new LocalQuickFix[]{new InsertProperty(property, value)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsonProperty";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateCheckJs";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static TypeScriptConfig getConfig(@NotNull ProblemsHolder holder, @NotNull PsiFile file) {
        if (holder == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(3);
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(holder.getProject());
        return service.parseConfigFile(file.getVirtualFile());
    }

    private static boolean hasPropertyInParentObject(@NotNull JsonProperty o, @NotNull String propertyName) {
        PsiElement parent;
        if (o == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(4);
        }
        if (propertyName == null) {
            TypeScriptConfigInspection.$$$reportNull$$$0(5);
        }
        if (!((parent = o.getParent()) instanceof JsonObject)) {
            return true;
        }
        JsonObject compilerOptions = (JsonObject)parent;
        return compilerOptions.findProperty(propertyName) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfig";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPropertyInParentObject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InsertProperty
    implements LocalQuickFix {
        private final String myName;
        private final String myValue;

        InsertProperty(@NotNull String name, @NotNull String value) {
            if (name == null) {
                InsertProperty.$$$reportNull$$$0(0);
            }
            if (value == null) {
                InsertProperty.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myValue = value;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("intention.family.name.add.required.property", new Object[0]);
            if (string == null) {
                InsertProperty.$$$reportNull$$$0(2);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("typescript.config.inspection.fix.pattern", this.myName);
            if (string == null) {
                InsertProperty.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element2;
            if (project == null) {
                InsertProperty.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                InsertProperty.$$$reportNull$$$0(5);
            }
            if ((element2 = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiElement parent = element2.getParent();
            if (!(parent instanceof JsonProperty)) {
                return;
            }
            PsiElement jsonObject = parent.getParent();
            if (!(jsonObject instanceof JsonObject)) {
                return;
            }
            WriteAction.run(() -> {
                JsonProperty property = TypeScriptConfigUtil.createJsonProperty(project, this.myName, this.myValue, true);
                PsiElement comma = property.getNextSibling();
                assert (comma != null);
                PsiElement newElement = jsonObject.addBefore(property.copy(), parent);
                jsonObject.addAfter(comma.copy(), newElement);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$InsertProperty";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptConfigInspection$InsertProperty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

