/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNarrowTypeByInstanceOfOperation
extends JSConditionalTypeOperationBase {
    @NotNull
    private final JSType myInstanceType;

    public JSNarrowTypeByInstanceOfOperation(@NotNull JSTypeOperation prev, @NotNull JSExpression instanceOfRightExpression, boolean assumeTrue) {
        if (prev == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(0);
        }
        if (instanceOfRightExpression == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(1);
        }
        super(prev, assumeTrue);
        JSType type2 = JSNarrowTypeByInstanceOfOperation.getInstanceOfType(instanceOfRightExpression);
        this.myInstanceType = type2 == null ? JSAnyType.get(JSTypeSource.EMPTY) : type2;
    }

    @Nullable
    private static JSType getInstanceOfType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(2);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression operand = (JSReferenceExpression)expression;
        return JSSymbolUtil.createNamespaceFromReferenceExpression(operand, JSContext.INSTANCE, false, false);
    }

    @Override
    @NotNull
    public JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type2) {
        JSType instanceOfType;
        if (context2 == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(4);
        }
        if ((instanceOfType = context2.expandOperationType(this.myInstanceType)) == null) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        JSType targetType = instanceOfType.copyWithStrict(context2.getDefaultTypeSource().isStrict());
        if (JSTypeUtils.isNullOrUndefinedType(type2) && type2.isJavaScript()) {
            JSType jSType = targetType;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (JSTypeGuardUtil.isSourceTypeAnyAndTargetTypeFunctionOrObject(type2, targetType)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (JSTypeUtils.isAnyType(type2)) {
            JSType jSType = this.myAssumeTrue ? targetType : type2;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType narrowedType = context2.getNarrowedType(type2, targetType, this.myAssumeTrue, (el, el2) -> TypeScriptTypeRelations.isTypeDerivedFrom(el, el2, context2.getContextElement()));
        JSType jSType = context2.processNeverType(type2, narrowedType);
        if (jSType == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context2) {
        if (context2 == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(10);
        }
        Set<JSDecoratedType.TypeDecoration> prevDecorators = super.inferTypeDecoratorsImpl(context2);
        if (!this.myAssumeTrue) {
            Set<JSDecoratedType.TypeDecoration> set = prevDecorators;
            if (set == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<JSDecoratedType.TypeDecoration> set = this.mergeSimilarDecorators(JSTypeGuardChecker.NOTNULL_NOTUNDEFINED, prevDecorators);
        if (set == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(13);
        }
        return this.myInstanceType.isEquivalentTo(((JSNarrowTypeByInstanceOfOperation)sameTypeOperation).myInstanceType, null, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfRightExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByInstanceOfOperation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByInstanceOfOperation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }
}

