/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.xml.util.XmlTagUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBasicGutterIconNavigationHandler<T extends JSPsiNamedElementBase>
implements GutterIconNavigationHandler<PsiElement> {
    public void navigate(MouseEvent e, PsiElement place) {
        JSPsiElementBase elt = JSBasicGutterIconNavigationHandler.getElementFromLineMarker(place, true);
        Query<JSPsiElementBase> elementQuery = this.search(elt);
        if (elementQuery == null) {
            return;
        }
        Collection navElements = elementQuery.findAll();
        JSBasicGutterIconNavigationHandler.doNavigate(navElements, this.getTitle(elt, navElements.size()), e);
    }

    @NlsContexts.PopupTitle
    protected abstract String getTitle(T var1, int var2);

    @Nullable
    public abstract Query<T> search(T var1);

    public static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, @NlsContexts.PopupTitle String popupTitle, MouseEvent e) {
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JSBasicGutterIconNavigationHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])items.toArray(new JSPsiNamedElementBase[0]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    @NotNull
    static PsiElement getPlaceForLineMarker(@NotNull PsiElement element2) {
        ES6ComputedName computedName;
        PsiElement nameIdentifier;
        if (element2 == null) {
            JSBasicGutterIconNavigationHandler.$$$reportNull$$$0(0);
        }
        if (element2 instanceof PsiNameIdentifierOwner && (nameIdentifier = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)element2)) != element2) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                JSBasicGutterIconNavigationHandler.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        if (element2 instanceof JSComputedPropertyNameOwner && (computedName = ((JSComputedPropertyNameOwner)element2).getComputedPropertyName()) != null) {
            ES6ComputedName item;
            for (item = computedName; item != null && !(item instanceof LeafPsiElement); item = item.getFirstChild()) {
            }
            if (item != null) {
                ES6ComputedName eS6ComputedName = item;
                if (eS6ComputedName == null) {
                    JSBasicGutterIconNavigationHandler.$$$reportNull$$$0(2);
                }
                return eS6ComputedName;
            }
        }
        PsiElement prev = element2;
        while (element2 != null) {
            prev = element2;
            element2 = element2.getFirstChild();
        }
        PsiElement psiElement = prev;
        if (psiElement == null) {
            JSBasicGutterIconNavigationHandler.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public static JSPsiElementBase getElementFromLineMarker(@NotNull PsiElement place, boolean withAssertion) {
        JSExpression initializer;
        JSPsiElementBase parent;
        PsiElement parent2;
        if (place == null) {
            JSBasicGutterIconNavigationHandler.$$$reportNull$$$0(4);
        }
        if (place.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && (parent2 = place.getParent()) instanceof XmlTag && XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)parent2)) == place && parent2.getParent() instanceof XmlDocument && parent2.getContainingFile() != null && FlexSupportLoader.isFlexMxmFile(parent2.getContainingFile())) {
            return XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)parent2);
        }
        JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(place);
        JSPsiElementBase jSPsiElementBase = parent = namedElement instanceof JSPsiElementBase ? (JSPsiElementBase)((Object)namedElement) : (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)place, JSPsiElementBase.class, (boolean)false);
        if (JSUtils.getMemberContainingClass((PsiElement)parent) == null && parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)((Object)parent)).getInitializer()) instanceof JSNamedExpression) {
            parent = (JSPsiElementBase)((Object)initializer);
        }
        if (withAssertion) {
            assert (parent != null && JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)parent) == place) : "named element wasn't found for " + String.valueOf(parent);
            return parent;
        }
        return parent != null && JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)parent) == place ? parent : null;
    }

    public static List<? extends JSPsiNamedElementBase> sort(Collection<? extends JSPsiNamedElementBase> items, PsiElementListCellRenderer<? super JSPsiNamedElementBase> renderer) {
        ArrayList<? extends JSPsiNamedElementBase> sorted = new ArrayList<JSPsiNamedElementBase>(items);
        sorted.sort(renderer.getComparator());
        return sorted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSBasicGutterIconNavigationHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSBasicGutterIconNavigationHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceForLineMarker";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromLineMarker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

