/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileExportsImplKt;
import com.intellij.lang.javascript.config.JSFileImportsBase;
import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSSimpleFileInclude;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0012\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0005R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/config/JSFileExportsImpl;", "Lcom/intellij/lang/javascript/config/JSFileImportsBase;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/lang/javascript/config/JSConfig;", "startFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSConfig;Lcom/intellij/openapi/vfs/VirtualFile;)V", "include", "Lcom/intellij/lang/javascript/config/JSSimpleFileInclude;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSSimpleFileInclude;Lcom/intellij/openapi/vfs/VirtualFile;)V", "myFile", "myPsiManager", "Lcom/intellij/psi/PsiManager;", "myHasNodeModulesDirInPath", "", "rootFiles", "", "getRootFiles", "()Ljava/util/Set;", "getOutFiles", "", "file", "isAcceptable", "resolved", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSFileExportsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFileExportsImpl.kt\ncom/intellij/lang/javascript/config/JSFileExportsImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n11546#2,9:63\n13472#2:72\n13473#2:76\n11555#2:77\n19#3:73\n1#4:74\n1#4:75\n*S KotlinDebug\n*F\n+ 1 JSFileExportsImpl.kt\ncom/intellij/lang/javascript/config/JSFileExportsImpl\n*L\n51#1:63,9\n51#1:72\n51#1:76\n51#1:77\n52#1:73\n51#1:75\n*E\n"})
public class JSFileExportsImpl
extends JSFileImportsBase {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final PsiManager myPsiManager;
    private final boolean myHasNodeModulesDirInPath;

    public JSFileExportsImpl(@NotNull Project project, @NotNull JSConfig config, @NotNull VirtualFile startFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)startFile, (String)"startFile");
        super(project, config);
        this.myFile = startFile;
        this.myHasNodeModulesDirInPath = NodeModuleUtil.hasNodeModulesDirInPath(startFile, null);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.myPsiManager = psiManager;
    }

    public JSFileExportsImpl(@NotNull Project project, @NotNull JSSimpleFileInclude include, @NotNull VirtualFile startFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        Intrinsics.checkNotNullParameter((Object)startFile, (String)"startFile");
        JSImportResolveContext jSImportResolveContext = include.getResolveContext();
        Intrinsics.checkNotNullExpressionValue((Object)jSImportResolveContext, (String)"getResolveContext(...)");
        JSFileImportsResolver jSFileImportsResolver = include.getImportResolver();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileImportsResolver, (String)"getImportResolver(...)");
        super(project, jSImportResolveContext, jSFileImportsResolver);
        this.myFile = startFile;
        this.myHasNodeModulesDirInPath = NodeModuleUtil.hasNodeModulesDirInPath(startFile, null);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.myPsiManager = psiManager;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Object[] objectArray = new VirtualFile[]{this.myFile};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = this.myPsiManager.findFile(file);
        if (!(psiFile instanceof JSFile)) {
            return CollectionsKt.emptyList();
        }
        PsiElement[] psiElementArray = JSStubBasedPsiTreeUtil.getChildrenByType((PsiElement)psiFile, JSFileExportsImplKt.access$getEXPORTS_TOKEN_SET$p());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildrenByType(...)");
        Object[] $this$mapNotNull$iv = psiElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            PsiElement $this$asSafely$iv = it;
            boolean $i$f$asSafely = false;
            PsiElement psiElement = $this$asSafely$iv;
            if (!(psiElement instanceof ES6ExportDeclaration)) {
                psiElement = null;
            }
            if ((object2 = (ES6ExportDeclaration)psiElement) == null || (object2 = object2.getFromClause()) == null || (object2 = object2.getReferenceText()) == null) {
                object = null;
            } else {
                Object text = object2;
                String string = ES6FileIncludeProvider.preProcessPath((String)text);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"preProcessPath(...)");
                if (this.resolveFile(string, file) != null) {
                    VirtualFile virtualFile;
                    VirtualFile p0 = virtualFile;
                    boolean bl3 = false;
                    object = this.isAcceptable(p0) ? virtualFile : null;
                } else {
                    object = null;
                }
            }
            if (object == null) continue;
            VirtualFile it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Contract(value="null->false")
    protected final boolean isAcceptable(@Nullable VirtualFile resolved) {
        return resolved != null && this.myHasNodeModulesDirInPath == NodeModuleUtil.hasNodeModulesDirInPath(resolved, null);
    }
}

