/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\u0004\u001a\u00020\u0003J\u0013\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0003J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/LongitudeSegment;", "", "start", "", "end", "(DD)V", "isEmpty", "", "()Z", "myEnd", "myStart", "encloses", "longitudeSegment", "equals", "other", "hashCode", "", "invert", "length", "splitByAntiMeridian", "", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Companion", "commons"})
public final class LongitudeSegment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double myStart;
    private final double myEnd;
    private final boolean isEmpty;

    public LongitudeSegment(double start2, double end) {
        this.myStart = GeographicKt.limitLon(start2);
        this.myEnd = GeographicKt.limitLon(end);
        this.isEmpty = this.myEnd == this.myStart;
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final double start() {
        return this.myStart;
    }

    public final double end() {
        return this.myEnd;
    }

    public final double length() {
        return this.myEnd - this.myStart + (this.myEnd < this.myStart ? 360.0 : 0.0);
    }

    @NotNull
    public final LongitudeSegment invert() {
        return new LongitudeSegment(this.myEnd, this.myStart);
    }

    public final boolean encloses(@NotNull LongitudeSegment longitudeSegment) {
        Intrinsics.checkNotNullParameter((Object)longitudeSegment, (String)"longitudeSegment");
        List<DoubleSpan> externalRanges = this.splitByAntiMeridian();
        List<DoubleSpan> internalRanges = longitudeSegment.splitByAntiMeridian();
        for (DoubleSpan internalRange : internalRanges) {
            if (LongitudeSegment.Companion.disjointRangesEncloseRange(externalRanges, internalRange)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<DoubleSpan> splitByAntiMeridian() {
        return Companion.splitSegment(this.myStart, this.myEnd, -180.0, 180.0);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongitudeSegment that = (LongitudeSegment)other;
        return ((Object)that.myStart).equals(this.myStart) && ((Object)that.myEnd).equals(this.myEnd);
    }

    public int hashCode() {
        Object[] objectArray = new Double[]{this.myStart, this.myEnd};
        return ((Object)CollectionsKt.listOf((Object[])objectArray)).hashCode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/LongitudeSegment$Companion;", "", "()V", "disjointRangesEncloseRange", "", "ranges", "", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "internalRange", "splitSegment", "start", "", "end", "min", "max", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DoubleSpan> splitSegment(double start2, double end, double min, double max) {
            List list2;
            if (start2 <= end) {
                list2 = CollectionsKt.listOf((Object)new DoubleSpan(start2, end));
            } else {
                Object[] objectArray = new DoubleSpan[]{new DoubleSpan(start2, max), new DoubleSpan(min, end)};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            }
            return list2;
        }

        private final boolean disjointRangesEncloseRange(List<DoubleSpan> ranges, DoubleSpan internalRange) {
            for (DoubleSpan range : ranges) {
                if (!range.encloses(internalRange)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

