/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigurable;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.webpack.WebpackBundle;
import com.intellij.webpack.WebpackConfigLocator;
import com.intellij.webpack.WebpackConfigManager;
import com.intellij.webpack.WebpackConfiguration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/webpack/WebpackConfigurable;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configManager", "Lcom/intellij/webpack/WebpackConfigManager;", "getConfigManager", "()Lcom/intellij/webpack/WebpackConfigManager;", "getId", "", "getHelpTopic", "getDisplayName", "createConfiguration", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfiguration;", "getConfigPathFieldChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "intellij.webpack"})
public final class WebpackConfigurable
extends WebBundlerConfigurable {
    @NotNull
    private final WebpackConfigManager configManager;

    public WebpackConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configManager = WebpackConfigManager.Companion.getInstance(project);
    }

    @NotNull
    public WebpackConfigManager getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public String getId() {
        return "settings.webpack";
    }

    @NotNull
    public String getHelpTopic() {
        return "procedures.webpack";
    }

    @NotNull
    public String getDisplayName() {
        return WebpackBundle.message("webpack.configuration.title", new Object[0]);
    }

    @NotNull
    public WebBundlerConfiguration createConfiguration() {
        return new WebpackConfiguration(null, null, 3, null);
    }

    @NotNull
    protected FileChooserDescriptor getConfigPathFieldChooserDescriptor() {
        Object[] objectArray = new Object[]{this.getDisplayName()};
        String string = IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])objectArray);
        objectArray = WebpackConfigLocator.Companion.getWEBPACK_CONFIG_FILE_TYPES$intellij_webpack();
        FileChooserDescriptor fileChooserDescriptor = super.getConfigPathFieldChooserDescriptor().withExtensionFilter(string, (FileType[])Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withExtensionFilter(...)");
        return fileChooserDescriptor;
    }
}

