/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.fs;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.core.actions.fs.SaveDiagramAction;

public class DiagramCopyHandler
implements CopyHandlerDelegate {
    public boolean canCopy(PsiElement[] elements) {
        if (elements.length != 1) {
            return false;
        }
        PsiFile file = elements[0].getContainingFile();
        return file != null && file.getVirtualFile() instanceof UmlVirtualFileSystem.UmlVirtualFile;
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        VirtualFile file = elements[0].getContainingFile().getVirtualFile();
        if (!(file instanceof UmlVirtualFileSystem.UmlVirtualFile)) {
            return;
        }
        UmlVirtualFileSystem.UmlVirtualFile diagramFile = (UmlVirtualFileSystem.UmlVirtualFile)file;
        DiagramBuilder builder = diagramFile.getBuilder();
        if (builder == null) {
            return;
        }
        SaveDiagramAction.doSave(diagramFile, builder);
    }

    public void doClone(PsiElement element) {
    }
}

