/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 108501399744035L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1935903900 + -11247, -1935903900 + -12609, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1935903900 + -11248, -1935903900 + -13978, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 99101648706004L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.f();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(426632850 + (char)-13842, 426632850 + (char)-21130, (int)l2) + string + WindowsNamedPipeAgentIpc.b(426632850 + (char)-13841, -426763920 - -((char)-4141), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(426632850 + (char)-13836, -426763920 - -((char)-5470), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 68634128948442L;
                Object object = this.lock;
                String string = SshAgentIpcService.f();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-551542560 + -11095, 551542560 + 30600, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551542560 + -11094, 551542560 + 26927, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-551542560 + -11093, -551542560 + -30369, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-551542560 + -11100, -551542560 + -20389, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551542560 + -11099, -551542560 + -((char)-26686), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551542560 + -11098, -551542560 + -24539, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-551542560 + -11100, -551542560 + -20389, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551542560 + -11097, 551542560 + 30255, (int)l2));
            if (ActionTimestamp.f() != null) {
                SshAgentIpcService.f("VLupy");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 119443038362976L;
                    string = SshAgentIpcService.f();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 16183728244921L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                string = SshAgentIpcService.f();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-291499680 - -20611, -291499680 + -3035, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20610, 291499680 - 14065, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20609, -291499680 - -605, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-291499680 - -20611, -291499680 + -3035, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20608, 291499680 - 24147, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-291499680 - -20611, -291499680 + -3035, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20639, 291499680 - 12586, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20638, 291499680 - 3793, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20609, -291499680 - -605, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-291499680 - -20611, -291499680 + -3035, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-291499680 - -20615, -291499680 - -13304, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-291499680 - -20637, -291499680 - -20367, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 114637201191550L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(229110360 - 14236, -229110360 - -12503, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 24636678387616L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(745919370 + (char)-5159, -745919370 + -((char)-10446), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00beS\u0006\u00a9k\u001b2$e\u000f\u00a4\"\u00f7i\u00d6h\u00dc\u008b\u0005\u0014\u00ea\u008a\u008c\u0094!~\u0006\ra,\u00e1\u0092\u009d\u0086Z\u001e\u00a0\u0083\u008d\u008c";
                        var4_3 = "\u00beS\u0006\u00a9k\u001b2$e\u000f\u00a4\"\u00f7i\u00d6h\u00dc\u008b\u0005\u0014\u00ea\u008a\u008c\u0094!~\u0006\ra,\u00e1\u0092\u009d\u0086Z\u001e\u00a0\u0083\u008d\u008c".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 50;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 16;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 121;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 115;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 24;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 70;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 73;
                                        break;
                                    }
                                    default: {
                                        v11 = 53;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x8C2) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 42;
                            case 1 -> 27;
                            case 2 -> 97;
                            case 3 -> 130;
                            case 4 -> 201;
                            case 5 -> 47;
                            case 6 -> 137;
                            case 7 -> 149;
                            case 8 -> 249;
                            case 9 -> 20;
                            case 10 -> 80;
                            case 11 -> 110;
                            case 12 -> 63;
                            case 13 -> 173;
                            case 14 -> 124;
                            case 15 -> 23;
                            case 16 -> 248;
                            case 17 -> 100;
                            case 18 -> 162;
                            case 19 -> 65;
                            case 20 -> 11;
                            case 21 -> 98;
                            case 22 -> 217;
                            case 23 -> 102;
                            case 24 -> 165;
                            case 25 -> 59;
                            case 26 -> 252;
                            case 27 -> 227;
                            case 28 -> 112;
                            case 29 -> 202;
                            case 30 -> 3;
                            case 31 -> 57;
                            case 32 -> 166;
                            case 33 -> 254;
                            case 34 -> 228;
                            case 35 -> 208;
                            case 36 -> 188;
                            case 37 -> 61;
                            case 38 -> 46;
                            case 39 -> 32;
                            case 40 -> 160;
                            case 41 -> 154;
                            case 42 -> 50;
                            case 43 -> 226;
                            case 44 -> 2;
                            case 45 -> 180;
                            case 46 -> 207;
                            case 47 -> 93;
                            case 48 -> 148;
                            case 49 -> 233;
                            case 50 -> 196;
                            case 51 -> 58;
                            case 52 -> 72;
                            case 53 -> 41;
                            case 54 -> 167;
                            case 55 -> 19;
                            case 56 -> 86;
                            case 57 -> 182;
                            case 58 -> 108;
                            case 59 -> 0;
                            case 60 -> 119;
                            case 61 -> 125;
                            case 62 -> 56;
                            case 63 -> 145;
                            case 64 -> 230;
                            case 65 -> 163;
                            case 66 -> 122;
                            case 67 -> 133;
                            case 68 -> 222;
                            case 69 -> 35;
                            case 70 -> 34;
                            case 71 -> 40;
                            case 72 -> 64;
                            case 73 -> 113;
                            case 74 -> 128;
                            case 75 -> 155;
                            case 76 -> 143;
                            case 77 -> 96;
                            case 78 -> 175;
                            case 79 -> 101;
                            case 80 -> 191;
                            case 81 -> 151;
                            case 82 -> 18;
                            case 83 -> 7;
                            case 84 -> 43;
                            case 85 -> 99;
                            case 86 -> 116;
                            case 87 -> 159;
                            case 88 -> 253;
                            case 89 -> 251;
                            case 90 -> 30;
                            case 91 -> 250;
                            case 92 -> 105;
                            case 93 -> 176;
                            case 94 -> 85;
                            case 95 -> 200;
                            case 96 -> 150;
                            case 97 -> 255;
                            case 98 -> 121;
                            case 99 -> 9;
                            case 100 -> 171;
                            case 101 -> 212;
                            case 102 -> 78;
                            case 103 -> 111;
                            case 104 -> 25;
                            case 105 -> 157;
                            case 106 -> 8;
                            case 107 -> 60;
                            case 108 -> 87;
                            case 109 -> 39;
                            case 110 -> 21;
                            case 111 -> 54;
                            case 112 -> 115;
                            case 113 -> 232;
                            case 114 -> 120;
                            case 115 -> 170;
                            case 116 -> 92;
                            case 117 -> 16;
                            case 118 -> 172;
                            case 119 -> 224;
                            case 120 -> 95;
                            case 121 -> 181;
                            case 122 -> 236;
                            case 123 -> 218;
                            case 124 -> 140;
                            case 125 -> 199;
                            case 126 -> 158;
                            case 127 -> 91;
                            case 128 -> 83;
                            case 129 -> 247;
                            case 130 -> 84;
                            case 131 -> 239;
                            case 132 -> 126;
                            case 133 -> 141;
                            case 134 -> 14;
                            case 135 -> 244;
                            case 136 -> 77;
                            case 137 -> 216;
                            case 138 -> 118;
                            case 139 -> 139;
                            case 140 -> 82;
                            case 141 -> 135;
                            case 142 -> 246;
                            case 143 -> 161;
                            case 144 -> 205;
                            case 145 -> 238;
                            case 146 -> 231;
                            case 147 -> 6;
                            case 148 -> 76;
                            case 149 -> 195;
                            case 150 -> 55;
                            case 151 -> 136;
                            case 152 -> 220;
                            case 153 -> 22;
                            case 154 -> 204;
                            case 155 -> 88;
                            case 156 -> 15;
                            case 157 -> 243;
                            case 158 -> 31;
                            case 159 -> 12;
                            case 160 -> 221;
                            case 161 -> 24;
                            case 162 -> 189;
                            case 163 -> 38;
                            case 164 -> 44;
                            case 165 -> 186;
                            case 166 -> 4;
                            case 167 -> 45;
                            case 168 -> 184;
                            case 169 -> 174;
                            case 170 -> 37;
                            case 171 -> 90;
                            case 172 -> 185;
                            case 173 -> 89;
                            case 174 -> 28;
                            case 175 -> 75;
                            case 176 -> 178;
                            case 177 -> 17;
                            case 178 -> 127;
                            case 179 -> 94;
                            case 180 -> 74;
                            case 181 -> 114;
                            case 182 -> 69;
                            case 183 -> 10;
                            case 184 -> 67;
                            case 185 -> 73;
                            case 186 -> 131;
                            case 187 -> 179;
                            case 188 -> 190;
                            case 189 -> 210;
                            case 190 -> 229;
                            case 191 -> 169;
                            case 192 -> 242;
                            case 193 -> 1;
                            case 194 -> 134;
                            case 195 -> 132;
                            case 196 -> 123;
                            case 197 -> 109;
                            case 198 -> 138;
                            case 199 -> 198;
                            case 200 -> 62;
                            case 201 -> 79;
                            case 202 -> 215;
                            case 203 -> 211;
                            case 204 -> 13;
                            case 205 -> 152;
                            case 206 -> 107;
                            case 207 -> 203;
                            case 208 -> 36;
                            case 209 -> 48;
                            case 210 -> 235;
                            case 211 -> 81;
                            case 212 -> 104;
                            case 213 -> 177;
                            case 214 -> 117;
                            case 215 -> 53;
                            case 216 -> 168;
                            case 217 -> 49;
                            case 218 -> 237;
                            case 219 -> 129;
                            case 220 -> 219;
                            case 221 -> 33;
                            case 222 -> 193;
                            case 223 -> 153;
                            case 224 -> 66;
                            case 225 -> 194;
                            case 226 -> 52;
                            case 227 -> 51;
                            case 228 -> 146;
                            case 229 -> 192;
                            case 230 -> 29;
                            case 231 -> 197;
                            case 232 -> 206;
                            case 233 -> 26;
                            case 234 -> 5;
                            case 235 -> 68;
                            case 236 -> 234;
                            case 237 -> 240;
                            case 238 -> 213;
                            case 239 -> 214;
                            case 240 -> 225;
                            case 241 -> 147;
                            case 242 -> 103;
                            case 243 -> 187;
                            case 244 -> 142;
                            case 245 -> 241;
                            case 246 -> 223;
                            case 247 -> 164;
                            case 248 -> 71;
                            case 249 -> 106;
                            case 250 -> 245;
                            case 251 -> 156;
                            case 252 -> 209;
                            case 253 -> 144;
                            case 254 -> 70;
                            default -> 183;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string == null) {
                ActionTimestamp.f(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 31927200710074L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.f();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29548, 1586209140 - 12526, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29552, 1586209140 - 28953, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29579, 1586209140 - 11458, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29548, 1586209140 - 12526, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29552, 1586209140 - 28953, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1586209140 - (char)-29572, 1586209140 - 32493, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 119265558316854L;
                        String string3 = SshAgentIpcService.f();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1388555580 - 32455, -1388555580 - -19342, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1388555580 - 32454, 1388555580 - 13020, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 85455703673581L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.f();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1260631260 - 20773, 1260631260 - (char)-21237, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1260631260 - 20777, 1260631260 - 28112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1260631260 - 20784, -1260631260 - -((char)-26039), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1260631260 - 20777, 1260631260 - 28112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1260631260 - 20775, 1260631260 - (char)-23821, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1260631260 - 20773, 1260631260 - (char)-21237, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1260631260 - 20777, 1260631260 - 28112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1260631260 - 20793, -1260631260 - -((char)-19679), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1260631260 - 20773, 1260631260 - (char)-21237, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1260631260 - 20777, 1260631260 - 28112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1260631260 - 20794, -1260631260 - -14218, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1260631260 - 20773, 1260631260 - (char)-21237, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1260631260 - 20777, 1260631260 - 28112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1260631260 - 20795, -1260631260 - -((char)-26226), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 50771284321016L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.f();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4284, -475915170 - -21350, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-475915170 + -4280, -475915170 - -4795, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-475915170 + -4265, -475915170 + -3182, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-475915170 + -4268, -475915170 + -2721, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4284, -475915170 - -21350, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-475915170 + -4280, -475915170 - -4795, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-475915170 + -4267, -475915170 - -7873, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4284, -475915170 - -21350, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-475915170 + -4280, -475915170 - -4795, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-475915170 + -4270, -475915170 + -3058, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4284, -475915170 - -21350, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-475915170 + -4280, -475915170 - -4795, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-475915170 + -4269, 475915170 - 12187, (int)l2));
                    if (string == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4284, -475915170 - -21350, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-475915170 + -4280, -475915170 - -4795, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-475915170 + -4304, 475915170 - 2292, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-475915170 + -4303, 475915170 - 11131, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "b\t\u00bf1\u000e\u00b6\u00c7M\u0014\u001c\u00b6H!\u000e<h\u0006:\u00c8y\u00e3\u00dc\u00dd\u00bf\u00b3\u00ff\u0097\u0014J\u0006\u0097\u009f\u0001\u00e3\u00b3\u00ad\u0018)3\u008e\u00a1T\u00e9!|\u00db\u00faJ\u00d5\u00dc\u00e4\u00ed\u0016\u001cJFl]Y\u0086\"\t\u00bb(Bs\u00a6,g\u008c/\u0005\u000b<\u0092\u0097\u00db\b\u00f8'\u00ec\u00856\u0006\u00c6\u00b9\u0014\u00db\u00bd\u00c8\u00dbsk\u00f2{\u0007\u00bau\u0019\u0017!}\u00c1\u00b5\n\u00a4\u00bb\u0005\u00d2\u00d9\u00a9+\u00bc\u001eE\u008eN\u00a5\u00dd\u00ad\u00b2\u008e\f\u00b0\u00fb\u001b\u00a6\u001d\u0000M@\u00b0\u001f\u00c7\u00da\u0003z\u00a4&\u00cbc\u0002\u009cL\u0010PV\b{BD\u00b7J\u00d1\u009a\u00cd\u00a3f_\u00b7\u009a\t\u00f88\u00fc`\"i\u00d1\u00bb\u0017\u0010.Y\u00c7\u009a\u00bbx\u0088\u00cd6j1\u00bd\u00f9\u009cD\u00e2?\u00d6\u00934\u0006\u009f\u00d0\u007fM\u00c4\u0019\u00a7\u00d5\u00922\u00bb\u0091\u00f2N4\u00dd1\u0012|\u00e0\u00f6\u00abt\u00baI\rS\u00c6\u001f\u00bf\u0083)Q3h\u0092\u00ba\u00d1#\u00cc\u00f8\u008b\u0004\u009e\n\u00f6\u00b5\r\u00ed\t8Yc\u0000\u00c1Ma\u00b9\u00c3\b\u0098\u00ff\u00e0\u009e\u00b7e\u00f6\u00d5\fr2\u00ad<\u0003S\u008e\u0014\u00df\u0019^\u00d7F\u00a7]\u0017\u00d1T\u00eed\u00a3\u0082\u00e3\u00ffL\u000f\t\u0017\u00d0\u009b\u0001\u0019\u009b\u0086\u0088\u0089\u0081~\u00ac\u0096Q\u00aaY\u0015p\u00eb\u00df\u00df\u0004\u0000\u00db\u00e9K\u0019\u00ff\u00dc\u00f2\u00d9\u00c9t\u00ab\u00e3\u00a8\u00eeli\u00b3\u00be\u0015,\u00fd\u00beN\u00bd\u00b0\u0004B\u001b\u0011\u00cbtk\u0087\u001f\u0002?\u00a6\u0093\u00c0k\u0011Vx\u00abuxwl1\u00d2\u001d\u00ab\u00c9n\u00cb\u00b6\u008f\u00b9\u00f9\u00b8\u008f\u00a0\u001c\u00e9\u00c1\u000b`\u00d2\u00ef K\u00d0\u0087d\u00fe\u001bp\u00152\u00af\u00a5\u008c\u0005-\u00a2\u00a6d\u00a3\u00eb\u00b2\u001a\u0099\u0081:\u00f0\"\u00a9&\u00f1)'\u0099\u0002GT\u00f1\u0083\u0005*\u00c1?5:\u00cf\u0006\u00a3\u00a4\r%\u001d\u00a6\u00a0\u00e4c\u00fb\u00aa\u0018\u009a\u00c1Z\u00f8.\u00a8\u00b1\u00d1D\u00df\u00ce\u0099@\u00b4\u0007\u00b4\u00a5z\u00da\u007f\u001f}\u0007V\u00f9B=\u009f\fw(\u0002^\u00ea\u009e\u00f9\u00a0\u00c0\b2\u00b7\u0016\u00cd<Q\u0084\u00f3\u00f3\u00aaa\u00aaOh\u00b6\u00b1!L\u00f5=K\u00cer\u00a5\u0002\u00ab\u001a\u00aa\u001cnr\u00a7\u000f\u000bC\u0085\u0014\u00fc\u009d\u00c5l\u00e7\u00b6\r\u00bc\u00ff+b\"\\\u0085m\u00c4\u00b9\u0081>\u000b\u009d\u0000\u00c9\r\u00e7\u00c4\u00d9\f\u00b4\u00d1\u00ad\u00c4]\u009b;T\u0093\u0018\u00d8\u0012\u00fdy\u00ddM\".\u000efe(\u00d0I\u0005s\u007f1\u00d4\u00d7\u00f0\u00a8\u00a8\u001b23\u00a5\u001f\u0003I\u00af\u00aa\u00fd\u00e9\u00c3VzJL\u00cb\u00ae\u0083S\u0012\u00b9u\u00d4/%\u001a[\n\u008f\u00d7\u00d6\u0084y\u00de3r\u00c5\u0090\u0018\u0018\u001a\u00e07\u00aa\u00f0\u00bb\u00c3a\r\u0092U\u00e9y\u00c2\u008c\bjPV\u00a1\u00b6\u008c\u0004)t\nh5\u0019\u00bf*\u00cc\u001f\u00f8\u0099\u0012\u00ea\"\u0083ej\u00a0#m\\\u00be\u00f2\u00acL\u00c1s\u001b\u00ff6\u00842\u0002\u00ecQ{\u0011\r@8\u008f\t\u00afj\u00164u,mH=";
                var4_3 = "b\t\u00bf1\u000e\u00b6\u00c7M\u0014\u001c\u00b6H!\u000e<h\u0006:\u00c8y\u00e3\u00dc\u00dd\u00bf\u00b3\u00ff\u0097\u0014J\u0006\u0097\u009f\u0001\u00e3\u00b3\u00ad\u0018)3\u008e\u00a1T\u00e9!|\u00db\u00faJ\u00d5\u00dc\u00e4\u00ed\u0016\u001cJFl]Y\u0086\"\t\u00bb(Bs\u00a6,g\u008c/\u0005\u000b<\u0092\u0097\u00db\b\u00f8'\u00ec\u00856\u0006\u00c6\u00b9\u0014\u00db\u00bd\u00c8\u00dbsk\u00f2{\u0007\u00bau\u0019\u0017!}\u00c1\u00b5\n\u00a4\u00bb\u0005\u00d2\u00d9\u00a9+\u00bc\u001eE\u008eN\u00a5\u00dd\u00ad\u00b2\u008e\f\u00b0\u00fb\u001b\u00a6\u001d\u0000M@\u00b0\u001f\u00c7\u00da\u0003z\u00a4&\u00cbc\u0002\u009cL\u0010PV\b{BD\u00b7J\u00d1\u009a\u00cd\u00a3f_\u00b7\u009a\t\u00f88\u00fc`\"i\u00d1\u00bb\u0017\u0010.Y\u00c7\u009a\u00bbx\u0088\u00cd6j1\u00bd\u00f9\u009cD\u00e2?\u00d6\u00934\u0006\u009f\u00d0\u007fM\u00c4\u0019\u00a7\u00d5\u00922\u00bb\u0091\u00f2N4\u00dd1\u0012|\u00e0\u00f6\u00abt\u00baI\rS\u00c6\u001f\u00bf\u0083)Q3h\u0092\u00ba\u00d1#\u00cc\u00f8\u008b\u0004\u009e\n\u00f6\u00b5\r\u00ed\t8Yc\u0000\u00c1Ma\u00b9\u00c3\b\u0098\u00ff\u00e0\u009e\u00b7e\u00f6\u00d5\fr2\u00ad<\u0003S\u008e\u0014\u00df\u0019^\u00d7F\u00a7]\u0017\u00d1T\u00eed\u00a3\u0082\u00e3\u00ffL\u000f\t\u0017\u00d0\u009b\u0001\u0019\u009b\u0086\u0088\u0089\u0081~\u00ac\u0096Q\u00aaY\u0015p\u00eb\u00df\u00df\u0004\u0000\u00db\u00e9K\u0019\u00ff\u00dc\u00f2\u00d9\u00c9t\u00ab\u00e3\u00a8\u00eeli\u00b3\u00be\u0015,\u00fd\u00beN\u00bd\u00b0\u0004B\u001b\u0011\u00cbtk\u0087\u001f\u0002?\u00a6\u0093\u00c0k\u0011Vx\u00abuxwl1\u00d2\u001d\u00ab\u00c9n\u00cb\u00b6\u008f\u00b9\u00f9\u00b8\u008f\u00a0\u001c\u00e9\u00c1\u000b`\u00d2\u00ef K\u00d0\u0087d\u00fe\u001bp\u00152\u00af\u00a5\u008c\u0005-\u00a2\u00a6d\u00a3\u00eb\u00b2\u001a\u0099\u0081:\u00f0\"\u00a9&\u00f1)'\u0099\u0002GT\u00f1\u0083\u0005*\u00c1?5:\u00cf\u0006\u00a3\u00a4\r%\u001d\u00a6\u00a0\u00e4c\u00fb\u00aa\u0018\u009a\u00c1Z\u00f8.\u00a8\u00b1\u00d1D\u00df\u00ce\u0099@\u00b4\u0007\u00b4\u00a5z\u00da\u007f\u001f}\u0007V\u00f9B=\u009f\fw(\u0002^\u00ea\u009e\u00f9\u00a0\u00c0\b2\u00b7\u0016\u00cd<Q\u0084\u00f3\u00f3\u00aaa\u00aaOh\u00b6\u00b1!L\u00f5=K\u00cer\u00a5\u0002\u00ab\u001a\u00aa\u001cnr\u00a7\u000f\u000bC\u0085\u0014\u00fc\u009d\u00c5l\u00e7\u00b6\r\u00bc\u00ff+b\"\\\u0085m\u00c4\u00b9\u0081>\u000b\u009d\u0000\u00c9\r\u00e7\u00c4\u00d9\f\u00b4\u00d1\u00ad\u00c4]\u009b;T\u0093\u0018\u00d8\u0012\u00fdy\u00ddM\".\u000efe(\u00d0I\u0005s\u007f1\u00d4\u00d7\u00f0\u00a8\u00a8\u001b23\u00a5\u001f\u0003I\u00af\u00aa\u00fd\u00e9\u00c3VzJL\u00cb\u00ae\u0083S\u0012\u00b9u\u00d4/%\u001a[\n\u008f\u00d7\u00d6\u0084y\u00de3r\u00c5\u0090\u0018\u0018\u001a\u00e07\u00aa\u00f0\u00bb\u00c3a\r\u0092U\u00e9y\u00c2\u008c\bjPV\u00a1\u00b6\u008c\u0004)t\nh5\u0019\u00bf*\u00cc\u001f\u00f8\u0099\u0012\u00ea\"\u0083ej\u00a0#m\\\u00be\u00f2\u00acL\u00c1s\u001b\u00ff6\u00842\u0002\u00ecQ{\u0011\r@8\u008f\t\u00afj\u00164u,mH=".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 64;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u001f\u00fd\u0095[6\u00e2_\u00f7!\u000f\u00ce|\u0090\u007f\\^\u0001[\u008e\u0006,|\u009f\u00ba\u00da\u008f\u00a0\u0007\u0085\u0014\u00a4\"\u00cf#n\u00ec\u00f4\u008c9\t\u0089KRX\u00fe\u0093G\u0003\u0093H";
                    var4_3 = "\u001f\u00fd\u0095[6\u00e2_\u00f7!\u000f\u00ce|\u0090\u007f\\^\u0001[\u008e\u0006,|\u009f\u00ba\u00da\u008f\u00a0\u0007\u0085\u0014\u00a4\"\u00cf#n\u00ec\u00f4\u008c9\t\u0089KRX\u00fe\u0093G\u0003\u0093H".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 63;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 20;
                            break;
                        }
                        case 1: {
                            v15 = 18;
                            break;
                        }
                        case 2: {
                            v15 = 55;
                            break;
                        }
                        case 3: {
                            v15 = 59;
                            break;
                        }
                        case 4: {
                            v15 = 121;
                            break;
                        }
                        case 5: {
                            v15 = 23;
                            break;
                        }
                        default: {
                            v15 = 79;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFE956) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 161;
                case 1 -> 132;
                case 2 -> 229;
                case 3 -> 174;
                case 4 -> 124;
                case 5 -> 194;
                case 6 -> 15;
                case 7 -> 90;
                case 8 -> 17;
                case 9 -> 37;
                case 10 -> 199;
                case 11 -> 51;
                case 12 -> 154;
                case 13 -> 102;
                case 14 -> 88;
                case 15 -> 137;
                case 16 -> 184;
                case 17 -> 153;
                case 18 -> 59;
                case 19 -> 252;
                case 20 -> 24;
                case 21 -> 250;
                case 22 -> 36;
                case 23 -> 43;
                case 24 -> 116;
                case 25 -> 114;
                case 26 -> 240;
                case 27 -> 223;
                case 28 -> 196;
                case 29 -> 101;
                case 30 -> 11;
                case 31 -> 219;
                case 32 -> 122;
                case 33 -> 152;
                case 34 -> 236;
                case 35 -> 16;
                case 36 -> 144;
                case 37 -> 18;
                case 38 -> 216;
                case 39 -> 46;
                case 40 -> 149;
                case 41 -> 8;
                case 42 -> 251;
                case 43 -> 181;
                case 44 -> 126;
                case 45 -> 75;
                case 46 -> 249;
                case 47 -> 146;
                case 48 -> 71;
                case 49 -> 92;
                case 50 -> 87;
                case 51 -> 164;
                case 52 -> 72;
                case 53 -> 203;
                case 54 -> 186;
                case 55 -> 61;
                case 56 -> 54;
                case 57 -> 143;
                case 58 -> 197;
                case 59 -> 163;
                case 60 -> 60;
                case 61 -> 180;
                case 62 -> 38;
                case 63 -> 70;
                case 64 -> 173;
                case 65 -> 136;
                case 66 -> 33;
                case 67 -> 30;
                case 68 -> 12;
                case 69 -> 178;
                case 70 -> 157;
                case 71 -> 224;
                case 72 -> 232;
                case 73 -> 28;
                case 74 -> 20;
                case 75 -> 159;
                case 76 -> 113;
                case 77 -> 50;
                case 78 -> 192;
                case 79 -> 56;
                case 80 -> 66;
                case 81 -> 45;
                case 82 -> 253;
                case 83 -> 79;
                case 84 -> 77;
                case 85 -> 1;
                case 86 -> 10;
                case 87 -> 242;
                case 88 -> 108;
                case 89 -> 29;
                case 90 -> 150;
                case 91 -> 190;
                case 92 -> 123;
                case 93 -> 76;
                case 94 -> 118;
                case 95 -> 67;
                case 96 -> 246;
                case 97 -> 233;
                case 98 -> 133;
                case 99 -> 34;
                case 100 -> 98;
                case 101 -> 129;
                case 102 -> 172;
                case 103 -> 170;
                case 104 -> 228;
                case 105 -> 202;
                case 106 -> 32;
                case 107 -> 171;
                case 108 -> 2;
                case 109 -> 222;
                case 110 -> 227;
                case 111 -> 21;
                case 112 -> 86;
                case 113 -> 84;
                case 114 -> 48;
                case 115 -> 244;
                case 116 -> 119;
                case 117 -> 139;
                case 118 -> 40;
                case 119 -> 168;
                case 120 -> 215;
                case 121 -> 183;
                case 122 -> 31;
                case 123 -> 247;
                case 124 -> 177;
                case 125 -> 58;
                case 126 -> 73;
                case 127 -> 187;
                case 128 -> 83;
                case 129 -> 169;
                case 130 -> 94;
                case 131 -> 221;
                case 132 -> 135;
                case 133 -> 254;
                case 134 -> 235;
                case 135 -> 127;
                case 136 -> 117;
                case 137 -> 35;
                case 138 -> 176;
                case 139 -> 111;
                case 140 -> 9;
                case 141 -> 134;
                case 142 -> 141;
                case 143 -> 25;
                case 144 -> 234;
                case 145 -> 5;
                case 146 -> 156;
                case 147 -> 130;
                case 148 -> 100;
                case 149 -> 91;
                case 150 -> 165;
                case 151 -> 230;
                case 152 -> 237;
                case 153 -> 55;
                case 154 -> 204;
                case 155 -> 145;
                case 156 -> 195;
                case 157 -> 193;
                case 158 -> 140;
                case 159 -> 214;
                case 160 -> 53;
                case 161 -> 93;
                case 162 -> 106;
                case 163 -> 23;
                case 164 -> 128;
                case 165 -> 213;
                case 166 -> 95;
                case 167 -> 96;
                case 168 -> 217;
                case 169 -> 82;
                case 170 -> 109;
                case 171 -> 198;
                case 172 -> 255;
                case 173 -> 166;
                case 174 -> 167;
                case 175 -> 205;
                case 176 -> 191;
                case 177 -> 4;
                case 178 -> 85;
                case 179 -> 201;
                case 180 -> 65;
                case 181 -> 0;
                case 182 -> 42;
                case 183 -> 147;
                case 184 -> 57;
                case 185 -> 211;
                case 186 -> 185;
                case 187 -> 206;
                case 188 -> 64;
                case 189 -> 22;
                case 190 -> 89;
                case 191 -> 74;
                case 192 -> 52;
                case 193 -> 220;
                case 194 -> 80;
                case 195 -> 41;
                case 196 -> 69;
                case 197 -> 245;
                case 198 -> 120;
                case 199 -> 19;
                case 200 -> 112;
                case 201 -> 131;
                case 202 -> 182;
                case 203 -> 63;
                case 204 -> 14;
                case 205 -> 179;
                case 206 -> 160;
                case 207 -> 218;
                case 208 -> 151;
                case 209 -> 103;
                case 210 -> 162;
                case 211 -> 208;
                case 212 -> 210;
                case 213 -> 99;
                case 214 -> 231;
                case 215 -> 125;
                case 216 -> 188;
                case 217 -> 248;
                case 218 -> 44;
                case 219 -> 78;
                case 220 -> 47;
                case 221 -> 115;
                case 222 -> 239;
                case 223 -> 142;
                case 224 -> 212;
                case 225 -> 226;
                case 226 -> 97;
                case 227 -> 121;
                case 228 -> 26;
                case 229 -> 155;
                case 230 -> 200;
                case 231 -> 241;
                case 232 -> 189;
                case 233 -> 68;
                case 234 -> 207;
                case 235 -> 107;
                case 236 -> 138;
                case 237 -> 175;
                case 238 -> 39;
                case 239 -> 3;
                case 240 -> 110;
                case 241 -> 148;
                case 242 -> 81;
                case 243 -> 6;
                case 244 -> 49;
                case 245 -> 158;
                case 246 -> 105;
                case 247 -> 243;
                case 248 -> 225;
                case 249 -> 209;
                case 250 -> 104;
                case 251 -> 62;
                case 252 -> 13;
                case 253 -> 7;
                case 254 -> 27;
                default -> 238;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 75987742801806L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1181464980 - -((char)-9277), -1181464980 - -((char)-17042), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 3347654105371L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.f();
                            try {
                                hANDLE2 = hANDLE;
                                if (string == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1874563140 + -11009, -1874563140 + -26935, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1874563140 + -11012, -1874563140 - -3113, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1874563140 + -11011, -1874563140 + -25483, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "s\u008a\u001e\t\u0088i>\u0082\u0010\u00f5n?4\u0016u\u0014X\b[\u00be)\u00d0'U8";
                    var4_3 = "s\u008a\u001e\t\u0088i>\u0082\u0010\u00f5n?4\u0016u\u0014X\b[\u00be)\u00d0'U8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008c\u00a9x\u00f4\u00ad5\u00f3\u001a\u0080\u00ee`\u008e[\u0015\u000f\u00d0U\u0001\u00c3Q\u00ab\u00e5\u00f4\u00d8H\u00df\u0012z\u0080\u00a3\u00d9G\u00cf\u00bd\u0003\u00e9\u00d1\u00cc\u0098\u0003\u00c7R(l\u00d29\u001c;\u00cdMj\u0081\u008f\f\u007f\u00ff<\u0013H";
                        var4_3 = "\u008c\u00a9x\u00f4\u00ad5\u00f3\u001a\u0080\u00ee`\u008e[\u0015\u000f\u00d0U\u0001\u00c3Q\u00ab\u00e5\u00f4\u00d8H\u00df\u0012z\u0080\u00a3\u00d9G\u00cf\u00bd\u0003\u00e9\u00d1\u00cc\u0098\u0003\u00c7R(l\u00d29\u001c;\u00cdMj\u0081\u008f\f\u007f\u00ff<\u0013H".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 111;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 114;
                                break;
                            }
                            case 1: {
                                v15 = 42;
                                break;
                            }
                            case 2: {
                                v15 = 43;
                                break;
                            }
                            case 3: {
                                v15 = 39;
                                break;
                            }
                            case 4: {
                                v15 = 27;
                                break;
                            }
                            case 5: {
                                v15 = 31;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9DA1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 153;
                    case 1 -> 181;
                    case 2 -> 66;
                    case 3 -> 68;
                    case 4 -> 155;
                    case 5 -> 241;
                    case 6 -> 118;
                    case 7 -> 47;
                    case 8 -> 32;
                    case 9 -> 149;
                    case 10 -> 201;
                    case 11 -> 98;
                    case 12 -> 44;
                    case 13 -> 91;
                    case 14 -> 37;
                    case 15 -> 196;
                    case 16 -> 41;
                    case 17 -> 209;
                    case 18 -> 124;
                    case 19 -> 144;
                    case 20 -> 183;
                    case 21 -> 143;
                    case 22 -> 22;
                    case 23 -> 159;
                    case 24 -> 182;
                    case 25 -> 235;
                    case 26 -> 185;
                    case 27 -> 247;
                    case 28 -> 138;
                    case 29 -> 162;
                    case 30 -> 205;
                    case 31 -> 179;
                    case 32 -> 54;
                    case 33 -> 2;
                    case 34 -> 0;
                    case 35 -> 10;
                    case 36 -> 248;
                    case 37 -> 40;
                    case 38 -> 88;
                    case 39 -> 168;
                    case 40 -> 87;
                    case 41 -> 141;
                    case 42 -> 145;
                    case 43 -> 77;
                    case 44 -> 157;
                    case 45 -> 99;
                    case 46 -> 233;
                    case 47 -> 84;
                    case 48 -> 140;
                    case 49 -> 239;
                    case 50 -> 79;
                    case 51 -> 101;
                    case 52 -> 90;
                    case 53 -> 251;
                    case 54 -> 147;
                    case 55 -> 11;
                    case 56 -> 163;
                    case 57 -> 136;
                    case 58 -> 1;
                    case 59 -> 20;
                    case 60 -> 35;
                    case 61 -> 110;
                    case 62 -> 95;
                    case 63 -> 117;
                    case 64 -> 16;
                    case 65 -> 237;
                    case 66 -> 207;
                    case 67 -> 76;
                    case 68 -> 100;
                    case 69 -> 50;
                    case 70 -> 254;
                    case 71 -> 27;
                    case 72 -> 42;
                    case 73 -> 70;
                    case 74 -> 3;
                    case 75 -> 102;
                    case 76 -> 69;
                    case 77 -> 255;
                    case 78 -> 158;
                    case 79 -> 240;
                    case 80 -> 244;
                    case 81 -> 93;
                    case 82 -> 236;
                    case 83 -> 74;
                    case 84 -> 108;
                    case 85 -> 232;
                    case 86 -> 176;
                    case 87 -> 36;
                    case 88 -> 34;
                    case 89 -> 152;
                    case 90 -> 186;
                    case 91 -> 92;
                    case 92 -> 59;
                    case 93 -> 119;
                    case 94 -> 192;
                    case 95 -> 24;
                    case 96 -> 229;
                    case 97 -> 246;
                    case 98 -> 97;
                    case 99 -> 56;
                    case 100 -> 115;
                    case 101 -> 82;
                    case 102 -> 191;
                    case 103 -> 38;
                    case 104 -> 135;
                    case 105 -> 15;
                    case 106 -> 132;
                    case 107 -> 204;
                    case 108 -> 4;
                    case 109 -> 211;
                    case 110 -> 67;
                    case 111 -> 104;
                    case 112 -> 46;
                    case 113 -> 123;
                    case 114 -> 203;
                    case 115 -> 220;
                    case 116 -> 216;
                    case 117 -> 198;
                    case 118 -> 184;
                    case 119 -> 73;
                    case 120 -> 64;
                    case 121 -> 189;
                    case 122 -> 148;
                    case 123 -> 96;
                    case 124 -> 112;
                    case 125 -> 226;
                    case 126 -> 7;
                    case 127 -> 156;
                    case 128 -> 71;
                    case 129 -> 75;
                    case 130 -> 52;
                    case 131 -> 109;
                    case 132 -> 224;
                    case 133 -> 114;
                    case 134 -> 131;
                    case 135 -> 83;
                    case 136 -> 169;
                    case 137 -> 49;
                    case 138 -> 28;
                    case 139 -> 106;
                    case 140 -> 126;
                    case 141 -> 31;
                    case 142 -> 48;
                    case 143 -> 61;
                    case 144 -> 105;
                    case 145 -> 29;
                    case 146 -> 43;
                    case 147 -> 194;
                    case 148 -> 223;
                    case 149 -> 94;
                    case 150 -> 30;
                    case 151 -> 200;
                    case 152 -> 58;
                    case 153 -> 107;
                    case 154 -> 17;
                    case 155 -> 218;
                    case 156 -> 81;
                    case 157 -> 137;
                    case 158 -> 142;
                    case 159 -> 166;
                    case 160 -> 53;
                    case 161 -> 195;
                    case 162 -> 151;
                    case 163 -> 173;
                    case 164 -> 39;
                    case 165 -> 134;
                    case 166 -> 65;
                    case 167 -> 242;
                    case 168 -> 13;
                    case 169 -> 113;
                    case 170 -> 231;
                    case 171 -> 199;
                    case 172 -> 208;
                    case 173 -> 250;
                    case 174 -> 116;
                    case 175 -> 175;
                    case 176 -> 167;
                    case 177 -> 243;
                    case 178 -> 234;
                    case 179 -> 121;
                    case 180 -> 221;
                    case 181 -> 187;
                    case 182 -> 120;
                    case 183 -> 78;
                    case 184 -> 19;
                    case 185 -> 51;
                    case 186 -> 178;
                    case 187 -> 230;
                    case 188 -> 128;
                    case 189 -> 103;
                    case 190 -> 206;
                    case 191 -> 213;
                    case 192 -> 214;
                    case 193 -> 249;
                    case 194 -> 252;
                    case 195 -> 89;
                    case 196 -> 225;
                    case 197 -> 222;
                    case 198 -> 125;
                    case 199 -> 139;
                    case 200 -> 197;
                    case 201 -> 210;
                    case 202 -> 190;
                    case 203 -> 150;
                    case 204 -> 55;
                    case 205 -> 212;
                    case 206 -> 45;
                    case 207 -> 170;
                    case 208 -> 33;
                    case 209 -> 165;
                    case 210 -> 215;
                    case 211 -> 80;
                    case 212 -> 122;
                    case 213 -> 72;
                    case 214 -> 180;
                    case 215 -> 238;
                    case 216 -> 193;
                    case 217 -> 23;
                    case 218 -> 129;
                    case 219 -> 227;
                    case 220 -> 60;
                    case 221 -> 9;
                    case 222 -> 62;
                    case 223 -> 21;
                    case 224 -> 146;
                    case 225 -> 18;
                    case 226 -> 202;
                    case 227 -> 217;
                    case 228 -> 12;
                    case 229 -> 172;
                    case 230 -> 161;
                    case 231 -> 6;
                    case 232 -> 130;
                    case 233 -> 174;
                    case 234 -> 164;
                    case 235 -> 253;
                    case 236 -> 8;
                    case 237 -> 57;
                    case 238 -> 86;
                    case 239 -> 25;
                    case 240 -> 85;
                    case 241 -> 127;
                    case 242 -> 219;
                    case 243 -> 111;
                    case 244 -> 160;
                    case 245 -> 171;
                    case 246 -> 14;
                    case 247 -> 154;
                    case 248 -> 245;
                    case 249 -> 228;
                    case 250 -> 188;
                    case 251 -> 63;
                    case 252 -> 26;
                    case 253 -> 5;
                    case 254 -> 133;
                    default -> 177;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 134565566197550L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "!^u\fm\u000f\u0019x\t&Tf\u0006 M\u0004d\u0012";
                    var5_4 = "!^u\fm\u000f\u0019x\t&Tf\u0006 M\u0004d\u0012".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 122;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 48;
                                    break;
                                }
                                case 1: {
                                    v11 = 65;
                                    break;
                                }
                                case 2: {
                                    v11 = 125;
                                    break;
                                }
                                case 3: {
                                    v11 = 24;
                                    break;
                                }
                                case 4: {
                                    v11 = 114;
                                    break;
                                }
                                case 5: {
                                    v11 = 25;
                                    break;
                                }
                                default: {
                                    v11 = 80;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 125320667891105L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "|G%.5\u0013\u0007\u0004zY)4\nvF\"49\u0011\u001f\\G+\tvF\"49\u0011\u001fPM\rq@?93\u001c\u0005PJ832\u0015";
                    var5_4 = "|G%.5\u0013\u0007\u0004zY)4\nvF\"49\u0011\u001f\\G+\tvF\"49\u0011\u001fPM\rq@?93\u001c\u0005PJ832\u0015".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 24;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u00003U_Cjz\u0006\u00003U_O`";
                        var5_4 = "\u00003U_Cjz\u0006\u00003U_O`".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 110;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 45;
                                break;
                            }
                            case 1: {
                                v15 = 49;
                                break;
                            }
                            case 2: {
                                v15 = 84;
                                break;
                            }
                            case 3: {
                                v15 = 66;
                                break;
                            }
                            case 4: {
                                v15 = 68;
                                break;
                            }
                            case 5: {
                                v15 = 106;
                                break;
                            }
                            default: {
                                v15 = 115;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 25783341030491L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(652335390 + 24717, 652335390 + 25523, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 77034326740025L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00e3\u00fa\u0005\u0018\u00e4\u0003d9A\u0005\u00f1\u00bba\u00f4\u008b\r\u00e1yU\u00e6\u00f8O\u0007\u00ff\u00f5\u00049\u00133\u0010\u00cc\u00027b\u008bJBb\u00943\u00f6\u00b8,\u00f0\u0017\u0094\u0005Y\u009at\u00d0)3E\u00b8\u00e6\u00e3d>\u008f\u00f8P\u009d\u00e5D\u0088>\u00afR\u00f2w\u00faF\u009f\u000b\u0098\u00b3S\u00df\u001b\u0084c\u00b5TX\u00ec[\u00d5v_\u001c\u00ce8n=\u00d6p\u00ce\u0016p\u00b8u\u001dB";
                    var4_3 = "\u00e3\u00fa\u0005\u0018\u00e4\u0003d9A\u0005\u00f1\u00bba\u00f4\u008b\r\u00e1yU\u00e6\u00f8O\u0007\u00ff\u00f5\u00049\u00133\u0010\u00cc\u00027b\u008bJBb\u00943\u00f6\u00b8,\u00f0\u0017\u0094\u0005Y\u009at\u00d0)3E\u00b8\u00e6\u00e3d>\u008f\u00f8P\u009d\u00e5D\u0088>\u00afR\u00f2w\u00faF\u009f\u000b\u0098\u00b3S\u00df\u001b\u0084c\u00b5TX\u00ec[\u00d5v_\u001c\u00ce8n=\u00d6p\u00ce\u0016p\u00b8u\u001dB".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 89;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "PeXr\u009a\u00b4\u009cA\u00b3\u00ab\u00eeW\u00d3\u00f1\u0014HL\u00d7\u00f3_jP\u007f\u00abV\u00dc\u00da\u00af\u00c0\u00f5\u008dC\u00be\u0096\u00c7uZ\u00fa\u0010\u00e2\u008e\u00c3o\u00d0\u00a8\u001c\u0085\u00a8\u00cd\u009f\u00fb6\u0082\u00ed\u00a0^5\u00b6\u009d\u00fe\u00e5\"\u0086\u00dan.\u000f=\u00d3\u00bc\u00d9<\u0081\u00f2\u00c8l\u00022\u00f91\u000b\u00cfh\u00c4\u00e8\u00f2s\u00f5\u00b1\u00af\u0019_\u0016";
                        var4_3 = "PeXr\u009a\u00b4\u009cA\u00b3\u00ab\u00eeW\u00d3\u00f1\u0014HL\u00d7\u00f3_jP\u007f\u00abV\u00dc\u00da\u00af\u00c0\u00f5\u008dC\u00be\u0096\u00c7uZ\u00fa\u0010\u00e2\u008e\u00c3o\u00d0\u00a8\u001c\u0085\u00a8\u00cd\u009f\u00fb6\u0082\u00ed\u00a0^5\u00b6\u009d\u00fe\u00e5\"\u0086\u00dan.\u000f=\u00d3\u00bc\u00d9<\u0081\u00f2\u00c8l\u00022\u00f91\u000b\u00cfh\u00c4\u00e8\u00f2s\u00f5\u00b1\u00af\u0019_\u0016".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 70;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 32;
                                break;
                            }
                            case 1: {
                                v15 = 85;
                                break;
                            }
                            case 2: {
                                v15 = 39;
                                break;
                            }
                            case 3: {
                                v15 = 122;
                                break;
                            }
                            case 4: {
                                v15 = 111;
                                break;
                            }
                            case 5: {
                                v15 = 40;
                                break;
                            }
                            default: {
                                v15 = 123;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x25F0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 123;
                    case 1 -> 208;
                    case 2 -> 97;
                    case 3 -> 43;
                    case 4 -> 206;
                    case 5 -> 48;
                    case 6 -> 189;
                    case 7 -> 42;
                    case 8 -> 151;
                    case 9 -> 74;
                    case 10 -> 158;
                    case 11 -> 207;
                    case 12 -> 2;
                    case 13 -> 52;
                    case 14 -> 106;
                    case 15 -> 254;
                    case 16 -> 210;
                    case 17 -> 91;
                    case 18 -> 144;
                    case 19 -> 137;
                    case 20 -> 129;
                    case 21 -> 138;
                    case 22 -> 184;
                    case 23 -> 86;
                    case 24 -> 201;
                    case 25 -> 94;
                    case 26 -> 134;
                    case 27 -> 77;
                    case 28 -> 148;
                    case 29 -> 4;
                    case 30 -> 167;
                    case 31 -> 247;
                    case 32 -> 240;
                    case 33 -> 211;
                    case 34 -> 103;
                    case 35 -> 46;
                    case 36 -> 157;
                    case 37 -> 231;
                    case 38 -> 212;
                    case 39 -> 232;
                    case 40 -> 156;
                    case 41 -> 26;
                    case 42 -> 160;
                    case 43 -> 0;
                    case 44 -> 105;
                    case 45 -> 255;
                    case 46 -> 99;
                    case 47 -> 49;
                    case 48 -> 227;
                    case 49 -> 251;
                    case 50 -> 8;
                    case 51 -> 31;
                    case 52 -> 41;
                    case 53 -> 15;
                    case 54 -> 72;
                    case 55 -> 217;
                    case 56 -> 179;
                    case 57 -> 7;
                    case 58 -> 248;
                    case 59 -> 124;
                    case 60 -> 64;
                    case 61 -> 22;
                    case 62 -> 250;
                    case 63 -> 66;
                    case 64 -> 76;
                    case 65 -> 45;
                    case 66 -> 169;
                    case 67 -> 75;
                    case 68 -> 27;
                    case 69 -> 73;
                    case 70 -> 60;
                    case 71 -> 30;
                    case 72 -> 90;
                    case 73 -> 44;
                    case 74 -> 168;
                    case 75 -> 223;
                    case 76 -> 35;
                    case 77 -> 11;
                    case 78 -> 141;
                    case 79 -> 190;
                    case 80 -> 55;
                    case 81 -> 102;
                    case 82 -> 34;
                    case 83 -> 209;
                    case 84 -> 84;
                    case 85 -> 50;
                    case 86 -> 10;
                    case 87 -> 225;
                    case 88 -> 130;
                    case 89 -> 252;
                    case 90 -> 173;
                    case 91 -> 140;
                    case 92 -> 68;
                    case 93 -> 54;
                    case 94 -> 107;
                    case 95 -> 16;
                    case 96 -> 98;
                    case 97 -> 241;
                    case 98 -> 172;
                    case 99 -> 89;
                    case 100 -> 233;
                    case 101 -> 118;
                    case 102 -> 82;
                    case 103 -> 238;
                    case 104 -> 25;
                    case 105 -> 131;
                    case 106 -> 230;
                    case 107 -> 117;
                    case 108 -> 213;
                    case 109 -> 249;
                    case 110 -> 109;
                    case 111 -> 226;
                    case 112 -> 198;
                    case 113 -> 59;
                    case 114 -> 159;
                    case 115 -> 95;
                    case 116 -> 121;
                    case 117 -> 220;
                    case 118 -> 136;
                    case 119 -> 93;
                    case 120 -> 216;
                    case 121 -> 146;
                    case 122 -> 163;
                    case 123 -> 215;
                    case 124 -> 224;
                    case 125 -> 70;
                    case 126 -> 176;
                    case 127 -> 37;
                    case 128 -> 119;
                    case 129 -> 92;
                    case 130 -> 155;
                    case 131 -> 182;
                    case 132 -> 145;
                    case 133 -> 191;
                    case 134 -> 186;
                    case 135 -> 164;
                    case 136 -> 205;
                    case 137 -> 236;
                    case 138 -> 193;
                    case 139 -> 85;
                    case 140 -> 244;
                    case 141 -> 221;
                    case 142 -> 1;
                    case 143 -> 202;
                    case 144 -> 40;
                    case 145 -> 96;
                    case 146 -> 100;
                    case 147 -> 111;
                    case 148 -> 114;
                    case 149 -> 171;
                    case 150 -> 110;
                    case 151 -> 242;
                    case 152 -> 150;
                    case 153 -> 23;
                    case 154 -> 143;
                    case 155 -> 180;
                    case 156 -> 222;
                    case 157 -> 239;
                    case 158 -> 51;
                    case 159 -> 175;
                    case 160 -> 67;
                    case 161 -> 57;
                    case 162 -> 183;
                    case 163 -> 229;
                    case 164 -> 61;
                    case 165 -> 47;
                    case 166 -> 115;
                    case 167 -> 29;
                    case 168 -> 185;
                    case 169 -> 188;
                    case 170 -> 116;
                    case 171 -> 133;
                    case 172 -> 108;
                    case 173 -> 149;
                    case 174 -> 196;
                    case 175 -> 19;
                    case 176 -> 58;
                    case 177 -> 192;
                    case 178 -> 32;
                    case 179 -> 81;
                    case 180 -> 214;
                    case 181 -> 122;
                    case 182 -> 80;
                    case 183 -> 218;
                    case 184 -> 165;
                    case 185 -> 195;
                    case 186 -> 200;
                    case 187 -> 199;
                    case 188 -> 120;
                    case 189 -> 161;
                    case 190 -> 243;
                    case 191 -> 33;
                    case 192 -> 78;
                    case 193 -> 104;
                    case 194 -> 162;
                    case 195 -> 69;
                    case 196 -> 204;
                    case 197 -> 63;
                    case 198 -> 128;
                    case 199 -> 3;
                    case 200 -> 187;
                    case 201 -> 219;
                    case 202 -> 36;
                    case 203 -> 203;
                    case 204 -> 17;
                    case 205 -> 71;
                    case 206 -> 147;
                    case 207 -> 253;
                    case 208 -> 132;
                    case 209 -> 126;
                    case 210 -> 5;
                    case 211 -> 234;
                    case 212 -> 62;
                    case 213 -> 154;
                    case 214 -> 87;
                    case 215 -> 197;
                    case 216 -> 113;
                    case 217 -> 65;
                    case 218 -> 13;
                    case 219 -> 170;
                    case 220 -> 14;
                    case 221 -> 83;
                    case 222 -> 245;
                    case 223 -> 178;
                    case 224 -> 9;
                    case 225 -> 181;
                    case 226 -> 152;
                    case 227 -> 12;
                    case 228 -> 24;
                    case 229 -> 21;
                    case 230 -> 79;
                    case 231 -> 228;
                    case 232 -> 166;
                    case 233 -> 38;
                    case 234 -> 139;
                    case 235 -> 235;
                    case 236 -> 20;
                    case 237 -> 194;
                    case 238 -> 6;
                    case 239 -> 125;
                    case 240 -> 88;
                    case 241 -> 142;
                    case 242 -> 174;
                    case 243 -> 53;
                    case 244 -> 246;
                    case 245 -> 127;
                    case 246 -> 112;
                    case 247 -> 28;
                    case 248 -> 135;
                    case 249 -> 153;
                    case 250 -> 177;
                    case 251 -> 237;
                    case 252 -> 18;
                    case 253 -> 56;
                    case 254 -> 39;
                    default -> 101;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 15937406197949L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1217378160 + (char)-10619, -1217509230 - -((char)-6431), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 97233217102464L;
                    String string = SshAgentIpcService.f();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(547479390 + 28779, -547479390 + -31415, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 102308565319683L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00e8\u0001.\u00a6\u0010\u0003z\u00af*";
                var4_3 = "\u00e8\u0001.\u00a6\u0010\u0003z\u00af*".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 6;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 92;
                                break;
                            }
                            case 1: {
                                v11 = 52;
                                break;
                            }
                            case 2: {
                                v11 = 86;
                                break;
                            }
                            case 3: {
                                v11 = 35;
                                break;
                            }
                            case 4: {
                                v11 = 100;
                                break;
                            }
                            case 5: {
                                v11 = 91;
                                break;
                            }
                            default: {
                                v11 = 20;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFED48) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 246;
                    case 1 -> 37;
                    case 2 -> 145;
                    case 3 -> 92;
                    case 4 -> 163;
                    case 5 -> 65;
                    case 6 -> 7;
                    case 7 -> 172;
                    case 8 -> 211;
                    case 9 -> 26;
                    case 10 -> 68;
                    case 11 -> 158;
                    case 12 -> 195;
                    case 13 -> 114;
                    case 14 -> 254;
                    case 15 -> 100;
                    case 16 -> 159;
                    case 17 -> 85;
                    case 18 -> 232;
                    case 19 -> 126;
                    case 20 -> 6;
                    case 21 -> 25;
                    case 22 -> 194;
                    case 23 -> 110;
                    case 24 -> 9;
                    case 25 -> 180;
                    case 26 -> 93;
                    case 27 -> 75;
                    case 28 -> 119;
                    case 29 -> 196;
                    case 30 -> 113;
                    case 31 -> 204;
                    case 32 -> 24;
                    case 33 -> 150;
                    case 34 -> 129;
                    case 35 -> 120;
                    case 36 -> 34;
                    case 37 -> 146;
                    case 38 -> 183;
                    case 39 -> 56;
                    case 40 -> 46;
                    case 41 -> 166;
                    case 42 -> 224;
                    case 43 -> 44;
                    case 44 -> 135;
                    case 45 -> 156;
                    case 46 -> 220;
                    case 47 -> 192;
                    case 48 -> 62;
                    case 49 -> 216;
                    case 50 -> 189;
                    case 51 -> 250;
                    case 52 -> 140;
                    case 53 -> 169;
                    case 54 -> 52;
                    case 55 -> 32;
                    case 56 -> 49;
                    case 57 -> 78;
                    case 58 -> 55;
                    case 59 -> 230;
                    case 60 -> 127;
                    case 61 -> 30;
                    case 62 -> 16;
                    case 63 -> 152;
                    case 64 -> 190;
                    case 65 -> 58;
                    case 66 -> 151;
                    case 67 -> 128;
                    case 68 -> 124;
                    case 69 -> 83;
                    case 70 -> 45;
                    case 71 -> 155;
                    case 72 -> 2;
                    case 73 -> 244;
                    case 74 -> 247;
                    case 75 -> 139;
                    case 76 -> 42;
                    case 77 -> 109;
                    case 78 -> 179;
                    case 79 -> 212;
                    case 80 -> 144;
                    case 81 -> 61;
                    case 82 -> 21;
                    case 83 -> 60;
                    case 84 -> 242;
                    case 85 -> 132;
                    case 86 -> 76;
                    case 87 -> 185;
                    case 88 -> 133;
                    case 89 -> 40;
                    case 90 -> 184;
                    case 91 -> 10;
                    case 92 -> 107;
                    case 93 -> 138;
                    case 94 -> 205;
                    case 95 -> 210;
                    case 96 -> 20;
                    case 97 -> 122;
                    case 98 -> 101;
                    case 99 -> 241;
                    case 100 -> 97;
                    case 101 -> 240;
                    case 102 -> 17;
                    case 103 -> 123;
                    case 104 -> 86;
                    case 105 -> 87;
                    case 106 -> 50;
                    case 107 -> 221;
                    case 108 -> 237;
                    case 109 -> 118;
                    case 110 -> 236;
                    case 111 -> 197;
                    case 112 -> 15;
                    case 113 -> 148;
                    case 114 -> 31;
                    case 115 -> 229;
                    case 116 -> 23;
                    case 117 -> 207;
                    case 118 -> 19;
                    case 119 -> 209;
                    case 120 -> 253;
                    case 121 -> 255;
                    case 122 -> 3;
                    case 123 -> 91;
                    case 124 -> 35;
                    case 125 -> 69;
                    case 126 -> 54;
                    case 127 -> 202;
                    case 128 -> 63;
                    case 129 -> 28;
                    case 130 -> 72;
                    case 131 -> 219;
                    case 132 -> 141;
                    case 133 -> 154;
                    case 134 -> 59;
                    case 135 -> 206;
                    case 136 -> 252;
                    case 137 -> 64;
                    case 138 -> 198;
                    case 139 -> 164;
                    case 140 -> 248;
                    case 141 -> 213;
                    case 142 -> 245;
                    case 143 -> 171;
                    case 144 -> 201;
                    case 145 -> 12;
                    case 146 -> 105;
                    case 147 -> 79;
                    case 148 -> 226;
                    case 149 -> 81;
                    case 150 -> 191;
                    case 151 -> 162;
                    case 152 -> 218;
                    case 153 -> 116;
                    case 154 -> 176;
                    case 155 -> 168;
                    case 156 -> 74;
                    case 157 -> 0;
                    case 158 -> 121;
                    case 159 -> 90;
                    case 160 -> 160;
                    case 161 -> 125;
                    case 162 -> 43;
                    case 163 -> 165;
                    case 164 -> 53;
                    case 165 -> 177;
                    case 166 -> 136;
                    case 167 -> 234;
                    case 168 -> 39;
                    case 169 -> 228;
                    case 170 -> 73;
                    case 171 -> 239;
                    case 172 -> 225;
                    case 173 -> 84;
                    case 174 -> 115;
                    case 175 -> 249;
                    case 176 -> 95;
                    case 177 -> 167;
                    case 178 -> 251;
                    case 179 -> 71;
                    case 180 -> 174;
                    case 181 -> 175;
                    case 182 -> 147;
                    case 183 -> 99;
                    case 184 -> 181;
                    case 185 -> 106;
                    case 186 -> 48;
                    case 187 -> 243;
                    case 188 -> 182;
                    case 189 -> 187;
                    case 190 -> 170;
                    case 191 -> 108;
                    case 192 -> 29;
                    case 193 -> 153;
                    case 194 -> 11;
                    case 195 -> 103;
                    case 196 -> 33;
                    case 197 -> 199;
                    case 198 -> 4;
                    case 199 -> 112;
                    case 200 -> 66;
                    case 201 -> 38;
                    case 202 -> 5;
                    case 203 -> 142;
                    case 204 -> 8;
                    case 205 -> 57;
                    case 206 -> 231;
                    case 207 -> 149;
                    case 208 -> 227;
                    case 209 -> 47;
                    case 210 -> 134;
                    case 211 -> 143;
                    case 212 -> 96;
                    case 213 -> 217;
                    case 214 -> 89;
                    case 215 -> 203;
                    case 216 -> 104;
                    case 217 -> 173;
                    case 218 -> 98;
                    case 219 -> 233;
                    case 220 -> 178;
                    case 221 -> 117;
                    case 222 -> 36;
                    case 223 -> 67;
                    case 224 -> 88;
                    case 225 -> 161;
                    case 226 -> 14;
                    case 227 -> 77;
                    case 228 -> 94;
                    case 229 -> 157;
                    case 230 -> 214;
                    case 231 -> 137;
                    case 232 -> 200;
                    case 233 -> 208;
                    case 234 -> 188;
                    case 235 -> 186;
                    case 236 -> 223;
                    case 237 -> 111;
                    case 238 -> 18;
                    case 239 -> 27;
                    case 240 -> 70;
                    case 241 -> 215;
                    case 242 -> 235;
                    case 243 -> 130;
                    case 244 -> 238;
                    case 245 -> 131;
                    case 246 -> 193;
                    case 247 -> 22;
                    case 248 -> 41;
                    case 249 -> 222;
                    case 250 -> 13;
                    case 251 -> 1;
                    case 252 -> 51;
                    case 253 -> 80;
                    case 254 -> 102;
                    default -> 82;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

