/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tailwind.lsp;

import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.idea.AppMode;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCodeActionsCustomizer;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.api.customization.LspCompletionCustomizer;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspFindReferencesCustomizer;
import com.intellij.platform.lsp.api.customization.LspFindReferencesDisabled;
import com.intellij.platform.lsp.api.customization.LspFormattingCustomizer;
import com.intellij.platform.lsp.api.customization.LspFormattingDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionCustomizer;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToTypeDefinitionCustomizer;
import com.intellij.platform.lsp.api.customization.LspGoToTypeDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensCustomizer;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensDisabled;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.tailwind.settings.TailwindSettings;
import com.intellij.tailwind.util.TailwindUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xml.util.ColorIconCache;
import icons.TailwindcssIcons;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class TailwindLspServerDescriptor
extends LspServerDescriptor {
    private static final LspCompletionSupport COMPLETION_SUPPORT = new LspCompletionSupport(){

        public boolean isTriggerCharacterRespected(char charTyped) {
            return false;
        }

        @NotNull
        public LookupElement createLookupElement(@NotNull CompletionParameters parameters, @NotNull CompletionItem item) {
            if (parameters == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            LookupElement element = Objects.requireNonNull(super.createLookupElement(parameters, item));
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)21.0);
            if (lookupElement == null) {
                1.$$$reportNull$$$0(2);
            }
            return lookupElement;
        }

        @NotNull
        protected Icon getIcon(@NotNull CompletionItem item) {
            if (item == null) {
                1.$$$reportNull$$$0(3);
            }
            Icon icon = TailwindLspServerDescriptor.getCompletionIcon(item);
            if (icon == null) {
                1.$$$reportNull$$$0(4);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    };
    private static final LspCodeActionsSupport CODE_ACTIONS_SUPPORT = new LspCodeActionsSupport(){

        public boolean getIntentionActionsSupport() {
            return false;
        }
    };
    private static final LspCustomization CUSTOMIZATION = new LspCustomization(){

        @NotNull
        public LspSemanticTokensCustomizer getSemanticTokensCustomizer() {
            LspSemanticTokensDisabled lspSemanticTokensDisabled = LspSemanticTokensDisabled.INSTANCE;
            if (lspSemanticTokensDisabled == null) {
                3.$$$reportNull$$$0(0);
            }
            return lspSemanticTokensDisabled;
        }

        @NotNull
        public LspCodeActionsCustomizer getCodeActionsCustomizer() {
            LspCodeActionsSupport lspCodeActionsSupport = CODE_ACTIONS_SUPPORT;
            if (lspCodeActionsSupport == null) {
                3.$$$reportNull$$$0(1);
            }
            return lspCodeActionsSupport;
        }

        @NotNull
        public LspGoToDefinitionCustomizer getGoToDefinitionCustomizer() {
            LspGoToDefinitionDisabled lspGoToDefinitionDisabled = LspGoToDefinitionDisabled.INSTANCE;
            if (lspGoToDefinitionDisabled == null) {
                3.$$$reportNull$$$0(2);
            }
            return lspGoToDefinitionDisabled;
        }

        @NotNull
        public LspGoToTypeDefinitionCustomizer getGoToTypeDefinitionCustomizer() {
            LspGoToTypeDefinitionDisabled lspGoToTypeDefinitionDisabled = LspGoToTypeDefinitionDisabled.INSTANCE;
            if (lspGoToTypeDefinitionDisabled == null) {
                3.$$$reportNull$$$0(3);
            }
            return lspGoToTypeDefinitionDisabled;
        }

        @NotNull
        public LspFormattingCustomizer getFormattingCustomizer() {
            LspFormattingDisabled lspFormattingDisabled = LspFormattingDisabled.INSTANCE;
            if (lspFormattingDisabled == null) {
                3.$$$reportNull$$$0(4);
            }
            return lspFormattingDisabled;
        }

        @NotNull
        public LspFindReferencesCustomizer getFindReferencesCustomizer() {
            LspFindReferencesDisabled lspFindReferencesDisabled = LspFindReferencesDisabled.INSTANCE;
            if (lspFindReferencesDisabled == null) {
                3.$$$reportNull$$$0(5);
            }
            return lspFindReferencesDisabled;
        }

        @NotNull
        public LspCompletionCustomizer getCompletionCustomizer() {
            LspCompletionSupport lspCompletionSupport = COMPLETION_SUPPORT;
            if (lspCompletionSupport == null) {
                3.$$$reportNull$$$0(6);
            }
            return lspCompletionSupport;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSemanticTokensCustomizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeActionsCustomizer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGoToDefinitionCustomizer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGoToTypeDefinitionCustomizer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormattingCustomizer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFindReferencesCustomizer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionCustomizer";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private NodeTargetRun myNodeTargetRun;

    TailwindLspServerDescriptor(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(0);
        }
        if (root == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(1);
        }
        super(project, "Tailwind CSS", new VirtualFile[]{root});
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(2);
        }
        return TailwindUtil.isSupportedFile(this.getProject(), file);
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        throw new RuntimeException("Not expected to be called because startServerProcess() is overridden");
    }

    @NotNull
    public OSProcessHandler startServerProcess() throws com.intellij.execution.ExecutionException {
        NodeJsInterpreter node = NodeJsInterpreterManager.getInstance((Project)this.getProject()).getInterpreterOrThrow();
        this.myNodeTargetRun = new NodeTargetRun(node, this.getProject(), null, NodeTargetRunOptions.of((Boolean)false));
        TargetedCommandLineBuilder builder = this.myNodeTargetRun.getCommandLineBuilder();
        builder.addParameter(this.myNodeTargetRun.path(this.getLspServerPath()));
        builder.setWorkingDirectory(this.myNodeTargetRun.path(this.getRoots()[0].toNioPath()));
        this.saveTailwindConfigFiles();
        LOG.info("Starting Tailwind LSP server. Node.js version " + String.valueOf(node.getCachedVersion()) + ", path: " + node.getPresentableName());
        ProcessWithCmdLine processWithCmdLine = this.myNodeTargetRun.startProcessEx();
        LOG.debug("Tailwind LSP server started:\n" + processWithCmdLine.getCommandLinePresentation());
        KillableProcessHandler killableProcessHandler = processWithCmdLine.getProcessHandler();
        if (killableProcessHandler == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(3);
        }
        return killableProcessHandler;
    }

    private void saveTailwindConfigFiles() {
        CancellablePromise future = ReadAction.nonBlocking(() -> this.getUnsavedConfigsAsDocuments()).finishOnUiThread(ModalityState.nonModal(), documents -> WriteAction.run(() -> TailwindLspServerDescriptor.saveDocuments(documents))).submit((Executor)AppExecutorUtil.getAppExecutorService());
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    private static void saveDocuments(List<Document> documents) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (Document document : documents) {
            documentManager.saveDocument(document);
        }
    }

    private List<Document> getUnsavedConfigsAsDocuments() {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document[] unsavedDocuments = documentManager.getUnsavedDocuments();
        ArrayList<Document> documentsToSave = new ArrayList<Document>();
        for (Document document : unsavedDocuments) {
            PsiFile psiFile = psiDocumentManager.getPsiFile(document);
            if (psiFile == null || !TailwindUtil.isTailwindConfigFile(psiFile)) continue;
            documentsToSave.add(document);
        }
        return documentsToSave;
    }

    @NotNull
    private String getLspServerPath() {
        String packagePath = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)TailwindSettings.getInstance(this.getProject()).getLspServerPackageRef());
        if (packagePath.equals("Default")) {
            String string;
            try {
                string = JSPluginPathManager.getPluginResource(((Object)((Object)this)).getClass(), (String)"server/tailwindcss-language-server", (String)(AppMode.isDevServer() ? "tailwindcss" : "tailwindcss/resources")).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (string == null) {
                TailwindLspServerDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = packagePath + "/bin/tailwindcss-language-server";
        if (string == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        String string;
        if (file == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(6);
        }
        try {
            string = this.myNodeTargetRun.convertLocalPathToTargetPath(file.getPath());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            String string2 = super.getFilePath(file);
            if (string2 == null) {
                TailwindLspServerDescriptor.$$$reportNull$$$0(8);
            }
            return string2;
        }
        if (string == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path) {
        if (path == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(9);
        }
        try {
            return super.findLocalFileByPath(this.myNodeTargetRun.convertTargetPathToLocalPath(path));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return super.findLocalFileByPath(path);
        }
    }

    @Nullable
    public Object getWorkspaceConfiguration(@NotNull ConfigurationItem item) {
        if (item == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(10);
        }
        if ("editor".equals(item.getSection())) {
            JsonObject result = new JsonObject();
            result.addProperty("tabSize", (Number)4);
            return result;
        }
        if ("tailwindCSS".equals(item.getSection())) {
            return TailwindSettings.getParsedLspConfigurationGson(this.getProject());
        }
        return super.getWorkspaceConfiguration(item);
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        LspCustomization lspCustomization = CUSTOMIZATION;
        if (lspCustomization == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(11);
        }
        return lspCustomization;
    }

    @NotNull
    private static Icon getCompletionIcon(@NotNull CompletionItem completionItem) {
        if (completionItem == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(12);
        }
        if (completionItem.getKind() == CompletionItemKind.Color) {
            String doc;
            Either docEither = completionItem.getDocumentation();
            String string = doc = docEither != null ? (String)docEither.getLeft() : null;
            if (doc != null) {
                Color color = null;
                if (doc.startsWith("rgb(") && doc.endsWith(")")) {
                    String args = doc.substring("rgb(".length(), doc.length() - 1);
                    color = CssPsiColorUtil.getColorInRGBsFunctions((String)args);
                } else if (doc.startsWith("#") && doc.length() == 7) {
                    try {
                        color = Color.decode(doc);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color != null) {
                    Icon icon = ColorIconCache.getIconCache().getIcon(color, 16);
                    if (icon == null) {
                        TailwindLspServerDescriptor.$$$reportNull$$$0(13);
                    }
                    return icon;
                }
            }
        }
        Icon icon = TailwindcssIcons.Tailwind_16;
        if (icon == null) {
            TailwindLspServerDescriptor.$$$reportNull$$$0(14);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tailwind/lsp/TailwindLspServerDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startServerProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLspServerPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLspCustomization";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFileByPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWorkspaceConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

