/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.split;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionBase;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.core.impl.actions.mode.JupyterCommandModeActionsHelper;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/split/NotebookSplitCellAction;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionBase;", "<init>", "()V", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "Companion", "intellij.jupyter.core"})
public final class NotebookSplitCellAction
extends NotebookCellLinesActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long lastTimeActionPerformed;

    private NotebookSplitCellAction() {
    }

    @Override
    @NotNull
    public JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)NotebookSplitCellAction::createActionUpdater$lambda$2));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        if (SystemInfo.isMac) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTimeActionPerformed < 200L) {
                return;
            }
            lastTimeActionPerformed = currentTime;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        WriteCommandAction.writeCommandAction((Project)project2).withName(this.getTemplateText()).run(() -> NotebookSplitCellAction.actionPerformed$lambda$3(cellLines, editor));
    }

    private static final boolean createActionUpdater$lambda$2$lambda$0(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return !JupyterCommandModeActionsHelper.INSTANCE.isCommandModeActionEnabled(dataContext);
    }

    private static final boolean createActionUpdater$lambda$2$lambda$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JupyterCell jupyterCell = JupyterDataContextExtensionsKt.getSelectedJupyterCell(dataContext);
        if (jupyterCell == null || (jupyterCell = jupyterCell.getCellType()) == null) {
            return true;
        }
        JupyterCell primaryCellType = jupyterCell;
        return !Companion.isUnsupported((JupyterCellType)primaryCellType);
    }

    private static final Unit createActionUpdater$lambda$2(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)NotebookSplitCellAction::createActionUpdater$lambda$2$lambda$0));
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)NotebookSplitCellAction::createActionUpdater$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$3(NotebookCellLines $cellLines, EditorImpl $editor) {
        NotebookCellLines.Interval cell = (NotebookCellLines.Interval)$cellLines.intervalsIterator($editor.getCaretModel().getLogicalPosition().line).next();
        NotebookCellLinesEditHelper helper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)$editor);
        NotebookCellLinesActionUtil.INSTANCE.trySplitCellAtOffset((Editor)$editor, cell, $editor.getCaretModel().getOffset(), $cellLines, helper);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/split/NotebookSplitCellAction$Companion;", "", "<init>", "()V", "lastTimeActionPerformed", "", "isUnsupported", "", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;)Z", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isUnsupported(@NotNull JupyterCellType $this$isUnsupported) {
            Intrinsics.checkNotNullParameter((Object)$this$isUnsupported, (String)"<this>");
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$isUnsupported.ordinal()]) {
                case 1, 2, 3 -> true;
                case 4, 5, 6, 7, 8, 9, 10, 11 -> false;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JupyterCellType.values().length];
                try {
                    nArray[JupyterCellType.DATA_INPUT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.DATA_WRANGLER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.SQL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.RAW.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.MARKDOWN.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.CODE_OR_MAGIC.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.CODE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.MAGIC.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.UNDEFINED.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.HEADING.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.HTML.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

