/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class DefineAttributeQuickFix
implements LocalQuickFix {
    private final String myAttrName;
    private final String myAttrValue;
    private final String myNamespace;

    public DefineAttributeQuickFix(String attrName) {
        this(attrName, "", "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace) {
        if (attrName == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(1);
        }
        this(attrName, namespace, "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace, @NotNull String attrValue) {
        if (attrName == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(3);
        }
        if (attrValue == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(4);
        }
        this.myAttrName = attrName;
        this.myNamespace = namespace;
        this.myAttrValue = attrValue;
    }

    @NotNull
    public String getName() {
        String string = XmlDomBundle.message("dom.quickfix.define.attribute.text", this.myAttrName);
        if (string == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlDomBundle.message("dom.quickfix.define.attribute.family", new Object[0]);
        if (string == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlTag tag;
        if (project == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            DefineAttributeQuickFix.$$$reportNull$$$0(8);
        }
        XmlAttribute attribute = tag.setAttribute(this.myAttrName, this.myNamespace.equals((tag = (XmlTag)descriptor.getPsiElement()).getNamespace()) ? "" : this.myNamespace, this.myAttrValue);
        VirtualFile virtualFile = tag.getContainingFile().getVirtualFile();
        if (virtualFile != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DefineAttributeQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DefineAttributeQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

