/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.util.UnitUtils;
import org.openhab.core.util.StringUtils;

@NonNullByDefault
public class YamlElementUtils {
    private static final Set<String> VALID_ITEM_TYPES = Set.of("Switch", "Rollershutter", "Contact", "String", "Number", "Dimmer", "DateTime", "Color", "Image", "Player", "Location", "Call");

    public static boolean equalsConfig(@Nullable Map<String, Object> first, @Nullable Map<String, Object> second) {
        if (first != null && second != null) {
            return first.size() != second.size() ? false : first.entrySet().stream().allMatch(e -> YamlElementUtils.equalsConfigValue(e.getValue(), second.get(e.getKey())));
        }
        return first == null && second == null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean equalsConfigValue(Object first, @Nullable Object second) {
        boolean bl;
        if (first instanceof List) {
            List firstList = (List)first;
            if (second instanceof List) {
                List secondList = (List)second;
                bl = Arrays.equals(firstList.toArray(), secondList.toArray());
                return bl;
            }
        }
        bl = first.equals(second);
        return bl;
    }

    public static boolean equalsListStrings(@Nullable List<String> first, @Nullable List<String> second) {
        if (first != null && second != null) {
            return Arrays.equals(first.toArray(), second.toArray());
        }
        return first == null && second == null;
    }

    public static boolean equalsSetStrings(@Nullable Set<String> first, @Nullable Set<String> second) {
        if (first != null && second != null) {
            return first.size() != second.size() ? false : first.containsAll(second);
        }
        return first == null && second == null;
    }

    public static @Nullable String getAdjustedItemType(@Nullable String type) {
        return type == null ? null : StringUtils.capitalize((String)type);
    }

    public static boolean isValidItemType(@Nullable String type) {
        String adjustedType = YamlElementUtils.getAdjustedItemType(type);
        return adjustedType == null ? true : VALID_ITEM_TYPES.contains(adjustedType);
    }

    public static boolean isNumberItemType(@Nullable String type) {
        return "Number".equals(YamlElementUtils.getAdjustedItemType(type));
    }

    public static @Nullable String getAdjustedItemDimension(@Nullable String dimension) {
        return dimension == null ? null : StringUtils.capitalize((String)dimension);
    }

    public static boolean isValidItemDimension(@Nullable String dimension) {
        String adjustedDimension = YamlElementUtils.getAdjustedItemDimension(dimension);
        if (adjustedDimension != null) {
            try {
                UnitUtils.parseDimension((String)adjustedDimension);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public static @Nullable String getItemTypeWithDimension(@Nullable String type, @Nullable String dimension) {
        String adjustedType = YamlElementUtils.getAdjustedItemType(type);
        String adjustedDimension = YamlElementUtils.getAdjustedItemDimension(dimension);
        return adjustedType != null ? adjustedType + (String)(adjustedDimension == null ? "" : ":" + adjustedDimension) : null;
    }
}

