/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;
import gnu.io.rfc2217.Util;

public class ModemStateMaskCommand
extends ComPortCommand {
    private int modemStateMask;

    public ModemStateMaskCommand(int[] bytes) {
        super("SET-MODEMSTATE-MASK", 11, bytes);
        this.modemStateMask = bytes[2];
    }

    public ModemStateMaskCommand(boolean client, int modemStateMask) {
        this(new int[]{44, client ? 11 : 111, modemStateMask});
    }

    @Override
    public String toString() {
        return this.getName() + " " + Util.decodeBits(this.modemStateMask, Util.MODEM_STATE_BITS);
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseModemStateMask(this);
    }

    public int getModemStateMask() {
        return this.modemStateMask;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

