/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.common.DuplicateExecutionException;
import org.openhab.core.internal.common.Invocation;
import org.openhab.core.internal.common.SafeCallManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
abstract class AbstractInvocationHandler<T> {
    private static final String MSG_TIMEOUT_R = "Timeout of {}ms exceeded while calling\n{}\nThread '{}' ({}) is in state '{}'\n{}";
    private static final String MSG_TIMEOUT_Q = "Timeout of {}ms exceeded while calling\n{}\nThe task was still queued.";
    private static final String MSG_DUPLICATE = "Thread occupied while calling method '{}' on '{}' because of another blocking call.\n\tThe other call was to '{}'.\n\tIt's thread '{}' ({}) is in state '{}'\n{}";
    private static final String MSG_ERROR = "An error occurred while calling method '{}' on '{}': {}";
    private final Logger logger = LoggerFactory.getLogger(AbstractInvocationHandler.class);
    private final SafeCallManager manager;
    private final T target;
    private final Object identifier;
    private final long timeout;
    private final @Nullable Consumer<Throwable> exceptionHandler;
    private final @Nullable Runnable timeoutHandler;

    AbstractInvocationHandler(SafeCallManager manager, T target, Object identifier, long timeout, @Nullable Consumer<Throwable> exceptionHandler, @Nullable Runnable timeoutHandler) {
        this.manager = manager;
        this.target = target;
        this.identifier = identifier;
        this.timeout = timeout;
        this.exceptionHandler = exceptionHandler;
        this.timeoutHandler = timeoutHandler;
    }

    SafeCallManager getManager() {
        return this.manager;
    }

    T getTarget() {
        return this.target;
    }

    Object getIdentifier() {
        return this.identifier;
    }

    long getTimeout() {
        return this.timeout;
    }

    @Nullable Consumer<Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Nullable Runnable getTimeoutHandler() {
        return this.timeoutHandler;
    }

    void handleExecutionException(Method method, ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof DuplicateExecutionException) {
            DuplicateExecutionException exception = (DuplicateExecutionException)cause;
            this.handleDuplicate(method, exception);
        } else if (cause instanceof InvocationTargetException) {
            InvocationTargetException exception = (InvocationTargetException)cause;
            this.handleException(method, exception);
        }
    }

    void handleException(Method method, InvocationTargetException e) {
        Throwable cause = e.getCause();
        this.logger.error(MSG_ERROR, new Object[]{this.toString(method), this.target, cause == null ? "" : cause.getMessage(), e.getCause()});
        Consumer<Throwable> localConsumer = this.exceptionHandler;
        if (localConsumer != null) {
            localConsumer.accept(cause == null ? e : cause);
        }
    }

    void handleDuplicate(Method method, DuplicateExecutionException e) {
        Thread thread = Objects.requireNonNull(e.getCallable().getThread());
        this.logger.debug(MSG_DUPLICATE, new Object[]{this.toString(method), this.target, this.toString(e.getCallable().getMethod()), thread.getName(), thread.threadId(), thread.getState().toString(), this.getStacktrace(thread)});
    }

    void handleTimeout(Method method, Invocation invocation) {
        Thread thread = invocation.getThread();
        if (thread != null) {
            this.logger.debug(MSG_TIMEOUT_R, new Object[]{this.timeout, this.toString(invocation.getInvocationStack()), thread.getName(), thread.threadId(), thread.getState().toString(), this.getStacktrace(thread)});
        } else {
            this.logger.debug(MSG_TIMEOUT_Q, (Object)this.timeout, (Object)this.toString(invocation.getInvocationStack()));
        }
        Runnable runnable = this.timeoutHandler;
        if (runnable instanceof Runnable) {
            Runnable handler = runnable;
            handler.run();
        }
    }

    private String toString(Collection<Invocation> invocationStack) {
        return invocationStack.stream().map(invocation -> "\t'" + this.toString(invocation.getMethod()) + "' on '" + String.valueOf(invocation.getInvocationHandler().getTarget()) + "'").collect(Collectors.joining(" via\n"));
    }

    private String getStacktrace(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        return Arrays.stream(elements).map(element -> "\tat " + String.valueOf(element)).collect(Collectors.joining("\n"));
    }

    String toString(Method method) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
    }

    @Nullable Object invokeDirect(Invocation invocation) throws IllegalAccessException, IllegalArgumentException {
        try {
            this.manager.recordCallStart(invocation);
        }
        catch (DuplicateExecutionException e) {
            return null;
        }
        try {
            Object object = invocation.getMethod().invoke(this.target, invocation.getArgs());
            return object;
        }
        catch (InvocationTargetException e) {
            this.handleException(invocation.getMethod(), e);
            return null;
        }
        finally {
            this.manager.recordCallEnd(invocation);
        }
    }
}

