/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCertificateFactory;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateMessage
extends HandshakeMessage {
    private static final String CERTIFICATE_TYPE_X509 = "X.509";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateMessage.class);
    private static final int CERTIFICATE_LENGTH_BITS = 24;
    private static final int CERTIFICATE_LIST_LENGTH_BITS = 24;
    private static final ThreadLocalCertificateFactory CERTIFICATE_FACTORY = new ThreadLocalCertificateFactory("X.509");
    private static final CertPath EMPTY_CERT_PATH;
    private static final List<byte[]> EMPTY_ENCODED_CHAIN;
    private final CertPath certPath;
    private final List<byte[]> encodedChain;
    private final byte[] rawPublicKeyBytes;
    private final PublicKey publicKey;
    private final int length;

    public CertificateMessage() {
        this(EMPTY_CERT_PATH);
    }

    public CertificateMessage(List<X509Certificate> certificateChain) {
        this(certificateChain, null);
    }

    public CertificateMessage(List<X509Certificate> certificateChain, List<X500Principal> certificateAuthorities) {
        this(CertPathUtil.generateValidatableCertPath(certificateChain, certificateAuthorities));
        if (LOGGER.isDebugEnabled()) {
            int size = this.certPath.getCertificates().size();
            if (size < certificateChain.size()) {
                LOGGER.debug("created CERTIFICATE message with truncated certificate chain [length: {}, full-length: {}]", (Object)size, (Object)certificateChain.size());
            } else {
                LOGGER.debug("created CERTIFICATE message with certificate chain [length: {}]", (Object)size);
            }
        }
    }

    private CertificateMessage(CertPath peerCertChain) {
        if (peerCertChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        this.rawPublicKeyBytes = null;
        this.certPath = peerCertChain;
        List<? extends Certificate> certificates = peerCertChain.getCertificates();
        int size = certificates.size();
        if (size == 0) {
            this.publicKey = null;
            this.encodedChain = EMPTY_ENCODED_CHAIN;
            this.length = 3;
        } else {
            List<Object> encodedChain = new ArrayList(size);
            int length = 0;
            try {
                for (Certificate certificate : certificates) {
                    byte[] encoded = certificate.getEncoded();
                    encodedChain.add(encoded);
                    length += 3 + encoded.length;
                }
            }
            catch (CertificateEncodingException e) {
                encodedChain = EMPTY_ENCODED_CHAIN;
                length = 0;
                LOGGER.warn("Could not encode certificate chain", (Throwable)e);
            }
            this.publicKey = encodedChain.isEmpty() ? null : certificates.get(0).getPublicKey();
            this.encodedChain = encodedChain;
            this.length = length + 3;
        }
    }

    public CertificateMessage(PublicKey publicKey) {
        this.publicKey = publicKey;
        if (publicKey == null) {
            this.rawPublicKeyBytes = null;
            this.certPath = EMPTY_CERT_PATH;
            this.encodedChain = EMPTY_ENCODED_CHAIN;
            this.length = 3;
        } else {
            this.certPath = null;
            this.encodedChain = null;
            this.rawPublicKeyBytes = publicKey.getEncoded();
            this.length = 3 + this.rawPublicKeyBytes.length;
        }
    }

    public CertificateMessage(byte[] rawPublicKeyBytes) {
        this(CertificateMessage.generateRawPublicKey(rawPublicKeyBytes));
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CERTIFICATE;
    }

    @Override
    public int getMessageLength() {
        return this.length;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation((int)(indent + 1));
        String indentation2 = StringUtil.indentation((int)(indent + 2));
        if (this.rawPublicKeyBytes == null && this.certPath != null) {
            List<? extends Certificate> certificates = this.certPath.getCertificates();
            sb.append(indentation).append("Certificate chain: ").append(certificates.size()).append(" certificates").append(StringUtil.lineSeparator());
            int index = 0;
            for (Certificate certificate : certificates) {
                sb.append(indentation2).append("Certificate Length: ").append(this.encodedChain.get(index).length).append(" bytes").append(StringUtil.lineSeparator());
                String text = StringUtil.toDisplayString((Certificate)certificate);
                sb.append(indentation2).append("Certificate[").append(index).append(".]: ");
                sb.append(text.replaceAll("\n", "\n" + indentation2)).append(StringUtil.lineSeparator());
                ++index;
            }
        } else if (this.rawPublicKeyBytes != null && this.certPath == null) {
            String text;
            sb.append(indentation).append("Raw Public Key: ");
            if (this.publicKey != null) {
                text = StringUtil.toDisplayString((PublicKey)this.publicKey);
                text = text.replaceAll("\n", "\n" + indentation2);
            } else {
                text = "<empty>";
            }
            sb.append(text.replaceAll("\n", "\n" + indentation2));
            sb.append(StringUtil.lineSeparator());
        }
        return sb.toString();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public CertPath getCertificateChain() {
        return this.certPath;
    }

    public boolean isEmpty() {
        return this.publicKey == null;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter(this.getMessageLength());
        if (this.rawPublicKeyBytes == null) {
            writer.write(this.getMessageLength() - 3, 24);
            for (byte[] encoded : this.encodedChain) {
                writer.writeVarBytes(encoded, 24);
            }
        } else {
            writer.writeVarBytes(this.rawPublicKeyBytes, 24);
        }
        return writer.toByteArray();
    }

    public static CertificateMessage fromReader(DatagramReader reader, CertificateType certificateType) throws HandshakeException {
        int certificatesLength = reader.read(24);
        if (certificatesLength == 0) {
            return new CertificateMessage(EMPTY_CERT_PATH);
        }
        if (CertificateType.RAW_PUBLIC_KEY == certificateType) {
            LOGGER.debug("Parsing RawPublicKey CERTIFICATE message");
            byte[] rawPublicKey = reader.readBytes(certificatesLength);
            return new CertificateMessage(rawPublicKey);
        }
        if (CertificateType.X_509 == certificateType) {
            reader = reader.createRangeReader(certificatesLength);
            LOGGER.debug("Parsing X.509 CERTIFICATE message");
            try {
                CertificateFactory factory = (CertificateFactory)CERTIFICATE_FACTORY.currentWithCause();
                ArrayList<Certificate> certs = new ArrayList<Certificate>();
                while (reader.bytesAvailable()) {
                    int certificateLength = reader.read(24);
                    certs.add(factory.generateCertificate(reader.createRangeInputStream(certificateLength)));
                }
                return new CertificateMessage(factory.generateCertPath(certs));
            }
            catch (GeneralSecurityException e) {
                throw new HandshakeException("Cannot parse X.509 certificate chain provided by peer", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE), e);
            }
        }
        throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " not supported!");
    }

    private static PublicKey generateRawPublicKey(byte[] rawPublicKeyBytes) {
        if (rawPublicKeyBytes != null && rawPublicKeyBytes.length > 0) {
            try {
                String keyAlgorithm = Asn1DerDecoder.readSubjectPublicKeyAlgorithm((byte[])rawPublicKeyBytes);
                if (keyAlgorithm != null) {
                    ThreadLocalKeyFactory factory = ThreadLocalKeyFactory.KEY_FACTORIES.get(keyAlgorithm);
                    if (factory != null && factory.current() != null) {
                        return ((KeyFactory)factory.current()).generatePublic(new X509EncodedKeySpec(rawPublicKeyBytes));
                    }
                } else {
                    LOGGER.info("Could not reconstruct the peer's public key [{}]", (Object)StringUtil.byteArray2Hex((byte[])rawPublicKeyBytes));
                }
            }
            catch (GeneralSecurityException e) {
                LOGGER.warn("Could not reconstruct the peer's public key", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Could not reconstruct the peer's public key", (Throwable)e);
            }
        }
        return null;
    }

    static {
        CertPath certPath = null;
        try {
            List certs = Collections.emptyList();
            CertificateFactory factory = (CertificateFactory)CERTIFICATE_FACTORY.currentWithCause();
            certPath = factory.generateCertPath(certs);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        EMPTY_CERT_PATH = certPath;
        EMPTY_ENCODED_CHAIN = Collections.emptyList();
    }
}

