/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command.completers;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class FeatureVersionCompleter
implements Completer {
    @Reference
    private FeaturesService featuresService;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        String[] args = commandLine.getArguments();
        if (args.length >= 3) {
            String featureArg = args[1];
            try {
                List<String> versions = this.getAllVersionsOfFeature(featureArg, this.featuresService);
                delegate.getStrings().addAll(versions);
                return delegate.complete(session, commandLine, candidates);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return delegate.complete(session, commandLine, candidates);
    }

    private List<String> getAllVersionsOfFeature(String feature, FeaturesService featuresService) throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        for (Repository repo : featuresService.listRepositories()) {
            for (Feature f : repo.getFeatures()) {
                if (!f.getName().equals(feature)) continue;
                versions.add(f.getVersion());
            }
        }
        return versions;
    }
}

