/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.resource.XtextResource;

public class ReferenceUpdaterContext
implements IReferenceUpdaterContext {
    private final EObjectDescriptionDeltaProvider.Deltas deltas;
    private final ITextRegionDiffBuilder diffBuilder;
    private final List<Runnable> handler = Lists.newArrayList();
    private final List<IUpdatableReference> references = Lists.newArrayList();
    private final RelatedResourcesProvider.RelatedResource relatedResource;

    public ReferenceUpdaterContext(EObjectDescriptionDeltaProvider.Deltas deltas, ITextRegionDiffBuilder diffBuilder) {
        this.deltas = deltas;
        this.diffBuilder = diffBuilder;
        this.relatedResource = null;
    }

    public ReferenceUpdaterContext(EObjectDescriptionDeltaProvider.Deltas deltas, ITextRegionDiffBuilder diffBuilder, RelatedResourcesProvider.RelatedResource relatedResource) {
        this.deltas = deltas;
        this.diffBuilder = diffBuilder;
        this.relatedResource = relatedResource;
    }

    @Override
    public EObjectDescriptionDeltaProvider.Deltas getEObjectDescriptionDeltas() {
        return this.deltas;
    }

    protected List<Runnable> getModifications() {
        return this.handler;
    }

    @Override
    public ITextRegionDiffBuilder getModifyableDocument() {
        return this.diffBuilder;
    }

    @Override
    public RelatedResourcesProvider.RelatedResource getRelatedResource() {
        return this.relatedResource;
    }

    @Override
    public XtextResource getResource() {
        return this.diffBuilder.getOriginalTextRegionAccess().getResource();
    }

    @Override
    public List<IUpdatableReference> getUpdatableReferences() {
        return this.references;
    }

    @Override
    public void modifyModel(Runnable runnable) {
        this.handler.add(runnable);
    }

    @Override
    public void updateReference(IUpdatableReference updatableReference) {
        this.references.add(updatableReference);
    }
}

