/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.time.Duration;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.SshServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="sshd", description="Creates a SSH server")
@Service
public class SshServerAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-p", aliases={"--port"}, description="The port to setup the SSH server", required=false, multiValued=false)
    private int port = 8101;
    @Option(name="-b", aliases={"--background"}, description="The service will run in the background", required=false, multiValued=false)
    private boolean background = true;
    @Option(name="-i", aliases={"--idle-timeout"}, description="The session idle timeout in milliseconds", required=false, multiValued=false)
    private long idleTimeout = 1800000L;
    @Option(name="-n", aliases={"--nio-workers"}, description="The number of NIO worker threads to use", required=false, multiValued=false)
    private int nioWorkers = 2;
    @Option(name="-c", aliases={"--max-concurrent-sessions"}, description="The maximum number of concurrent sessions opened on the ssh server", required=false, multiValued=false)
    private int maxConcurrentSessions = -1;
    @Option(name="-w", aliases={"--welcome-banner"}, description="The welcome banner to display when logging in", required=false, multiValued=false)
    private String welcomeBanner;
    @Reference
    private SshServer server;

    public void setServer(SshServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        this.log.debug("Created server: {}", (Object)this.server);
        this.server.setPort(this.port);
        CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)this.server, (Object)Duration.ofMillis(this.idleTimeout));
        CoreModuleProperties.NIO_WORKERS.set((PropertyResolver)this.server, (Object)this.nioWorkers);
        if (this.maxConcurrentSessions != -1) {
            CoreModuleProperties.MAX_CONCURRENT_SESSIONS.set((PropertyResolver)this.server, (Object)this.maxConcurrentSessions);
        }
        if (this.welcomeBanner != null) {
            CoreModuleProperties.WELCOME_BANNER.set((PropertyResolver)this.server, (Object)this.welcomeBanner);
        }
        this.server.start();
        System.out.println("SSH server listening on port " + this.port + " (idle timeout " + this.idleTimeout + "ms)  (nio worker Threads " + this.nioWorkers + ") ");
        if (!this.background) {
            SshServerAction sshServerAction = this;
            synchronized (sshServerAction) {
                this.log.debug("Waiting for server to shutdown");
                this.wait();
            }
            this.server.stop();
        }
        return null;
    }
}

