/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.graph.Dependency;
import shaded.org.eclipse.aether.graph.DependencyCycle;
import shaded.org.eclipse.aether.graph.DependencyNode;
import shaded.org.eclipse.aether.util.artifact.ArtifactIdUtils;

public final class DefaultDependencyCycle
implements DependencyCycle {
    private final List<Dependency> dependencies;
    private final int cycleEntry;

    public DefaultDependencyCycle(List<DependencyNode> nodes, int cycleEntry, Dependency dependency) {
        int offset = cycleEntry > 0 && nodes.get(0).getDependency() == null ? 1 : 0;
        Dependency[] dependencies = new Dependency[nodes.size() - offset + 1];
        int n = dependencies.length - 1;
        for (int i = 0; i < n; ++i) {
            DependencyNode node = nodes.get(i + offset);
            dependencies[i] = node.getDependency();
            if (dependencies[i] != null) continue;
            dependencies[i] = new Dependency(node.getArtifact(), null);
        }
        dependencies[dependencies.length - 1] = dependency;
        this.dependencies = Collections.unmodifiableList(Arrays.asList(dependencies));
        this.cycleEntry = cycleEntry;
    }

    @Override
    public List<Dependency> getPrecedingDependencies() {
        return this.dependencies.subList(0, this.cycleEntry);
    }

    @Override
    public List<Dependency> getCyclicDependencies() {
        return this.dependencies.subList(this.cycleEntry, this.dependencies.size());
    }

    public static int find(List<DependencyNode> nodes, Artifact artifact) {
        DependencyNode node;
        Artifact a;
        for (int i = nodes.size() - 1; i >= 0 && (a = (node = nodes.get(i)).getArtifact()) != null; --i) {
            if (!a.getArtifactId().equals(artifact.getArtifactId()) || !a.getGroupId().equals(artifact.getGroupId()) || !a.getExtension().equals(artifact.getExtension()) || !a.getClassifier().equals(artifact.getClassifier())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        int i = 0;
        for (Dependency dependency : this.dependencies) {
            if (i++ > 0) {
                buffer.append(" -> ");
            }
            buffer.append(ArtifactIdUtils.toVersionlessId(dependency.getArtifact()));
        }
        return buffer.toString();
    }
}

