/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.observe.ObserveHealth;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.ObservableResource;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;

public class ObserveManager {
    private final ConcurrentHashMap<InetSocketAddress, ObservingEndpoint> endpoints = new ConcurrentHashMap();
    private final ConcurrentHashMap<KeyToken, ObserveRelation> relations = new ConcurrentHashMap();
    private final int maxObserves;
    private final Configuration config;
    private volatile ObserveHealth observeHealth;

    public ObserveManager(Configuration config) {
        this.config = config;
        int maxObserves = 0;
        if (config != null) {
            maxObserves = (Integer)config.get((BasicDefinition)CoapConfig.MAX_SERVER_OBSERVES);
        }
        this.maxObserves = maxObserves;
    }

    public void setObserveHealth(ObserveHealth observeHealth) {
        this.observeHealth = observeHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserveRelation(Exchange exchange, ObservableResource resource) {
        ObserveHealth observeHealth;
        ObserveRelation previous;
        ObserveRelation relation = new ObserveRelation(this, resource, exchange);
        ObserveManager observeManager = this;
        synchronized (observeManager) {
            previous = this.relations.get(relation.getKeyToken());
            if (previous != null || this.maxObserves == 0 || this.relations.size() < this.maxObserves) {
                this.relations.put(relation.getKeyToken(), relation);
                ObservingEndpoint remoteEndpoint = this.endpoints.get(relation.getSource());
                if (remoteEndpoint == null) {
                    remoteEndpoint = new ObservingEndpoint(relation.getSource());
                    relation.setEndpoint(remoteEndpoint);
                    this.endpoints.put(relation.getSource(), remoteEndpoint);
                } else {
                    relation.setEndpoint(remoteEndpoint);
                }
            }
        }
        if (previous != null) {
            previous.cancel();
        }
        if ((observeHealth = this.observeHealth) != null) {
            observeHealth.receivingObserveRequest();
            observeHealth.setObserveRelations(this.relations.size());
            observeHealth.setObserveEndpoints(this.endpoints.size());
        }
    }

    public void cancelObserveRelation(Exchange exchange) {
        ObserveHealth observeHealth;
        KeyToken keyToken = ObserveRelation.getKeyToken(exchange);
        ObserveRelation relation = this.relations.get(keyToken);
        if (relation != null) {
            relation.cancel();
        }
        if ((observeHealth = this.observeHealth) != null) {
            observeHealth.receivingCancelRequest();
        }
    }

    public void onRejectedNotification(ObserveRelation relation) {
        ObserveHealth observeHealth = this.observeHealth;
        if (observeHealth != null) {
            observeHealth.receivingReject();
        }
        relation.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserveRelation(ObserveRelation relation) {
        boolean change = this.relations.remove(relation.getKeyToken(), relation);
        ObservingEndpoint endpoint = relation.getEndpoint();
        if (endpoint != null) {
            endpoint.removeObserveRelation(relation);
            ObserveManager observeManager = this;
            synchronized (observeManager) {
                if (endpoint.isEmpty()) {
                    change = this.endpoints.remove(relation.getSource(), endpoint) || change;
                }
            }
        }
        ObserveHealth observeHealth = this.observeHealth;
        if (change && observeHealth != null) {
            observeHealth.setObserveRelations(this.relations.size());
            observeHealth.setObserveEndpoints(this.endpoints.size());
        }
    }

    public int getNumberOfEndpoints() {
        return this.endpoints.size();
    }

    public int getNumberOfObserverRelations() {
        return this.relations.size();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isFull() {
        return this.maxObserves > 0 && this.relations.size() >= this.maxObserves;
    }
}

