//go:build !ignore_autogenerated

// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by controller-gen. DO NOT EDIT.

package v1alpha1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerConfig) DeepCopyInto(out *AlertmanagerConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerConfig.
func (in *AlertmanagerConfig) DeepCopy() *AlertmanagerConfig {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerConfigList) DeepCopyInto(out *AlertmanagerConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]*AlertmanagerConfig, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(AlertmanagerConfig)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerConfigList.
func (in *AlertmanagerConfigList) DeepCopy() *AlertmanagerConfigList {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AlertmanagerConfigSpec) DeepCopyInto(out *AlertmanagerConfigSpec) {
	*out = *in
	if in.Route != nil {
		in, out := &in.Route, &out.Route
		*out = new(Route)
		(*in).DeepCopyInto(*out)
	}
	if in.Receivers != nil {
		in, out := &in.Receivers, &out.Receivers
		*out = make([]Receiver, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.InhibitRules != nil {
		in, out := &in.InhibitRules, &out.InhibitRules
		*out = make([]InhibitRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MuteTimeIntervals != nil {
		in, out := &in.MuteTimeIntervals, &out.MuteTimeIntervals
		*out = make([]MuteTimeInterval, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AlertmanagerConfigSpec.
func (in *AlertmanagerConfigSpec) DeepCopy() *AlertmanagerConfigSpec {
	if in == nil {
		return nil
	}
	out := new(AlertmanagerConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AttachMetadata) DeepCopyInto(out *AttachMetadata) {
	*out = *in
	if in.Node != nil {
		in, out := &in.Node, &out.Node
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AttachMetadata.
func (in *AttachMetadata) DeepCopy() *AttachMetadata {
	if in == nil {
		return nil
	}
	out := new(AttachMetadata)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AzureSDConfig) DeepCopyInto(out *AzureSDConfig) {
	*out = *in
	if in.Environment != nil {
		in, out := &in.Environment, &out.Environment
		*out = new(string)
		**out = **in
	}
	if in.AuthenticationMethod != nil {
		in, out := &in.AuthenticationMethod, &out.AuthenticationMethod
		*out = new(string)
		**out = **in
	}
	if in.TenantID != nil {
		in, out := &in.TenantID, &out.TenantID
		*out = new(string)
		**out = **in
	}
	if in.ClientID != nil {
		in, out := &in.ClientID, &out.ClientID
		*out = new(string)
		**out = **in
	}
	if in.ClientSecret != nil {
		in, out := &in.ClientSecret, &out.ClientSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ResourceGroup != nil {
		in, out := &in.ResourceGroup, &out.ResourceGroup
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AzureSDConfig.
func (in *AzureSDConfig) DeepCopy() *AzureSDConfig {
	if in == nil {
		return nil
	}
	out := new(AzureSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ConsulSDConfig) DeepCopyInto(out *ConsulSDConfig) {
	*out = *in
	if in.PathPrefix != nil {
		in, out := &in.PathPrefix, &out.PathPrefix
		*out = new(string)
		**out = **in
	}
	if in.TokenRef != nil {
		in, out := &in.TokenRef, &out.TokenRef
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Datacenter != nil {
		in, out := &in.Datacenter, &out.Datacenter
		*out = new(string)
		**out = **in
	}
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
	if in.Partition != nil {
		in, out := &in.Partition, &out.Partition
		*out = new(string)
		**out = **in
	}
	if in.Scheme != nil {
		in, out := &in.Scheme, &out.Scheme
		*out = new(string)
		**out = **in
	}
	if in.Services != nil {
		in, out := &in.Services, &out.Services
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Tags != nil {
		in, out := &in.Tags, &out.Tags
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.TagSeparator != nil {
		in, out := &in.TagSeparator, &out.TagSeparator
		*out = new(string)
		**out = **in
	}
	if in.NodeMeta != nil {
		in, out := &in.NodeMeta, &out.NodeMeta
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Filter != nil {
		in, out := &in.Filter, &out.Filter
		*out = new(string)
		**out = **in
	}
	if in.AllowStale != nil {
		in, out := &in.AllowStale, &out.AllowStale
		*out = new(bool)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHttp2 != nil {
		in, out := &in.EnableHttp2, &out.EnableHttp2
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ConsulSDConfig.
func (in *ConsulSDConfig) DeepCopy() *ConsulSDConfig {
	if in == nil {
		return nil
	}
	out := new(ConsulSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNSSDConfig) DeepCopyInto(out *DNSSDConfig) {
	*out = *in
	if in.Names != nil {
		in, out := &in.Names, &out.Names
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Type != nil {
		in, out := &in.Type, &out.Type
		*out = new(DNSRecordType)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNSSDConfig.
func (in *DNSSDConfig) DeepCopy() *DNSSDConfig {
	if in == nil {
		return nil
	}
	out := new(DNSSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DayOfMonthRange) DeepCopyInto(out *DayOfMonthRange) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DayOfMonthRange.
func (in *DayOfMonthRange) DeepCopy() *DayOfMonthRange {
	if in == nil {
		return nil
	}
	out := new(DayOfMonthRange)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DigitalOceanSDConfig) DeepCopyInto(out *DigitalOceanSDConfig) {
	*out = *in
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DigitalOceanSDConfig.
func (in *DigitalOceanSDConfig) DeepCopy() *DigitalOceanSDConfig {
	if in == nil {
		return nil
	}
	out := new(DigitalOceanSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DiscordConfig) DeepCopyInto(out *DiscordConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	in.APIURL.DeepCopyInto(&out.APIURL)
	if in.Title != nil {
		in, out := &in.Title, &out.Title
		*out = new(string)
		**out = **in
	}
	if in.Message != nil {
		in, out := &in.Message, &out.Message
		*out = new(string)
		**out = **in
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DiscordConfig.
func (in *DiscordConfig) DeepCopy() *DiscordConfig {
	if in == nil {
		return nil
	}
	out := new(DiscordConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerSDConfig) DeepCopyInto(out *DockerSDConfig) {
	*out = *in
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int)
		**out = **in
	}
	if in.HostNetworkingHost != nil {
		in, out := &in.HostNetworkingHost, &out.HostNetworkingHost
		*out = new(string)
		**out = **in
	}
	if in.MatchFirstNetwork != nil {
		in, out := &in.MatchFirstNetwork, &out.MatchFirstNetwork
		*out = new(bool)
		**out = **in
	}
	if in.Filters != nil {
		in, out := &in.Filters, &out.Filters
		*out = make(Filters, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerSDConfig.
func (in *DockerSDConfig) DeepCopy() *DockerSDConfig {
	if in == nil {
		return nil
	}
	out := new(DockerSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerSwarmSDConfig) DeepCopyInto(out *DockerSwarmSDConfig) {
	*out = *in
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.Filters != nil {
		in, out := &in.Filters, &out.Filters
		*out = make(Filters, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerSwarmSDConfig.
func (in *DockerSwarmSDConfig) DeepCopy() *DockerSwarmSDConfig {
	if in == nil {
		return nil
	}
	out := new(DockerSwarmSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EC2SDConfig) DeepCopyInto(out *EC2SDConfig) {
	*out = *in
	if in.Region != nil {
		in, out := &in.Region, &out.Region
		*out = new(string)
		**out = **in
	}
	if in.AccessKey != nil {
		in, out := &in.AccessKey, &out.AccessKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretKey != nil {
		in, out := &in.SecretKey, &out.SecretKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RoleARN != nil {
		in, out := &in.RoleARN, &out.RoleARN
		*out = new(string)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Filters != nil {
		in, out := &in.Filters, &out.Filters
		*out = make(Filters, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EC2SDConfig.
func (in *EC2SDConfig) DeepCopy() *EC2SDConfig {
	if in == nil {
		return nil
	}
	out := new(EC2SDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EmailConfig) DeepCopyInto(out *EmailConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.AuthPassword != nil {
		in, out := &in.AuthPassword, &out.AuthPassword
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AuthSecret != nil {
		in, out := &in.AuthSecret, &out.AuthSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Headers != nil {
		in, out := &in.Headers, &out.Headers
		*out = make([]KeyValue, len(*in))
		copy(*out, *in)
	}
	if in.HTML != nil {
		in, out := &in.HTML, &out.HTML
		*out = new(string)
		**out = **in
	}
	if in.Text != nil {
		in, out := &in.Text, &out.Text
		*out = new(string)
		**out = **in
	}
	if in.RequireTLS != nil {
		in, out := &in.RequireTLS, &out.RequireTLS
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EmailConfig.
func (in *EmailConfig) DeepCopy() *EmailConfig {
	if in == nil {
		return nil
	}
	out := new(EmailConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EurekaSDConfig) DeepCopyInto(out *EurekaSDConfig) {
	*out = *in
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EurekaSDConfig.
func (in *EurekaSDConfig) DeepCopy() *EurekaSDConfig {
	if in == nil {
		return nil
	}
	out := new(EurekaSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FileSDConfig) DeepCopyInto(out *FileSDConfig) {
	*out = *in
	if in.Files != nil {
		in, out := &in.Files, &out.Files
		*out = make([]SDFile, len(*in))
		copy(*out, *in)
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FileSDConfig.
func (in *FileSDConfig) DeepCopy() *FileSDConfig {
	if in == nil {
		return nil
	}
	out := new(FileSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Filter) DeepCopyInto(out *Filter) {
	*out = *in
	if in.Values != nil {
		in, out := &in.Values, &out.Values
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Filter.
func (in *Filter) DeepCopy() *Filter {
	if in == nil {
		return nil
	}
	out := new(Filter)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in Filters) DeepCopyInto(out *Filters) {
	{
		in := &in
		*out = make(Filters, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Filters.
func (in Filters) DeepCopy() Filters {
	if in == nil {
		return nil
	}
	out := new(Filters)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GCESDConfig) DeepCopyInto(out *GCESDConfig) {
	*out = *in
	if in.Filter != nil {
		in, out := &in.Filter, &out.Filter
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int)
		**out = **in
	}
	if in.TagSeparator != nil {
		in, out := &in.TagSeparator, &out.TagSeparator
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GCESDConfig.
func (in *GCESDConfig) DeepCopy() *GCESDConfig {
	if in == nil {
		return nil
	}
	out := new(GCESDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPConfig) DeepCopyInto(out *HTTPConfig) {
	*out = *in
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.BearerTokenSecret != nil {
		in, out := &in.BearerTokenSecret, &out.BearerTokenSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.ProxyURLOriginal != nil {
		in, out := &in.ProxyURLOriginal, &out.ProxyURLOriginal
		*out = new(string)
		**out = **in
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPConfig.
func (in *HTTPConfig) DeepCopy() *HTTPConfig {
	if in == nil {
		return nil
	}
	out := new(HTTPConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HTTPSDConfig) DeepCopyInto(out *HTTPSDConfig) {
	*out = *in
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HTTPSDConfig.
func (in *HTTPSDConfig) DeepCopy() *HTTPSDConfig {
	if in == nil {
		return nil
	}
	out := new(HTTPSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HetznerSDConfig) DeepCopyInto(out *HetznerSDConfig) {
	*out = *in
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HetznerSDConfig.
func (in *HetznerSDConfig) DeepCopy() *HetznerSDConfig {
	if in == nil {
		return nil
	}
	out := new(HetznerSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *InhibitRule) DeepCopyInto(out *InhibitRule) {
	*out = *in
	if in.TargetMatch != nil {
		in, out := &in.TargetMatch, &out.TargetMatch
		*out = make([]Matcher, len(*in))
		copy(*out, *in)
	}
	if in.SourceMatch != nil {
		in, out := &in.SourceMatch, &out.SourceMatch
		*out = make([]Matcher, len(*in))
		copy(*out, *in)
	}
	if in.Equal != nil {
		in, out := &in.Equal, &out.Equal
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new InhibitRule.
func (in *InhibitRule) DeepCopy() *InhibitRule {
	if in == nil {
		return nil
	}
	out := new(InhibitRule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IonosSDConfig) DeepCopyInto(out *IonosSDConfig) {
	*out = *in
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	in.Authorization.DeepCopyInto(&out.Authorization)
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IonosSDConfig.
func (in *IonosSDConfig) DeepCopy() *IonosSDConfig {
	if in == nil {
		return nil
	}
	out := new(IonosSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *K8SSelectorConfig) DeepCopyInto(out *K8SSelectorConfig) {
	*out = *in
	if in.Label != nil {
		in, out := &in.Label, &out.Label
		*out = new(string)
		**out = **in
	}
	if in.Field != nil {
		in, out := &in.Field, &out.Field
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new K8SSelectorConfig.
func (in *K8SSelectorConfig) DeepCopy() *K8SSelectorConfig {
	if in == nil {
		return nil
	}
	out := new(K8SSelectorConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeyValue) DeepCopyInto(out *KeyValue) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeyValue.
func (in *KeyValue) DeepCopy() *KeyValue {
	if in == nil {
		return nil
	}
	out := new(KeyValue)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KubernetesSDConfig) DeepCopyInto(out *KubernetesSDConfig) {
	*out = *in
	if in.APIServer != nil {
		in, out := &in.APIServer, &out.APIServer
		*out = new(string)
		**out = **in
	}
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = new(NamespaceDiscovery)
		(*in).DeepCopyInto(*out)
	}
	if in.AttachMetadata != nil {
		in, out := &in.AttachMetadata, &out.AttachMetadata
		*out = new(AttachMetadata)
		(*in).DeepCopyInto(*out)
	}
	if in.Selectors != nil {
		in, out := &in.Selectors, &out.Selectors
		*out = make([]K8SSelectorConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KubernetesSDConfig.
func (in *KubernetesSDConfig) DeepCopy() *KubernetesSDConfig {
	if in == nil {
		return nil
	}
	out := new(KubernetesSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KumaSDConfig) DeepCopyInto(out *KumaSDConfig) {
	*out = *in
	if in.ClientID != nil {
		in, out := &in.ClientID, &out.ClientID
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.FetchTimeout != nil {
		in, out := &in.FetchTimeout, &out.FetchTimeout
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KumaSDConfig.
func (in *KumaSDConfig) DeepCopy() *KumaSDConfig {
	if in == nil {
		return nil
	}
	out := new(KumaSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LightSailSDConfig) DeepCopyInto(out *LightSailSDConfig) {
	*out = *in
	if in.Region != nil {
		in, out := &in.Region, &out.Region
		*out = new(string)
		**out = **in
	}
	if in.AccessKey != nil {
		in, out := &in.AccessKey, &out.AccessKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.SecretKey != nil {
		in, out := &in.SecretKey, &out.SecretKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.RoleARN != nil {
		in, out := &in.RoleARN, &out.RoleARN
		*out = new(string)
		**out = **in
	}
	if in.Endpoint != nil {
		in, out := &in.Endpoint, &out.Endpoint
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LightSailSDConfig.
func (in *LightSailSDConfig) DeepCopy() *LightSailSDConfig {
	if in == nil {
		return nil
	}
	out := new(LightSailSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LinodeSDConfig) DeepCopyInto(out *LinodeSDConfig) {
	*out = *in
	if in.Region != nil {
		in, out := &in.Region, &out.Region
		*out = new(string)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.TagSeparator != nil {
		in, out := &in.TagSeparator, &out.TagSeparator
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LinodeSDConfig.
func (in *LinodeSDConfig) DeepCopy() *LinodeSDConfig {
	if in == nil {
		return nil
	}
	out := new(LinodeSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MSTeamsConfig) DeepCopyInto(out *MSTeamsConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	in.WebhookURL.DeepCopyInto(&out.WebhookURL)
	if in.Title != nil {
		in, out := &in.Title, &out.Title
		*out = new(string)
		**out = **in
	}
	if in.Summary != nil {
		in, out := &in.Summary, &out.Summary
		*out = new(string)
		**out = **in
	}
	if in.Text != nil {
		in, out := &in.Text, &out.Text
		*out = new(string)
		**out = **in
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MSTeamsConfig.
func (in *MSTeamsConfig) DeepCopy() *MSTeamsConfig {
	if in == nil {
		return nil
	}
	out := new(MSTeamsConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Matcher) DeepCopyInto(out *Matcher) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Matcher.
func (in *Matcher) DeepCopy() *Matcher {
	if in == nil {
		return nil
	}
	out := new(Matcher)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MuteTimeInterval) DeepCopyInto(out *MuteTimeInterval) {
	*out = *in
	if in.TimeIntervals != nil {
		in, out := &in.TimeIntervals, &out.TimeIntervals
		*out = make([]TimeInterval, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MuteTimeInterval.
func (in *MuteTimeInterval) DeepCopy() *MuteTimeInterval {
	if in == nil {
		return nil
	}
	out := new(MuteTimeInterval)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NamespaceDiscovery) DeepCopyInto(out *NamespaceDiscovery) {
	*out = *in
	if in.IncludeOwnNamespace != nil {
		in, out := &in.IncludeOwnNamespace, &out.IncludeOwnNamespace
		*out = new(bool)
		**out = **in
	}
	if in.Names != nil {
		in, out := &in.Names, &out.Names
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NamespaceDiscovery.
func (in *NamespaceDiscovery) DeepCopy() *NamespaceDiscovery {
	if in == nil {
		return nil
	}
	out := new(NamespaceDiscovery)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NomadSDConfig) DeepCopyInto(out *NomadSDConfig) {
	*out = *in
	if in.AllowStale != nil {
		in, out := &in.AllowStale, &out.AllowStale
		*out = new(bool)
		**out = **in
	}
	if in.Namespace != nil {
		in, out := &in.Namespace, &out.Namespace
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Region != nil {
		in, out := &in.Region, &out.Region
		*out = new(string)
		**out = **in
	}
	if in.TagSeparator != nil {
		in, out := &in.TagSeparator, &out.TagSeparator
		*out = new(string)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NomadSDConfig.
func (in *NomadSDConfig) DeepCopy() *NomadSDConfig {
	if in == nil {
		return nil
	}
	out := new(NomadSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OVHCloudSDConfig) DeepCopyInto(out *OVHCloudSDConfig) {
	*out = *in
	in.ApplicationSecret.DeepCopyInto(&out.ApplicationSecret)
	in.ConsumerKey.DeepCopyInto(&out.ConsumerKey)
	if in.Endpoint != nil {
		in, out := &in.Endpoint, &out.Endpoint
		*out = new(string)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OVHCloudSDConfig.
func (in *OVHCloudSDConfig) DeepCopy() *OVHCloudSDConfig {
	if in == nil {
		return nil
	}
	out := new(OVHCloudSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpenStackSDConfig) DeepCopyInto(out *OpenStackSDConfig) {
	*out = *in
	if in.IdentityEndpoint != nil {
		in, out := &in.IdentityEndpoint, &out.IdentityEndpoint
		*out = new(string)
		**out = **in
	}
	if in.Username != nil {
		in, out := &in.Username, &out.Username
		*out = new(string)
		**out = **in
	}
	if in.UserID != nil {
		in, out := &in.UserID, &out.UserID
		*out = new(string)
		**out = **in
	}
	if in.Password != nil {
		in, out := &in.Password, &out.Password
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.DomainName != nil {
		in, out := &in.DomainName, &out.DomainName
		*out = new(string)
		**out = **in
	}
	if in.DomainID != nil {
		in, out := &in.DomainID, &out.DomainID
		*out = new(string)
		**out = **in
	}
	if in.ProjectName != nil {
		in, out := &in.ProjectName, &out.ProjectName
		*out = new(string)
		**out = **in
	}
	if in.ProjectID != nil {
		in, out := &in.ProjectID, &out.ProjectID
		*out = new(string)
		**out = **in
	}
	if in.ApplicationCredentialName != nil {
		in, out := &in.ApplicationCredentialName, &out.ApplicationCredentialName
		*out = new(string)
		**out = **in
	}
	if in.ApplicationCredentialID != nil {
		in, out := &in.ApplicationCredentialID, &out.ApplicationCredentialID
		*out = new(string)
		**out = **in
	}
	if in.ApplicationCredentialSecret != nil {
		in, out := &in.ApplicationCredentialSecret, &out.ApplicationCredentialSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.AllTenants != nil {
		in, out := &in.AllTenants, &out.AllTenants
		*out = new(bool)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int)
		**out = **in
	}
	if in.Availability != nil {
		in, out := &in.Availability, &out.Availability
		*out = new(string)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpenStackSDConfig.
func (in *OpenStackSDConfig) DeepCopy() *OpenStackSDConfig {
	if in == nil {
		return nil
	}
	out := new(OpenStackSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpsGenieConfig) DeepCopyInto(out *OpsGenieConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.UpdateAlerts != nil {
		in, out := &in.UpdateAlerts, &out.UpdateAlerts
		*out = new(bool)
		**out = **in
	}
	if in.Details != nil {
		in, out := &in.Details, &out.Details
		*out = make([]KeyValue, len(*in))
		copy(*out, *in)
	}
	if in.Responders != nil {
		in, out := &in.Responders, &out.Responders
		*out = make([]OpsGenieConfigResponder, len(*in))
		copy(*out, *in)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpsGenieConfig.
func (in *OpsGenieConfig) DeepCopy() *OpsGenieConfig {
	if in == nil {
		return nil
	}
	out := new(OpsGenieConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OpsGenieConfigResponder) DeepCopyInto(out *OpsGenieConfigResponder) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OpsGenieConfigResponder.
func (in *OpsGenieConfigResponder) DeepCopy() *OpsGenieConfigResponder {
	if in == nil {
		return nil
	}
	out := new(OpsGenieConfigResponder)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PagerDutyConfig) DeepCopyInto(out *PagerDutyConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.RoutingKey != nil {
		in, out := &in.RoutingKey, &out.RoutingKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.ServiceKey != nil {
		in, out := &in.ServiceKey, &out.ServiceKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Details != nil {
		in, out := &in.Details, &out.Details
		*out = make([]KeyValue, len(*in))
		copy(*out, *in)
	}
	if in.PagerDutyImageConfigs != nil {
		in, out := &in.PagerDutyImageConfigs, &out.PagerDutyImageConfigs
		*out = make([]PagerDutyImageConfig, len(*in))
		copy(*out, *in)
	}
	if in.PagerDutyLinkConfigs != nil {
		in, out := &in.PagerDutyLinkConfigs, &out.PagerDutyLinkConfigs
		*out = make([]PagerDutyLinkConfig, len(*in))
		copy(*out, *in)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Source != nil {
		in, out := &in.Source, &out.Source
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PagerDutyConfig.
func (in *PagerDutyConfig) DeepCopy() *PagerDutyConfig {
	if in == nil {
		return nil
	}
	out := new(PagerDutyConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PagerDutyImageConfig) DeepCopyInto(out *PagerDutyImageConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PagerDutyImageConfig.
func (in *PagerDutyImageConfig) DeepCopy() *PagerDutyImageConfig {
	if in == nil {
		return nil
	}
	out := new(PagerDutyImageConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PagerDutyLinkConfig) DeepCopyInto(out *PagerDutyLinkConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PagerDutyLinkConfig.
func (in *PagerDutyLinkConfig) DeepCopy() *PagerDutyLinkConfig {
	if in == nil {
		return nil
	}
	out := new(PagerDutyLinkConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusAgent) DeepCopyInto(out *PrometheusAgent) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusAgent.
func (in *PrometheusAgent) DeepCopy() *PrometheusAgent {
	if in == nil {
		return nil
	}
	out := new(PrometheusAgent)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusAgentList) DeepCopyInto(out *PrometheusAgentList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]*PrometheusAgent, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(PrometheusAgent)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusAgentList.
func (in *PrometheusAgentList) DeepCopy() *PrometheusAgentList {
	if in == nil {
		return nil
	}
	out := new(PrometheusAgentList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PrometheusAgentSpec) DeepCopyInto(out *PrometheusAgentSpec) {
	*out = *in
	if in.Mode != nil {
		in, out := &in.Mode, &out.Mode
		*out = new(string)
		**out = **in
	}
	in.CommonPrometheusFields.DeepCopyInto(&out.CommonPrometheusFields)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PrometheusAgentSpec.
func (in *PrometheusAgentSpec) DeepCopy() *PrometheusAgentSpec {
	if in == nil {
		return nil
	}
	out := new(PrometheusAgentSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PuppetDBSDConfig) DeepCopyInto(out *PuppetDBSDConfig) {
	*out = *in
	if in.IncludeParameters != nil {
		in, out := &in.IncludeParameters, &out.IncludeParameters
		*out = new(bool)
		**out = **in
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PuppetDBSDConfig.
func (in *PuppetDBSDConfig) DeepCopy() *PuppetDBSDConfig {
	if in == nil {
		return nil
	}
	out := new(PuppetDBSDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PushoverConfig) DeepCopyInto(out *PushoverConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.UserKey != nil {
		in, out := &in.UserKey, &out.UserKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.UserKeyFile != nil {
		in, out := &in.UserKeyFile, &out.UserKeyFile
		*out = new(string)
		**out = **in
	}
	if in.Token != nil {
		in, out := &in.Token, &out.Token
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.TokenFile != nil {
		in, out := &in.TokenFile, &out.TokenFile
		*out = new(string)
		**out = **in
	}
	if in.TTL != nil {
		in, out := &in.TTL, &out.TTL
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.Device != nil {
		in, out := &in.Device, &out.Device
		*out = new(string)
		**out = **in
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PushoverConfig.
func (in *PushoverConfig) DeepCopy() *PushoverConfig {
	if in == nil {
		return nil
	}
	out := new(PushoverConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Receiver) DeepCopyInto(out *Receiver) {
	*out = *in
	if in.OpsGenieConfigs != nil {
		in, out := &in.OpsGenieConfigs, &out.OpsGenieConfigs
		*out = make([]OpsGenieConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PagerDutyConfigs != nil {
		in, out := &in.PagerDutyConfigs, &out.PagerDutyConfigs
		*out = make([]PagerDutyConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DiscordConfigs != nil {
		in, out := &in.DiscordConfigs, &out.DiscordConfigs
		*out = make([]DiscordConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SlackConfigs != nil {
		in, out := &in.SlackConfigs, &out.SlackConfigs
		*out = make([]SlackConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.WebhookConfigs != nil {
		in, out := &in.WebhookConfigs, &out.WebhookConfigs
		*out = make([]WebhookConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.WeChatConfigs != nil {
		in, out := &in.WeChatConfigs, &out.WeChatConfigs
		*out = make([]WeChatConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EmailConfigs != nil {
		in, out := &in.EmailConfigs, &out.EmailConfigs
		*out = make([]EmailConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VictorOpsConfigs != nil {
		in, out := &in.VictorOpsConfigs, &out.VictorOpsConfigs
		*out = make([]VictorOpsConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PushoverConfigs != nil {
		in, out := &in.PushoverConfigs, &out.PushoverConfigs
		*out = make([]PushoverConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.SNSConfigs != nil {
		in, out := &in.SNSConfigs, &out.SNSConfigs
		*out = make([]SNSConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TelegramConfigs != nil {
		in, out := &in.TelegramConfigs, &out.TelegramConfigs
		*out = make([]TelegramConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.WebexConfigs != nil {
		in, out := &in.WebexConfigs, &out.WebexConfigs
		*out = make([]WebexConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MSTeamsConfigs != nil {
		in, out := &in.MSTeamsConfigs, &out.MSTeamsConfigs
		*out = make([]MSTeamsConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Receiver.
func (in *Receiver) DeepCopy() *Receiver {
	if in == nil {
		return nil
	}
	out := new(Receiver)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Route) DeepCopyInto(out *Route) {
	*out = *in
	if in.GroupBy != nil {
		in, out := &in.GroupBy, &out.GroupBy
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Matchers != nil {
		in, out := &in.Matchers, &out.Matchers
		*out = make([]Matcher, len(*in))
		copy(*out, *in)
	}
	if in.Routes != nil {
		in, out := &in.Routes, &out.Routes
		*out = make([]v1.JSON, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MuteTimeIntervals != nil {
		in, out := &in.MuteTimeIntervals, &out.MuteTimeIntervals
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ActiveTimeIntervals != nil {
		in, out := &in.ActiveTimeIntervals, &out.ActiveTimeIntervals
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Route.
func (in *Route) DeepCopy() *Route {
	if in == nil {
		return nil
	}
	out := new(Route)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SNSConfig) DeepCopyInto(out *SNSConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.Sigv4 != nil {
		in, out := &in.Sigv4, &out.Sigv4
		*out = new(monitoringv1.Sigv4)
		(*in).DeepCopyInto(*out)
	}
	if in.Attributes != nil {
		in, out := &in.Attributes, &out.Attributes
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SNSConfig.
func (in *SNSConfig) DeepCopy() *SNSConfig {
	if in == nil {
		return nil
	}
	out := new(SNSConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScalewaySDConfig) DeepCopyInto(out *ScalewaySDConfig) {
	*out = *in
	in.SecretKey.DeepCopyInto(&out.SecretKey)
	if in.Port != nil {
		in, out := &in.Port, &out.Port
		*out = new(int32)
		**out = **in
	}
	if in.ApiURL != nil {
		in, out := &in.ApiURL, &out.ApiURL
		*out = new(string)
		**out = **in
	}
	if in.Zone != nil {
		in, out := &in.Zone, &out.Zone
		*out = new(string)
		**out = **in
	}
	if in.NameFilter != nil {
		in, out := &in.NameFilter, &out.NameFilter
		*out = new(string)
		**out = **in
	}
	if in.TagsFilter != nil {
		in, out := &in.TagsFilter, &out.TagsFilter
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.RefreshInterval != nil {
		in, out := &in.RefreshInterval, &out.RefreshInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.FollowRedirects != nil {
		in, out := &in.FollowRedirects, &out.FollowRedirects
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScalewaySDConfig.
func (in *ScalewaySDConfig) DeepCopy() *ScalewaySDConfig {
	if in == nil {
		return nil
	}
	out := new(ScalewaySDConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScrapeConfig) DeepCopyInto(out *ScrapeConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScrapeConfig.
func (in *ScrapeConfig) DeepCopy() *ScrapeConfig {
	if in == nil {
		return nil
	}
	out := new(ScrapeConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScrapeConfigList) DeepCopyInto(out *ScrapeConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]*ScrapeConfig, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(ScrapeConfig)
				(*in).DeepCopyInto(*out)
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScrapeConfigList.
func (in *ScrapeConfigList) DeepCopy() *ScrapeConfigList {
	if in == nil {
		return nil
	}
	out := new(ScrapeConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ScrapeConfigSpec) DeepCopyInto(out *ScrapeConfigSpec) {
	*out = *in
	if in.JobName != nil {
		in, out := &in.JobName, &out.JobName
		*out = new(string)
		**out = **in
	}
	if in.StaticConfigs != nil {
		in, out := &in.StaticConfigs, &out.StaticConfigs
		*out = make([]StaticConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.FileSDConfigs != nil {
		in, out := &in.FileSDConfigs, &out.FileSDConfigs
		*out = make([]FileSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.HTTPSDConfigs != nil {
		in, out := &in.HTTPSDConfigs, &out.HTTPSDConfigs
		*out = make([]HTTPSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.KubernetesSDConfigs != nil {
		in, out := &in.KubernetesSDConfigs, &out.KubernetesSDConfigs
		*out = make([]KubernetesSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ConsulSDConfigs != nil {
		in, out := &in.ConsulSDConfigs, &out.ConsulSDConfigs
		*out = make([]ConsulSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DNSSDConfigs != nil {
		in, out := &in.DNSSDConfigs, &out.DNSSDConfigs
		*out = make([]DNSSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EC2SDConfigs != nil {
		in, out := &in.EC2SDConfigs, &out.EC2SDConfigs
		*out = make([]EC2SDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AzureSDConfigs != nil {
		in, out := &in.AzureSDConfigs, &out.AzureSDConfigs
		*out = make([]AzureSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.GCESDConfigs != nil {
		in, out := &in.GCESDConfigs, &out.GCESDConfigs
		*out = make([]GCESDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.OpenStackSDConfigs != nil {
		in, out := &in.OpenStackSDConfigs, &out.OpenStackSDConfigs
		*out = make([]OpenStackSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DigitalOceanSDConfigs != nil {
		in, out := &in.DigitalOceanSDConfigs, &out.DigitalOceanSDConfigs
		*out = make([]DigitalOceanSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.KumaSDConfigs != nil {
		in, out := &in.KumaSDConfigs, &out.KumaSDConfigs
		*out = make([]KumaSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.EurekaSDConfigs != nil {
		in, out := &in.EurekaSDConfigs, &out.EurekaSDConfigs
		*out = make([]EurekaSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DockerSDConfigs != nil {
		in, out := &in.DockerSDConfigs, &out.DockerSDConfigs
		*out = make([]DockerSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LinodeSDConfigs != nil {
		in, out := &in.LinodeSDConfigs, &out.LinodeSDConfigs
		*out = make([]LinodeSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.HetznerSDConfigs != nil {
		in, out := &in.HetznerSDConfigs, &out.HetznerSDConfigs
		*out = make([]HetznerSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.NomadSDConfigs != nil {
		in, out := &in.NomadSDConfigs, &out.NomadSDConfigs
		*out = make([]NomadSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.DockerSwarmSDConfigs != nil {
		in, out := &in.DockerSwarmSDConfigs, &out.DockerSwarmSDConfigs
		*out = make([]DockerSwarmSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.PuppetDBSDConfigs != nil {
		in, out := &in.PuppetDBSDConfigs, &out.PuppetDBSDConfigs
		*out = make([]PuppetDBSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.LightSailSDConfigs != nil {
		in, out := &in.LightSailSDConfigs, &out.LightSailSDConfigs
		*out = make([]LightSailSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.OVHCloudSDConfigs != nil {
		in, out := &in.OVHCloudSDConfigs, &out.OVHCloudSDConfigs
		*out = make([]OVHCloudSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.ScalewaySDConfigs != nil {
		in, out := &in.ScalewaySDConfigs, &out.ScalewaySDConfigs
		*out = make([]ScalewaySDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.IonosSDConfigs != nil {
		in, out := &in.IonosSDConfigs, &out.IonosSDConfigs
		*out = make([]IonosSDConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.RelabelConfigs != nil {
		in, out := &in.RelabelConfigs, &out.RelabelConfigs
		*out = make([]monitoringv1.RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MetricsPath != nil {
		in, out := &in.MetricsPath, &out.MetricsPath
		*out = new(string)
		**out = **in
	}
	if in.ScrapeInterval != nil {
		in, out := &in.ScrapeInterval, &out.ScrapeInterval
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.ScrapeTimeout != nil {
		in, out := &in.ScrapeTimeout, &out.ScrapeTimeout
		*out = new(monitoringv1.Duration)
		**out = **in
	}
	if in.ScrapeProtocols != nil {
		in, out := &in.ScrapeProtocols, &out.ScrapeProtocols
		*out = make([]monitoringv1.ScrapeProtocol, len(*in))
		copy(*out, *in)
	}
	if in.FallbackScrapeProtocol != nil {
		in, out := &in.FallbackScrapeProtocol, &out.FallbackScrapeProtocol
		*out = new(monitoringv1.ScrapeProtocol)
		**out = **in
	}
	if in.HonorTimestamps != nil {
		in, out := &in.HonorTimestamps, &out.HonorTimestamps
		*out = new(bool)
		**out = **in
	}
	if in.TrackTimestampsStaleness != nil {
		in, out := &in.TrackTimestampsStaleness, &out.TrackTimestampsStaleness
		*out = new(bool)
		**out = **in
	}
	if in.HonorLabels != nil {
		in, out := &in.HonorLabels, &out.HonorLabels
		*out = new(bool)
		**out = **in
	}
	if in.Params != nil {
		in, out := &in.Params, &out.Params
		*out = make(map[string][]string, len(*in))
		for key, val := range *in {
			var outVal []string
			if val == nil {
				(*out)[key] = nil
			} else {
				inVal := (*in)[key]
				in, out := &inVal, &outVal
				*out = make([]string, len(*in))
				copy(*out, *in)
			}
			(*out)[key] = outVal
		}
	}
	if in.Scheme != nil {
		in, out := &in.Scheme, &out.Scheme
		*out = new(string)
		**out = **in
	}
	if in.EnableCompression != nil {
		in, out := &in.EnableCompression, &out.EnableCompression
		*out = new(bool)
		**out = **in
	}
	if in.EnableHTTP2 != nil {
		in, out := &in.EnableHTTP2, &out.EnableHTTP2
		*out = new(bool)
		**out = **in
	}
	if in.BasicAuth != nil {
		in, out := &in.BasicAuth, &out.BasicAuth
		*out = new(monitoringv1.BasicAuth)
		(*in).DeepCopyInto(*out)
	}
	if in.Authorization != nil {
		in, out := &in.Authorization, &out.Authorization
		*out = new(monitoringv1.SafeAuthorization)
		(*in).DeepCopyInto(*out)
	}
	if in.OAuth2 != nil {
		in, out := &in.OAuth2, &out.OAuth2
		*out = new(monitoringv1.OAuth2)
		(*in).DeepCopyInto(*out)
	}
	if in.TLSConfig != nil {
		in, out := &in.TLSConfig, &out.TLSConfig
		*out = new(monitoringv1.SafeTLSConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.SampleLimit != nil {
		in, out := &in.SampleLimit, &out.SampleLimit
		*out = new(uint64)
		**out = **in
	}
	if in.TargetLimit != nil {
		in, out := &in.TargetLimit, &out.TargetLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelLimit != nil {
		in, out := &in.LabelLimit, &out.LabelLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelNameLengthLimit != nil {
		in, out := &in.LabelNameLengthLimit, &out.LabelNameLengthLimit
		*out = new(uint64)
		**out = **in
	}
	if in.LabelValueLengthLimit != nil {
		in, out := &in.LabelValueLengthLimit, &out.LabelValueLengthLimit
		*out = new(uint64)
		**out = **in
	}
	in.NativeHistogramConfig.DeepCopyInto(&out.NativeHistogramConfig)
	if in.KeepDroppedTargets != nil {
		in, out := &in.KeepDroppedTargets, &out.KeepDroppedTargets
		*out = new(uint64)
		**out = **in
	}
	if in.MetricRelabelConfigs != nil {
		in, out := &in.MetricRelabelConfigs, &out.MetricRelabelConfigs
		*out = make([]monitoringv1.RelabelConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.ProxyConfig.DeepCopyInto(&out.ProxyConfig)
	if in.ScrapeClassName != nil {
		in, out := &in.ScrapeClassName, &out.ScrapeClassName
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ScrapeConfigSpec.
func (in *ScrapeConfigSpec) DeepCopy() *ScrapeConfigSpec {
	if in == nil {
		return nil
	}
	out := new(ScrapeConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SlackAction) DeepCopyInto(out *SlackAction) {
	*out = *in
	if in.ConfirmField != nil {
		in, out := &in.ConfirmField, &out.ConfirmField
		*out = new(SlackConfirmationField)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SlackAction.
func (in *SlackAction) DeepCopy() *SlackAction {
	if in == nil {
		return nil
	}
	out := new(SlackAction)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SlackConfig) DeepCopyInto(out *SlackConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Fields != nil {
		in, out := &in.Fields, &out.Fields
		*out = make([]SlackField, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MrkdwnIn != nil {
		in, out := &in.MrkdwnIn, &out.MrkdwnIn
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.Actions != nil {
		in, out := &in.Actions, &out.Actions
		*out = make([]SlackAction, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SlackConfig.
func (in *SlackConfig) DeepCopy() *SlackConfig {
	if in == nil {
		return nil
	}
	out := new(SlackConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SlackConfirmationField) DeepCopyInto(out *SlackConfirmationField) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SlackConfirmationField.
func (in *SlackConfirmationField) DeepCopy() *SlackConfirmationField {
	if in == nil {
		return nil
	}
	out := new(SlackConfirmationField)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SlackField) DeepCopyInto(out *SlackField) {
	*out = *in
	if in.Short != nil {
		in, out := &in.Short, &out.Short
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SlackField.
func (in *SlackField) DeepCopy() *SlackField {
	if in == nil {
		return nil
	}
	out := new(SlackField)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StaticConfig) DeepCopyInto(out *StaticConfig) {
	*out = *in
	if in.Targets != nil {
		in, out := &in.Targets, &out.Targets
		*out = make([]Target, len(*in))
		copy(*out, *in)
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StaticConfig.
func (in *StaticConfig) DeepCopy() *StaticConfig {
	if in == nil {
		return nil
	}
	out := new(StaticConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TelegramConfig) DeepCopyInto(out *TelegramConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.BotToken != nil {
		in, out := &in.BotToken, &out.BotToken
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.BotTokenFile != nil {
		in, out := &in.BotTokenFile, &out.BotTokenFile
		*out = new(string)
		**out = **in
	}
	if in.MessageThreadID != nil {
		in, out := &in.MessageThreadID, &out.MessageThreadID
		*out = new(int64)
		**out = **in
	}
	if in.DisableNotifications != nil {
		in, out := &in.DisableNotifications, &out.DisableNotifications
		*out = new(bool)
		**out = **in
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TelegramConfig.
func (in *TelegramConfig) DeepCopy() *TelegramConfig {
	if in == nil {
		return nil
	}
	out := new(TelegramConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TimeInterval) DeepCopyInto(out *TimeInterval) {
	*out = *in
	if in.Times != nil {
		in, out := &in.Times, &out.Times
		*out = make([]TimeRange, len(*in))
		copy(*out, *in)
	}
	if in.Weekdays != nil {
		in, out := &in.Weekdays, &out.Weekdays
		*out = make([]WeekdayRange, len(*in))
		copy(*out, *in)
	}
	if in.DaysOfMonth != nil {
		in, out := &in.DaysOfMonth, &out.DaysOfMonth
		*out = make([]DayOfMonthRange, len(*in))
		copy(*out, *in)
	}
	if in.Months != nil {
		in, out := &in.Months, &out.Months
		*out = make([]MonthRange, len(*in))
		copy(*out, *in)
	}
	if in.Years != nil {
		in, out := &in.Years, &out.Years
		*out = make([]YearRange, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TimeInterval.
func (in *TimeInterval) DeepCopy() *TimeInterval {
	if in == nil {
		return nil
	}
	out := new(TimeInterval)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TimeRange) DeepCopyInto(out *TimeRange) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TimeRange.
func (in *TimeRange) DeepCopy() *TimeRange {
	if in == nil {
		return nil
	}
	out := new(TimeRange)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VictorOpsConfig) DeepCopyInto(out *VictorOpsConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.APIKey != nil {
		in, out := &in.APIKey, &out.APIKey
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.CustomFields != nil {
		in, out := &in.CustomFields, &out.CustomFields
		*out = make([]KeyValue, len(*in))
		copy(*out, *in)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VictorOpsConfig.
func (in *VictorOpsConfig) DeepCopy() *VictorOpsConfig {
	if in == nil {
		return nil
	}
	out := new(VictorOpsConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WeChatConfig) DeepCopyInto(out *WeChatConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.APISecret != nil {
		in, out := &in.APISecret, &out.APISecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WeChatConfig.
func (in *WeChatConfig) DeepCopy() *WeChatConfig {
	if in == nil {
		return nil
	}
	out := new(WeChatConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebexConfig) DeepCopyInto(out *WebexConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.APIURL != nil {
		in, out := &in.APIURL, &out.APIURL
		*out = new(URL)
		**out = **in
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Message != nil {
		in, out := &in.Message, &out.Message
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebexConfig.
func (in *WebexConfig) DeepCopy() *WebexConfig {
	if in == nil {
		return nil
	}
	out := new(WebexConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WebhookConfig) DeepCopyInto(out *WebhookConfig) {
	*out = *in
	if in.SendResolved != nil {
		in, out := &in.SendResolved, &out.SendResolved
		*out = new(bool)
		**out = **in
	}
	if in.URL != nil {
		in, out := &in.URL, &out.URL
		*out = new(string)
		**out = **in
	}
	if in.URLSecret != nil {
		in, out := &in.URLSecret, &out.URLSecret
		*out = new(corev1.SecretKeySelector)
		(*in).DeepCopyInto(*out)
	}
	if in.HTTPConfig != nil {
		in, out := &in.HTTPConfig, &out.HTTPConfig
		*out = new(HTTPConfig)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WebhookConfig.
func (in *WebhookConfig) DeepCopy() *WebhookConfig {
	if in == nil {
		return nil
	}
	out := new(WebhookConfig)
	in.DeepCopyInto(out)
	return out
}
