/*
Copyright 2024 The KEDA Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "github.com/kedacore/keda/v2/apis/keda/v1alpha1"
	scheme "github.com/kedacore/keda/v2/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterTriggerAuthenticationsGetter has a method to return a ClusterTriggerAuthenticationInterface.
// A group's client should implement this interface.
type ClusterTriggerAuthenticationsGetter interface {
	ClusterTriggerAuthentications() ClusterTriggerAuthenticationInterface
}

// ClusterTriggerAuthenticationInterface has methods to work with ClusterTriggerAuthentication resources.
type ClusterTriggerAuthenticationInterface interface {
	Create(ctx context.Context, clusterTriggerAuthentication *v1alpha1.ClusterTriggerAuthentication, opts v1.CreateOptions) (*v1alpha1.ClusterTriggerAuthentication, error)
	Update(ctx context.Context, clusterTriggerAuthentication *v1alpha1.ClusterTriggerAuthentication, opts v1.UpdateOptions) (*v1alpha1.ClusterTriggerAuthentication, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, clusterTriggerAuthentication *v1alpha1.ClusterTriggerAuthentication, opts v1.UpdateOptions) (*v1alpha1.ClusterTriggerAuthentication, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterTriggerAuthentication, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterTriggerAuthenticationList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterTriggerAuthentication, err error)
	ClusterTriggerAuthenticationExpansion
}

// clusterTriggerAuthentications implements ClusterTriggerAuthenticationInterface
type clusterTriggerAuthentications struct {
	*gentype.ClientWithList[*v1alpha1.ClusterTriggerAuthentication, *v1alpha1.ClusterTriggerAuthenticationList]
}

// newClusterTriggerAuthentications returns a ClusterTriggerAuthentications
func newClusterTriggerAuthentications(c *KedaV1alpha1Client) *clusterTriggerAuthentications {
	return &clusterTriggerAuthentications{
		gentype.NewClientWithList[*v1alpha1.ClusterTriggerAuthentication, *v1alpha1.ClusterTriggerAuthenticationList](
			"clustertriggerauthentications",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1alpha1.ClusterTriggerAuthentication { return &v1alpha1.ClusterTriggerAuthentication{} },
			func() *v1alpha1.ClusterTriggerAuthenticationList { return &v1alpha1.ClusterTriggerAuthenticationList{} }),
	}
}
