package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AdmissionConfig = map[string]string{
	"enabledPlugins":  "enabledPlugins is a list of admission plugins that must be on in addition to the default list. Some admission plugins are disabled by default, but certain configurations require them.  This is fairly uncommon and can result in performance penalties and unexpected behavior.",
	"disabledPlugins": "disabledPlugins is a list of admission plugins that must be off.  Putting something in this list is almost always a mistake and likely to result in cluster instability.",
}

func (AdmissionConfig) SwaggerDoc() map[string]string {
	return map_AdmissionConfig
}

var map_AdmissionPluginConfig = map[string]string{
	"":              "AdmissionPluginConfig holds the necessary configuration options for admission plugins",
	"location":      "Location is the path to a configuration file that contains the plugin's configuration",
	"configuration": "Configuration is an embedded configuration object to be used as the plugin's configuration. If present, it will be used instead of the path to the configuration file.",
}

func (AdmissionPluginConfig) SwaggerDoc() map[string]string {
	return map_AdmissionPluginConfig
}

var map_AuditConfig = map[string]string{
	"":                         "AuditConfig holds configuration for the audit capabilities",
	"enabled":                  "If this flag is set, audit log will be printed in the logs. The logs contains, method, user and a requested URL.",
	"auditFilePath":            "All requests coming to the apiserver will be logged to this file.",
	"maximumFileRetentionDays": "Maximum number of days to retain old log files based on the timestamp encoded in their filename.",
	"maximumRetainedFiles":     "Maximum number of old log files to retain.",
	"maximumFileSizeMegabytes": "Maximum size in megabytes of the log file before it gets rotated. Defaults to 100MB.",
	"policyFile":               "PolicyFile is a path to the file that defines the audit policy configuration.",
	"policyConfiguration":      "PolicyConfiguration is an embedded policy configuration object to be used as the audit policy configuration. If present, it will be used instead of the path to the policy file.",
	"logFormat":                "Format of saved audits (legacy or json).",
	"webHookKubeConfig":        "Path to a .kubeconfig formatted file that defines the audit webhook configuration.",
	"webHookMode":              "Strategy for sending audit events (block or batch).",
}

func (AuditConfig) SwaggerDoc() map[string]string {
	return map_AuditConfig
}

var map_CertInfo = map[string]string{
	"":         "CertInfo relates a certificate with a private key",
	"certFile": "CertFile is a file containing a PEM-encoded certificate",
	"keyFile":  "KeyFile is a file containing a PEM-encoded private key for the certificate specified by CertFile",
}

func (CertInfo) SwaggerDoc() map[string]string {
	return map_CertInfo
}

var map_ClientConnectionOverrides = map[string]string{
	"acceptContentTypes": "acceptContentTypes defines the Accept header sent by clients when connecting to a server, overriding the default value of 'application/json'. This field will control all connections to the server used by a particular client.",
	"contentType":        "contentType is the content type used when sending data to the server from this client.",
	"qps":                "qps controls the number of queries per second allowed for this connection.",
	"burst":              "burst allows extra queries to accumulate when a client is exceeding its rate.",
}

func (ClientConnectionOverrides) SwaggerDoc() map[string]string {
	return map_ClientConnectionOverrides
}

var map_ConfigMapFileReference = map[string]string{
	"":    "ConfigMapFileReference references a config map in a specific namespace. The namespace must be specified at the point of use.",
	"key": "Key allows pointing to a specific key/value inside of the configmap.  This is useful for logical file references.",
}

func (ConfigMapFileReference) SwaggerDoc() map[string]string {
	return map_ConfigMapFileReference
}

var map_ConfigMapNameReference = map[string]string{
	"":     "ConfigMapNameReference references a config map in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced config map",
}

func (ConfigMapNameReference) SwaggerDoc() map[string]string {
	return map_ConfigMapNameReference
}

var map_DelegatedAuthentication = map[string]string{
	"":         "DelegatedAuthentication allows authentication to be disabled.",
	"disabled": "disabled indicates that authentication should be disabled.  By default it will use delegated authentication.",
}

func (DelegatedAuthentication) SwaggerDoc() map[string]string {
	return map_DelegatedAuthentication
}

var map_DelegatedAuthorization = map[string]string{
	"":         "DelegatedAuthorization allows authorization to be disabled.",
	"disabled": "disabled indicates that authorization should be disabled.  By default it will use delegated authorization.",
}

func (DelegatedAuthorization) SwaggerDoc() map[string]string {
	return map_DelegatedAuthorization
}

var map_EtcdConnectionInfo = map[string]string{
	"":     "EtcdConnectionInfo holds information necessary for connecting to an etcd server",
	"urls": "URLs are the URLs for etcd",
	"ca":   "CA is a file containing trusted roots for the etcd server certificates",
}

func (EtcdConnectionInfo) SwaggerDoc() map[string]string {
	return map_EtcdConnectionInfo
}

var map_EtcdStorageConfig = map[string]string{
	"storagePrefix": "StoragePrefix is the path within etcd that the OpenShift resources will be rooted under. This value, if changed, will mean existing objects in etcd will no longer be located.",
}

func (EtcdStorageConfig) SwaggerDoc() map[string]string {
	return map_EtcdStorageConfig
}

var map_GenericAPIServerConfig = map[string]string{
	"":                   "GenericAPIServerConfig is an inline-able struct for aggregated apiservers that need to store data in etcd",
	"servingInfo":        "servingInfo describes how to start serving",
	"corsAllowedOrigins": "corsAllowedOrigins",
	"auditConfig":        "auditConfig describes how to configure audit information",
	"storageConfig":      "storageConfig contains information about how to use",
	"admission":          "admissionConfig holds information about how to configure admission.",
}

func (GenericAPIServerConfig) SwaggerDoc() map[string]string {
	return map_GenericAPIServerConfig
}

var map_GenericControllerConfig = map[string]string{
	"":               "GenericControllerConfig provides information to configure a controller",
	"servingInfo":    "ServingInfo is the HTTP serving information for the controller's endpoints",
	"leaderElection": "leaderElection provides information to elect a leader. Only override this if you have a specific need",
	"authentication": "authentication allows configuration of authentication for the endpoints",
	"authorization":  "authorization allows configuration of authentication for the endpoints",
}

func (GenericControllerConfig) SwaggerDoc() map[string]string {
	return map_GenericControllerConfig
}

var map_HTTPServingInfo = map[string]string{
	"":                      "HTTPServingInfo holds configuration for serving HTTP",
	"maxRequestsInFlight":   "MaxRequestsInFlight is the number of concurrent requests allowed to the server. If zero, no limit.",
	"requestTimeoutSeconds": "RequestTimeoutSeconds is the number of seconds before requests are timed out. The default is 60 minutes, if -1 there is no limit on requests.",
}

func (HTTPServingInfo) SwaggerDoc() map[string]string {
	return map_HTTPServingInfo
}

var map_KubeClientConfig = map[string]string{
	"kubeConfig":          "kubeConfig is a .kubeconfig filename for going to the owning kube-apiserver.  Empty uses an in-cluster-config",
	"connectionOverrides": "connectionOverrides specifies client overrides for system components to loop back to this master.",
}

func (KubeClientConfig) SwaggerDoc() map[string]string {
	return map_KubeClientConfig
}

var map_LeaderElection = map[string]string{
	"":              "LeaderElection provides information to elect a leader",
	"disable":       "disable allows leader election to be suspended while allowing a fully defaulted \"normal\" startup case.",
	"namespace":     "namespace indicates which namespace the resource is in",
	"name":          "name indicates what name to use for the resource",
	"leaseDuration": "leaseDuration is the duration that non-leader candidates will wait after observing a leadership renewal until attempting to acquire leadership of a led but unrenewed leader slot. This is effectively the maximum duration that a leader can be stopped before it is replaced by another candidate. This is only applicable if leader election is enabled.",
	"renewDeadline": "renewDeadline is the interval between attempts by the acting master to renew a leadership slot before it stops leading. This must be less than or equal to the lease duration. This is only applicable if leader election is enabled.",
	"retryPeriod":   "retryPeriod is the duration the clients should wait between attempting acquisition and renewal of a leadership. This is only applicable if leader election is enabled.",
}

func (LeaderElection) SwaggerDoc() map[string]string {
	return map_LeaderElection
}

var map_MaxAgePolicy = map[string]string{
	"":               "MaxAgePolicy contains a numeric range for specifying a compliant HSTS max-age for the enclosing RequiredHSTSPolicy",
	"largestMaxAge":  "The largest allowed value (in seconds) of the RequiredHSTSPolicy max-age This value can be left unspecified, in which case no upper limit is enforced.",
	"smallestMaxAge": "The smallest allowed value (in seconds) of the RequiredHSTSPolicy max-age Setting max-age=0 allows the deletion of an existing HSTS header from a host.  This is a necessary tool for administrators to quickly correct mistakes. This value can be left unspecified, in which case no lower limit is enforced.",
}

func (MaxAgePolicy) SwaggerDoc() map[string]string {
	return map_MaxAgePolicy
}

var map_NamedCertificate = map[string]string{
	"":      "NamedCertificate specifies a certificate/key, and the names it should be served for",
	"names": "Names is a list of DNS names this certificate should be used to secure A name can be a normal DNS name, or can contain leading wildcard segments.",
}

func (NamedCertificate) SwaggerDoc() map[string]string {
	return map_NamedCertificate
}

var map_RemoteConnectionInfo = map[string]string{
	"":    "RemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url": "URL is the remote URL to connect to",
	"ca":  "CA is the CA for verifying TLS connections",
}

func (RemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_RemoteConnectionInfo
}

var map_RequiredHSTSPolicy = map[string]string{
	"namespaceSelector":       "namespaceSelector specifies a label selector such that the policy applies only to those routes that are in namespaces with labels that match the selector, and are in one of the DomainPatterns. Defaults to the empty LabelSelector, which matches everything.",
	"domainPatterns":          "domainPatterns is a list of domains for which the desired HSTS annotations are required. If domainPatterns is specified and a route is created with a spec.host matching one of the domains, the route must specify the HSTS Policy components described in the matching RequiredHSTSPolicy.\n\nThe use of wildcards is allowed like this: *.foo.com matches everything under foo.com. foo.com only matches foo.com, so to cover foo.com and everything under it, you must specify *both*.",
	"maxAge":                  "maxAge is the delta time range in seconds during which hosts are regarded as HSTS hosts. If set to 0, it negates the effect, and hosts are removed as HSTS hosts. If set to 0 and includeSubdomains is specified, all subdomains of the host are also removed as HSTS hosts. maxAge is a time-to-live value, and if this policy is not refreshed on a client, the HSTS policy will eventually expire on that client.",
	"preloadPolicy":           "preloadPolicy directs the client to include hosts in its host preload list so that it never needs to do an initial load to get the HSTS header (note that this is not defined in RFC 6797 and is therefore client implementation-dependent).",
	"includeSubDomainsPolicy": "includeSubDomainsPolicy means the HSTS Policy should apply to any subdomains of the host's domain name.  Thus, for the host bar.foo.com, if includeSubDomainsPolicy was set to RequireIncludeSubDomains: - the host app.bar.foo.com would inherit the HSTS Policy of bar.foo.com - the host bar.foo.com would inherit the HSTS Policy of bar.foo.com - the host foo.com would NOT inherit the HSTS Policy of bar.foo.com - the host def.foo.com would NOT inherit the HSTS Policy of bar.foo.com",
}

func (RequiredHSTSPolicy) SwaggerDoc() map[string]string {
	return map_RequiredHSTSPolicy
}

var map_SecretNameReference = map[string]string{
	"":     "SecretNameReference references a secret in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced secret",
}

func (SecretNameReference) SwaggerDoc() map[string]string {
	return map_SecretNameReference
}

var map_ServingInfo = map[string]string{
	"":                  "ServingInfo holds information about serving web pages",
	"bindAddress":       "BindAddress is the ip:port to serve on",
	"bindNetwork":       "BindNetwork is the type of network to bind to - defaults to \"tcp4\", accepts \"tcp\", \"tcp4\", and \"tcp6\"",
	"clientCA":          "ClientCA is the certificate bundle for all the signers that you'll recognize for incoming client certificates",
	"namedCertificates": "NamedCertificates is a list of certificates to use to secure requests to specific hostnames",
	"minTLSVersion":     "MinTLSVersion is the minimum TLS version supported. Values must match version names from https://golang.org/pkg/crypto/tls/#pkg-constants",
	"cipherSuites":      "CipherSuites contains an overridden list of ciphers for the server to support. Values must match cipher suite IDs from https://golang.org/pkg/crypto/tls/#pkg-constants",
}

func (ServingInfo) SwaggerDoc() map[string]string {
	return map_ServingInfo
}

var map_StringSource = map[string]string{
	"": "StringSource allows specifying a string inline, or externally via env var or file. When it contains only a string value, it marshals to a simple JSON string.",
}

func (StringSource) SwaggerDoc() map[string]string {
	return map_StringSource
}

var map_StringSourceSpec = map[string]string{
	"":        "StringSourceSpec specifies a string value, or external location",
	"value":   "Value specifies the cleartext value, or an encrypted value if keyFile is specified.",
	"env":     "Env specifies an envvar containing the cleartext value, or an encrypted value if the keyFile is specified.",
	"file":    "File references a file containing the cleartext value, or an encrypted value if a keyFile is specified.",
	"keyFile": "KeyFile references a file containing the key to use to decrypt the value.",
}

func (StringSourceSpec) SwaggerDoc() map[string]string {
	return map_StringSourceSpec
}

var map_APIServer = map[string]string{
	"":         "APIServer holds configuration (like serving certificates, client CA and CORS domains) shared by all API servers in the system, among them especially kube-apiserver and openshift-apiserver. The canonical name of an instance is 'cluster'.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (APIServer) SwaggerDoc() map[string]string {
	return map_APIServer
}

var map_APIServerEncryption = map[string]string{
	"type": "type defines what encryption type should be used to encrypt resources at the datastore layer. When this field is unset (i.e. when it is set to the empty string), identity is implied. The behavior of unset can and will change over time.  Even if encryption is enabled by default, the meaning of unset may change to a different encryption type based on changes in best practices.\n\nWhen encryption is enabled, all sensitive resources shipped with the platform are encrypted. This list of sensitive resources can and will change over time.  The current authoritative list is:\n\n  1. secrets\n  2. configmaps\n  3. routes.route.openshift.io\n  4. oauthaccesstokens.oauth.openshift.io\n  5. oauthauthorizetokens.oauth.openshift.io",
}

func (APIServerEncryption) SwaggerDoc() map[string]string {
	return map_APIServerEncryption
}

var map_APIServerList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (APIServerList) SwaggerDoc() map[string]string {
	return map_APIServerList
}

var map_APIServerNamedServingCert = map[string]string{
	"":                   "APIServerNamedServingCert maps a server DNS name, as understood by a client, to a certificate.",
	"names":              "names is a optional list of explicit DNS names (leading wildcards allowed) that should use this certificate to serve secure traffic. If no names are provided, the implicit names will be extracted from the certificates. Exact names trump over wildcard names. Explicit names defined here trump over extracted implicit names.",
	"servingCertificate": "servingCertificate references a kubernetes.io/tls type secret containing the TLS cert info for serving secure traffic. The secret must exist in the openshift-config namespace and contain the following required fields: - Secret.Data[\"tls.key\"] - TLS private key. - Secret.Data[\"tls.crt\"] - TLS certificate.",
}

func (APIServerNamedServingCert) SwaggerDoc() map[string]string {
	return map_APIServerNamedServingCert
}

var map_APIServerServingCerts = map[string]string{
	"namedCertificates": "namedCertificates references secrets containing the TLS cert info for serving secure traffic to specific hostnames. If no named certificates are provided, or no named certificates match the server name as understood by a client, the defaultServingCertificate will be used.",
}

func (APIServerServingCerts) SwaggerDoc() map[string]string {
	return map_APIServerServingCerts
}

var map_APIServerSpec = map[string]string{
	"servingCerts":                 "servingCert is the TLS cert info for serving secure traffic. If not specified, operator managed certificates will be used for serving secure traffic.",
	"clientCA":                     "clientCA references a ConfigMap containing a certificate bundle for the signers that will be recognized for incoming client certificates in addition to the operator managed signers. If this is empty, then only operator managed signers are valid. You usually only have to set this if you have your own PKI you wish to honor client certificates from. The ConfigMap must exist in the openshift-config namespace and contain the following required fields: - ConfigMap.Data[\"ca-bundle.crt\"] - CA bundle.",
	"additionalCORSAllowedOrigins": "additionalCORSAllowedOrigins lists additional, user-defined regular expressions describing hosts for which the API server allows access using the CORS headers. This may be needed to access the API and the integrated OAuth server from JavaScript applications. The values are regular expressions that correspond to the Golang regular expression language.",
	"encryption":                   "encryption allows the configuration of encryption of resources at the datastore layer.",
	"tlsSecurityProfile":           "tlsSecurityProfile specifies settings for TLS connections for externally exposed servers.\n\nIf unset, a default (which may change between releases) is chosen. Note that only Old, Intermediate and Custom profiles are currently supported, and the maximum available MinTLSVersions is VersionTLS12.",
	"audit":                        "audit specifies the settings for audit configuration to be applied to all OpenShift-provided API servers in the cluster.",
}

func (APIServerSpec) SwaggerDoc() map[string]string {
	return map_APIServerSpec
}

var map_Audit = map[string]string{
	"profile":     "profile specifies the name of the desired top-level audit profile to be applied to all requests sent to any of the OpenShift-provided API servers in the cluster (kube-apiserver, openshift-apiserver and oauth-apiserver), with the exception of those requests that match one or more of the customRules.\n\nThe following profiles are provided: - Default: default policy which means MetaData level logging with the exception of events\n  (not logged at all), oauthaccesstokens and oauthauthorizetokens (both logged at RequestBody\n  level).\n- WriteRequestBodies: like 'Default', but logs request and response HTTP payloads for write requests (create, update, patch). - AllRequestBodies: like 'WriteRequestBodies', but also logs request and response HTTP payloads for read requests (get, list). - None: no requests are logged at all, not even oauthaccesstokens and oauthauthorizetokens.\n\nWarning: It is not recommended to disable audit logging by using the `None` profile unless you are fully aware of the risks of not logging data that can be beneficial when troubleshooting issues. If you disable audit logging and a support situation arises, you might need to enable audit logging and reproduce the issue in order to troubleshoot properly.\n\nIf unset, the 'Default' profile is used as the default.",
	"customRules": "customRules specify profiles per group. These profile take precedence over the top-level profile field if they apply. They are evaluation from top to bottom and the first one that matches, applies.",
}

func (Audit) SwaggerDoc() map[string]string {
	return map_Audit
}

var map_AuditCustomRule = map[string]string{
	"":        "AuditCustomRule describes a custom rule for an audit profile that takes precedence over the top-level profile.",
	"group":   "group is a name of group a request user must be member of in order to this profile to apply.",
	"profile": "profile specifies the name of the desired audit policy configuration to be deployed to all OpenShift-provided API servers in the cluster.\n\nThe following profiles are provided: - Default: the existing default policy. - WriteRequestBodies: like 'Default', but logs request and response HTTP payloads for write requests (create, update, patch). - AllRequestBodies: like 'WriteRequestBodies', but also logs request and response HTTP payloads for read requests (get, list). - None: no requests are logged at all, not even oauthaccesstokens and oauthauthorizetokens.\n\nIf unset, the 'Default' profile is used as the default.",
}

func (AuditCustomRule) SwaggerDoc() map[string]string {
	return map_AuditCustomRule
}

var map_Authentication = map[string]string{
	"":         "Authentication specifies cluster-wide settings for authentication (like OAuth and webhook token authenticators). The canonical name of an instance is `cluster`.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Authentication) SwaggerDoc() map[string]string {
	return map_Authentication
}

var map_AuthenticationList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (AuthenticationList) SwaggerDoc() map[string]string {
	return map_AuthenticationList
}

var map_AuthenticationSpec = map[string]string{
	"type":                       "type identifies the cluster managed, user facing authentication mode in use. Specifically, it manages the component that responds to login attempts. The default is IntegratedOAuth.",
	"oauthMetadata":              "oauthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for an external OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 If oauthMetadata.name is non-empty, this value has precedence over any metadata reference stored in status. The key \"oauthMetadata\" is used to locate the data. If specified and the config map or expected key is not found, no metadata is served. If the specified metadata is not valid, no metadata is served. The namespace for this config map is openshift-config.",
	"webhookTokenAuthenticators": "webhookTokenAuthenticators is DEPRECATED, setting it has no effect.",
	"webhookTokenAuthenticator":  "webhookTokenAuthenticator configures a remote token reviewer. These remote authentication webhooks can be used to verify bearer tokens via the tokenreviews.authentication.k8s.io REST API. This is required to honor bearer tokens that are provisioned by an external authentication service.",
	"serviceAccountIssuer":       "serviceAccountIssuer is the identifier of the bound service account token issuer. The default is https://kubernetes.default.svc WARNING: Updating this field will not result in immediate invalidation of all bound tokens with the previous issuer value. Instead, the tokens issued by previous service account issuer will continue to be trusted for a time period chosen by the platform (currently set to 24h). This time period is subject to change over time. This allows internal components to transition to use new service account issuer without service distruption.",
}

func (AuthenticationSpec) SwaggerDoc() map[string]string {
	return map_AuthenticationSpec
}

var map_AuthenticationStatus = map[string]string{
	"integratedOAuthMetadata": "integratedOAuthMetadata contains the discovery endpoint data for OAuth 2.0 Authorization Server Metadata for the in-cluster integrated OAuth server. This discovery document can be viewed from its served location: oc get --raw '/.well-known/oauth-authorization-server' For further details, see the IETF Draft: https://tools.ietf.org/html/draft-ietf-oauth-discovery-04#section-2 This contains the observed value based on cluster state. An explicitly set value in spec.oauthMetadata has precedence over this field. This field has no meaning if authentication spec.type is not set to IntegratedOAuth. The key \"oauthMetadata\" is used to locate the data. If the config map or expected key is not found, no metadata is served. If the specified metadata is not valid, no metadata is served. The namespace for this config map is openshift-config-managed.",
}

func (AuthenticationStatus) SwaggerDoc() map[string]string {
	return map_AuthenticationStatus
}

var map_DeprecatedWebhookTokenAuthenticator = map[string]string{
	"":           "deprecatedWebhookTokenAuthenticator holds the necessary configuration options for a remote token authenticator. It's the same as WebhookTokenAuthenticator but it's missing the 'required' validation on KubeConfig field.",
	"kubeConfig": "kubeConfig contains kube config file data which describes how to access the remote webhook service. For further details, see: https://kubernetes.io/docs/reference/access-authn-authz/authentication/#webhook-token-authentication The key \"kubeConfig\" is used to locate the data. If the secret or expected key is not found, the webhook is not honored. If the specified kube config data is not valid, the webhook is not honored. The namespace for this secret is determined by the point of use.",
}

func (DeprecatedWebhookTokenAuthenticator) SwaggerDoc() map[string]string {
	return map_DeprecatedWebhookTokenAuthenticator
}

var map_WebhookTokenAuthenticator = map[string]string{
	"":           "webhookTokenAuthenticator holds the necessary configuration options for a remote token authenticator",
	"kubeConfig": "kubeConfig references a secret that contains kube config file data which describes how to access the remote webhook service. The namespace for the referenced secret is openshift-config.\n\nFor further details, see:\n\nhttps://kubernetes.io/docs/reference/access-authn-authz/authentication/#webhook-token-authentication\n\nThe key \"kubeConfig\" is used to locate the data. If the secret or expected key is not found, the webhook is not honored. If the specified kube config data is not valid, the webhook is not honored.",
}

func (WebhookTokenAuthenticator) SwaggerDoc() map[string]string {
	return map_WebhookTokenAuthenticator
}

var map_Build = map[string]string{
	"":         "Build configures the behavior of OpenShift builds for the entire cluster. This includes default settings that can be overridden in BuildConfig objects, and overrides which are applied to all builds.\n\nThe canonical name is \"cluster\"\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "Spec holds user-settable values for the build controller configuration",
}

func (Build) SwaggerDoc() map[string]string {
	return map_Build
}

var map_BuildDefaults = map[string]string{
	"defaultProxy": "DefaultProxy contains the default proxy settings for all build operations, including image pull/push and source download.\n\nValues can be overrode by setting the `HTTP_PROXY`, `HTTPS_PROXY`, and `NO_PROXY` environment variables in the build config's strategy.",
	"gitProxy":     "GitProxy contains the proxy settings for git operations only. If set, this will override any Proxy settings for all git commands, such as git clone.\n\nValues that are not set here will be inherited from DefaultProxy.",
	"env":          "Env is a set of default environment variables that will be applied to the build if the specified variables do not exist on the build",
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. User can override a default label by providing a label with the same name in their Build/BuildConfig.",
	"resources":    "Resources defines resource requirements to execute the build.",
}

func (BuildDefaults) SwaggerDoc() map[string]string {
	return map_BuildDefaults
}

var map_BuildList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (BuildList) SwaggerDoc() map[string]string {
	return map_BuildList
}

var map_BuildOverrides = map[string]string{
	"imageLabels":  "ImageLabels is a list of docker labels that are applied to the resulting image. If user provided a label in their Build/BuildConfig with the same name as one in this list, the user's label will be overwritten.",
	"nodeSelector": "NodeSelector is a selector which must be true for the build pod to fit on a node",
	"tolerations":  "Tolerations is a list of Tolerations that will override any existing tolerations set on a build pod.",
	"forcePull":    "ForcePull overrides, if set, the equivalent value in the builds, i.e. false disables force pull for all builds, true enables force pull for all builds, independently of what each build specifies itself",
}

func (BuildOverrides) SwaggerDoc() map[string]string {
	return map_BuildOverrides
}

var map_BuildSpec = map[string]string{
	"additionalTrustedCA": "AdditionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted for image pushes and pulls during builds. The namespace for this config map is openshift-config.\n\nDEPRECATED: Additional CAs for image pull and push should be set on image.config.openshift.io/cluster instead.",
	"buildDefaults":       "BuildDefaults controls the default information for Builds",
	"buildOverrides":      "BuildOverrides controls override settings for builds",
}

func (BuildSpec) SwaggerDoc() map[string]string {
	return map_BuildSpec
}

var map_ImageLabel = map[string]string{
	"name":  "Name defines the name of the label. It must have non-zero length.",
	"value": "Value defines the literal value of the label.",
}

func (ImageLabel) SwaggerDoc() map[string]string {
	return map_ImageLabel
}

var map_ClusterOperator = map[string]string{
	"":         "ClusterOperator is the Custom Resource object which holds the current state of an operator. This object is used by operators to convey their state to the rest of the cluster.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds configuration that could apply to any operator.",
	"status":   "status holds the information about the state of an operator.  It is consistent with status information across the Kubernetes ecosystem.",
}

func (ClusterOperator) SwaggerDoc() map[string]string {
	return map_ClusterOperator
}

var map_ClusterOperatorList = map[string]string{
	"":         "ClusterOperatorList is a list of OperatorStatus resources.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ClusterOperatorList) SwaggerDoc() map[string]string {
	return map_ClusterOperatorList
}

var map_ClusterOperatorSpec = map[string]string{
	"": "ClusterOperatorSpec is empty for now, but you could imagine holding information like \"pause\".",
}

func (ClusterOperatorSpec) SwaggerDoc() map[string]string {
	return map_ClusterOperatorSpec
}

var map_ClusterOperatorStatus = map[string]string{
	"":               "ClusterOperatorStatus provides information about the status of the operator.",
	"conditions":     "conditions describes the state of the operator's managed and monitored components.",
	"versions":       "versions is a slice of operator and operand version tuples.  Operators which manage multiple operands will have multiple operand entries in the array.  Available operators must report the version of the operator itself with the name \"operator\". An operator reports a new \"operator\" version when it has rolled out the new version to all of its operands.",
	"relatedObjects": "relatedObjects is a list of objects that are \"interesting\" or related to this operator.  Common uses are: 1. the detailed resource driving the operator 2. operator namespaces 3. operand namespaces",
	"extension":      "extension contains any additional status information specific to the operator which owns this status object.",
}

func (ClusterOperatorStatus) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatus
}

var map_ClusterOperatorStatusCondition = map[string]string{
	"":                   "ClusterOperatorStatusCondition represents the state of the operator's managed and monitored components.",
	"type":               "type specifies the aspect reported by this condition.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status property.",
	"reason":             "reason is the CamelCase reason for the condition's current status.",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.  It may contain Line Feed characters (U+000A), which should be rendered as new lines.",
}

func (ClusterOperatorStatusCondition) SwaggerDoc() map[string]string {
	return map_ClusterOperatorStatusCondition
}

var map_ObjectReference = map[string]string{
	"":          "ObjectReference contains enough information to let you inspect or modify the referred object.",
	"group":     "group of the referent.",
	"resource":  "resource of the referent.",
	"namespace": "namespace of the referent.",
	"name":      "name of the referent.",
}

func (ObjectReference) SwaggerDoc() map[string]string {
	return map_ObjectReference
}

var map_OperandVersion = map[string]string{
	"name":    "name is the name of the particular operand this version is for.  It usually matches container images, not operators.",
	"version": "version indicates which version of a particular operand is currently being managed.  It must always match the Available operand.  If 1.0.0 is Available, then this must indicate 1.0.0 even if the operator is trying to rollout 1.1.0",
}

func (OperandVersion) SwaggerDoc() map[string]string {
	return map_OperandVersion
}

var map_ClusterCondition = map[string]string{
	"":       "ClusterCondition is a union of typed cluster conditions.  The 'type' property determines which of the type-specific properties are relevant. When evaluated on a cluster, the condition may match, not match, or fail to evaluate.",
	"type":   "type represents the cluster-condition type. This defines the members and semantics of any additional properties.",
	"promql": "promQL represents a cluster condition based on PromQL.",
}

func (ClusterCondition) SwaggerDoc() map[string]string {
	return map_ClusterCondition
}

var map_ClusterVersion = map[string]string{
	"":         "ClusterVersion is the configuration for the ClusterVersionOperator. This is where parameters related to automatic updates can be set.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec is the desired state of the cluster version - the operator will work to ensure that the desired version is applied to the cluster.",
	"status":   "status contains information about the available updates and any in-progress updates.",
}

func (ClusterVersion) SwaggerDoc() map[string]string {
	return map_ClusterVersion
}

var map_ClusterVersionCapabilitiesSpec = map[string]string{
	"":                              "ClusterVersionCapabilitiesSpec selects the managed set of optional, core cluster components.",
	"baselineCapabilitySet":         "baselineCapabilitySet selects an initial set of optional capabilities to enable, which can be extended via additionalEnabledCapabilities.  If unset, the cluster will choose a default, and the default may change over time. The current default is vCurrent.",
	"additionalEnabledCapabilities": "additionalEnabledCapabilities extends the set of managed capabilities beyond the baseline defined in baselineCapabilitySet.  The default is an empty set.",
}

func (ClusterVersionCapabilitiesSpec) SwaggerDoc() map[string]string {
	return map_ClusterVersionCapabilitiesSpec
}

var map_ClusterVersionCapabilitiesStatus = map[string]string{
	"":                    "ClusterVersionCapabilitiesStatus describes the state of optional, core cluster components.",
	"enabledCapabilities": "enabledCapabilities lists all the capabilities that are currently managed.",
	"knownCapabilities":   "knownCapabilities lists all the capabilities known to the current cluster.",
}

func (ClusterVersionCapabilitiesStatus) SwaggerDoc() map[string]string {
	return map_ClusterVersionCapabilitiesStatus
}

var map_ClusterVersionList = map[string]string{
	"":         "ClusterVersionList is a list of ClusterVersion resources.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ClusterVersionList) SwaggerDoc() map[string]string {
	return map_ClusterVersionList
}

var map_ClusterVersionSpec = map[string]string{
	"":              "ClusterVersionSpec is the desired version state of the cluster. It includes the version the cluster should be at, how the cluster is identified, and where the cluster should look for version updates.",
	"clusterID":     "clusterID uniquely identifies this cluster. This is expected to be an RFC4122 UUID value (xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx in hexadecimal values). This is a required field.",
	"desiredUpdate": "desiredUpdate is an optional field that indicates the desired value of the cluster version. Setting this value will trigger an upgrade (if the current version does not match the desired version). The set of recommended update values is listed as part of available updates in status, and setting values outside that range may cause the upgrade to fail.\n\nSome of the fields are inter-related with restrictions and meanings described here. 1. image is specified, version is specified, architecture is specified. API validation error. 2. image is specified, version is specified, architecture is not specified. You should not do this. version is silently ignored and image is used. 3. image is specified, version is not specified, architecture is specified. API validation error. 4. image is specified, version is not specified, architecture is not specified. image is used. 5. image is not specified, version is specified, architecture is specified. version and desired architecture are used to select an image. 6. image is not specified, version is specified, architecture is not specified. version and current architecture are used to select an image. 7. image is not specified, version is not specified, architecture is specified. API validation error. 8. image is not specified, version is not specified, architecture is not specified. API validation error.\n\nIf an upgrade fails the operator will halt and report status about the failing component. Setting the desired update value back to the previous version will cause a rollback to be attempted. Not all rollbacks will succeed.",
	"upstream":      "upstream may be used to specify the preferred update server. By default it will use the appropriate update server for the cluster and region.",
	"channel":       "channel is an identifier for explicitly requesting that a non-default set of updates be applied to this cluster. The default channel will be contain stable updates that are appropriate for production clusters.",
	"capabilities":  "capabilities configures the installation of optional, core cluster components.  A null value here is identical to an empty object; see the child properties for default semantics.",
	"overrides":     "overrides is list of overides for components that are managed by cluster version operator. Marking a component unmanaged will prevent the operator from creating or updating the object.",
}

func (ClusterVersionSpec) SwaggerDoc() map[string]string {
	return map_ClusterVersionSpec
}

var map_ClusterVersionStatus = map[string]string{
	"":                   "ClusterVersionStatus reports the status of the cluster versioning, including any upgrades that are in progress. The current field will be set to whichever version the cluster is reconciling to, and the conditions array will report whether the update succeeded, is in progress, or is failing.",
	"desired":            "desired is the version that the cluster is reconciling towards. If the cluster is not yet fully initialized desired will be set with the information available, which may be an image or a tag.",
	"history":            "history contains a list of the most recent versions applied to the cluster. This value may be empty during cluster startup, and then will be updated when a new update is being applied. The newest update is first in the list and it is ordered by recency. Updates in the history have state Completed if the rollout completed - if an update was failing or halfway applied the state will be Partial. Only a limited amount of update history is preserved.",
	"observedGeneration": "observedGeneration reports which version of the spec is being synced. If this value is not equal to metadata.generation, then the desired and conditions fields may represent a previous version.",
	"versionHash":        "versionHash is a fingerprint of the content that the cluster will be updated with. It is used by the operator to avoid unnecessary work and is for internal use only.",
	"capabilities":       "capabilities describes the state of optional, core cluster components.",
	"conditions":         "conditions provides information about the cluster version. The condition \"Available\" is set to true if the desiredUpdate has been reached. The condition \"Progressing\" is set to true if an update is being applied. The condition \"Degraded\" is set to true if an update is currently blocked by a temporary or permanent error. Conditions are only valid for the current desiredUpdate when metadata.generation is equal to status.generation.",
	"availableUpdates":   "availableUpdates contains updates recommended for this cluster. Updates which appear in conditionalUpdates but not in availableUpdates may expose this cluster to known issues. This list may be empty if no updates are recommended, if the update service is unavailable, or if an invalid channel has been specified.",
	"conditionalUpdates": "conditionalUpdates contains the list of updates that may be recommended for this cluster if it meets specific required conditions. Consumers interested in the set of updates that are actually recommended for this cluster should use availableUpdates. This list may be empty if no updates are recommended, if the update service is unavailable, or if an empty or invalid channel has been specified.",
}

func (ClusterVersionStatus) SwaggerDoc() map[string]string {
	return map_ClusterVersionStatus
}

var map_ComponentOverride = map[string]string{
	"":          "ComponentOverride allows overriding cluster version operator's behavior for a component.",
	"kind":      "kind indentifies which object to override.",
	"group":     "group identifies the API group that the kind is in.",
	"namespace": "namespace is the component's namespace. If the resource is cluster scoped, the namespace should be empty.",
	"name":      "name is the component's name.",
	"unmanaged": "unmanaged controls if cluster version operator should stop managing the resources in this cluster. Default: false",
}

func (ComponentOverride) SwaggerDoc() map[string]string {
	return map_ComponentOverride
}

var map_ConditionalUpdate = map[string]string{
	"":           "ConditionalUpdate represents an update which is recommended to some clusters on the version the current cluster is reconciling, but which may not be recommended for the current cluster.",
	"release":    "release is the target of the update.",
	"risks":      "risks represents the range of issues associated with updating to the target release. The cluster-version operator will evaluate all entries, and only recommend the update if there is at least one entry and all entries recommend the update.",
	"conditions": "conditions represents the observations of the conditional update's current status. Known types are: * Evaluating, for whether the cluster-version operator will attempt to evaluate any risks[].matchingRules. * Recommended, for whether the update is recommended for the current cluster.",
}

func (ConditionalUpdate) SwaggerDoc() map[string]string {
	return map_ConditionalUpdate
}

var map_ConditionalUpdateRisk = map[string]string{
	"":              "ConditionalUpdateRisk represents a reason and cluster-state for not recommending a conditional update.",
	"url":           "url contains information about this risk.",
	"name":          "name is the CamelCase reason for not recommending a conditional update, in the event that matchingRules match the cluster state.",
	"message":       "message provides additional information about the risk of updating, in the event that matchingRules match the cluster state. This is only to be consumed by humans. It may contain Line Feed characters (U+000A), which should be rendered as new lines.",
	"matchingRules": "matchingRules is a slice of conditions for deciding which clusters match the risk and which do not. The slice is ordered by decreasing precedence. The cluster-version operator will walk the slice in order, and stop after the first it can successfully evaluate. If no condition can be successfully evaluated, the update will not be recommended.",
}

func (ConditionalUpdateRisk) SwaggerDoc() map[string]string {
	return map_ConditionalUpdateRisk
}

var map_PromQLClusterCondition = map[string]string{
	"":       "PromQLClusterCondition represents a cluster condition based on PromQL.",
	"promql": "PromQL is a PromQL query classifying clusters. This query query should return a 1 in the match case and a 0 in the does-not-match case. Queries which return no time series, or which return values besides 0 or 1, are evaluation failures.",
}

func (PromQLClusterCondition) SwaggerDoc() map[string]string {
	return map_PromQLClusterCondition
}

var map_Release = map[string]string{
	"":         "Release represents an OpenShift release image and associated metadata.",
	"version":  "version is a semantic version identifying the update version. When this field is part of spec, version is optional if image is specified.",
	"image":    "image is a container image location that contains the update. When this field is part of spec, image is optional if version is specified and the availableUpdates field contains a matching version.",
	"url":      "url contains information about this release. This URL is set by the 'url' metadata property on a release or the metadata returned by the update API and should be displayed as a link in user interfaces. The URL field may not be set for test or nightly releases.",
	"channels": "channels is the set of Cincinnati channels to which the release currently belongs.",
}

func (Release) SwaggerDoc() map[string]string {
	return map_Release
}

var map_Update = map[string]string{
	"":             "Update represents an administrator update request.",
	"architecture": "architecture is an optional field that indicates the desired value of the cluster architecture. In this context cluster architecture means either a single architecture or a multi architecture. architecture can only be set to Multi thereby only allowing updates from single to multi architecture. If architecture is set, image cannot be set and version must be set. Valid values are 'Multi' and empty.",
	"version":      "version is a semantic version identifying the update version. version is ignored if image is specified and required if architecture is specified.",
	"image":        "image is a container image location that contains the update. image should be used when the desired version does not exist in availableUpdates or history. When image is set, version is ignored. When image is set, version should be empty. When image is set, architecture cannot be specified.",
	"force":        "force allows an administrator to update to an image that has failed verification or upgradeable checks. This option should only be used when the authenticity of the provided image has been verified out of band because the provided image will run with full administrative access to the cluster. Do not use this flag with images that comes from unknown or potentially malicious sources.",
}

func (Update) SwaggerDoc() map[string]string {
	return map_Update
}

var map_UpdateHistory = map[string]string{
	"":               "UpdateHistory is a single attempted update to the cluster.",
	"state":          "state reflects whether the update was fully applied. The Partial state indicates the update is not fully applied, while the Completed state indicates the update was successfully rolled out at least once (all parts of the update successfully applied).",
	"startedTime":    "startedTime is the time at which the update was started.",
	"completionTime": "completionTime, if set, is when the update was fully applied. The update that is currently being applied will have a null completion time. Completion time will always be set for entries that are not the current update (usually to the started time of the next update).",
	"version":        "version is a semantic version identifying the update version. If the requested image does not define a version, or if a failure occurs retrieving the image, this value may be empty.",
	"image":          "image is a container image location that contains the update. This value is always populated.",
	"verified":       "verified indicates whether the provided update was properly verified before it was installed. If this is false the cluster may not be trusted. Verified does not cover upgradeable checks that depend on the cluster state at the time when the update target was accepted.",
	"acceptedRisks":  "acceptedRisks records risks which were accepted to initiate the update. For example, it may menition an Upgradeable=False or missing signature that was overriden via desiredUpdate.force, or an update that was initiated despite not being in the availableUpdates set of recommended update targets.",
}

func (UpdateHistory) SwaggerDoc() map[string]string {
	return map_UpdateHistory
}

var map_Console = map[string]string{
	"":         "Console holds cluster-wide configuration for the web console, including the logout URL, and reports the public URL of the console. The canonical name is `cluster`.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Console) SwaggerDoc() map[string]string {
	return map_Console
}

var map_ConsoleAuthentication = map[string]string{
	"":               "ConsoleAuthentication defines a list of optional configuration for console authentication.",
	"logoutRedirect": "An optional, absolute URL to redirect web browsers to after logging out of the console. If not specified, it will redirect to the default login page. This is required when using an identity provider that supports single sign-on (SSO) such as: - OpenID (Keycloak, Azure) - RequestHeader (GSSAPI, SSPI, SAML) - OAuth (GitHub, GitLab, Google) Logging out of the console will destroy the user's token. The logoutRedirect provides the user the option to perform single logout (SLO) through the identity provider to destroy their single sign-on session.",
}

func (ConsoleAuthentication) SwaggerDoc() map[string]string {
	return map_ConsoleAuthentication
}

var map_ConsoleList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ConsoleList) SwaggerDoc() map[string]string {
	return map_ConsoleList
}

var map_ConsoleSpec = map[string]string{
	"": "ConsoleSpec is the specification of the desired behavior of the Console.",
}

func (ConsoleSpec) SwaggerDoc() map[string]string {
	return map_ConsoleSpec
}

var map_ConsoleStatus = map[string]string{
	"":           "ConsoleStatus defines the observed status of the Console.",
	"consoleURL": "The URL for the console. This will be derived from the host for the route that is created for the console.",
}

func (ConsoleStatus) SwaggerDoc() map[string]string {
	return map_ConsoleStatus
}

var map_DNS = map[string]string{
	"":         "DNS holds cluster-wide information about DNS. The canonical name is `cluster`\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (DNS) SwaggerDoc() map[string]string {
	return map_DNS
}

var map_DNSList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (DNSList) SwaggerDoc() map[string]string {
	return map_DNSList
}

var map_DNSSpec = map[string]string{
	"baseDomain":  "baseDomain is the base domain of the cluster. All managed DNS records will be sub-domains of this base.\n\nFor example, given the base domain `openshift.example.com`, an API server DNS record may be created for `cluster-api.openshift.example.com`.\n\nOnce set, this field cannot be changed.",
	"publicZone":  "publicZone is the location where all the DNS records that are publicly accessible to the internet exist.\n\nIf this field is nil, no public records should be created.\n\nOnce set, this field cannot be changed.",
	"privateZone": "privateZone is the location where all the DNS records that are only available internally to the cluster exist.\n\nIf this field is nil, no private records should be created.\n\nOnce set, this field cannot be changed.",
}

func (DNSSpec) SwaggerDoc() map[string]string {
	return map_DNSSpec
}

var map_DNSZone = map[string]string{
	"":     "DNSZone is used to define a DNS hosted zone. A zone can be identified by an ID or tags.",
	"id":   "id is the identifier that can be used to find the DNS hosted zone.\n\non AWS zone can be fetched using `ID` as id in [1] on Azure zone can be fetched using `ID` as a pre-determined name in [2], on GCP zone can be fetched using `ID` as a pre-determined name in [3].\n\n[1]: https://docs.aws.amazon.com/cli/latest/reference/route53/get-hosted-zone.html#options [2]: https://docs.microsoft.com/en-us/cli/azure/network/dns/zone?view=azure-cli-latest#az-network-dns-zone-show [3]: https://cloud.google.com/dns/docs/reference/v1/managedZones/get",
	"tags": "tags can be used to query the DNS hosted zone.\n\non AWS, resourcegroupstaggingapi [1] can be used to fetch a zone using `Tags` as tag-filters,\n\n[1]: https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/get-resources.html#options",
}

func (DNSZone) SwaggerDoc() map[string]string {
	return map_DNSZone
}

var map_CustomFeatureGates = map[string]string{
	"enabled":  "enabled is a list of all feature gates that you want to force on",
	"disabled": "disabled is a list of all feature gates that you want to force off",
}

func (CustomFeatureGates) SwaggerDoc() map[string]string {
	return map_CustomFeatureGates
}

var map_FeatureGate = map[string]string{
	"":         "Feature holds cluster-wide information about feature gates.  The canonical name is `cluster`\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (FeatureGate) SwaggerDoc() map[string]string {
	return map_FeatureGate
}

var map_FeatureGateList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (FeatureGateList) SwaggerDoc() map[string]string {
	return map_FeatureGateList
}

var map_FeatureGateSelection = map[string]string{
	"featureSet":      "featureSet changes the list of features in the cluster.  The default is empty.  Be very careful adjusting this setting. Turning on or off features may cause irreversible changes in your cluster which cannot be undone.",
	"customNoUpgrade": "customNoUpgrade allows the enabling or disabling of any feature. Turning this feature set on IS NOT SUPPORTED, CANNOT BE UNDONE, and PREVENTS UPGRADES. Because of its nature, this setting cannot be validated.  If you have any typos or accidentally apply invalid combinations your cluster may fail in an unrecoverable way.  featureSet must equal \"CustomNoUpgrade\" must be set to use this field.",
}

func (FeatureGateSelection) SwaggerDoc() map[string]string {
	return map_FeatureGateSelection
}

var map_Image = map[string]string{
	"":         "Image governs policies related to imagestream imports and runtime configuration for external registries. It allows cluster admins to configure which registries OpenShift is allowed to import images from, extra CA trust bundles for external registries, and policies to block or allow registry hostnames. When exposing OpenShift's image registry to the public, this also lets cluster admins specify the external hostname.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Image) SwaggerDoc() map[string]string {
	return map_Image
}

var map_ImageList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ImageList) SwaggerDoc() map[string]string {
	return map_ImageList
}

var map_ImageSpec = map[string]string{
	"allowedRegistriesForImport": "allowedRegistriesForImport limits the container image registries that normal users may import images from. Set this list to the registries that you trust to contain valid Docker images and that you want applications to be able to import from. Users with permission to create Images or ImageStreamMappings via the API are not affected by this policy - typically only administrators or system integrations will have those permissions.",
	"externalRegistryHostnames":  "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
	"additionalTrustedCA":        "additionalTrustedCA is a reference to a ConfigMap containing additional CAs that should be trusted during imagestream import, pod image pull, build image pull, and imageregistry pullthrough. The namespace for this config map is openshift-config.",
	"registrySources":            "registrySources contains configuration that determines how the container runtime should treat individual registries when accessing images for builds+pods. (e.g. whether or not to allow insecure access).  It does not contain configuration for the internal cluster registry.",
}

func (ImageSpec) SwaggerDoc() map[string]string {
	return map_ImageSpec
}

var map_ImageStatus = map[string]string{
	"internalRegistryHostname":  "internalRegistryHostname sets the hostname for the default internal image registry. The value must be in \"hostname[:port]\" format. This value is set by the image registry operator which controls the internal registry hostname. For backward compatibility, users can still use OPENSHIFT_DEFAULT_REGISTRY environment variable but this setting overrides the environment variable.",
	"externalRegistryHostnames": "externalRegistryHostnames provides the hostnames for the default external image registry. The external hostname should be set only when the image registry is exposed externally. The first value is used in 'publicDockerImageRepository' field in ImageStreams. The value must be in \"hostname[:port]\" format.",
}

func (ImageStatus) SwaggerDoc() map[string]string {
	return map_ImageStatus
}

var map_RegistryLocation = map[string]string{
	"":           "RegistryLocation contains a location of the registry specified by the registry domain name. The domain name might include wildcards, like '*' or '??'.",
	"domainName": "domainName specifies a domain name for the registry In case the registry use non-standard (80 or 443) port, the port should be included in the domain name as well.",
	"insecure":   "insecure indicates whether the registry is secure (https) or insecure (http) By default (if not specified) the registry is assumed as secure.",
}

func (RegistryLocation) SwaggerDoc() map[string]string {
	return map_RegistryLocation
}

var map_RegistrySources = map[string]string{
	"":                                 "RegistrySources holds cluster-wide information about how to handle the registries config.",
	"insecureRegistries":               "insecureRegistries are registries which do not have a valid TLS certificates or only support HTTP connections.",
	"blockedRegistries":                "blockedRegistries cannot be used for image pull and push actions. All other registries are permitted.\n\nOnly one of BlockedRegistries or AllowedRegistries may be set.",
	"allowedRegistries":                "allowedRegistries are the only registries permitted for image pull and push actions. All other registries are denied.\n\nOnly one of BlockedRegistries or AllowedRegistries may be set.",
	"containerRuntimeSearchRegistries": "containerRuntimeSearchRegistries are registries that will be searched when pulling images that do not have fully qualified domains in their pull specs. Registries will be searched in the order provided in the list. Note: this search list only works with the container runtime, i.e CRI-O. Will NOT work with builds or imagestream imports.",
}

func (RegistrySources) SwaggerDoc() map[string]string {
	return map_RegistrySources
}

var map_ImageContentPolicy = map[string]string{
	"":         "ImageContentPolicy holds cluster-wide information about how to handle registry mirror rules. When multiple policies are defined, the outcome of the behavior is defined on each field.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
}

func (ImageContentPolicy) SwaggerDoc() map[string]string {
	return map_ImageContentPolicy
}

var map_ImageContentPolicyList = map[string]string{
	"":         "ImageContentPolicyList lists the items in the ImageContentPolicy CRD.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ImageContentPolicyList) SwaggerDoc() map[string]string {
	return map_ImageContentPolicyList
}

var map_ImageContentPolicySpec = map[string]string{
	"":                        "ImageContentPolicySpec is the specification of the ImageContentPolicy CRD.",
	"repositoryDigestMirrors": "repositoryDigestMirrors allows images referenced by image digests in pods to be pulled from alternative mirrored repository locations. The image pull specification provided to the pod will be compared to the source locations described in RepositoryDigestMirrors and the image may be pulled down from any of the mirrors in the list instead of the specified repository allowing administrators to choose a potentially faster mirror. To pull image from mirrors by tags, should set the \"allowMirrorByTags\".\n\nEach “source” repository is treated independently; configurations for different “source” repositories don’t interact.\n\nIf the \"mirrors\" is not specified, the image will continue to be pulled from the specified repository in the pull spec.\n\nWhen multiple policies are defined for the same “source” repository, the sets of defined mirrors will be merged together, preserving the relative order of the mirrors, if possible. For example, if policy A has mirrors `a, b, c` and policy B has mirrors `c, d, e`, the mirrors will be used in the order `a, b, c, d, e`.  If the orders of mirror entries conflict (e.g. `a, b` vs. `b, a`) the configuration is not rejected but the resulting order is unspecified.",
}

func (ImageContentPolicySpec) SwaggerDoc() map[string]string {
	return map_ImageContentPolicySpec
}

var map_RepositoryDigestMirrors = map[string]string{
	"":                  "RepositoryDigestMirrors holds cluster-wide information about how to handle mirrors in the registries config.",
	"source":            "source is the repository that users refer to, e.g. in image pull specifications.",
	"allowMirrorByTags": "allowMirrorByTags if true, the mirrors can be used to pull the images that are referenced by their tags. Default is false, the mirrors only work when pulling the images that are referenced by their digests. Pulling images by tag can potentially yield different images, depending on which endpoint we pull from. Forcing digest-pulls for mirrors avoids that issue.",
	"mirrors":           "mirrors is zero or more repositories that may also contain the same images. If the \"mirrors\" is not specified, the image will continue to be pulled from the specified repository in the pull spec. No mirror will be configured. The order of mirrors in this list is treated as the user's desired priority, while source is by default considered lower priority than all mirrors. Other cluster configuration, including (but not limited to) other repositoryDigestMirrors objects, may impact the exact order mirrors are contacted in, or some mirrors may be contacted in parallel, so this should be considered a preference rather than a guarantee of ordering.",
}

func (RepositoryDigestMirrors) SwaggerDoc() map[string]string {
	return map_RepositoryDigestMirrors
}

var map_ImageDigestMirrorSet = map[string]string{
	"":         "ImageDigestMirrorSet holds cluster-wide information about how to handle registry mirror rules on using digest pull specification. When multiple policies are defined, the outcome of the behavior is defined on each field.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status contains the observed state of the resource.",
}

func (ImageDigestMirrorSet) SwaggerDoc() map[string]string {
	return map_ImageDigestMirrorSet
}

var map_ImageDigestMirrorSetList = map[string]string{
	"":         "ImageDigestMirrorSetList lists the items in the ImageDigestMirrorSet CRD.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ImageDigestMirrorSetList) SwaggerDoc() map[string]string {
	return map_ImageDigestMirrorSetList
}

var map_ImageDigestMirrorSetSpec = map[string]string{
	"":                   "ImageDigestMirrorSetSpec is the specification of the ImageDigestMirrorSet CRD.",
	"imageDigestMirrors": "imageDigestMirrors allows images referenced by image digests in pods to be pulled from alternative mirrored repository locations. The image pull specification provided to the pod will be compared to the source locations described in imageDigestMirrors and the image may be pulled down from any of the mirrors in the list instead of the specified repository allowing administrators to choose a potentially faster mirror. To use mirrors to pull images using tag specification, users should configure a list of mirrors using \"ImageTagMirrorSet\" CRD.\n\nIf the image pull specification matches the repository of \"source\" in multiple imagedigestmirrorset objects, only the objects which define the most specific namespace match will be used. For example, if there are objects using quay.io/libpod and quay.io/libpod/busybox as the \"source\", only the objects using quay.io/libpod/busybox are going to apply for pull specification quay.io/libpod/busybox. Each “source” repository is treated independently; configurations for different “source” repositories don’t interact.\n\nIf the \"mirrors\" is not specified, the image will continue to be pulled from the specified repository in the pull spec.\n\nWhen multiple policies are defined for the same “source” repository, the sets of defined mirrors will be merged together, preserving the relative order of the mirrors, if possible. For example, if policy A has mirrors `a, b, c` and policy B has mirrors `c, d, e`, the mirrors will be used in the order `a, b, c, d, e`.  If the orders of mirror entries conflict (e.g. `a, b` vs. `b, a`) the configuration is not rejected but the resulting order is unspecified. Users who want to use a specific order of mirrors, should configure them into one list of mirrors using the expected order.",
}

func (ImageDigestMirrorSetSpec) SwaggerDoc() map[string]string {
	return map_ImageDigestMirrorSetSpec
}

var map_ImageDigestMirrors = map[string]string{
	"":                   "ImageDigestMirrors holds cluster-wide information about how to handle mirrors in the registries config.",
	"source":             "source matches the repository that users refer to, e.g. in image pull specifications. Setting source to a registry hostname e.g. docker.io. quay.io, or registry.redhat.io, will match the image pull specification of corressponding registry. \"source\" uses one of the following formats: host[:port] host[:port]/namespace[/namespace…] host[:port]/namespace[/namespace…]/repo [*.]host for more information about the format, see the document about the location field: https://github.com/containers/image/blob/main/docs/containers-registries.conf.5.md#choosing-a-registry-toml-table",
	"mirrors":            "mirrors is zero or more locations that may also contain the same images. No mirror will be configured if not specified. Images can be pulled from these mirrors only if they are referenced by their digests. The mirrored location is obtained by replacing the part of the input reference that matches source by the mirrors entry, e.g. for registry.redhat.io/product/repo reference, a (source, mirror) pair *.redhat.io, mirror.local/redhat causes a mirror.local/redhat/product/repo repository to be used. The order of mirrors in this list is treated as the user's desired priority, while source is by default considered lower priority than all mirrors. If no mirror is specified or all image pulls from the mirror list fail, the image will continue to be pulled from the repository in the pull spec unless explicitly prohibited by \"mirrorSourcePolicy\" Other cluster configuration, including (but not limited to) other imageDigestMirrors objects, may impact the exact order mirrors are contacted in, or some mirrors may be contacted in parallel, so this should be considered a preference rather than a guarantee of ordering. \"mirrors\" uses one of the following formats: host[:port] host[:port]/namespace[/namespace…] host[:port]/namespace[/namespace…]/repo for more information about the format, see the document about the location field: https://github.com/containers/image/blob/main/docs/containers-registries.conf.5.md#choosing-a-registry-toml-table",
	"mirrorSourcePolicy": "mirrorSourcePolicy defines the fallback policy if fails to pull image from the mirrors. If unset, the image will continue to be pulled from the the repository in the pull spec. sourcePolicy is valid configuration only when one or more mirrors are in the mirror list.",
}

func (ImageDigestMirrors) SwaggerDoc() map[string]string {
	return map_ImageDigestMirrors
}

var map_ImageTagMirrorSet = map[string]string{
	"":         "ImageTagMirrorSet holds cluster-wide information about how to handle registry mirror rules on using tag pull specification. When multiple policies are defined, the outcome of the behavior is defined on each field.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status contains the observed state of the resource.",
}

func (ImageTagMirrorSet) SwaggerDoc() map[string]string {
	return map_ImageTagMirrorSet
}

var map_ImageTagMirrorSetList = map[string]string{
	"":         "ImageTagMirrorSetList lists the items in the ImageTagMirrorSet CRD.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ImageTagMirrorSetList) SwaggerDoc() map[string]string {
	return map_ImageTagMirrorSetList
}

var map_ImageTagMirrorSetSpec = map[string]string{
	"":                "ImageTagMirrorSetSpec is the specification of the ImageTagMirrorSet CRD.",
	"imageTagMirrors": "imageTagMirrors allows images referenced by image tags in pods to be pulled from alternative mirrored repository locations. The image pull specification provided to the pod will be compared to the source locations described in imageTagMirrors and the image may be pulled down from any of the mirrors in the list instead of the specified repository allowing administrators to choose a potentially faster mirror. To use mirrors to pull images using digest specification only, users should configure a list of mirrors using \"ImageDigestMirrorSet\" CRD.\n\nIf the image pull specification matches the repository of \"source\" in multiple imagetagmirrorset objects, only the objects which define the most specific namespace match will be used. For example, if there are objects using quay.io/libpod and quay.io/libpod/busybox as the \"source\", only the objects using quay.io/libpod/busybox are going to apply for pull specification quay.io/libpod/busybox. Each “source” repository is treated independently; configurations for different “source” repositories don’t interact.\n\nIf the \"mirrors\" is not specified, the image will continue to be pulled from the specified repository in the pull spec.\n\nWhen multiple policies are defined for the same “source” repository, the sets of defined mirrors will be merged together, preserving the relative order of the mirrors, if possible. For example, if policy A has mirrors `a, b, c` and policy B has mirrors `c, d, e`, the mirrors will be used in the order `a, b, c, d, e`.  If the orders of mirror entries conflict (e.g. `a, b` vs. `b, a`) the configuration is not rejected but the resulting order is unspecified. Users who want to use a deterministic order of mirrors, should configure them into one list of mirrors using the expected order.",
}

func (ImageTagMirrorSetSpec) SwaggerDoc() map[string]string {
	return map_ImageTagMirrorSetSpec
}

var map_ImageTagMirrors = map[string]string{
	"":                   "ImageTagMirrors holds cluster-wide information about how to handle mirrors in the registries config.",
	"source":             "source matches the repository that users refer to, e.g. in image pull specifications. Setting source to a registry hostname e.g. docker.io. quay.io, or registry.redhat.io, will match the image pull specification of corressponding registry. \"source\" uses one of the following formats: host[:port] host[:port]/namespace[/namespace…] host[:port]/namespace[/namespace…]/repo [*.]host for more information about the format, see the document about the location field: https://github.com/containers/image/blob/main/docs/containers-registries.conf.5.md#choosing-a-registry-toml-table",
	"mirrors":            "mirrors is zero or more locations that may also contain the same images. No mirror will be configured if not specified. Images can be pulled from these mirrors only if they are referenced by their tags. The mirrored location is obtained by replacing the part of the input reference that matches source by the mirrors entry, e.g. for registry.redhat.io/product/repo reference, a (source, mirror) pair *.redhat.io, mirror.local/redhat causes a mirror.local/redhat/product/repo repository to be used. Pulling images by tag can potentially yield different images, depending on which endpoint we pull from. Configuring a list of mirrors using \"ImageDigestMirrorSet\" CRD and forcing digest-pulls for mirrors avoids that issue. The order of mirrors in this list is treated as the user's desired priority, while source is by default considered lower priority than all mirrors. If no mirror is specified or all image pulls from the mirror list fail, the image will continue to be pulled from the repository in the pull spec unless explicitly prohibited by \"mirrorSourcePolicy\". Other cluster configuration, including (but not limited to) other imageTagMirrors objects, may impact the exact order mirrors are contacted in, or some mirrors may be contacted in parallel, so this should be considered a preference rather than a guarantee of ordering. \"mirrors\" uses one of the following formats: host[:port] host[:port]/namespace[/namespace…] host[:port]/namespace[/namespace…]/repo for more information about the format, see the document about the location field: https://github.com/containers/image/blob/main/docs/containers-registries.conf.5.md#choosing-a-registry-toml-table",
	"mirrorSourcePolicy": "mirrorSourcePolicy defines the fallback policy if fails to pull image from the mirrors. If unset, the image will continue to be pulled from the repository in the pull spec. sourcePolicy is valid configuration only when one or more mirrors are in the mirror list.",
}

func (ImageTagMirrors) SwaggerDoc() map[string]string {
	return map_ImageTagMirrors
}

var map_AWSPlatformSpec = map[string]string{
	"":                 "AWSPlatformSpec holds the desired state of the Amazon Web Services infrastructure provider. This only includes fields that can be modified in the cluster.",
	"serviceEndpoints": "serviceEndpoints list contains custom endpoints which will override default service endpoint of AWS Services. There must be only one ServiceEndpoint for a service.",
}

func (AWSPlatformSpec) SwaggerDoc() map[string]string {
	return map_AWSPlatformSpec
}

var map_AWSPlatformStatus = map[string]string{
	"":                 "AWSPlatformStatus holds the current status of the Amazon Web Services infrastructure provider.",
	"region":           "region holds the default AWS region for new AWS resources created by the cluster.",
	"serviceEndpoints": "ServiceEndpoints list contains custom endpoints which will override default service endpoint of AWS Services. There must be only one ServiceEndpoint for a service.",
	"resourceTags":     "resourceTags is a list of additional tags to apply to AWS resources created for the cluster. See https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html for information on tagging AWS resources. AWS supports a maximum of 50 tags per resource. OpenShift reserves 25 tags for its use, leaving 25 tags available for the user.",
}

func (AWSPlatformStatus) SwaggerDoc() map[string]string {
	return map_AWSPlatformStatus
}

var map_AWSResourceTag = map[string]string{
	"":      "AWSResourceTag is a tag to apply to AWS resources created for the cluster.",
	"key":   "key is the key of the tag",
	"value": "value is the value of the tag. Some AWS service do not support empty values. Since tags are added to resources in many services, the length of the tag value must meet the requirements of all services.",
}

func (AWSResourceTag) SwaggerDoc() map[string]string {
	return map_AWSResourceTag
}

var map_AWSServiceEndpoint = map[string]string{
	"":     "AWSServiceEndpoint store the configuration of a custom url to override existing defaults of AWS Services.",
	"name": "name is the name of the AWS service. The list of all the service names can be found at https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html This must be provided and cannot be empty.",
	"url":  "url is fully qualified URI with scheme https, that overrides the default generated endpoint for a client. This must be provided and cannot be empty.",
}

func (AWSServiceEndpoint) SwaggerDoc() map[string]string {
	return map_AWSServiceEndpoint
}

var map_AlibabaCloudPlatformSpec = map[string]string{
	"": "AlibabaCloudPlatformSpec holds the desired state of the Alibaba Cloud infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (AlibabaCloudPlatformSpec) SwaggerDoc() map[string]string {
	return map_AlibabaCloudPlatformSpec
}

var map_AlibabaCloudPlatformStatus = map[string]string{
	"":                "AlibabaCloudPlatformStatus holds the current status of the Alibaba Cloud infrastructure provider.",
	"region":          "region specifies the region for Alibaba Cloud resources created for the cluster.",
	"resourceGroupID": "resourceGroupID is the ID of the resource group for the cluster.",
	"resourceTags":    "resourceTags is a list of additional tags to apply to Alibaba Cloud resources created for the cluster.",
}

func (AlibabaCloudPlatformStatus) SwaggerDoc() map[string]string {
	return map_AlibabaCloudPlatformStatus
}

var map_AlibabaCloudResourceTag = map[string]string{
	"":      "AlibabaCloudResourceTag is the set of tags to add to apply to resources.",
	"key":   "key is the key of the tag.",
	"value": "value is the value of the tag.",
}

func (AlibabaCloudResourceTag) SwaggerDoc() map[string]string {
	return map_AlibabaCloudResourceTag
}

var map_AzurePlatformSpec = map[string]string{
	"": "AzurePlatformSpec holds the desired state of the Azure infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (AzurePlatformSpec) SwaggerDoc() map[string]string {
	return map_AzurePlatformSpec
}

var map_AzurePlatformStatus = map[string]string{
	"":                         "AzurePlatformStatus holds the current status of the Azure infrastructure provider.",
	"resourceGroupName":        "resourceGroupName is the Resource Group for new Azure resources created for the cluster.",
	"networkResourceGroupName": "networkResourceGroupName is the Resource Group for network resources like the Virtual Network and Subnets used by the cluster. If empty, the value is same as ResourceGroupName.",
	"cloudName":                "cloudName is the name of the Azure cloud environment which can be used to configure the Azure SDK with the appropriate Azure API endpoints. If empty, the value is equal to `AzurePublicCloud`.",
	"armEndpoint":              "armEndpoint specifies a URL to use for resource management in non-soverign clouds such as Azure Stack.",
	"resourceTags":             "resourceTags is a list of additional tags to apply to Azure resources created for the cluster. See https://docs.microsoft.com/en-us/rest/api/resources/tags for information on tagging Azure resources. Due to limitations on Automation, Content Delivery Network, DNS Azure resources, a maximum of 15 tags may be applied. OpenShift reserves 5 tags for internal use, allowing 10 tags for user configuration.",
}

func (AzurePlatformStatus) SwaggerDoc() map[string]string {
	return map_AzurePlatformStatus
}

var map_AzureResourceTag = map[string]string{
	"":      "AzureResourceTag is a tag to apply to Azure resources created for the cluster.",
	"key":   "key is the key part of the tag. A tag key can have a maximum of 128 characters and cannot be empty. Key must begin with a letter, end with a letter, number or underscore, and must contain only alphanumeric characters and the following special characters `_ . -`.",
	"value": "value is the value part of the tag. A tag value can have a maximum of 256 characters and cannot be empty. Value must contain only alphanumeric characters and the following special characters `_ + , - . / : ; < = > ? @`.",
}

func (AzureResourceTag) SwaggerDoc() map[string]string {
	return map_AzureResourceTag
}

var map_BareMetalPlatformLoadBalancer = map[string]string{
	"":     "BareMetalPlatformLoadBalancer defines the load balancer used by the cluster on BareMetal platform.",
	"type": "type defines the type of load balancer used by the cluster on BareMetal platform which can be a user-managed or openshift-managed load balancer that is to be used for the OpenShift API and Ingress endpoints. When set to OpenShiftManagedDefault the static pods in charge of API and Ingress traffic load-balancing defined in the machine config operator will be deployed. When set to UserManaged these static pods will not be deployed and it is expected that the load balancer is configured out of band by the deployer. When omitted, this means no opinion and the platform is left to choose a reasonable default. The default value is OpenShiftManagedDefault.",
}

func (BareMetalPlatformLoadBalancer) SwaggerDoc() map[string]string {
	return map_BareMetalPlatformLoadBalancer
}

var map_BareMetalPlatformSpec = map[string]string{
	"": "BareMetalPlatformSpec holds the desired state of the BareMetal infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (BareMetalPlatformSpec) SwaggerDoc() map[string]string {
	return map_BareMetalPlatformSpec
}

var map_BareMetalPlatformStatus = map[string]string{
	"":                     "BareMetalPlatformStatus holds the current status of the BareMetal infrastructure provider. For more information about the network architecture used with the BareMetal platform type, see: https://github.com/openshift/installer/blob/master/docs/design/baremetal/networking-infrastructure.md",
	"apiServerInternalIP":  "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.\n\nDeprecated: Use APIServerInternalIPs instead.",
	"apiServerInternalIPs": "apiServerInternalIPs are the IP addresses to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. These are the IPs for a self-hosted load balancer in front of the API servers. In dual stack clusters this list contains two IPs otherwise only one.",
	"ingressIP":            "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.\n\nDeprecated: Use IngressIPs instead.",
	"ingressIPs":           "ingressIPs are the external IPs which route to the default ingress controller. The IPs are suitable targets of a wildcard DNS record used to resolve default route host names. In dual stack clusters this list contains two IPs otherwise only one.",
	"nodeDNSIP":            "nodeDNSIP is the IP address for the internal DNS used by the nodes. Unlike the one managed by the DNS operator, `NodeDNSIP` provides name resolution for the nodes themselves. There is no DNS-as-a-service for BareMetal deployments. In order to minimize necessary changes to the datacenter DNS, a DNS service is hosted as a static pod to serve those hostnames to the nodes in the cluster.",
	"loadBalancer":         "loadBalancer defines how the load balancer used by the cluster is configured.",
}

func (BareMetalPlatformStatus) SwaggerDoc() map[string]string {
	return map_BareMetalPlatformStatus
}

var map_EquinixMetalPlatformSpec = map[string]string{
	"": "EquinixMetalPlatformSpec holds the desired state of the Equinix Metal infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (EquinixMetalPlatformSpec) SwaggerDoc() map[string]string {
	return map_EquinixMetalPlatformSpec
}

var map_EquinixMetalPlatformStatus = map[string]string{
	"":                    "EquinixMetalPlatformStatus holds the current status of the Equinix Metal infrastructure provider.",
	"apiServerInternalIP": "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.",
	"ingressIP":           "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.",
}

func (EquinixMetalPlatformStatus) SwaggerDoc() map[string]string {
	return map_EquinixMetalPlatformStatus
}

var map_ExternalPlatformSpec = map[string]string{
	"":             "ExternalPlatformSpec holds the desired state for the generic External infrastructure provider.",
	"platformName": "PlatformName holds the arbitrary string representing the infrastructure provider name, expected to be set at the installation time. This field is solely for informational and reporting purposes and is not expected to be used for decision-making.",
}

func (ExternalPlatformSpec) SwaggerDoc() map[string]string {
	return map_ExternalPlatformSpec
}

var map_ExternalPlatformStatus = map[string]string{
	"": "ExternalPlatformStatus holds the current status of the generic External infrastructure provider.",
}

func (ExternalPlatformStatus) SwaggerDoc() map[string]string {
	return map_ExternalPlatformStatus
}

var map_GCPPlatformSpec = map[string]string{
	"": "GCPPlatformSpec holds the desired state of the Google Cloud Platform infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (GCPPlatformSpec) SwaggerDoc() map[string]string {
	return map_GCPPlatformSpec
}

var map_GCPPlatformStatus = map[string]string{
	"":          "GCPPlatformStatus holds the current status of the Google Cloud Platform infrastructure provider.",
	"projectID": "resourceGroupName is the Project ID for new GCP resources created for the cluster.",
	"region":    "region holds the region for new GCP resources created for the cluster.",
}

func (GCPPlatformStatus) SwaggerDoc() map[string]string {
	return map_GCPPlatformStatus
}

var map_IBMCloudPlatformSpec = map[string]string{
	"": "IBMCloudPlatformSpec holds the desired state of the IBMCloud infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (IBMCloudPlatformSpec) SwaggerDoc() map[string]string {
	return map_IBMCloudPlatformSpec
}

var map_IBMCloudPlatformStatus = map[string]string{
	"":                  "IBMCloudPlatformStatus holds the current status of the IBMCloud infrastructure provider.",
	"location":          "Location is where the cluster has been deployed",
	"resourceGroupName": "ResourceGroupName is the Resource Group for new IBMCloud resources created for the cluster.",
	"providerType":      "ProviderType indicates the type of cluster that was created",
	"cisInstanceCRN":    "CISInstanceCRN is the CRN of the Cloud Internet Services instance managing the DNS zone for the cluster's base domain",
	"dnsInstanceCRN":    "DNSInstanceCRN is the CRN of the DNS Services instance managing the DNS zone for the cluster's base domain",
}

func (IBMCloudPlatformStatus) SwaggerDoc() map[string]string {
	return map_IBMCloudPlatformStatus
}

var map_Infrastructure = map[string]string{
	"":         "Infrastructure holds cluster-wide information about Infrastructure.  The canonical name is `cluster`\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Infrastructure) SwaggerDoc() map[string]string {
	return map_Infrastructure
}

var map_InfrastructureList = map[string]string{
	"":         "InfrastructureList is\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (InfrastructureList) SwaggerDoc() map[string]string {
	return map_InfrastructureList
}

var map_InfrastructureSpec = map[string]string{
	"":             "InfrastructureSpec contains settings that apply to the cluster infrastructure.",
	"cloudConfig":  "cloudConfig is a reference to a ConfigMap containing the cloud provider configuration file. This configuration file is used to configure the Kubernetes cloud provider integration when using the built-in cloud provider integration or the external cloud controller manager. The namespace for this config map is openshift-config.\n\ncloudConfig should only be consumed by the kube_cloud_config controller. The controller is responsible for using the user configuration in the spec for various platforms and combining that with the user provided ConfigMap in this field to create a stitched kube cloud config. The controller generates a ConfigMap `kube-cloud-config` in `openshift-config-managed` namespace with the kube cloud config is stored in `cloud.conf` key. All the clients are expected to use the generated ConfigMap only.",
	"platformSpec": "platformSpec holds desired information specific to the underlying infrastructure provider.",
}

func (InfrastructureSpec) SwaggerDoc() map[string]string {
	return map_InfrastructureSpec
}

var map_InfrastructureStatus = map[string]string{
	"":                       "InfrastructureStatus describes the infrastructure the cluster is leveraging.",
	"infrastructureName":     "infrastructureName uniquely identifies a cluster with a human friendly name. Once set it should not be changed. Must be of max length 27 and must have only alphanumeric or hyphen characters.",
	"platform":               "platform is the underlying infrastructure provider for the cluster.\n\nDeprecated: Use platformStatus.type instead.",
	"platformStatus":         "platformStatus holds status information specific to the underlying infrastructure provider.",
	"etcdDiscoveryDomain":    "etcdDiscoveryDomain is the domain used to fetch the SRV records for discovering etcd servers and clients. For more info: https://github.com/etcd-io/etcd/blob/329be66e8b3f9e2e6af83c123ff89297e49ebd15/Documentation/op-guide/clustering.md#dns-discovery deprecated: as of 4.7, this field is no longer set or honored.  It will be removed in a future release.",
	"apiServerURL":           "apiServerURL is a valid URI with scheme 'https', address and optionally a port (defaulting to 443).  apiServerURL can be used by components like the web console to tell users where to find the Kubernetes API.",
	"apiServerInternalURI":   "apiServerInternalURL is a valid URI with scheme 'https', address and optionally a port (defaulting to 443).  apiServerInternalURL can be used by components like kubelets, to contact the Kubernetes API server using the infrastructure provider rather than Kubernetes networking.",
	"controlPlaneTopology":   "controlPlaneTopology expresses the expectations for operands that normally run on control nodes. The default is 'HighlyAvailable', which represents the behavior operators have in a \"normal\" cluster. The 'SingleReplica' mode will be used in single-node deployments and the operators should not configure the operand for highly-available operation The 'External' mode indicates that the control plane is hosted externally to the cluster and that its components are not visible within the cluster.",
	"infrastructureTopology": "infrastructureTopology expresses the expectations for infrastructure services that do not run on control plane nodes, usually indicated by a node selector for a `role` value other than `master`. The default is 'HighlyAvailable', which represents the behavior operators have in a \"normal\" cluster. The 'SingleReplica' mode will be used in single-node deployments and the operators should not configure the operand for highly-available operation NOTE: External topology mode is not applicable for this field.",
	"cpuPartitioning":        "cpuPartitioning expresses if CPU partitioning is a currently enabled feature in the cluster. CPU Partitioning means that this cluster can support partitioning workloads to specific CPU Sets. Valid values are \"None\" and \"AllNodes\". When omitted, the default value is \"None\". The default value of \"None\" indicates that no nodes will be setup with CPU partitioning. The \"AllNodes\" value indicates that all nodes have been setup with CPU partitioning, and can then be further configured via the PerformanceProfile API.",
}

func (InfrastructureStatus) SwaggerDoc() map[string]string {
	return map_InfrastructureStatus
}

var map_KubevirtPlatformSpec = map[string]string{
	"": "KubevirtPlatformSpec holds the desired state of the kubevirt infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (KubevirtPlatformSpec) SwaggerDoc() map[string]string {
	return map_KubevirtPlatformSpec
}

var map_KubevirtPlatformStatus = map[string]string{
	"":                    "KubevirtPlatformStatus holds the current status of the kubevirt infrastructure provider.",
	"apiServerInternalIP": "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.",
	"ingressIP":           "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.",
}

func (KubevirtPlatformStatus) SwaggerDoc() map[string]string {
	return map_KubevirtPlatformStatus
}

var map_NutanixPlatformLoadBalancer = map[string]string{
	"":     "NutanixPlatformLoadBalancer defines the load balancer used by the cluster on Nutanix platform.",
	"type": "type defines the type of load balancer used by the cluster on Nutanix platform which can be a user-managed or openshift-managed load balancer that is to be used for the OpenShift API and Ingress endpoints. When set to OpenShiftManagedDefault the static pods in charge of API and Ingress traffic load-balancing defined in the machine config operator will be deployed. When set to UserManaged these static pods will not be deployed and it is expected that the load balancer is configured out of band by the deployer. When omitted, this means no opinion and the platform is left to choose a reasonable default. The default value is OpenShiftManagedDefault.",
}

func (NutanixPlatformLoadBalancer) SwaggerDoc() map[string]string {
	return map_NutanixPlatformLoadBalancer
}

var map_NutanixPlatformSpec = map[string]string{
	"":              "NutanixPlatformSpec holds the desired state of the Nutanix infrastructure provider. This only includes fields that can be modified in the cluster.",
	"prismCentral":  "prismCentral holds the endpoint address and port to access the Nutanix Prism Central. When a cluster-wide proxy is installed, by default, this endpoint will be accessed via the proxy. Should you wish for communication with this endpoint not to be proxied, please add the endpoint to the proxy spec.noProxy list.",
	"prismElements": "prismElements holds one or more endpoint address and port data to access the Nutanix Prism Elements (clusters) of the Nutanix Prism Central. Currently we only support one Prism Element (cluster) for an OpenShift cluster, where all the Nutanix resources (VMs, subnets, volumes, etc.) used in the OpenShift cluster are located. In the future, we may support Nutanix resources (VMs, etc.) spread over multiple Prism Elements (clusters) of the Prism Central.",
}

func (NutanixPlatformSpec) SwaggerDoc() map[string]string {
	return map_NutanixPlatformSpec
}

var map_NutanixPlatformStatus = map[string]string{
	"":                     "NutanixPlatformStatus holds the current status of the Nutanix infrastructure provider.",
	"apiServerInternalIP":  "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.\n\nDeprecated: Use APIServerInternalIPs instead.",
	"apiServerInternalIPs": "apiServerInternalIPs are the IP addresses to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. These are the IPs for a self-hosted load balancer in front of the API servers. In dual stack clusters this list contains two IPs otherwise only one.",
	"ingressIP":            "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.\n\nDeprecated: Use IngressIPs instead.",
	"ingressIPs":           "ingressIPs are the external IPs which route to the default ingress controller. The IPs are suitable targets of a wildcard DNS record used to resolve default route host names. In dual stack clusters this list contains two IPs otherwise only one.",
	"loadBalancer":         "loadBalancer defines how the load balancer used by the cluster is configured.",
}

func (NutanixPlatformStatus) SwaggerDoc() map[string]string {
	return map_NutanixPlatformStatus
}

var map_NutanixPrismElementEndpoint = map[string]string{
	"":         "NutanixPrismElementEndpoint holds the name and endpoint data for a Prism Element (cluster)",
	"name":     "name is the name of the Prism Element (cluster). This value will correspond with the cluster field configured on other resources (eg Machines, PVCs, etc).",
	"endpoint": "endpoint holds the endpoint address and port data of the Prism Element (cluster). When a cluster-wide proxy is installed, by default, this endpoint will be accessed via the proxy. Should you wish for communication with this endpoint not to be proxied, please add the endpoint to the proxy spec.noProxy list.",
}

func (NutanixPrismElementEndpoint) SwaggerDoc() map[string]string {
	return map_NutanixPrismElementEndpoint
}

var map_NutanixPrismEndpoint = map[string]string{
	"":        "NutanixPrismEndpoint holds the endpoint address and port to access the Nutanix Prism Central or Element (cluster)",
	"address": "address is the endpoint address (DNS name or IP address) of the Nutanix Prism Central or Element (cluster)",
	"port":    "port is the port number to access the Nutanix Prism Central or Element (cluster)",
}

func (NutanixPrismEndpoint) SwaggerDoc() map[string]string {
	return map_NutanixPrismEndpoint
}

var map_OpenStackPlatformLoadBalancer = map[string]string{
	"":     "OpenStackPlatformLoadBalancer defines the load balancer used by the cluster on OpenStack platform.",
	"type": "type defines the type of load balancer used by the cluster on OpenStack platform which can be a user-managed or openshift-managed load balancer that is to be used for the OpenShift API and Ingress endpoints. When set to OpenShiftManagedDefault the static pods in charge of API and Ingress traffic load-balancing defined in the machine config operator will be deployed. When set to UserManaged these static pods will not be deployed and it is expected that the load balancer is configured out of band by the deployer. When omitted, this means no opinion and the platform is left to choose a reasonable default. The default value is OpenShiftManagedDefault.",
}

func (OpenStackPlatformLoadBalancer) SwaggerDoc() map[string]string {
	return map_OpenStackPlatformLoadBalancer
}

var map_OpenStackPlatformSpec = map[string]string{
	"": "OpenStackPlatformSpec holds the desired state of the OpenStack infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (OpenStackPlatformSpec) SwaggerDoc() map[string]string {
	return map_OpenStackPlatformSpec
}

var map_OpenStackPlatformStatus = map[string]string{
	"":                     "OpenStackPlatformStatus holds the current status of the OpenStack infrastructure provider.",
	"apiServerInternalIP":  "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.\n\nDeprecated: Use APIServerInternalIPs instead.",
	"apiServerInternalIPs": "apiServerInternalIPs are the IP addresses to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. These are the IPs for a self-hosted load balancer in front of the API servers. In dual stack clusters this list contains two IPs otherwise only one.",
	"cloudName":            "cloudName is the name of the desired OpenStack cloud in the client configuration file (`clouds.yaml`).",
	"ingressIP":            "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.\n\nDeprecated: Use IngressIPs instead.",
	"ingressIPs":           "ingressIPs are the external IPs which route to the default ingress controller. The IPs are suitable targets of a wildcard DNS record used to resolve default route host names. In dual stack clusters this list contains two IPs otherwise only one.",
	"nodeDNSIP":            "nodeDNSIP is the IP address for the internal DNS used by the nodes. Unlike the one managed by the DNS operator, `NodeDNSIP` provides name resolution for the nodes themselves. There is no DNS-as-a-service for OpenStack deployments. In order to minimize necessary changes to the datacenter DNS, a DNS service is hosted as a static pod to serve those hostnames to the nodes in the cluster.",
	"loadBalancer":         "loadBalancer defines how the load balancer used by the cluster is configured.",
}

func (OpenStackPlatformStatus) SwaggerDoc() map[string]string {
	return map_OpenStackPlatformStatus
}

var map_OvirtPlatformLoadBalancer = map[string]string{
	"":     "OvirtPlatformLoadBalancer defines the load balancer used by the cluster on Ovirt platform.",
	"type": "type defines the type of load balancer used by the cluster on Ovirt platform which can be a user-managed or openshift-managed load balancer that is to be used for the OpenShift API and Ingress endpoints. When set to OpenShiftManagedDefault the static pods in charge of API and Ingress traffic load-balancing defined in the machine config operator will be deployed. When set to UserManaged these static pods will not be deployed and it is expected that the load balancer is configured out of band by the deployer. When omitted, this means no opinion and the platform is left to choose a reasonable default. The default value is OpenShiftManagedDefault.",
}

func (OvirtPlatformLoadBalancer) SwaggerDoc() map[string]string {
	return map_OvirtPlatformLoadBalancer
}

var map_OvirtPlatformSpec = map[string]string{
	"": "OvirtPlatformSpec holds the desired state of the oVirt infrastructure provider. This only includes fields that can be modified in the cluster.",
}

func (OvirtPlatformSpec) SwaggerDoc() map[string]string {
	return map_OvirtPlatformSpec
}

var map_OvirtPlatformStatus = map[string]string{
	"":                     "OvirtPlatformStatus holds the current status of the  oVirt infrastructure provider.",
	"apiServerInternalIP":  "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.\n\nDeprecated: Use APIServerInternalIPs instead.",
	"apiServerInternalIPs": "apiServerInternalIPs are the IP addresses to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. These are the IPs for a self-hosted load balancer in front of the API servers. In dual stack clusters this list contains two IPs otherwise only one.",
	"ingressIP":            "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.\n\nDeprecated: Use IngressIPs instead.",
	"ingressIPs":           "ingressIPs are the external IPs which route to the default ingress controller. The IPs are suitable targets of a wildcard DNS record used to resolve default route host names. In dual stack clusters this list contains two IPs otherwise only one.",
	"nodeDNSIP":            "deprecated: as of 4.6, this field is no longer set or honored.  It will be removed in a future release.",
	"loadBalancer":         "loadBalancer defines how the load balancer used by the cluster is configured.",
}

func (OvirtPlatformStatus) SwaggerDoc() map[string]string {
	return map_OvirtPlatformStatus
}

var map_PlatformSpec = map[string]string{
	"":             "PlatformSpec holds the desired state specific to the underlying infrastructure provider of the current cluster. Since these are used at spec-level for the underlying cluster, it is supposed that only one of the spec structs is set.",
	"type":         "type is the underlying infrastructure provider for the cluster. This value controls whether infrastructure automation such as service load balancers, dynamic volume provisioning, machine creation and deletion, and other integrations are enabled. If None, no infrastructure automation is enabled. Allowed values are \"AWS\", \"Azure\", \"BareMetal\", \"GCP\", \"Libvirt\", \"OpenStack\", \"VSphere\", \"oVirt\", \"KubeVirt\", \"EquinixMetal\", \"PowerVS\", \"AlibabaCloud\", \"Nutanix\" and \"None\". Individual components may not support all platforms, and must handle unrecognized platforms as None if they do not support that platform.",
	"aws":          "AWS contains settings specific to the Amazon Web Services infrastructure provider.",
	"azure":        "Azure contains settings specific to the Azure infrastructure provider.",
	"gcp":          "GCP contains settings specific to the Google Cloud Platform infrastructure provider.",
	"baremetal":    "BareMetal contains settings specific to the BareMetal platform.",
	"openstack":    "OpenStack contains settings specific to the OpenStack infrastructure provider.",
	"ovirt":        "Ovirt contains settings specific to the oVirt infrastructure provider.",
	"vsphere":      "VSphere contains settings specific to the VSphere infrastructure provider.",
	"ibmcloud":     "IBMCloud contains settings specific to the IBMCloud infrastructure provider.",
	"kubevirt":     "Kubevirt contains settings specific to the kubevirt infrastructure provider.",
	"equinixMetal": "EquinixMetal contains settings specific to the Equinix Metal infrastructure provider.",
	"powervs":      "PowerVS contains settings specific to the IBM Power Systems Virtual Servers infrastructure provider.",
	"alibabaCloud": "AlibabaCloud contains settings specific to the Alibaba Cloud infrastructure provider.",
	"nutanix":      "Nutanix contains settings specific to the Nutanix infrastructure provider.",
	"external":     "ExternalPlatformType represents generic infrastructure provider. Platform-specific components should be supplemented separately.",
}

func (PlatformSpec) SwaggerDoc() map[string]string {
	return map_PlatformSpec
}

var map_PlatformStatus = map[string]string{
	"":             "PlatformStatus holds the current status specific to the underlying infrastructure provider of the current cluster. Since these are used at status-level for the underlying cluster, it is supposed that only one of the status structs is set.",
	"type":         "type is the underlying infrastructure provider for the cluster. This value controls whether infrastructure automation such as service load balancers, dynamic volume provisioning, machine creation and deletion, and other integrations are enabled. If None, no infrastructure automation is enabled. Allowed values are \"AWS\", \"Azure\", \"BareMetal\", \"GCP\", \"Libvirt\", \"OpenStack\", \"VSphere\", \"oVirt\", \"EquinixMetal\", \"PowerVS\", \"AlibabaCloud\", \"Nutanix\" and \"None\". Individual components may not support all platforms, and must handle unrecognized platforms as None if they do not support that platform.\n\nThis value will be synced with to the `status.platform` and `status.platformStatus.type`. Currently this value cannot be changed once set.",
	"aws":          "AWS contains settings specific to the Amazon Web Services infrastructure provider.",
	"azure":        "Azure contains settings specific to the Azure infrastructure provider.",
	"gcp":          "GCP contains settings specific to the Google Cloud Platform infrastructure provider.",
	"baremetal":    "BareMetal contains settings specific to the BareMetal platform.",
	"openstack":    "OpenStack contains settings specific to the OpenStack infrastructure provider.",
	"ovirt":        "Ovirt contains settings specific to the oVirt infrastructure provider.",
	"vsphere":      "VSphere contains settings specific to the VSphere infrastructure provider.",
	"ibmcloud":     "IBMCloud contains settings specific to the IBMCloud infrastructure provider.",
	"kubevirt":     "Kubevirt contains settings specific to the kubevirt infrastructure provider.",
	"equinixMetal": "EquinixMetal contains settings specific to the Equinix Metal infrastructure provider.",
	"powervs":      "PowerVS contains settings specific to the Power Systems Virtual Servers infrastructure provider.",
	"alibabaCloud": "AlibabaCloud contains settings specific to the Alibaba Cloud infrastructure provider.",
	"nutanix":      "Nutanix contains settings specific to the Nutanix infrastructure provider.",
	"external":     "External contains settings specific to the generic External infrastructure provider.",
}

func (PlatformStatus) SwaggerDoc() map[string]string {
	return map_PlatformStatus
}

var map_PowerVSPlatformSpec = map[string]string{
	"":                 "PowerVSPlatformSpec holds the desired state of the IBM Power Systems Virtual Servers infrastructure provider. This only includes fields that can be modified in the cluster.",
	"serviceEndpoints": "serviceEndpoints is a list of custom endpoints which will override the default service endpoints of a Power VS service.",
}

func (PowerVSPlatformSpec) SwaggerDoc() map[string]string {
	return map_PowerVSPlatformSpec
}

var map_PowerVSPlatformStatus = map[string]string{
	"":                 "PowerVSPlatformStatus holds the current status of the IBM Power Systems Virtual Servers infrastrucutre provider.",
	"region":           "region holds the default Power VS region for new Power VS resources created by the cluster.",
	"zone":             "zone holds the default zone for the new Power VS resources created by the cluster. Note: Currently only single-zone OCP clusters are supported",
	"resourceGroup":    "resourceGroup is the resource group name for new IBMCloud resources created for a cluster. The resource group specified here will be used by cluster-image-registry-operator to set up a COS Instance in IBMCloud for the cluster registry. More about resource groups can be found here: https://cloud.ibm.com/docs/account?topic=account-rgs. When omitted, the image registry operator won't be able to configure storage, which results in the image registry cluster operator not being in an available state.",
	"serviceEndpoints": "serviceEndpoints is a list of custom endpoints which will override the default service endpoints of a Power VS service.",
	"cisInstanceCRN":   "CISInstanceCRN is the CRN of the Cloud Internet Services instance managing the DNS zone for the cluster's base domain",
	"dnsInstanceCRN":   "DNSInstanceCRN is the CRN of the DNS Services instance managing the DNS zone for the cluster's base domain",
}

func (PowerVSPlatformStatus) SwaggerDoc() map[string]string {
	return map_PowerVSPlatformStatus
}

var map_PowerVSServiceEndpoint = map[string]string{
	"":     "PowervsServiceEndpoint stores the configuration of a custom url to override existing defaults of PowerVS Services.",
	"name": "name is the name of the Power VS service. Few of the services are IAM - https://cloud.ibm.com/apidocs/iam-identity-token-api ResourceController - https://cloud.ibm.com/apidocs/resource-controller/resource-controller Power Cloud - https://cloud.ibm.com/apidocs/power-cloud",
	"url":  "url is fully qualified URI with scheme https, that overrides the default generated endpoint for a client. This must be provided and cannot be empty.",
}

func (PowerVSServiceEndpoint) SwaggerDoc() map[string]string {
	return map_PowerVSServiceEndpoint
}

var map_VSpherePlatformFailureDomainSpec = map[string]string{
	"":         "VSpherePlatformFailureDomainSpec holds the region and zone failure domain and the vCenter topology of that failure domain.",
	"name":     "name defines the arbitrary but unique name of a failure domain.",
	"region":   "region defines the name of a region tag that will be attached to a vCenter datacenter. The tag category in vCenter must be named openshift-region.",
	"zone":     "zone defines the name of a zone tag that will be attached to a vCenter cluster. The tag category in vCenter must be named openshift-zone.",
	"server":   "server is the fully-qualified domain name or the IP address of the vCenter server.",
	"topology": "Topology describes a given failure domain using vSphere constructs",
}

func (VSpherePlatformFailureDomainSpec) SwaggerDoc() map[string]string {
	return map_VSpherePlatformFailureDomainSpec
}

var map_VSpherePlatformLoadBalancer = map[string]string{
	"":     "VSpherePlatformLoadBalancer defines the load balancer used by the cluster on VSphere platform.",
	"type": "type defines the type of load balancer used by the cluster on VSphere platform which can be a user-managed or openshift-managed load balancer that is to be used for the OpenShift API and Ingress endpoints. When set to OpenShiftManagedDefault the static pods in charge of API and Ingress traffic load-balancing defined in the machine config operator will be deployed. When set to UserManaged these static pods will not be deployed and it is expected that the load balancer is configured out of band by the deployer. When omitted, this means no opinion and the platform is left to choose a reasonable default. The default value is OpenShiftManagedDefault.",
}

func (VSpherePlatformLoadBalancer) SwaggerDoc() map[string]string {
	return map_VSpherePlatformLoadBalancer
}

var map_VSpherePlatformNodeNetworking = map[string]string{
	"":         "VSpherePlatformNodeNetworking holds the external and internal node networking spec.",
	"external": "external represents the network configuration of the node that is externally routable.",
	"internal": "internal represents the network configuration of the node that is routable only within the cluster.",
}

func (VSpherePlatformNodeNetworking) SwaggerDoc() map[string]string {
	return map_VSpherePlatformNodeNetworking
}

var map_VSpherePlatformNodeNetworkingSpec = map[string]string{
	"":                         "VSpherePlatformNodeNetworkingSpec holds the network CIDR(s) and port group name for including and excluding IP ranges in the cloud provider. This would be used for example when multiple network adapters are attached to a guest to help determine which IP address the cloud config manager should use for the external and internal node networking.",
	"networkSubnetCidr":        "networkSubnetCidr IP address on VirtualMachine's network interfaces included in the fields' CIDRs that will be used in respective status.addresses fields.",
	"network":                  "network VirtualMachine's VM Network names that will be used to when searching for status.addresses fields. Note that if internal.networkSubnetCIDR and external.networkSubnetCIDR are not set, then the vNIC associated to this network must only have a single IP address assigned to it. The available networks (port groups) can be listed using `govc ls 'network/*'`",
	"excludeNetworkSubnetCidr": "excludeNetworkSubnetCidr IP addresses in subnet ranges will be excluded when selecting the IP address from the VirtualMachine's VM for use in the status.addresses fields.",
}

func (VSpherePlatformNodeNetworkingSpec) SwaggerDoc() map[string]string {
	return map_VSpherePlatformNodeNetworkingSpec
}

var map_VSpherePlatformSpec = map[string]string{
	"":               "VSpherePlatformSpec holds the desired state of the vSphere infrastructure provider. In the future the cloud provider operator, storage operator and machine operator will use these fields for configuration.",
	"vcenters":       "vcenters holds the connection details for services to communicate with vCenter. Currently, only a single vCenter is supported.",
	"failureDomains": "failureDomains contains the definition of region, zone and the vCenter topology. If this is omitted failure domains (regions and zones) will not be used.",
	"nodeNetworking": "nodeNetworking contains the definition of internal and external network constraints for assigning the node's networking. If this field is omitted, networking defaults to the legacy address selection behavior which is to only support a single address and return the first one found.",
}

func (VSpherePlatformSpec) SwaggerDoc() map[string]string {
	return map_VSpherePlatformSpec
}

var map_VSpherePlatformStatus = map[string]string{
	"":                     "VSpherePlatformStatus holds the current status of the vSphere infrastructure provider.",
	"apiServerInternalIP":  "apiServerInternalIP is an IP address to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. It is the IP that the Infrastructure.status.apiServerInternalURI points to. It is the IP for a self-hosted load balancer in front of the API servers.\n\nDeprecated: Use APIServerInternalIPs instead.",
	"apiServerInternalIPs": "apiServerInternalIPs are the IP addresses to contact the Kubernetes API server that can be used by components inside the cluster, like kubelets using the infrastructure rather than Kubernetes networking. These are the IPs for a self-hosted load balancer in front of the API servers. In dual stack clusters this list contains two IPs otherwise only one.",
	"ingressIP":            "ingressIP is an external IP which routes to the default ingress controller. The IP is a suitable target of a wildcard DNS record used to resolve default route host names.\n\nDeprecated: Use IngressIPs instead.",
	"ingressIPs":           "ingressIPs are the external IPs which route to the default ingress controller. The IPs are suitable targets of a wildcard DNS record used to resolve default route host names. In dual stack clusters this list contains two IPs otherwise only one.",
	"nodeDNSIP":            "nodeDNSIP is the IP address for the internal DNS used by the nodes. Unlike the one managed by the DNS operator, `NodeDNSIP` provides name resolution for the nodes themselves. There is no DNS-as-a-service for vSphere deployments. In order to minimize necessary changes to the datacenter DNS, a DNS service is hosted as a static pod to serve those hostnames to the nodes in the cluster.",
	"loadBalancer":         "loadBalancer defines how the load balancer used by the cluster is configured.",
}

func (VSpherePlatformStatus) SwaggerDoc() map[string]string {
	return map_VSpherePlatformStatus
}

var map_VSpherePlatformTopology = map[string]string{
	"":               "VSpherePlatformTopology holds the required and optional vCenter objects - datacenter, computeCluster, networks, datastore and resourcePool - to provision virtual machines.",
	"datacenter":     "datacenter is the name of vCenter datacenter in which virtual machines will be located. The maximum length of the datacenter name is 80 characters.",
	"computeCluster": "computeCluster the absolute path of the vCenter cluster in which virtual machine will be located. The absolute path is of the form /<datacenter>/host/<cluster>. The maximum length of the path is 2048 characters.",
	"networks":       "networks is the list of port group network names within this failure domain. Currently, we only support a single interface per RHCOS virtual machine. The available networks (port groups) can be listed using `govc ls 'network/*'` The single interface should be the absolute path of the form /<datacenter>/network/<portgroup>.",
	"datastore":      "datastore is the absolute path of the datastore in which the virtual machine is located. The absolute path is of the form /<datacenter>/datastore/<datastore> The maximum length of the path is 2048 characters.",
	"resourcePool":   "resourcePool is the absolute path of the resource pool where virtual machines will be created. The absolute path is of the form /<datacenter>/host/<cluster>/Resources/<resourcepool>. The maximum length of the path is 2048 characters.",
	"folder":         "folder is the absolute path of the folder where virtual machines are located. The absolute path is of the form /<datacenter>/vm/<folder>. The maximum length of the path is 2048 characters.",
}

func (VSpherePlatformTopology) SwaggerDoc() map[string]string {
	return map_VSpherePlatformTopology
}

var map_VSpherePlatformVCenterSpec = map[string]string{
	"":            "VSpherePlatformVCenterSpec stores the vCenter connection fields. This is used by the vSphere CCM.",
	"server":      "server is the fully-qualified domain name or the IP address of the vCenter server.",
	"port":        "port is the TCP port that will be used to communicate to the vCenter endpoint. When omitted, this means the user has no opinion and it is up to the platform to choose a sensible default, which is subject to change over time.",
	"datacenters": "The vCenter Datacenters in which the RHCOS vm guests are located. This field will be used by the Cloud Controller Manager. Each datacenter listed here should be used within a topology.",
}

func (VSpherePlatformVCenterSpec) SwaggerDoc() map[string]string {
	return map_VSpherePlatformVCenterSpec
}

var map_AWSIngressSpec = map[string]string{
	"":     "AWSIngressSpec holds the desired state of the Ingress for Amazon Web Services infrastructure provider. This only includes fields that can be modified in the cluster.",
	"type": "type allows user to set a load balancer type. When this field is set the default ingresscontroller will get created using the specified LBType. If this field is not set then the default ingress controller of LBType Classic will be created. Valid values are:\n\n* \"Classic\": A Classic Load Balancer that makes routing decisions at either\n  the transport layer (TCP/SSL) or the application layer (HTTP/HTTPS). See\n  the following for additional details:\n\n    https://docs.aws.amazon.com/AmazonECS/latest/developerguide/load-balancer-types.html#clb\n\n* \"NLB\": A Network Load Balancer that makes routing decisions at the\n  transport layer (TCP/SSL). See the following for additional details:\n\n    https://docs.aws.amazon.com/AmazonECS/latest/developerguide/load-balancer-types.html#nlb",
}

func (AWSIngressSpec) SwaggerDoc() map[string]string {
	return map_AWSIngressSpec
}

var map_ComponentRouteSpec = map[string]string{
	"":                         "ComponentRouteSpec allows for configuration of a route's hostname and serving certificate.",
	"namespace":                "namespace is the namespace of the route to customize.\n\nThe namespace and name of this componentRoute must match a corresponding entry in the list of status.componentRoutes if the route is to be customized.",
	"name":                     "name is the logical name of the route to customize.\n\nThe namespace and name of this componentRoute must match a corresponding entry in the list of status.componentRoutes if the route is to be customized.",
	"hostname":                 "hostname is the hostname that should be used by the route.",
	"servingCertKeyPairSecret": "servingCertKeyPairSecret is a reference to a secret of type `kubernetes.io/tls` in the openshift-config namespace. The serving cert/key pair must match and will be used by the operator to fulfill the intent of serving with this name. If the custom hostname uses the default routing suffix of the cluster, the Secret specification for a serving certificate will not be needed.",
}

func (ComponentRouteSpec) SwaggerDoc() map[string]string {
	return map_ComponentRouteSpec
}

var map_ComponentRouteStatus = map[string]string{
	"":                 "ComponentRouteStatus contains information allowing configuration of a route's hostname and serving certificate.",
	"namespace":        "namespace is the namespace of the route to customize. It must be a real namespace. Using an actual namespace ensures that no two components will conflict and the same component can be installed multiple times.\n\nThe namespace and name of this componentRoute must match a corresponding entry in the list of spec.componentRoutes if the route is to be customized.",
	"name":             "name is the logical name of the route to customize. It does not have to be the actual name of a route resource but it cannot be renamed.\n\nThe namespace and name of this componentRoute must match a corresponding entry in the list of spec.componentRoutes if the route is to be customized.",
	"defaultHostname":  "defaultHostname is the hostname of this route prior to customization.",
	"consumingUsers":   "consumingUsers is a slice of ServiceAccounts that need to have read permission on the servingCertKeyPairSecret secret.",
	"currentHostnames": "currentHostnames is the list of current names used by the route. Typically, this list should consist of a single hostname, but if multiple hostnames are supported by the route the operator may write multiple entries to this list.",
	"conditions":       "conditions are used to communicate the state of the componentRoutes entry.\n\nSupported conditions include Available, Degraded and Progressing.\n\nIf available is true, the content served by the route can be accessed by users. This includes cases where a default may continue to serve content while the customized route specified by the cluster-admin is being configured.\n\nIf Degraded is true, that means something has gone wrong trying to handle the componentRoutes entry. The currentHostnames field may or may not be in effect.\n\nIf Progressing is true, that means the component is taking some action related to the componentRoutes entry.",
	"relatedObjects":   "relatedObjects is a list of resources which are useful when debugging or inspecting how spec.componentRoutes is applied.",
}

func (ComponentRouteStatus) SwaggerDoc() map[string]string {
	return map_ComponentRouteStatus
}

var map_Ingress = map[string]string{
	"":         "Ingress holds cluster-wide information about ingress, including the default ingress domain used for routes. The canonical name is `cluster`.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Ingress) SwaggerDoc() map[string]string {
	return map_Ingress
}

var map_IngressList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (IngressList) SwaggerDoc() map[string]string {
	return map_IngressList
}

var map_IngressPlatformSpec = map[string]string{
	"":     "IngressPlatformSpec holds the desired state of Ingress specific to the underlying infrastructure provider of the current cluster. Since these are used at spec-level for the underlying cluster, it is supposed that only one of the spec structs is set.",
	"type": "type is the underlying infrastructure provider for the cluster. Allowed values are \"AWS\", \"Azure\", \"BareMetal\", \"GCP\", \"Libvirt\", \"OpenStack\", \"VSphere\", \"oVirt\", \"KubeVirt\", \"EquinixMetal\", \"PowerVS\", \"AlibabaCloud\", \"Nutanix\" and \"None\". Individual components may not support all platforms, and must handle unrecognized platforms as None if they do not support that platform.",
	"aws":  "aws contains settings specific to the Amazon Web Services infrastructure provider.",
}

func (IngressPlatformSpec) SwaggerDoc() map[string]string {
	return map_IngressPlatformSpec
}

var map_IngressSpec = map[string]string{
	"domain":               "domain is used to generate a default host name for a route when the route's host name is empty. The generated host name will follow this pattern: \"<route-name>.<route-namespace>.<domain>\".\n\nIt is also used as the default wildcard domain suffix for ingress. The default ingresscontroller domain will follow this pattern: \"*.<domain>\".\n\nOnce set, changing domain is not currently supported.",
	"appsDomain":           "appsDomain is an optional domain to use instead of the one specified in the domain field when a Route is created without specifying an explicit host. If appsDomain is nonempty, this value is used to generate default host values for Route. Unlike domain, appsDomain may be modified after installation. This assumes a new ingresscontroller has been setup with a wildcard certificate.",
	"componentRoutes":      "componentRoutes is an optional list of routes that are managed by OpenShift components that a cluster-admin is able to configure the hostname and serving certificate for. The namespace and name of each route in this list should match an existing entry in the status.componentRoutes list.\n\nTo determine the set of configurable Routes, look at namespace and name of entries in the .status.componentRoutes list, where participating operators write the status of configurable routes.",
	"requiredHSTSPolicies": "requiredHSTSPolicies specifies HSTS policies that are required to be set on newly created  or updated routes matching the domainPattern/s and namespaceSelector/s that are specified in the policy. Each requiredHSTSPolicy must have at least a domainPattern and a maxAge to validate a route HSTS Policy route annotation, and affect route admission.\n\nA candidate route is checked for HSTS Policies if it has the HSTS Policy route annotation: \"haproxy.router.openshift.io/hsts_header\" E.g. haproxy.router.openshift.io/hsts_header: max-age=31536000;preload;includeSubDomains\n\n- For each candidate route, if it matches a requiredHSTSPolicy domainPattern and optional namespaceSelector, then the maxAge, preloadPolicy, and includeSubdomainsPolicy must be valid to be admitted.  Otherwise, the route is rejected. - The first match, by domainPattern and optional namespaceSelector, in the ordering of the RequiredHSTSPolicies determines the route's admission status. - If the candidate route doesn't match any requiredHSTSPolicy domainPattern and optional namespaceSelector, then it may use any HSTS Policy annotation.\n\nThe HSTS policy configuration may be changed after routes have already been created. An update to a previously admitted route may then fail if the updated route does not conform to the updated HSTS policy configuration. However, changing the HSTS policy configuration will not cause a route that is already admitted to stop working.\n\nNote that if there are no RequiredHSTSPolicies, any HSTS Policy annotation on the route is valid.",
	"loadBalancer":         "loadBalancer contains the load balancer details in general which are not only specific to the underlying infrastructure provider of the current cluster and are required for Ingress Controller to work on OpenShift.",
}

func (IngressSpec) SwaggerDoc() map[string]string {
	return map_IngressSpec
}

var map_IngressStatus = map[string]string{
	"componentRoutes":  "componentRoutes is where participating operators place the current route status for routes whose hostnames and serving certificates can be customized by the cluster-admin.",
	"defaultPlacement": "defaultPlacement is set at installation time to control which nodes will host the ingress router pods by default. The options are control-plane nodes or worker nodes.\n\nThis field works by dictating how the Cluster Ingress Operator will consider unset replicas and nodePlacement fields in IngressController resources when creating the corresponding Deployments.\n\nSee the documentation for the IngressController replicas and nodePlacement fields for more information.\n\nWhen omitted, the default value is Workers",
}

func (IngressStatus) SwaggerDoc() map[string]string {
	return map_IngressStatus
}

var map_LoadBalancer = map[string]string{
	"platform": "platform holds configuration specific to the underlying infrastructure provider for the ingress load balancers. When omitted, this means the user has no opinion and the platform is left to choose reasonable defaults. These defaults are subject to change over time.",
}

func (LoadBalancer) SwaggerDoc() map[string]string {
	return map_LoadBalancer
}

var map_ClusterNetworkEntry = map[string]string{
	"":           "ClusterNetworkEntry is a contiguous block of IP addresses from which pod IPs are allocated.",
	"cidr":       "The complete block for pod IPs.",
	"hostPrefix": "The size (prefix) of block to allocate to each node. If this field is not used by the plugin, it can be left unset.",
}

func (ClusterNetworkEntry) SwaggerDoc() map[string]string {
	return map_ClusterNetworkEntry
}

var map_ExternalIPConfig = map[string]string{
	"":                "ExternalIPConfig specifies some IP blocks relevant for the ExternalIP field of a Service resource.",
	"policy":          "policy is a set of restrictions applied to the ExternalIP field. If nil or empty, then ExternalIP is not allowed to be set.",
	"autoAssignCIDRs": "autoAssignCIDRs is a list of CIDRs from which to automatically assign Service.ExternalIP. These are assigned when the service is of type LoadBalancer. In general, this is only useful for bare-metal clusters. In Openshift 3.x, this was misleadingly called \"IngressIPs\". Automatically assigned External IPs are not affected by any ExternalIPPolicy rules. Currently, only one entry may be provided.",
}

func (ExternalIPConfig) SwaggerDoc() map[string]string {
	return map_ExternalIPConfig
}

var map_ExternalIPPolicy = map[string]string{
	"":              "ExternalIPPolicy configures exactly which IPs are allowed for the ExternalIP field in a Service. If the zero struct is supplied, then none are permitted. The policy controller always allows automatically assigned external IPs.",
	"allowedCIDRs":  "allowedCIDRs is the list of allowed CIDRs.",
	"rejectedCIDRs": "rejectedCIDRs is the list of disallowed CIDRs. These take precedence over allowedCIDRs.",
}

func (ExternalIPPolicy) SwaggerDoc() map[string]string {
	return map_ExternalIPPolicy
}

var map_MTUMigration = map[string]string{
	"":        "MTUMigration contains infomation about MTU migration.",
	"network": "Network contains MTU migration configuration for the default network.",
	"machine": "Machine contains MTU migration configuration for the machine's uplink.",
}

func (MTUMigration) SwaggerDoc() map[string]string {
	return map_MTUMigration
}

var map_MTUMigrationValues = map[string]string{
	"":     "MTUMigrationValues contains the values for a MTU migration.",
	"to":   "To is the MTU to migrate to.",
	"from": "From is the MTU to migrate from.",
}

func (MTUMigrationValues) SwaggerDoc() map[string]string {
	return map_MTUMigrationValues
}

var map_Network = map[string]string{
	"":         "Network holds cluster-wide information about Network. The canonical name is `cluster`. It is used to configure the desired network configuration, such as: IP address pools for services/pod IPs, network plugin, etc. Please view network.spec for an explanation on what applies when configuring this resource.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration. As a general rule, this SHOULD NOT be read directly. Instead, you should consume the NetworkStatus, as it indicates the currently deployed configuration. Currently, most spec fields are immutable after installation. Please view the individual ones for further details on each.",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Network) SwaggerDoc() map[string]string {
	return map_Network
}

var map_NetworkList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (NetworkList) SwaggerDoc() map[string]string {
	return map_NetworkList
}

var map_NetworkMigration = map[string]string{
	"":            "NetworkMigration represents the cluster network configuration.",
	"networkType": "NetworkType is the target plugin that is to be deployed. Currently supported values are: OpenShiftSDN, OVNKubernetes",
	"mtu":         "MTU contains the MTU migration configuration.",
}

func (NetworkMigration) SwaggerDoc() map[string]string {
	return map_NetworkMigration
}

var map_NetworkSpec = map[string]string{
	"":                     "NetworkSpec is the desired network configuration. As a general rule, this SHOULD NOT be read directly. Instead, you should consume the NetworkStatus, as it indicates the currently deployed configuration. Currently, most spec fields are immutable after installation. Please view the individual ones for further details on each.",
	"clusterNetwork":       "IP address pool to use for pod IPs. This field is immutable after installation.",
	"serviceNetwork":       "IP address pool for services. Currently, we only support a single entry here. This field is immutable after installation.",
	"networkType":          "NetworkType is the plugin that is to be deployed (e.g. OpenShiftSDN). This should match a value that the cluster-network-operator understands, or else no networking will be installed. Currently supported values are: - OpenShiftSDN This field is immutable after installation.",
	"externalIP":           "externalIP defines configuration for controllers that affect Service.ExternalIP. If nil, then ExternalIP is not allowed to be set.",
	"serviceNodePortRange": "The port range allowed for Services of type NodePort. If not specified, the default of 30000-32767 will be used. Such Services without a NodePort specified will have one automatically allocated from this range. This parameter can be updated after the cluster is installed.",
}

func (NetworkSpec) SwaggerDoc() map[string]string {
	return map_NetworkSpec
}

var map_NetworkStatus = map[string]string{
	"":                  "NetworkStatus is the current network configuration.",
	"clusterNetwork":    "IP address pool to use for pod IPs.",
	"serviceNetwork":    "IP address pool for services. Currently, we only support a single entry here.",
	"networkType":       "NetworkType is the plugin that is deployed (e.g. OpenShiftSDN).",
	"clusterNetworkMTU": "ClusterNetworkMTU is the MTU for inter-pod networking.",
	"migration":         "Migration contains the cluster network migration configuration.",
}

func (NetworkStatus) SwaggerDoc() map[string]string {
	return map_NetworkStatus
}

var map_Node = map[string]string{
	"":         "Node holds cluster-wide information about node specific features.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values.",
}

func (Node) SwaggerDoc() map[string]string {
	return map_Node
}

var map_NodeList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (NodeList) SwaggerDoc() map[string]string {
	return map_NodeList
}

var map_NodeSpec = map[string]string{
	"cgroupMode":           "CgroupMode determines the cgroups version on the node",
	"workerLatencyProfile": "WorkerLatencyProfile determins the how fast the kubelet is updating the status and corresponding reaction of the cluster",
}

func (NodeSpec) SwaggerDoc() map[string]string {
	return map_NodeSpec
}

var map_BasicAuthIdentityProvider = map[string]string{
	"": "BasicAuthPasswordIdentityProvider provides identities for users authenticating using HTTP basic auth credentials",
}

func (BasicAuthIdentityProvider) SwaggerDoc() map[string]string {
	return map_BasicAuthIdentityProvider
}

var map_GitHubIdentityProvider = map[string]string{
	"":              "GitHubIdentityProvider provides identities for users authenticating using GitHub credentials",
	"clientID":      "clientID is the oauth client ID",
	"clientSecret":  "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"organizations": "organizations optionally restricts which organizations are allowed to log in",
	"teams":         "teams optionally restricts which teams are allowed to log in. Format is <org>/<team>.",
	"hostname":      "hostname is the optional domain (e.g. \"mycompany.com\") for use with a hosted instance of GitHub Enterprise. It must match the GitHub Enterprise settings value configured at /setup/settings#hostname.",
	"ca":            "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. This can only be configured when hostname is set to a non-empty value. The namespace for this config map is openshift-config.",
}

func (GitHubIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitHubIdentityProvider
}

var map_GitLabIdentityProvider = map[string]string{
	"":             "GitLabIdentityProvider provides identities for users authenticating using GitLab credentials",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"url":          "url is the oauth server base URL",
	"ca":           "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
}

func (GitLabIdentityProvider) SwaggerDoc() map[string]string {
	return map_GitLabIdentityProvider
}

var map_GoogleIdentityProvider = map[string]string{
	"":             "GoogleIdentityProvider provides identities for users authenticating using Google credentials",
	"clientID":     "clientID is the oauth client ID",
	"clientSecret": "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"hostedDomain": "hostedDomain is the optional Google App domain (e.g. \"mycompany.com\") to restrict logins to",
}

func (GoogleIdentityProvider) SwaggerDoc() map[string]string {
	return map_GoogleIdentityProvider
}

var map_HTPasswdIdentityProvider = map[string]string{
	"":         "HTPasswdPasswordIdentityProvider provides identities for users authenticating using htpasswd credentials",
	"fileData": "fileData is a required reference to a secret by name containing the data to use as the htpasswd file. The key \"htpasswd\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. If the specified htpasswd data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
}

func (HTPasswdIdentityProvider) SwaggerDoc() map[string]string {
	return map_HTPasswdIdentityProvider
}

var map_IdentityProvider = map[string]string{
	"":              "IdentityProvider provides identities for users authenticating using credentials",
	"name":          "name is used to qualify the identities returned by this provider. - It MUST be unique and not shared by any other identity provider used - It MUST be a valid path segment: name cannot equal \".\" or \"..\" or contain \"/\" or \"%\" or \":\"\n  Ref: https://godoc.org/github.com/openshift/origin/pkg/user/apis/user/validation#ValidateIdentityProviderName",
	"mappingMethod": "mappingMethod determines how identities from this provider are mapped to users Defaults to \"claim\"",
}

func (IdentityProvider) SwaggerDoc() map[string]string {
	return map_IdentityProvider
}

var map_IdentityProviderConfig = map[string]string{
	"":              "IdentityProviderConfig contains configuration for using a specific identity provider",
	"type":          "type identifies the identity provider type for this entry.",
	"basicAuth":     "basicAuth contains configuration options for the BasicAuth IdP",
	"github":        "github enables user authentication using GitHub credentials",
	"gitlab":        "gitlab enables user authentication using GitLab credentials",
	"google":        "google enables user authentication using Google credentials",
	"htpasswd":      "htpasswd enables user authentication using an HTPasswd file to validate credentials",
	"keystone":      "keystone enables user authentication using keystone password credentials",
	"ldap":          "ldap enables user authentication using LDAP credentials",
	"openID":        "openID enables user authentication using OpenID credentials",
	"requestHeader": "requestHeader enables user authentication using request header credentials",
}

func (IdentityProviderConfig) SwaggerDoc() map[string]string {
	return map_IdentityProviderConfig
}

var map_KeystoneIdentityProvider = map[string]string{
	"":           "KeystonePasswordIdentityProvider provides identities for users authenticating using keystone password credentials",
	"domainName": "domainName is required for keystone v3",
}

func (KeystoneIdentityProvider) SwaggerDoc() map[string]string {
	return map_KeystoneIdentityProvider
}

var map_LDAPAttributeMapping = map[string]string{
	"":                  "LDAPAttributeMapping maps LDAP attributes to OpenShift identity fields",
	"id":                "id is the list of attributes whose values should be used as the user ID. Required. First non-empty attribute is used. At least one attribute is required. If none of the listed attribute have a value, authentication fails. LDAP standard identity attribute is \"dn\"",
	"preferredUsername": "preferredUsername is the list of attributes whose values should be used as the preferred username. LDAP standard login attribute is \"uid\"",
	"name":              "name is the list of attributes whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity LDAP standard display name attribute is \"cn\"",
	"email":             "email is the list of attributes whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
}

func (LDAPAttributeMapping) SwaggerDoc() map[string]string {
	return map_LDAPAttributeMapping
}

var map_LDAPIdentityProvider = map[string]string{
	"":             "LDAPPasswordIdentityProvider provides identities for users authenticating using LDAP credentials",
	"url":          "url is an RFC 2255 URL which specifies the LDAP search parameters to use. The syntax of the URL is: ldap://host:port/basedn?attribute?scope?filter",
	"bindDN":       "bindDN is an optional DN to bind with during the search phase.",
	"bindPassword": "bindPassword is an optional reference to a secret by name containing a password to bind with during the search phase. The key \"bindPassword\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"insecure":     "insecure, if true, indicates the connection should not use TLS WARNING: Should not be set to `true` with the URL scheme \"ldaps://\" as \"ldaps://\" URLs always\n         attempt to connect using TLS, even when `insecure` is set to `true`\nWhen `true`, \"ldap://\" URLS connect insecurely. When `false`, \"ldap://\" URLs are upgraded to a TLS connection using StartTLS as specified in https://tools.ietf.org/html/rfc2830.",
	"ca":           "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"attributes":   "attributes maps LDAP attributes to identities",
}

func (LDAPIdentityProvider) SwaggerDoc() map[string]string {
	return map_LDAPIdentityProvider
}

var map_OAuth = map[string]string{
	"":         "OAuth holds cluster-wide information about OAuth.  The canonical name is `cluster`. It is used to configure the integrated OAuth server. This configuration is only honored when the top level Authentication config has type set to IntegratedOAuth.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (OAuth) SwaggerDoc() map[string]string {
	return map_OAuth
}

var map_OAuthList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (OAuthList) SwaggerDoc() map[string]string {
	return map_OAuthList
}

var map_OAuthRemoteConnectionInfo = map[string]string{
	"":              "OAuthRemoteConnectionInfo holds information necessary for establishing a remote connection",
	"url":           "url is the remote URL to connect to",
	"ca":            "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"tlsClientCert": "tlsClientCert is an optional reference to a secret by name that contains the PEM-encoded TLS client certificate to present when connecting to the server. The key \"tls.crt\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. If the specified certificate data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"tlsClientKey":  "tlsClientKey is an optional reference to a secret by name that contains the PEM-encoded TLS private key for the client certificate referenced in tlsClientCert. The key \"tls.key\" is used to locate the data. If specified and the secret or expected key is not found, the identity provider is not honored. If the specified certificate data is not valid, the identity provider is not honored. The namespace for this secret is openshift-config.",
}

func (OAuthRemoteConnectionInfo) SwaggerDoc() map[string]string {
	return map_OAuthRemoteConnectionInfo
}

var map_OAuthSpec = map[string]string{
	"":                  "OAuthSpec contains desired cluster auth configuration",
	"identityProviders": "identityProviders is an ordered list of ways for a user to identify themselves. When this list is empty, no identities are provisioned for users.",
	"tokenConfig":       "tokenConfig contains options for authorization and access tokens",
	"templates":         "templates allow you to customize pages like the login page.",
}

func (OAuthSpec) SwaggerDoc() map[string]string {
	return map_OAuthSpec
}

var map_OAuthStatus = map[string]string{
	"": "OAuthStatus shows current known state of OAuth server in the cluster",
}

func (OAuthStatus) SwaggerDoc() map[string]string {
	return map_OAuthStatus
}

var map_OAuthTemplates = map[string]string{
	"":                  "OAuthTemplates allow for customization of pages like the login page",
	"login":             "login is the name of a secret that specifies a go template to use to render the login page. The key \"login.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default login page is used. If the specified template is not valid, the default login page is used. If unspecified, the default login page is used. The namespace for this secret is openshift-config.",
	"providerSelection": "providerSelection is the name of a secret that specifies a go template to use to render the provider selection page. The key \"providers.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default provider selection page is used. If the specified template is not valid, the default provider selection page is used. If unspecified, the default provider selection page is used. The namespace for this secret is openshift-config.",
	"error":             "error is the name of a secret that specifies a go template to use to render error pages during the authentication or grant flow. The key \"errors.html\" is used to locate the template data. If specified and the secret or expected key is not found, the default error page is used. If the specified template is not valid, the default error page is used. If unspecified, the default error page is used. The namespace for this secret is openshift-config.",
}

func (OAuthTemplates) SwaggerDoc() map[string]string {
	return map_OAuthTemplates
}

var map_OpenIDClaims = map[string]string{
	"":                  "OpenIDClaims contains a list of OpenID claims to use when authenticating with an OpenID identity provider",
	"preferredUsername": "preferredUsername is the list of claims whose values should be used as the preferred username. If unspecified, the preferred username is determined from the value of the sub claim",
	"name":              "name is the list of claims whose values should be used as the display name. Optional. If unspecified, no display name is set for the identity",
	"email":             "email is the list of claims whose values should be used as the email address. Optional. If unspecified, no email is set for the identity",
	"groups":            "groups is the list of claims value of which should be used to synchronize groups from the OIDC provider to OpenShift for the user. If multiple claims are specified, the first one with a non-empty value is used.",
}

func (OpenIDClaims) SwaggerDoc() map[string]string {
	return map_OpenIDClaims
}

var map_OpenIDIdentityProvider = map[string]string{
	"":                         "OpenIDIdentityProvider provides identities for users authenticating using OpenID credentials",
	"clientID":                 "clientID is the oauth client ID",
	"clientSecret":             "clientSecret is a required reference to the secret by name containing the oauth client secret. The key \"clientSecret\" is used to locate the data. If the secret or expected key is not found, the identity provider is not honored. The namespace for this secret is openshift-config.",
	"ca":                       "ca is an optional reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. The key \"ca.crt\" is used to locate the data. If specified and the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. If empty, the default system roots are used. The namespace for this config map is openshift-config.",
	"extraScopes":              "extraScopes are any scopes to request in addition to the standard \"openid\" scope.",
	"extraAuthorizeParameters": "extraAuthorizeParameters are any custom parameters to add to the authorize request.",
	"issuer":                   "issuer is the URL that the OpenID Provider asserts as its Issuer Identifier. It must use the https scheme with no query or fragment component.",
	"claims":                   "claims mappings",
}

func (OpenIDIdentityProvider) SwaggerDoc() map[string]string {
	return map_OpenIDIdentityProvider
}

var map_RequestHeaderIdentityProvider = map[string]string{
	"":                         "RequestHeaderIdentityProvider provides identities for users authenticating using request header credentials",
	"loginURL":                 "loginURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect interactive logins will be redirected here ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when login is set to true.",
	"challengeURL":             "challengeURL is a URL to redirect unauthenticated /authorize requests to Unauthenticated requests from OAuth clients which expect WWW-Authenticate challenges will be redirected here. ${url} is replaced with the current URL, escaped to be safe in a query parameter\n  https://www.example.com/sso-login?then=${url}\n${query} is replaced with the current query string\n  https://www.example.com/auth-proxy/oauth/authorize?${query}\nRequired when challenge is set to true.",
	"ca":                       "ca is a required reference to a config map by name containing the PEM-encoded CA bundle. It is used as a trust anchor to validate the TLS certificate presented by the remote server. Specifically, it allows verification of incoming requests to prevent header spoofing. The key \"ca.crt\" is used to locate the data. If the config map or expected key is not found, the identity provider is not honored. If the specified ca data is not valid, the identity provider is not honored. The namespace for this config map is openshift-config.",
	"clientCommonNames":        "clientCommonNames is an optional list of common names to require a match from. If empty, any client certificate validated against the clientCA bundle is considered authoritative.",
	"headers":                  "headers is the set of headers to check for identity information",
	"preferredUsernameHeaders": "preferredUsernameHeaders is the set of headers to check for the preferred username",
	"nameHeaders":              "nameHeaders is the set of headers to check for the display name",
	"emailHeaders":             "emailHeaders is the set of headers to check for the email address",
}

func (RequestHeaderIdentityProvider) SwaggerDoc() map[string]string {
	return map_RequestHeaderIdentityProvider
}

var map_TokenConfig = map[string]string{
	"":                                    "TokenConfig holds the necessary configuration options for authorization and access tokens",
	"accessTokenMaxAgeSeconds":            "accessTokenMaxAgeSeconds defines the maximum age of access tokens",
	"accessTokenInactivityTimeoutSeconds": "accessTokenInactivityTimeoutSeconds - DEPRECATED: setting this field has no effect.",
	"accessTokenInactivityTimeout":        "accessTokenInactivityTimeout defines the token inactivity timeout for tokens granted by any client. The value represents the maximum amount of time that can occur between consecutive uses of the token. Tokens become invalid if they are not used within this temporal window. The user will need to acquire a new token to regain access once a token times out. Takes valid time duration string such as \"5m\", \"1.5h\" or \"2h45m\". The minimum allowed value for duration is 300s (5 minutes). If the timeout is configured per client, then that value takes precedence. If the timeout value is not specified and the client does not override the value, then tokens are valid until their lifetime.\n\nWARNING: existing tokens' timeout will not be affected (lowered) by changing this value",
}

func (TokenConfig) SwaggerDoc() map[string]string {
	return map_TokenConfig
}

var map_HubSource = map[string]string{
	"":         "HubSource is used to specify the hub source and its configuration",
	"name":     "name is the name of one of the default hub sources",
	"disabled": "disabled is used to disable a default hub source on cluster",
}

func (HubSource) SwaggerDoc() map[string]string {
	return map_HubSource
}

var map_HubSourceStatus = map[string]string{
	"":        "HubSourceStatus is used to reflect the current state of applying the configuration to a default source",
	"status":  "status indicates success or failure in applying the configuration",
	"message": "message provides more information regarding failures",
}

func (HubSourceStatus) SwaggerDoc() map[string]string {
	return map_HubSourceStatus
}

var map_OperatorHub = map[string]string{
	"":         "OperatorHub is the Schema for the operatorhubs API. It can be used to change the state of the default hub sources for OperatorHub on the cluster from enabled to disabled and vice versa.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (OperatorHub) SwaggerDoc() map[string]string {
	return map_OperatorHub
}

var map_OperatorHubList = map[string]string{
	"":         "OperatorHubList contains a list of OperatorHub\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (OperatorHubList) SwaggerDoc() map[string]string {
	return map_OperatorHubList
}

var map_OperatorHubSpec = map[string]string{
	"":                         "OperatorHubSpec defines the desired state of OperatorHub",
	"disableAllDefaultSources": "disableAllDefaultSources allows you to disable all the default hub sources. If this is true, a specific entry in sources can be used to enable a default source. If this is false, a specific entry in sources can be used to disable or enable a default source.",
	"sources":                  "sources is the list of default hub sources and their configuration. If the list is empty, it implies that the default hub sources are enabled on the cluster unless disableAllDefaultSources is true. If disableAllDefaultSources is true and sources is not empty, the configuration present in sources will take precedence. The list of default hub sources and their current state will always be reflected in the status block.",
}

func (OperatorHubSpec) SwaggerDoc() map[string]string {
	return map_OperatorHubSpec
}

var map_OperatorHubStatus = map[string]string{
	"":        "OperatorHubStatus defines the observed state of OperatorHub. The current state of the default hub sources will always be reflected here.",
	"sources": "sources encapsulates the result of applying the configuration for each hub source",
}

func (OperatorHubStatus) SwaggerDoc() map[string]string {
	return map_OperatorHubStatus
}

var map_Project = map[string]string{
	"":         "Project holds cluster-wide information about Project.  The canonical name is `cluster`\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Project) SwaggerDoc() map[string]string {
	return map_Project
}

var map_ProjectList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ProjectList) SwaggerDoc() map[string]string {
	return map_ProjectList
}

var map_ProjectSpec = map[string]string{
	"":                       "ProjectSpec holds the project creation configuration.",
	"projectRequestMessage":  "projectRequestMessage is the string presented to a user if they are unable to request a project via the projectrequest api endpoint",
	"projectRequestTemplate": "projectRequestTemplate is the template to use for creating projects in response to projectrequest. This must point to a template in 'openshift-config' namespace. It is optional. If it is not specified, a default template is used.",
}

func (ProjectSpec) SwaggerDoc() map[string]string {
	return map_ProjectSpec
}

var map_TemplateReference = map[string]string{
	"":     "TemplateReference references a template in a specific namespace. The namespace must be specified at the point of use.",
	"name": "name is the metadata.name of the referenced project request template",
}

func (TemplateReference) SwaggerDoc() map[string]string {
	return map_TemplateReference
}

var map_Proxy = map[string]string{
	"":         "Proxy holds cluster-wide information on how to configure default proxies for the cluster. The canonical name is `cluster`\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "Spec holds user-settable values for the proxy configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Proxy) SwaggerDoc() map[string]string {
	return map_Proxy
}

var map_ProxyList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (ProxyList) SwaggerDoc() map[string]string {
	return map_ProxyList
}

var map_ProxySpec = map[string]string{
	"":                   "ProxySpec contains cluster proxy creation configuration.",
	"httpProxy":          "httpProxy is the URL of the proxy for HTTP requests.  Empty means unset and will not result in an env var.",
	"httpsProxy":         "httpsProxy is the URL of the proxy for HTTPS requests.  Empty means unset and will not result in an env var.",
	"noProxy":            "noProxy is a comma-separated list of hostnames and/or CIDRs and/or IPs for which the proxy should not be used. Empty means unset and will not result in an env var.",
	"readinessEndpoints": "readinessEndpoints is a list of endpoints used to verify readiness of the proxy.",
	"trustedCA":          "trustedCA is a reference to a ConfigMap containing a CA certificate bundle. The trustedCA field should only be consumed by a proxy validator. The validator is responsible for reading the certificate bundle from the required key \"ca-bundle.crt\", merging it with the system default trust bundle, and writing the merged trust bundle to a ConfigMap named \"trusted-ca-bundle\" in the \"openshift-config-managed\" namespace. Clients that expect to make proxy connections must use the trusted-ca-bundle for all HTTPS requests to the proxy, and may use the trusted-ca-bundle for non-proxy HTTPS requests as well.\n\nThe namespace for the ConfigMap referenced by trustedCA is \"openshift-config\". Here is an example ConfigMap (in yaml):\n\napiVersion: v1 kind: ConfigMap metadata:\n name: user-ca-bundle\n namespace: openshift-config\n data:\n   ca-bundle.crt: |",
}

func (ProxySpec) SwaggerDoc() map[string]string {
	return map_ProxySpec
}

var map_ProxyStatus = map[string]string{
	"":           "ProxyStatus shows current known state of the cluster proxy.",
	"httpProxy":  "httpProxy is the URL of the proxy for HTTP requests.",
	"httpsProxy": "httpsProxy is the URL of the proxy for HTTPS requests.",
	"noProxy":    "noProxy is a comma-separated list of hostnames and/or CIDRs for which the proxy should not be used.",
}

func (ProxyStatus) SwaggerDoc() map[string]string {
	return map_ProxyStatus
}

var map_Scheduler = map[string]string{
	"":         "Scheduler holds cluster-wide config information to run the Kubernetes Scheduler and influence its placement decisions. The canonical name for this config is `cluster`.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec holds user settable values for configuration",
	"status":   "status holds observed values from the cluster. They may not be overridden.",
}

func (Scheduler) SwaggerDoc() map[string]string {
	return map_Scheduler
}

var map_SchedulerList = map[string]string{
	"":         "Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (SchedulerList) SwaggerDoc() map[string]string {
	return map_SchedulerList
}

var map_SchedulerSpec = map[string]string{
	"policy":              "DEPRECATED: the scheduler Policy API has been deprecated and will be removed in a future release. policy is a reference to a ConfigMap containing scheduler policy which has user specified predicates and priorities. If this ConfigMap is not available scheduler will default to use DefaultAlgorithmProvider. The namespace for this configmap is openshift-config.",
	"profile":             "profile sets which scheduling profile should be set in order to configure scheduling decisions for new pods.\n\nValid values are \"LowNodeUtilization\", \"HighNodeUtilization\", \"NoScoring\" Defaults to \"LowNodeUtilization\"",
	"defaultNodeSelector": "defaultNodeSelector helps set the cluster-wide default node selector to restrict pod placement to specific nodes. This is applied to the pods created in all namespaces and creates an intersection with any existing nodeSelectors already set on a pod, additionally constraining that pod's selector. For example, defaultNodeSelector: \"type=user-node,region=east\" would set nodeSelector field in pod spec to \"type=user-node,region=east\" to all pods created in all namespaces. Namespaces having project-wide node selectors won't be impacted even if this field is set. This adds an annotation section to the namespace. For example, if a new namespace is created with node-selector='type=user-node,region=east', the annotation openshift.io/node-selector: type=user-node,region=east gets added to the project. When the openshift.io/node-selector annotation is set on the project the value is used in preference to the value we are setting for defaultNodeSelector field. For instance, openshift.io/node-selector: \"type=user-node,region=west\" means that the default of \"type=user-node,region=east\" set in defaultNodeSelector would not be applied.",
	"mastersSchedulable":  "MastersSchedulable allows masters nodes to be schedulable. When this flag is turned on, all the master nodes in the cluster will be made schedulable, so that workload pods can run on them. The default value for this field is false, meaning none of the master nodes are schedulable. Important Note: Once the workload pods start running on the master nodes, extreme care must be taken to ensure that cluster-critical control plane components are not impacted. Please turn on this field after doing due diligence.",
}

func (SchedulerSpec) SwaggerDoc() map[string]string {
	return map_SchedulerSpec
}

var map_CustomTLSProfile = map[string]string{
	"": "CustomTLSProfile is a user-defined TLS security profile. Be extremely careful using a custom TLS profile as invalid configurations can be catastrophic.",
}

func (CustomTLSProfile) SwaggerDoc() map[string]string {
	return map_CustomTLSProfile
}

var map_IntermediateTLSProfile = map[string]string{
	"": "IntermediateTLSProfile is a TLS security profile based on: https://wiki.mozilla.org/Security/Server_Side_TLS#Intermediate_compatibility_.28default.29",
}

func (IntermediateTLSProfile) SwaggerDoc() map[string]string {
	return map_IntermediateTLSProfile
}

var map_ModernTLSProfile = map[string]string{
	"": "ModernTLSProfile is a TLS security profile based on: https://wiki.mozilla.org/Security/Server_Side_TLS#Modern_compatibility",
}

func (ModernTLSProfile) SwaggerDoc() map[string]string {
	return map_ModernTLSProfile
}

var map_OldTLSProfile = map[string]string{
	"": "OldTLSProfile is a TLS security profile based on: https://wiki.mozilla.org/Security/Server_Side_TLS#Old_backward_compatibility",
}

func (OldTLSProfile) SwaggerDoc() map[string]string {
	return map_OldTLSProfile
}

var map_TLSProfileSpec = map[string]string{
	"":              "TLSProfileSpec is the desired behavior of a TLSSecurityProfile.",
	"ciphers":       "ciphers is used to specify the cipher algorithms that are negotiated during the TLS handshake.  Operators may remove entries their operands do not support.  For example, to use DES-CBC3-SHA  (yaml):\n\n  ciphers:\n    - DES-CBC3-SHA",
	"minTLSVersion": "minTLSVersion is used to specify the minimal version of the TLS protocol that is negotiated during the TLS handshake. For example, to use TLS versions 1.1, 1.2 and 1.3 (yaml):\n\n  minTLSVersion: TLSv1.1\n\nNOTE: currently the highest minTLSVersion allowed is VersionTLS12",
}

func (TLSProfileSpec) SwaggerDoc() map[string]string {
	return map_TLSProfileSpec
}

var map_TLSSecurityProfile = map[string]string{
	"":             "TLSSecurityProfile defines the schema for a TLS security profile. This object is used by operators to apply TLS security settings to operands.",
	"type":         "type is one of Old, Intermediate, Modern or Custom. Custom provides the ability to specify individual TLS security profile parameters. Old, Intermediate and Modern are TLS security profiles based on:\n\nhttps://wiki.mozilla.org/Security/Server_Side_TLS#Recommended_configurations\n\nThe profiles are intent based, so they may change over time as new ciphers are developed and existing ciphers are found to be insecure.  Depending on precisely which ciphers are available to a process, the list may be reduced.\n\nNote that the Modern profile is currently not supported because it is not yet well adopted by common software libraries.",
	"old":          "old is a TLS security profile based on:\n\nhttps://wiki.mozilla.org/Security/Server_Side_TLS#Old_backward_compatibility\n\nand looks like this (yaml):\n\n  ciphers:\n    - TLS_AES_128_GCM_SHA256\n    - TLS_AES_256_GCM_SHA384\n    - TLS_CHACHA20_POLY1305_SHA256\n    - ECDHE-ECDSA-AES128-GCM-SHA256\n    - ECDHE-RSA-AES128-GCM-SHA256\n    - ECDHE-ECDSA-AES256-GCM-SHA384\n    - ECDHE-RSA-AES256-GCM-SHA384\n    - ECDHE-ECDSA-CHACHA20-POLY1305\n    - ECDHE-RSA-CHACHA20-POLY1305\n    - DHE-RSA-AES128-GCM-SHA256\n    - DHE-RSA-AES256-GCM-SHA384\n    - DHE-RSA-CHACHA20-POLY1305\n    - ECDHE-ECDSA-AES128-SHA256\n    - ECDHE-RSA-AES128-SHA256\n    - ECDHE-ECDSA-AES128-SHA\n    - ECDHE-RSA-AES128-SHA\n    - ECDHE-ECDSA-AES256-SHA384\n    - ECDHE-RSA-AES256-SHA384\n    - ECDHE-ECDSA-AES256-SHA\n    - ECDHE-RSA-AES256-SHA\n    - DHE-RSA-AES128-SHA256\n    - DHE-RSA-AES256-SHA256\n    - AES128-GCM-SHA256\n    - AES256-GCM-SHA384\n    - AES128-SHA256\n    - AES256-SHA256\n    - AES128-SHA\n    - AES256-SHA\n    - DES-CBC3-SHA\n  minTLSVersion: TLSv1.0",
	"intermediate": "intermediate is a TLS security profile based on:\n\nhttps://wiki.mozilla.org/Security/Server_Side_TLS#Intermediate_compatibility_.28recommended.29\n\nand looks like this (yaml):\n\n  ciphers:\n    - TLS_AES_128_GCM_SHA256\n    - TLS_AES_256_GCM_SHA384\n    - TLS_CHACHA20_POLY1305_SHA256\n    - ECDHE-ECDSA-AES128-GCM-SHA256\n    - ECDHE-RSA-AES128-GCM-SHA256\n    - ECDHE-ECDSA-AES256-GCM-SHA384\n    - ECDHE-RSA-AES256-GCM-SHA384\n    - ECDHE-ECDSA-CHACHA20-POLY1305\n    - ECDHE-RSA-CHACHA20-POLY1305\n    - DHE-RSA-AES128-GCM-SHA256\n    - DHE-RSA-AES256-GCM-SHA384\n  minTLSVersion: TLSv1.2",
	"modern":       "modern is a TLS security profile based on:\n\nhttps://wiki.mozilla.org/Security/Server_Side_TLS#Modern_compatibility\n\nand looks like this (yaml):\n\n  ciphers:\n    - TLS_AES_128_GCM_SHA256\n    - TLS_AES_256_GCM_SHA384\n    - TLS_CHACHA20_POLY1305_SHA256\n  minTLSVersion: TLSv1.3\n\nNOTE: Currently unsupported.",
	"custom":       "custom is a user-defined TLS security profile. Be extremely careful using a custom profile as invalid configurations can be catastrophic. An example custom profile looks like this:\n\n  ciphers:\n    - ECDHE-ECDSA-CHACHA20-POLY1305\n    - ECDHE-RSA-CHACHA20-POLY1305\n    - ECDHE-RSA-AES128-GCM-SHA256\n    - ECDHE-ECDSA-AES128-GCM-SHA256\n  minTLSVersion: TLSv1.1",
}

func (TLSSecurityProfile) SwaggerDoc() map[string]string {
	return map_TLSSecurityProfile
}

// AUTO-GENERATED FUNCTIONS END HERE
