/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.util.ByteList;

public class MatchInstr
extends CallInstr
implements FixedArityInstr {
    private static final ByteList MATCH = new ByteList(new byte[]{61, 126});

    protected MatchInstr(IRScope scope, Variable result2, Operand receiver2, Operand arg2, CallSite callSite, long callSiteId) {
        super(scope, Operation.MATCH, CallType.NORMAL, result2, scope.getManager().getRuntime().newSymbol(MATCH), receiver2, new Operand[]{arg2}, NullBlock.INSTANCE, 0, false, callSite, callSiteId);
    }

    public MatchInstr(IRScope scope, Variable result2, Operand receiver2, Operand arg2) {
        super(scope, Operation.MATCH, CallType.NORMAL, result2, scope.getManager().getRuntime().newSymbol(MATCH), receiver2, new Operand[]{arg2}, NullBlock.INSTANCE, 0, false);
        assert (result2 != null) : "Match2Instr result is null";
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        super.computeScopeFlags(scope, flags2);
        flags2.add(IRFlags.REQUIRES_BACKREF);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new MatchInstr(ii.getScope(), (Variable)this.result.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.getArg1().cloneForInlining(ii), this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
        e.encode(this.getResult());
        e.encode(this.getReceiver());
        e.encode(this.getArg1());
    }

    public static MatchInstr decode(IRReaderDecoder d) {
        return new MatchInstr(d.getCurrentScope(), d.decodeVariable(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.MatchInstr(this);
    }
}

