/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import nu.validator.htmlparser.annotation.Auto;
import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.common.ByteReadable;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.xml.sax.SAXException;

public abstract class MetaScanner {
    private static final char[] CHARSET = "harset".toCharArray();
    private static final char[] CONTENT = "ontent".toCharArray();
    private static final char[] HTTP_EQUIV = "ttp-equiv".toCharArray();
    private static final char[] CONTENT_TYPE = "content-type".toCharArray();
    private static final int NO = 0;
    private static final int M = 1;
    private static final int E = 2;
    private static final int T = 3;
    private static final int A = 4;
    private static final int DATA = 0;
    private static final int TAG_OPEN = 1;
    private static final int SCAN_UNTIL_GT = 2;
    private static final int TAG_NAME = 3;
    private static final int BEFORE_ATTRIBUTE_NAME = 4;
    private static final int ATTRIBUTE_NAME = 5;
    private static final int AFTER_ATTRIBUTE_NAME = 6;
    private static final int BEFORE_ATTRIBUTE_VALUE = 7;
    private static final int ATTRIBUTE_VALUE_DOUBLE_QUOTED = 8;
    private static final int ATTRIBUTE_VALUE_SINGLE_QUOTED = 9;
    private static final int ATTRIBUTE_VALUE_UNQUOTED = 10;
    private static final int AFTER_ATTRIBUTE_VALUE_QUOTED = 11;
    private static final int MARKUP_DECLARATION_OPEN = 13;
    private static final int MARKUP_DECLARATION_HYPHEN = 14;
    private static final int COMMENT_START = 15;
    private static final int COMMENT_START_DASH = 16;
    private static final int COMMENT = 17;
    private static final int COMMENT_END_DASH = 18;
    private static final int COMMENT_END = 19;
    private static final int SELF_CLOSING_START_TAG = 20;
    private static final int HTTP_EQUIV_NOT_SEEN = 0;
    private static final int HTTP_EQUIV_CONTENT_TYPE = 1;
    private static final int HTTP_EQUIV_OTHER = 2;
    protected ByteReadable readable = null;
    private int metaState = 0;
    private int contentIndex = Integer.MAX_VALUE;
    private int charsetIndex = Integer.MAX_VALUE;
    private int httpEquivIndex = Integer.MAX_VALUE;
    private int contentTypeIndex = Integer.MAX_VALUE;
    protected int stateSave = 0;
    private int strBufLen = 0;
    @Auto
    private char[] strBuf;
    private String content = null;
    private String charset = null;
    private int httpEquivState = 0;

    public MetaScanner() {
        this.contentIndex = Integer.MAX_VALUE;
        this.charsetIndex = Integer.MAX_VALUE;
        this.httpEquivIndex = Integer.MAX_VALUE;
        this.contentTypeIndex = Integer.MAX_VALUE;
        this.strBuf = new char[36];
    }

    private void destructor() {
        Portability.releaseString(this.content);
        Portability.releaseString(this.charset);
    }

    protected int read() throws IOException {
        return this.readable.readByte();
    }

    protected final void stateLoop(int state) throws SAXException, IOException {
        int n = -1;
        boolean reconsume = false;
        block130: while (true) {
            switch (state) {
                case 0: {
                    int n2;
                    block131: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 60: {
                                state = 1;
                                break block131;
                            }
                            default: {
                                continue block131;
                            }
                        }
                        break;
                    }
                }
                case 1: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 77: 
                        case 109: {
                            this.metaState = 1;
                            state = 3;
                            break;
                        }
                        case 33: {
                            state = 13;
                            continue block130;
                        }
                        case 47: 
                        case 63: {
                            state = 2;
                            continue block130;
                        }
                        case 62: {
                            state = 0;
                            continue block130;
                        }
                        default: {
                            if (n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122) {
                                this.metaState = 0;
                                state = 3;
                                break;
                            }
                            state = 0;
                            reconsume = true;
                            continue block130;
                        }
                    }
                }
                case 3: {
                    int n2;
                    block132: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                state = 4;
                                break block132;
                            }
                            case 47: {
                                state = 20;
                                continue block130;
                            }
                            case 62: {
                                state = 0;
                                continue block130;
                            }
                            case 69: 
                            case 101: {
                                if (this.metaState == 1) {
                                    this.metaState = 2;
                                    continue block132;
                                }
                                this.metaState = 0;
                                continue block132;
                            }
                            case 84: 
                            case 116: {
                                if (this.metaState == 2) {
                                    this.metaState = 3;
                                    continue block132;
                                }
                                this.metaState = 0;
                                continue block132;
                            }
                            case 65: 
                            case 97: {
                                if (this.metaState == 3) {
                                    this.metaState = 4;
                                    continue block132;
                                }
                                this.metaState = 0;
                                continue block132;
                            }
                            default: {
                                this.metaState = 0;
                                continue block132;
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    int n2;
                    block133: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block133;
                            }
                            case 47: {
                                state = 20;
                                continue block130;
                            }
                            case 62: {
                                if (this.handleTag()) break block130;
                                state = 0;
                                continue block130;
                            }
                            case 67: 
                            case 99: {
                                this.contentIndex = 0;
                                this.charsetIndex = 0;
                                this.httpEquivIndex = Integer.MAX_VALUE;
                                this.contentTypeIndex = Integer.MAX_VALUE;
                                state = 5;
                                break block133;
                            }
                            case 72: 
                            case 104: {
                                this.contentIndex = Integer.MAX_VALUE;
                                this.charsetIndex = Integer.MAX_VALUE;
                                this.httpEquivIndex = 0;
                                this.contentTypeIndex = Integer.MAX_VALUE;
                                state = 5;
                                break block133;
                            }
                            default: {
                                this.contentIndex = Integer.MAX_VALUE;
                                this.charsetIndex = Integer.MAX_VALUE;
                                this.httpEquivIndex = Integer.MAX_VALUE;
                                this.contentTypeIndex = Integer.MAX_VALUE;
                                state = 5;
                                break block133;
                            }
                        }
                        break;
                    }
                }
                case 5: {
                    int n2;
                    block134: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                state = 6;
                                continue block130;
                            }
                            case 47: {
                                state = 20;
                                continue block130;
                            }
                            case 61: {
                                this.strBufLen = 0;
                                this.contentTypeIndex = 0;
                                state = 7;
                                break block134;
                            }
                            case 62: {
                                if (this.handleTag()) break block130;
                                state = 0;
                                continue block130;
                            }
                            default: {
                                if (this.metaState != 4) continue block134;
                                if (n2 >= 65 && n2 <= 90) {
                                    n2 += 32;
                                }
                                this.contentIndex = this.contentIndex < CONTENT.length && n2 == CONTENT[this.contentIndex] ? ++this.contentIndex : Integer.MAX_VALUE;
                                this.charsetIndex = this.charsetIndex < CHARSET.length && n2 == CHARSET[this.charsetIndex] ? ++this.charsetIndex : Integer.MAX_VALUE;
                                if (this.httpEquivIndex < HTTP_EQUIV.length && n2 == HTTP_EQUIV[this.httpEquivIndex]) {
                                    ++this.httpEquivIndex;
                                    continue block134;
                                }
                                this.httpEquivIndex = Integer.MAX_VALUE;
                                continue block134;
                            }
                        }
                        break;
                    }
                }
                case 7: {
                    int n2;
                    block135: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block135;
                            }
                            case 34: {
                                state = 8;
                                break block135;
                            }
                            case 39: {
                                state = 9;
                                continue block130;
                            }
                            case 62: {
                                if (this.handleTag()) break block130;
                                state = 0;
                                continue block130;
                            }
                            default: {
                                this.handleCharInAttributeValue(n2);
                                state = 10;
                                continue block130;
                            }
                        }
                        break;
                    }
                }
                case 8: {
                    int n2;
                    block136: while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 34: {
                                this.handleAttributeValue();
                                state = 11;
                                break block136;
                            }
                            default: {
                                this.handleCharInAttributeValue(n2);
                                continue block136;
                            }
                        }
                        break;
                    }
                }
                case 11: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 9: 
                        case 10: 
                        case 12: 
                        case 32: {
                            state = 4;
                            continue block130;
                        }
                        case 47: {
                            state = 20;
                            break;
                        }
                        case 62: {
                            if (this.handleTag()) break block130;
                            state = 0;
                            continue block130;
                        }
                        default: {
                            state = 4;
                            reconsume = true;
                            continue block130;
                        }
                    }
                }
                case 20: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 62: {
                            if (this.handleTag()) break block130;
                            state = 0;
                            break;
                        }
                        default: {
                            state = 4;
                            reconsume = true;
                            break;
                        }
                    }
                    continue block130;
                }
                case 10: {
                    int n2;
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                this.handleAttributeValue();
                                state = 4;
                                continue block130;
                            }
                            case 62: {
                                this.handleAttributeValue();
                                if (this.handleTag()) break block130;
                                state = 0;
                                continue block130;
                            }
                            default: {
                                this.handleCharInAttributeValue(n2);
                                break;
                            }
                        }
                    }
                }
                case 6: {
                    int n2;
                    block138: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 9: 
                            case 10: 
                            case 12: 
                            case 32: {
                                continue block138;
                            }
                            case 47: {
                                this.handleAttributeValue();
                                state = 20;
                                break block138;
                            }
                            case 61: {
                                this.strBufLen = 0;
                                this.contentTypeIndex = 0;
                                state = 7;
                                break block138;
                            }
                            case 62: {
                                this.handleAttributeValue();
                                if (this.handleTag()) break block130;
                                state = 0;
                                break block138;
                            }
                            case 67: 
                            case 99: {
                                this.contentIndex = 0;
                                this.charsetIndex = 0;
                                state = 5;
                                break block138;
                            }
                            default: {
                                this.contentIndex = Integer.MAX_VALUE;
                                this.charsetIndex = Integer.MAX_VALUE;
                                state = 5;
                                break block138;
                            }
                        }
                        break;
                    }
                    continue block130;
                }
                case 13: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 45: {
                            state = 14;
                            break;
                        }
                        default: {
                            state = 2;
                            reconsume = true;
                            continue block130;
                        }
                    }
                }
                case 14: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 45: {
                            state = 15;
                            break;
                        }
                        default: {
                            state = 2;
                            reconsume = true;
                            continue block130;
                        }
                    }
                }
                case 15: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 45: {
                            state = 16;
                            continue block130;
                        }
                        case 62: {
                            state = 0;
                            continue block130;
                        }
                    }
                    state = 17;
                }
                case 17: {
                    int n2;
                    block139: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 45: {
                                state = 18;
                                break block139;
                            }
                            default: {
                                continue block139;
                            }
                        }
                        break;
                    }
                }
                case 18: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 45: {
                            state = 19;
                            break;
                        }
                        default: {
                            state = 17;
                            continue block130;
                        }
                    }
                }
                case 19: {
                    int n2;
                    block140: while (true) {
                        n2 = this.read();
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 62: {
                                state = 0;
                                continue block130;
                            }
                            case 45: {
                                continue block140;
                            }
                        }
                        break;
                    }
                    state = 17;
                    continue block130;
                }
                case 16: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            break block130;
                        }
                        case 45: {
                            state = 19;
                            continue block130;
                        }
                        case 62: {
                            state = 0;
                            continue block130;
                        }
                    }
                    state = 17;
                    continue block130;
                }
                case 9: {
                    int n2;
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 39: {
                                this.handleAttributeValue();
                                state = 11;
                                continue block130;
                            }
                        }
                        this.handleCharInAttributeValue(n2);
                    }
                }
                case 2: {
                    int n2;
                    while (true) {
                        if (reconsume) {
                            reconsume = false;
                        } else {
                            n2 = this.read();
                        }
                        switch (n2) {
                            case -1: {
                                break block130;
                            }
                            case 62: {
                                state = 0;
                                continue block130;
                            }
                        }
                    }
                }
                default: {
                    continue block130;
                }
            }
            break;
        }
        this.stateSave = state;
    }

    private void handleCharInAttributeValue(int c) {
        if (this.metaState == 4) {
            if (this.contentIndex == CONTENT.length || this.charsetIndex == CHARSET.length) {
                this.addToBuffer(c);
            } else if (this.httpEquivIndex == HTTP_EQUIV.length) {
                this.contentTypeIndex = this.contentTypeIndex < CONTENT_TYPE.length && this.toAsciiLowerCase(c) == CONTENT_TYPE[this.contentTypeIndex] ? ++this.contentTypeIndex : Integer.MAX_VALUE;
            }
        }
    }

    @Inline
    private int toAsciiLowerCase(int c) {
        if (c >= 65 && c <= 90) {
            return c + 32;
        }
        return c;
    }

    private void addToBuffer(int c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + (this.strBuf.length << 1)];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = (char)c;
    }

    private void handleAttributeValue() throws SAXException {
        if (this.metaState != 4) {
            return;
        }
        if (this.contentIndex == CONTENT.length && this.content == null) {
            this.content = Portability.newStringFromBuffer(this.strBuf, 0, this.strBufLen);
            return;
        }
        if (this.charsetIndex == CHARSET.length && this.charset == null) {
            this.charset = Portability.newStringFromBuffer(this.strBuf, 0, this.strBufLen);
            return;
        }
        if (this.httpEquivIndex == HTTP_EQUIV.length && this.httpEquivState == 0) {
            this.httpEquivState = this.contentTypeIndex == CONTENT_TYPE.length ? 1 : 2;
            return;
        }
    }

    private boolean handleTag() throws SAXException {
        boolean stop = this.handleTagInner();
        Portability.releaseString(this.content);
        this.content = null;
        Portability.releaseString(this.charset);
        this.charset = null;
        this.httpEquivState = 0;
        return stop;
    }

    private boolean handleTagInner() throws SAXException {
        if (this.charset != null && this.tryCharset(this.charset)) {
            return true;
        }
        if (this.content != null && this.httpEquivState == 1) {
            String extract = TreeBuilder.extractCharsetFromContent(this.content);
            if (extract == null) {
                return false;
            }
            boolean success = this.tryCharset(extract);
            Portability.releaseString(extract);
            return success;
        }
        return false;
    }

    protected abstract boolean tryCharset(String var1) throws SAXException;
}

