/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmmetPreviewUtil {
    private EmmetPreviewUtil() {
    }

    @Nullable
    public static String calculateTemplateText(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
        String templatePrefix;
        if (editor == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file);
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback, false);
        if (generator instanceof XmlZenCodingGenerator && (templatePrefix = new ZenCodingTemplate().computeTemplateKeyWithoutContextChecking(callback)) != null) {
            try {
                String templateText;
                ZenCodingTemplate.expand(templatePrefix, callback, generator, Collections.emptyList(), expandPrimitiveAbbreviations, 0);
                TemplateImpl template = callback.getGeneratedTemplate();
                String string = templateText = template != null ? template.getTemplateText() : null;
                if (!StringUtil.isEmpty((String)templateText)) {
                    return template.isToReformat() ? EmmetPreviewUtil.reformatTemplateText(file, templateText) : templateText;
                }
            }
            catch (EmmetException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static void addEmmetPreviewListeners(final @NotNull Editor editor, final @NotNull PsiFile file, final boolean expandPrimitiveAbbreviations) {
        if (editor == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(3);
        }
        editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                EmmetPreviewHint existingHint;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((existingHint = EmmetPreviewHint.getExistingHint(editor)) != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getDocument().removeDocumentListener((DocumentListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$1", "documentChanged"));
            }
        });
        editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                EmmetPreviewHint existingHint;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((existingHint = EmmetPreviewHint.getExistingHint(e.getEditor())) != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file, expandPrimitiveAbbreviations));
                } else {
                    e.getEditor().getCaretModel().removeCaretListener((CaretListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$2", "caretPositionChanged"));
            }
        });
    }

    private static String reformatTemplateText(@NotNull PsiFile file, @NotNull String templateText) {
        if (file == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(4);
        }
        if (templateText == null) {
            EmmetPreviewUtil.$$$reportNull$$$0(5);
        }
        PsiFile copy = PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText(file.getName(), file.getFileType(), (CharSequence)templateText);
        CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)copy);
        return copy.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateTemplateText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEmmetPreviewListeners";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatTemplateText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TemplateTextProducer
    implements Supplier<String> {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final PsiFile myFile;
        private final boolean myExpandPrimitiveAbbreviations;

        TemplateTextProducer(@NotNull Editor editor, @NotNull PsiFile file, boolean expandPrimitiveAbbreviations) {
            if (editor == null) {
                TemplateTextProducer.$$$reportNull$$$0(0);
            }
            if (file == null) {
                TemplateTextProducer.$$$reportNull$$$0(1);
            }
            this.myEditor = editor;
            this.myFile = file;
            this.myExpandPrimitiveAbbreviations = expandPrimitiveAbbreviations;
        }

        @Override
        @Nullable
        public String get() {
            return EmmetPreviewUtil.calculateTemplateText(this.myEditor, this.myFile, this.myExpandPrimitiveAbbreviations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewUtil$TemplateTextProducer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

