/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.util.connection;

import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.util.SessionRelatedInfo;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/util/connection/NotebookDebugConnectionHolder;", "", "backedFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "sessionRelatedInfo", "Lcom/intellij/kotlin/jupyter/core/debug/util/SessionRelatedInfo;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/kotlin/jupyter/core/debug/util/SessionRelatedInfo;)V", "getBackedFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getSessionRelatedInfo", "()Lcom/intellij/kotlin/jupyter/core/debug/util/SessionRelatedInfo;", "myEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getMyEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "setMyEnvironment", "(Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "runProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunProfileState", "()Lcom/intellij/execution/configurations/RunProfileState;", "setRunProfileState", "(Lcom/intellij/execution/configurations/RunProfileState;)V", "myDebugSession", "Lcom/intellij/debugger/impl/DebuggerSession;", "getMyDebugSession", "()Lcom/intellij/debugger/impl/DebuggerSession;", "setMyDebugSession", "(Lcom/intellij/debugger/impl/DebuggerSession;)V", "clearKnownConnection", "", "project", "Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.jupyter.core"})
public final class NotebookDebugConnectionHolder {
    @NotNull
    private final BackedNotebookVirtualFile backedFile;
    @NotNull
    private final SessionRelatedInfo sessionRelatedInfo;
    @Nullable
    private volatile ExecutionEnvironment myEnvironment;
    public RunProfileState runProfileState;
    @Nullable
    private volatile DebuggerSession myDebugSession;

    public NotebookDebugConnectionHolder(@NotNull BackedNotebookVirtualFile backedFile, @NotNull SessionRelatedInfo sessionRelatedInfo) {
        Intrinsics.checkNotNullParameter((Object)backedFile, (String)"backedFile");
        Intrinsics.checkNotNullParameter((Object)sessionRelatedInfo, (String)"sessionRelatedInfo");
        this.backedFile = backedFile;
        this.sessionRelatedInfo = sessionRelatedInfo;
    }

    @NotNull
    public final BackedNotebookVirtualFile getBackedFile() {
        return this.backedFile;
    }

    @NotNull
    public final SessionRelatedInfo getSessionRelatedInfo() {
        return this.sessionRelatedInfo;
    }

    @Nullable
    public final ExecutionEnvironment getMyEnvironment() {
        return this.myEnvironment;
    }

    public final void setMyEnvironment(@Nullable ExecutionEnvironment executionEnvironment) {
        this.myEnvironment = executionEnvironment;
    }

    @NotNull
    public final RunProfileState getRunProfileState() {
        RunProfileState runProfileState = this.runProfileState;
        if (runProfileState != null) {
            return runProfileState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"runProfileState");
        return null;
    }

    public final void setRunProfileState(@NotNull RunProfileState runProfileState) {
        Intrinsics.checkNotNullParameter((Object)runProfileState, (String)"<set-?>");
        this.runProfileState = runProfileState;
    }

    @Nullable
    public final DebuggerSession getMyDebugSession() {
        return this.myDebugSession;
    }

    public final void setMyDebugSession(@Nullable DebuggerSession debuggerSession) {
        this.myDebugSession = debuggerSession;
    }

    public final void clearKnownConnection(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myDebugSession = null;
        this.sessionRelatedInfo.setDebugPort(null);
        this.myEnvironment = null;
        SessionRelatedInfo.updateWith$default(this.sessionRelatedInfo, project, null, null, null, null, null, 62, null);
    }

    @NotNull
    public final BackedNotebookVirtualFile component1() {
        return this.backedFile;
    }

    @NotNull
    public final SessionRelatedInfo component2() {
        return this.sessionRelatedInfo;
    }

    @NotNull
    public final NotebookDebugConnectionHolder copy(@NotNull BackedNotebookVirtualFile backedFile, @NotNull SessionRelatedInfo sessionRelatedInfo) {
        Intrinsics.checkNotNullParameter((Object)backedFile, (String)"backedFile");
        Intrinsics.checkNotNullParameter((Object)sessionRelatedInfo, (String)"sessionRelatedInfo");
        return new NotebookDebugConnectionHolder(backedFile, sessionRelatedInfo);
    }

    public static /* synthetic */ NotebookDebugConnectionHolder copy$default(NotebookDebugConnectionHolder notebookDebugConnectionHolder, BackedNotebookVirtualFile backedNotebookVirtualFile, SessionRelatedInfo sessionRelatedInfo, int n, Object object) {
        if ((n & 1) != 0) {
            backedNotebookVirtualFile = notebookDebugConnectionHolder.backedFile;
        }
        if ((n & 2) != 0) {
            sessionRelatedInfo = notebookDebugConnectionHolder.sessionRelatedInfo;
        }
        return notebookDebugConnectionHolder.copy(backedNotebookVirtualFile, sessionRelatedInfo);
    }

    @NotNull
    public String toString() {
        return "NotebookDebugConnectionHolder(backedFile=" + this.backedFile + ", sessionRelatedInfo=" + this.sessionRelatedInfo + ")";
    }

    public int hashCode() {
        int result2 = this.backedFile.hashCode();
        result2 = result2 * 31 + this.sessionRelatedInfo.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotebookDebugConnectionHolder)) {
            return false;
        }
        NotebookDebugConnectionHolder notebookDebugConnectionHolder = (NotebookDebugConnectionHolder)other;
        if (!Intrinsics.areEqual((Object)this.backedFile, (Object)notebookDebugConnectionHolder.backedFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sessionRelatedInfo, (Object)notebookDebugConnectionHolder.sessionRelatedInfo);
    }
}

